/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.internal.SpinPanel;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.SpinDrawingView;
import cocon.CoFolder;
import cocon.CoMMFolder;
import cocon.CoObject;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.AbstractAction;
import miningmart.hci.gui.chInterface.ComponentFigureI;
import miningmart.hci.gui.main.Application;
import miningmart.hci.operators.MMStep;
import miningmart.m4.Chain;
import miningmart.m4.Step;
import miningmart.m4.StorageException;

public class ComponentFigure
extends ImageFigure
implements ComponentFigureI {
    private CoObject object;
    private AbstractAction insertAction = null;
    private CoFolder folder = null;
    int oldX;
    int oldY;

    public ComponentFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
    }

    public ComponentFigure(Image image, String fileName, Point origin, CoFolder f) {
        super(image, fileName, origin);
        this.folder = f;
        this.init();
    }

    public ComponentFigure(AbstractAction action, Image image, String fileName, Point origin, CoFolder f) {
        super(image, fileName, origin);
        this.folder = f;
        this.insertAction = action;
        this.init();
    }

    public ComponentFigure(AbstractAction action, String fileName, Point origin) {
        this(action, null, fileName, origin, null);
        this.init();
    }

    private void init() {
        this.setAttribute("Name", "");
        this.setAttribute("Description", "");
        this.setAttribute("URL", "");
    }

    public void mouseClicked(MouseEvent e) {
        Application.setSelectedNode((CoObject)this.getObject());
        if (e.getClickCount() == 2) {
            if (this.getObject() instanceof CoFolder) {
                SpinPanel panel = (SpinPanel)((Object)Application.graphDocumentView.getViewPanel());
                SpinDrawingView view = (SpinDrawingView)panel.getView();
                view.drawFolder((CoFolder)this.getObject());
            } else {
                Application.dispatcher.editOpen();
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.oldX = e.getX();
        this.oldY = e.getY();
        Application.setSelectedNode((CoObject)this.getObject());
    }

    public void mouseReleased(MouseEvent e) {
        if (this.oldX != e.getX() || this.oldY != e.getY()) {
            CoObject object = this.getObject();
            Point p = this.displayBox().getLocation();
            object.getPosition().setLocation(p, this.folder);
            if (!Application.mmWorkspace.isReadOnly()) {
                if (object instanceof MMStep) {
                    Step step = ((MMStep)object).m4Step;
                    step.setPoint(step.getChain(), p);
                    try {
                        step.store();
                    }
                    catch (StorageException ex) {
                        ex.printStackTrace();
                    }
                } else if (object instanceof CoMMFolder) {
                    CoMMFolder f = (CoMMFolder)object;
                    Chain chain = f.getChain();
                    try {
                        chain.setPoint(f.getParentChain(), p);
                        chain.store();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    catch (StorageException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    protected void basicMoveBy(int x, int y) {
        int newY;
        super.basicMoveBy(x, y);
        Point p = this.displayBox().getLocation();
        SpinPanel panel = (SpinPanel)((Object)Application.graphDocumentView.getViewPanel());
        SpinDrawingView view = (SpinDrawingView)panel.getView();
        Dimension d = view.getMinimumSize();
        int newX = p.x > d.width - 50 ? p.x + 50 : d.width;
        int n = newY = p.y > d.height - 50 ? p.y + 50 : d.height;
        if (newX != d.width || newY != d.height) {
            view.setDrawingViewSize(newX, newY);
            panel.setScrollPaneView(view);
        }
    }

    public void setObject(CoObject newObject) {
        this.object = newObject;
    }

    public CoObject getObject() {
        return this.object;
    }

    public AbstractAction getAction() {
        return this.insertAction;
    }

    public Vector handles() {
        Vector<NullHandle> handles = new Vector<NullHandle>();
        handles.addElement(new NullHandle((Figure)this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle((Figure)this, RelativeLocator.southEast()));
        handles.addElement(new NullHandle((Figure)this, RelativeLocator.southWest()));
        return handles;
    }

    public void setFolder(CoFolder newFolder) {
        this.folder = newFolder;
    }

    public CoFolder getFolder() {
        return this.folder;
    }

    public String toString() {
        return (String)this.getAttribute("Name");
    }
}

