package CH.ifa.draw.util;

import javax.swing.JButton;
import java.awt.*;
import java.awt.event.*;

/**
 * berschrift:   JHotDraw
 * Beschreibung:  Quellen und Dateien des Paketes JHotDraw zur Evaluierung.
 * Copyright:     Copyright (c) 2001
 * Organisation:
 * @author
 * @version 1.0
 */

public class PaletteButton extends JButton {

  static final int NORMAL = 1;
  static final int PRESSED = 2;
  static final int SELECTED = 3;

  public PaletteListener listener;
  public int state;
  public int oldState;

  public PaletteButton() {
  }

  public PaletteButton(PaletteListener l) {
    listener = l;
    state = oldState = NORMAL;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.setMaximumSize(new Dimension(24, 24));
    this.setMinimumSize(new Dimension(24, 24));
    this.setPreferredSize(new Dimension(24, 24));
    this.setBorderPainted(false);
    this.setFocusPainted(false);
    this.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
      public void mouseMoved(MouseEvent e) {
        this_mouseMoved(e);
      }
      public void mouseDragged(MouseEvent e) {
        this_mouseDragged(e);
      }
    });

    this.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseEntered(MouseEvent e) {
        this_mouseEntered(e);
      }
      public void mouseExited(MouseEvent e) {
        this_mouseExited(e);
      }
      public void mouseReleased(MouseEvent e) {
        this_mouseReleased(e);
      }
      public void mousePressed(MouseEvent e) {
        this_mousePressed(e);
      }
    });
  }

  // catch in the mouse- methods  listener == null
  public void this_mouseEntered(MouseEvent e) {
  }

  public void this_mouseExited(MouseEvent e) {
    if (state==PRESSED)
      this_mouseDragged(e);
    if (listener != null)
      listener.paletteUserOver(this, false);
  }

  public void this_mouseReleased(MouseEvent e) {
    state = oldState;
    if (listener != null)
      listener.paletteUserSelected(this);
  }

  public void this_mouseMoved(MouseEvent e) {
    if (listener != null)
      listener.paletteUserOver(this,true);
  }

  public void this_mouseDragged(MouseEvent e) {
    if (contains(e.getX(),e.getY()))
      state = PRESSED;
    else
      state = oldState;
  }

  public void this_mousePressed(MouseEvent e) {
    oldState = state;
    state = PRESSED;
  }
  // methods from PaletteButton
  public Object value() {
    return null;
  }
  public String name() {
    return " ";
  }
  public void reset() {
    setSelected(false);
  }
  public void select() {
    setSelected(true);
  }
}