package CH.ifa.draw.standard;

import java.awt.*;
import javax.swing.*;
import CH.ifa.draw.util.*;
import CH.ifa.draw.framework.*;

import java.awt.event.*;

/**
 * berschrift:   JHotDraw
 * Beschreibung:  Quellen und Dateien des Paketes JHotDraw zur Evaluierung.
 * Copyright:     Copyright (c) 2001
 * Organisation:
 * @author
 * @version 1.0
 */

public class ToolButton extends PaletteButton {

  static final String dummyName = "CH.ifa.draw.images.Button"; // if one icon doesn't exists

  private String name;
  private Tool tool;

  public Iconkit kit = Iconkit.instance();

  public ToolButton() {
    super();
  }

  public ToolButton(PaletteListener listener, String iconName, String name, Tool tool) {
    super(listener);

    this.tool = tool;
    this.name = name;

    setIcons(iconName);
  }
  public void setIcons(String iconName) {
    if (kit == null)
      throw new HJDError("Iconkit instance isn't set");

    Image im[] =new Image[3];
    Image dummy[] = new Image[1];
    im[0] = kit.loadImageResource(iconName+"1.gif");
    im[1] = kit.loadImageResource(iconName+"2.gif");
    im[2] = kit.loadImageResource(iconName+"3.gif");

    MediaTracker t = new MediaTracker(this);
    for (int i=0; i < 3; i++) {
      t.addImage(im[i],i);
    }
    try {
      t.waitForAll();
    } catch (Exception e) {}

    /* old
    setSelectedIcon(new ImageIcon(im[1]));
    setIcon(new ImageIcon(im[0]));
    setPressedIcon(new ImageIcon(im[2]));
    */
    // to ensure that always an icon is created. ensure, that the icons <DummyName>?.gif
    // exists
    try {
      setIcon(new ImageIcon(im[0]));
    } catch (Exception ex) {
      dummy[0] = kit.loadImageResource(dummyName+"1.gif");
      setIcon(new ImageIcon(dummy[0]));
    }
    try {
      setSelectedIcon(new ImageIcon(im[1]));
    } catch (Exception ex) {
      dummy[0] = kit.loadImageResource(dummyName+"2.gif");
      setSelectedIcon(new ImageIcon(dummy[1]));
    }
    try {
      setPressedIcon(new ImageIcon(im[2]));
    } catch (Exception ex) {
      dummy[0] = kit.loadImageResource(dummyName+"3.gif");
      setPressedIcon(new ImageIcon(dummy[2]));
    }

  }

  public Tool tool() {
    return tool;
  }
  public String name() {
    return name;
  }
  public Object attributeValue() {
    return tool();
  }

}