package cocon;

import CH.ifa.draw.framework.Figure;  // JHotdraw
import CH.ifa.draw.framework.FigureChangeEvent; // JHotdraw
import CH.ifa.draw.internal.SpinPanel;  // Hotdraw: own subclass  
import CH.ifa.draw.standard.SpinDrawingView;  // Hotdraw: own subclass
import CH.ifa.draw.standard.StandardDrawing;  // JHotdraw

import java.beans.PropertyChangeEvent;

import java.util.Enumeration;

import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.event.TreeSelectionListener;

import miningmart.hci.gui.main.Application;

import socrat.Workspace;

/**
 * This view visualises the <code>CoModelConnection</code> relation among
 * objects showing them in a graph. The nodes of the graph are pics of
 * objects from different classes.
 * We only visualized one the elements of one folder
 * @author Detlef Geppert
 * @version 1.0
 */

public class CoObjectHotdrawView extends CoGraphView implements TreeModelListener, InternalFrameListener  {

  // the active folder
  private CoFolder shownFolder = null;

  public CoObjectHotdrawView() {
    initCoObjectHotdrawView();
  }

  public int initCoObjectHotdrawView() {
    viewPanel = new SpinPanel();
    getHotdrawPanel().setModel(null);
    getHotdrawPanel().getTree().getSelectionModel().setSelectionMode(
      TreeSelectionModel.SINGLE_TREE_SELECTION
    );
    return 0;
  }
  public CoObject getRootNode() {
    if (getHotdrawPanel() == null) return null;
    if (getHotdrawPanel().getModel() == null) return null;
    return (CoObject)getHotdrawPanel().getModel().getRoot();
  }
  public DefaultTreeModel getTreeModel() {
    if (getHotdrawPanel() == null) return null;
    return (DefaultTreeModel)getHotdrawPanel().getModel();
  }
  public CoObject getSelectedNode() {
    SpinPanel viewPanel = getHotdrawPanel();
    if (viewPanel != null)
      return viewPanel.getSelectedNode();
    else
      return null;
  }
  public SpinPanel getHotdrawPanel() { // erspart den cast nach SpinPanel
    return (SpinPanel)getViewPanel();
  }
  public void setSelectedNode(CoObject node) {
    SpinPanel viewPanel = getHotdrawPanel();
    if (viewPanel != null)
      viewPanel.setSelectedNode(node);
  }
  public int getSelectionCount() {
    if (getHotdrawPanel() == null) return -1;
    return getHotdrawPanel().getSelectionCount();
  }
  // set / get the active(shown) folder
  public void setShownFolder(CoFolder f) {
    shownFolder = f;
    firePropertyChange("WindowName","",f.getName());
  }
  public CoFolder getShownFolder() {
    return shownFolder;
  }

  /***************************************************************************
   * gets the folder a given CoObject belongs to
   */
  public CoFolder getFolder(CoObject o) {
    CoObject folder = o;
    while (!(folder instanceof Workspace) && !(folder instanceof CoFolder) && folder != null)
      folder = (CoObject)folder.getParent();
    return (CoFolder)folder;
  }

  /****************************************************************************
   * CoView methods
   */
  public void updateView() {
    CoObject model = getModel();
    if (model==null) {
      getHotdrawPanel().setModel(null);
      return;
    }
    if (getRootNode()!=model) {
      getHotdrawPanel().setModel(new DefaultTreeModel(model));
    } else {
      getTreeModel().reload();
    }
    setShownFolder((CoFolder)getRootNode());
    ((SpinDrawingView)getHotdrawPanel().view()).drawFolder((CoFolder)getRootNode());
  }
  public String getWindowMenuName() {
    if (getShownFolder()==null) return " ";
    return getShownFolder().getName();
  }
  public String getWindowTitle() {
    if (getShownFolder()==null) return " ";
    return getShownFolder().getName();
  }
    /**
     * Creates the drawing used in this Application.
     * You need to override this method to use a Drawing
     * subclass in your Application. By default a standard
     * Drawing is returned.
     *
    protected Drawing createDrawing() {
        return new StandardDrawing();
    }*/


  /****************************************************************************
   * PropertyChangeListener
   */
  public void propertyChange(PropertyChangeEvent evt) {
    Figure f = null;
    if (getHotdrawPanel() != null) {
      Enumeration e = getHotdrawPanel().view().selectionElements();
      while (e.hasMoreElements()) {
        f = (Figure)e.nextElement();
        if (f.listener()!=null)
          f.listener().figureChanged(new FigureChangeEvent(f));
      }
      getHotdrawPanel().repaint();
    }
  }

  /****************************************************************************
   * TreeSelectionListener for reaction on selection in the tree - necessary??
   */
  public void valueChanged(TreeSelectionEvent e) {
    // test, wether the hotdrawview ist active. If, then nothing to do, the
    // changeEvent happens because of setting the selected node in the tree
    // because of the click in the HotdrawView
    if(Application.getActiveWindow()==Application.GRAPH_VIEW)
      return;
    TreePath path = null;
    CoFolder toShow = null;
    path = e.getNewLeadSelectionPath();
    if (path != null) {
      CoObject selectedNode = (CoObject)path.getLastPathComponent();
      if (selectedNode != null) {
        toShow = getFolder(selectedNode);
        if (toShow != null && !toShow.equals(getShownFolder())) {
          setShownFolder(toShow);
          //getHotdrawPanel().setDrawing(new StandardDrawing());
          ((SpinDrawingView)getHotdrawPanel().view()).drawFolder(toShow);
        }
        this.getHotdrawPanel().setSelectedNode(selectedNode);
        getHotdrawPanel().repaint();
      }
    }
  }

  /******************************************************************************
   * TreeModelListener - it listen to the tree from the treeview
   */
  public void treeNodesChanged(TreeModelEvent e) {
    //System.out.println("TreeNodeChangeEvent in Hotdraw");
  }
  public void treeNodesInserted(TreeModelEvent e) {
    //System.out.println("TreeNodeInsertedEvent in Hotdraw");
    Object insertAfter = e.getTreePath().getLastPathComponent();
    CoObject object = null;
    if(insertAfter instanceof Workspace || insertAfter instanceof CoFolder) {
      for (int i=0;i<e.getChildren().length;i++) {
        object = (CoObject)e.getChildren()[i];
        ((SpinDrawingView)getHotdrawPanel().view()).createAndInsertObjectFigure(object,getShownFolder());
      }
    }
  }
  public void treeNodesRemoved(TreeModelEvent e) {
    //System.out.println("treeNodes removed");//debug++
  }
  public void treeStructureChanged(TreeModelEvent e) {
    //only called, when a treenode is removed => redraw Folder
    //System.out.println("treestructure changed ");
    SpinDrawingView view = (SpinDrawingView)getHotdrawPanel().view();
    /*Object o = e.getTreePath().getLastPathComponent();
    if ((o instanceof Workspace) || (o instanceof CoFolder))
      view.drawing().removeAll(getHotdrawPanel().view().selection());*/
    //getHotdrawPanel().setDrawing(new StandardDrawing());
    view.drawFolder(getShownFolder());
  }

  /****************************************************************************
   * InternalFrameListener
   */
  public void internalFrameActivated(InternalFrameEvent e) {
    CoObject object = Application.getSelectedNode();
    getHotdrawPanel().toolDone();  // causes clearing of the selection,
    // so we set the selected node once again
    if ((object instanceof CoFolder) || (object instanceof Workspace)){
      Application.setSelectedNode(null); // to force a disableling of insertion
      Application.updateMenuInsert();
    }
    else
      Application.setSelectedNode(object);
  }
  public void internalFrameClosed(InternalFrameEvent e) {
  }
  public void internalFrameClosing(InternalFrameEvent e) {
  }
  public void internalFrameDeactivated(InternalFrameEvent e) {
  }
  public void internalFrameDeiconified(InternalFrameEvent e) {
  }
  public void internalFrameIconified(InternalFrameEvent e) {
  }
  public void internalFrameOpened(InternalFrameEvent e) {
  }

  /****************************************************************************
   * CiConnectionChangeListener
   */

  public void addedInConnection(CoConnectionChangeEvent cce) {
    super.addedInConnection(cce);
  }

  public void addedOutConnection(CoConnectionChangeEvent cce) {
    super.addedOutConnection(cce);
  }

  public void addedConnection(CoConnectionChangeEvent cce) {
    super.addedConnection(cce);
    CoObject model = getModel();
    CoConnection connection = cce.getConnection();
    if(connection instanceof CoViewConnection && cce.getSource() == this) {
      // If we have been attached to some model and have to visualise it
      // Connect also our subviews to the corresponding submodels
      updateView();
    }
    // If some new node has appeared below the model's root node (and new node is seen) then update the view to show it
    if(model != null && connection instanceof CoChildConnection && model.isNodeDescendant((CoObject)cce.getSource())) {
      getTreeModel().nodesWereInserted((CoObject)cce.getSource(),new int[] {((CoObject)cce.getSource()).getIndex((CoObject)cce.getDestination())});
    }
    // what to do if a model connection is inserted??
    if (connection instanceof CoModelConnection) {
      // view has to be repainted, when a connection to an "extern" node
      // has been inserted
      if (!getFolder((CoObject)cce.getSource()).equals(getShownFolder()) ||
            !getFolder((CoObject)cce.getDestination()).equals(getShownFolder())) {
          //getHotdrawPanel().setDrawing(new StandardDrawing());
          ((SpinDrawingView)getHotdrawPanel().view()).drawFolder(getShownFolder());
      } else {
        ((SpinDrawingView)getHotdrawPanel().view()).addModelConnection(cce.source, cce.destination,connection);
        getHotdrawPanel().repaint();
      }
    }
  }

  public void removedInConnection(CoConnectionChangeEvent cce) {
    super.removedInConnection(cce);
  }

  public void removedOutConnection(CoConnectionChangeEvent cce) {
    super.removedOutConnection(cce);
  }

  public void removedConnection(CoConnectionChangeEvent cce) {
    super.removedConnection(cce);
    CoObject model = getModel();
    CoConnection connection = cce.getConnection();

    if(connection instanceof CoViewConnection && cce.getSource() == this) {
      // If we have been dettached from our current model
      ; // Disconnect also our subviews from the corresponding submodels
      updateView();
    }
    // If some existing node has disappeared below the model's root node excluding the root node itself (and the deleted node or its parent is visible) then update the view to show it
    if(model != null && connection instanceof CoChildConnection && model.isNodeDescendant((CoObject)cce.getSource())) {
      getTreeModel().nodeStructureChanged((CoObject)cce.getSource());
      // getTreeModel().reload((CoObject)cce.getSource()); // It also works
      // getTreeModel().nodesWereRemoved((CoObject)cce.getSource(),int[] childIndices,new Object[] {cce.getDestination()}); // It is better but we do not know the index of the deleted node
    }
    // remove model connection in View
    if (connection instanceof CoModelConnection) {
      // only redraw the folder
      //getHotdrawPanel().setDrawing(new StandardDrawing());
      ((SpinDrawingView)getHotdrawPanel().view()).drawFolder(getShownFolder());
      // synchronize the selection
      setSelectedNode(((CoObjectTreeView)Application.documentView).getSelectedNode());
    }
  }
  // methods for seperating hotdraw from other projects
  public void toolDone() 
  {
    getHotdrawPanel().toolDone();  
  }
  public void openPanel() 
  {
    getHotdrawPanel().open();
  }
  public void addTreeSelListener(TreeSelectionListener l) 
  {
    getHotdrawPanel().getTree().addTreeSelectionListener(l);
  }
  public Enumeration getSelectionElements() 
  {
    return getHotdrawPanel().view().selectionElements();
  }
}