package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.figures.*;

import java.awt.event.*;
import java.util.*;

import miningmart.hci.gui.main.*;
import cocon.*;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class UnMergeTool extends SpinSelectionTool 
{
  public UnMergeTool(){
    super();
  }
  public UnMergeTool(DrawingView view) {
    super(view);
  }

  public void mouseReleasedInView(MouseEvent e) {
    Figure figure = drawing().findFigure(e.getX(),e.getY());
    CoObject o;
    if (figure!=null) {
      if (figure instanceof ComponentFigure) {
        o = ((ComponentFigure)figure).getObject();
        editor().toolDone();
        Application.dispatcher.unmergeChain(o);
      }
    }
    editor().toolDone();
  }
}