package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.SpinContext;

import javax.swing.AbstractAction;

import miningmart.hci.gui.chInterface.SpinToolButtonI;
import miningmart.hci.gui.chInterface.ToolI;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinToolButton extends ToolButton implements SpinToolButtonI {
  static final String dummyName = SpinContext.IMAGES+SpinContext.SPIN+"Button"; // if one icon doesn't exists

  private AbstractAction action;

  public SpinToolButton(AbstractAction action, String iconName, String name, ToolI tool) {
    super(null, iconName, name, (Tool)tool);

    if (action!= null)
      setAction(action);
 
    super.setIcons(iconName);  // this call is necassary although it is called in the constructor of the supreclass, too
  }

  public void setPaletteListener(PaletteListener paletteListener) {
    listener=paletteListener;
  }
  public PaletteListener getPaletteListener() {
    return listener;
  }

  public String name() {
    if(isEnabled())
      return super.name();
    else
      return null;
  }


}