package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.SpinLineConnection;
import CH.ifa.draw.figures.SpinTextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;

import java.awt.event.MouseEvent;

import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.chInterface.ToolI;
import miningmart.hci.gui.main.Application;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinSelectionTool extends SelectionTool implements SpinTool, ToolI{

  public SpinSelectionTool(DrawingView view) {
    super(view);
  }
  public SpinSelectionTool() 
  {
    super(null);
  }

  public void setView(DrawingView view) {
    fView = view;
  }

  /***************************************************************************
   * react on mouseEvents. Therefor pass the event to the component at point
   * from e. this fuctions are called and not a direct Reaktion on an event.
   */
  public void mouseClickedInView(MouseEvent e) {
    Figure figure = drawing().findFigure(e.getX(),e.getY());
    if (figure!=null) {
      if (figure instanceof ComponentFigure)
        ((ComponentFigure)figure).mouseClicked(e);
      else if (figure instanceof SpinLineConnection)
        ((SpinLineConnection)figure).mouseClicked(e);
      else if (figure instanceof SpinTextFigure)
        ((SpinTextFigure)figure).mouseClicked(e);
    } else // no figure hit
      Application.setSelectedNode(null);
  }
  public void mousePressedInView(MouseEvent e) {
    Figure figure = drawing().findFigure(e.getX(),e.getY());
    if (figure!=null) {
      if (figure instanceof ComponentFigure)
        ((ComponentFigure)figure).mousePressed(e);
      else if (figure instanceof SpinLineConnection)
        ((SpinLineConnection)figure).mousePressed(e);
      else if (figure instanceof SpinTextFigure)
        ((SpinTextFigure)figure).mousePressed(e);
    } else {// no figure hit
      Application.setSelectedNode(null);
    }
  }
  public void mouseReleasedInView(MouseEvent e) {
    Figure figure = drawing().findFigure(e.getX(),e.getY());
    if (figure!=null) {
      if (figure instanceof ComponentFigure)
        ((ComponentFigure)figure).mouseReleased(e);
    }
    Application.dispatcher.updateControls();
  }


  // ToolI- Interface
  public void setPrototype(FigureI f) {
  }
}

