package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.SpinLineConnection;
import CH.ifa.draw.figures.SpinTextFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.FigureVector;

import cocon.CoConnection;
import cocon.CoFolder;
import cocon.CoFolderConnection;
import cocon.CoModelConnection;
import cocon.CoObject;
import cocon.CoObjectTreeView;
import cocon.CoObjectHotdrawView;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

import java.util.Vector;

import javax.swing.AbstractAction;

import miningmart.hci.gui.main.Application;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinDrawingView extends StandardDrawingView {
  private int objectCount;
  private final int FIGURE_SIZE = 20;
  private final int SPACE_SIZE = 15;
  private Point insertPoint = null;

  private Dimension fViewSize = new Dimension(600,600);
  private FigureVector figures; // default

  public SpinDrawingView(DrawingEditor editor, int width, int height) {
    super(editor,width,height);
    this.setBackground(Color.white);
  }
  public void mouseClicked(MouseEvent e) { // necessary?? - yes for doubleClick
    if (tool() instanceof SpinSelectionTool) {
      ((SpinSelectionTool)tool()).mouseClickedInView(e); // cast necessary? - yes.
      this.repaint();
      Application.updateMenuEdit();
    }
  }
  public void mousePressed(MouseEvent e) {
    super.mousePressed(e);
    if (tool() instanceof SpinSelectionTool && selectionCount()<2) {
      ((SpinSelectionTool)tool()).mousePressedInView(e); // cast necessary? - yes.
      this.repaint();
      Application.updateMenuEdit();
    }
  }
  public void mouseReleased(MouseEvent e) {
    super.mouseReleased(e);
    if (tool() instanceof SpinSelectionTool) {
      ((SpinSelectionTool)tool()).mouseReleasedInView(e); // cast necessary? - yes.
    }
  }

  public void setDrawingViewSize(int x, int y) {
    fViewSize = new Dimension(x,y);
  }
  public Dimension getMinimumSize() {
    return fViewSize;
  }

  public void drawFolder(CoFolder folder) {
    ((CoObjectHotdrawView)Application.graphDocumentView).setShownFolder(folder);
    setDrawing(new StandardDrawing());
    objectCount = 0;
    CoObject object;
    Vector objectVector = new Vector();
    figures = new FigureVector();
    int i=0;
    while (folder != null && folder.getChildAt(i)!=null) {
      object = (CoObject)folder.getChildAt(i++);
      objectVector.add(object);
    }

    CoModelConnection c = new CoModelConnection();
    int j, inConnectionCount, outConnectionCount;
    Vector connectedObjects = new Vector();
    CoObject destination, source;
    CoObject connectedFolder;

    for (i=0;i<objectVector.size();i++) { //dg05.07
      object = (CoObject)objectVector.get(i);

      /* collect objects, which are connected to the objects in the folder by
      // a modelconnection and which belongs to a different folder
      outConnectionCount = object.getOutConnectionCount(c.getClass());
      inConnectionCount = object.getInConnectionCount(c.getClass());
      for (j=0; j<outConnectionCount || j< inConnectionCount;j++) {
        if (j<outConnectionCount) {
          destination = (CoObject)object.getOutConnection(c.getClass(),j).getDestination();
          if (!folder.equals(Application.graphDocumentView.getFolder(destination)) &&
              (!connectedObjects.contains(destination)) )
            connectedObjects.add(destination);
        }
        if (j<inConnectionCount) {
          source = (CoObject)object.getInConnection(c.getClass(),j).getSource();
          if (!folder.equals(Application.graphDocumentView.getFolder(source)) &&
              (!connectedObjects.contains(source)) )
            connectedObjects.add(source);
        }
      }*/
      // changed to:
      // collect folders with objects connected to objects in the <folder>
      // for them a CoFolderConnection is inserted
      CoFolderConnection fc = new CoFolderConnection();
      outConnectionCount = object.getOutConnectionCount(fc.getClass());
      inConnectionCount = object.getInConnectionCount(fc.getClass());
      for (j=0; j<outConnectionCount || j< inConnectionCount;j++) {
        if (j<outConnectionCount) {
          connectedFolder = (CoObject)object.getOutConnection(fc.getClass(),j).getDestination();
          if ((connectedFolder instanceof CoFolder) && 
              !folder.equals(connectedFolder) && 
              !connectedObjects.contains(connectedFolder) && 
              !folder.equals(connectedFolder.getParent())
            ) 
          {
            connectedObjects.add(connectedFolder);            
          }
        }
        if (j<inConnectionCount) {
          connectedFolder = (CoObject)object.getInConnection(fc.getClass(),j).getSource();
          if ((connectedFolder instanceof CoFolder) && 
              !folder.equals(connectedFolder) && 
              !connectedObjects.contains(connectedFolder) && 
              !folder.equals(connectedFolder.getParent())
            ) 
          {
            connectedObjects.add(connectedFolder);
          }
        }
      }

      // insert object      
      //if ((object != folder) && !(object instanceof CoObjectTreeView))
      if(!(object instanceof CoObjectTreeView))
        createAndInsertObjectFigure(object, folder);
    }

    // insert connected objects in view
    for (i=0; i<connectedObjects.size();i++) {
      object = (CoObject)connectedObjects.get(i);
      //if ((object != folder) && !(object instanceof CoObjectTreeView))
      if(!(object instanceof CoObjectTreeView))
        createAndInsertObjectFigure(object, folder);
    }

    objectVector.addAll(connectedObjects);

    SpinConnectionTool connectionTool = new SpinConnectionTool(
      this,new SpinLineConnection()
    );
    CoModelConnection modelConnection;
    CoFolderConnection folderConnection;

    for (i=0; i<objectVector.size(); i++) {
      object = (CoObject)objectVector.get(i);
      ComponentFigure startFigure = (ComponentFigure)figures.getFigureWithObject(object);
      ComponentFigure endFigure=null;
      if (startFigure!=null) {
        // insert arrows for model connections
        outConnectionCount = object.getOutConnectionCount(c.getClass());
        for (j=0; j<outConnectionCount; j++) {
          modelConnection = (CoModelConnection)object.getOutConnection(c.getClass(),j);
          destination = (CoObject)modelConnection.getDestination();
          endFigure = (ComponentFigure)figures.getFigureWithObject(destination);
          /*if (endFigure==null) {
            endFigure = (ComponentFigure)figures.getFigureWithObject(
                          Application.graphDocumentView.getFolder(destination));
          }*/
          // add ConnectionFigure
          if (endFigure!=null) {
            connectionTool.createFigureConnection(startFigure, startFigure.center(),
              endFigure, endFigure.center(), modelConnection
            );
          }
        }
        // insert arrows for folder connections
        outConnectionCount = object.getOutConnectionCount(new CoFolderConnection().getClass());
        for (j=0; j<outConnectionCount; j++) {
          folderConnection = (CoFolderConnection)object.getOutConnection(new CoFolderConnection().getClass(),j);
          destination = (CoObject)folderConnection.getDestination();
          endFigure = (ComponentFigure)figures.getFigureWithObject(destination);
          if (endFigure==null) {
            endFigure = (ComponentFigure)figures.getFigureWithObject(
                          Application.graphDocumentView.getFolder(destination));
          }
          // add ConnectionFigure
          if (endFigure!=null) {
            connectionTool.createFigureConnection(startFigure, startFigure.center(),
              endFigure, endFigure.center(), folderConnection
            );
          }
        }
      }
    }
  }

  public ComponentFigure createAndInsertObjectFigure(CoObject o, CoFolder f) {
    String iconName = " ";
    //if (!(o instanceof CoFolder)) {
      String s = o.getClass().toString();
      if (o instanceof CoFolder) {
        iconName = "coFolder";
      } else {
        iconName = s.substring(s.lastIndexOf(".")+1);
      }
      SpinCreationTool ct=null;
      ComponentFigure figure = null;

      ct = new SpinCreationTool(this, new ComponentFigure(
        null, "images/"+iconName+".gif", new Point(0,0), f
      ));
      Point p = null;
      if (o.getPosition()!=null)
        p = o.getPosition().getLocation(f);
      if (p!=null && !p.equals(new Point(0,0)))
        ct.addFigure(p);
      else if (getInsertPoint()!=null) {
        ct.addFigure(getInsertPoint());
        o.getPosition().setLocation(getInsertPoint(),f);
      }  else {
        p = new Point((SPACE_SIZE+FIGURE_SIZE)* (++objectCount % 7),(FIGURE_SIZE)*objectCount);
        ct.addFigure(p);
        o.getPosition().setLocation(p,f);
      }
      figure=(ComponentFigure)ct.createdFigure();
      if (figure != null) {
        figure.setObject(o);
        if (o.getName() != null)
          figure.setAttribute("Name", o.getName());
        else
          figure.setAttribute("Name",iconName);
      }
      SpinTextFigure textFigure = new SpinTextFigure();
      textFigure.connect(figure);
      textFigure.setText(figure.getObject().getName());
      textFigure.connectorVisibility(true);
      add(textFigure);
      return figure;
    //} else return null;
  }
  public void addModelConnection(Object source, Object destination,CoConnection connection) {
    ComponentFigure startFigure = (ComponentFigure)figures.getFigureWithObject((CoObject)source);
    ComponentFigure endFigure = (ComponentFigure)figures.getFigureWithObject((CoObject)destination);
    SpinConnectionTool connectionTool;
    if (startFigure!=null && endFigure!=null) {
      connectionTool = new SpinConnectionTool(this, new SpinLineConnection());
      connectionTool.createFigureConnection(startFigure, startFigure.center(),
        endFigure, endFigure.center(), connection
      );
    }
  }

  // in the moment the figure isn't inserted imidiatly to the view. we insert
  // the new object in the tree and as a reaction on TreeStructureChangeEvent
  // the figure is inserted in view.
  public Figure add(Figure f) {
    if (f instanceof ComponentFigure) {
      figures.add(f);
      AbstractAction action = ((ComponentFigure)f).getAction();
      if (action != null) {
        Application.setSelectedNode(Application.graphDocumentView.getShownFolder());
        action.actionPerformed(new ActionEvent(f,0,""));
        return f;
      }
    }
    return super.add(f);
  }

  public void setFigures(FigureVector newFigures) {
    figures = newFigures;
  }
  public FigureVector getFigures() {
    return figures;
  }
  public void setInsertPoint(Point p) {
    insertPoint = p;
  }
  public Point getInsertPoint() {
    return insertPoint;
  }

  /**
   * Handles key down events. Cursor keys are handled
   * by the view the other key events are delegated to the
   * currently active tool.
   * overwritten because of the new DeleteCommand
   */
  public void keyPressed(KeyEvent e) {
    int code = e.getKeyCode();
    if ((code == KeyEvent.VK_BACK_SPACE) || (code == KeyEvent.VK_DELETE)) {
      Command cmd = new SpinDeleteCommand("Delete", this);
      cmd.execute();
    } else if (code == KeyEvent.VK_DOWN || code == KeyEvent.VK_UP ||
      code == KeyEvent.VK_RIGHT || code == KeyEvent.VK_LEFT) {
      handleCursorKey(code);
    } else {
      tool().keyDown(e, code);
    }
    checkDamage();
  }
}
