package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.SpinLineConnection;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.internal.SpinPanel;

import cocon.CoModelConnection;
import cocon.CoObject;

import javax.swing.JComponent;

import miningmart.hci.gui.chInterface.CommandI;
import miningmart.hci.gui.main.Application;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinDeleteCommand extends DeleteCommand implements CommandI {
  private String fName;

  public SpinDeleteCommand(String name, JComponent viewComponent, Integer i) {
    super(name, ((SpinPanel)viewComponent).view());
    fName = name;
  }
  public SpinDeleteCommand(String name, DrawingView view) {
    //if (viewComponent instanceof SpinPanel) {
      super(name, view);
      fName = name;
    //}
  }

  public void setVar(String name, JComponent viewComponent) 
  {
    fName = name;
    fView = ((SpinPanel)viewComponent).view();
  }

  public void execute() {
    /**
     * when deleting, the figure-enumeration will be traversed and every figure
     * is deleted with 'editDelete()' from the dispatcher. Therefor the object
     * has to be selected.
     */
    Figure f;
    FigureEnumeration figures = fView.selectionElements();
    super.execute();
    while (figures.hasMoreElements()) {
      f = figures.nextFigure();
      if(f instanceof ComponentFigure) {
        Application.setSelectedNode(((ComponentFigure)f).getObject());
        Application.dispatcher.editDelete();
      } else if(f instanceof SpinLineConnection) {
        SpinLineConnection connection = (SpinLineConnection)f;
        CoObject start = ((ComponentFigure)connection.startFigure()).getObject();
        CoObject end = ((ComponentFigure)connection.endFigure()).getObject();
        CoModelConnection c = new CoModelConnection();
        start.removeConnection(((SpinLineConnection)f).getConnection());
      }
    }

    // delete in view
    // deleteSelection(); - is implezit done
    fView.clearSelection();
    fView.checkDamage();
  }

  public boolean isExecutable() {
    //return fView.selectionCount() > 0;
    return super.isExecutable();
  }

}