package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.SpinContext;

import cocon.CoObject;

import java.awt.Point;
import java.awt.event.MouseEvent;

import miningmart.hci.gui.chInterface.ComponentFigureI;
import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.chInterface.ToolI;
import miningmart.hci.gui.main.Application;

/**
 * berschrift:   Spin- View
 * Beschreibung:  A View to create, manipulate and show a SPIN!- workspace
 * Copyright:     Copyright (c) 2001
 * Organisation:  GMD-AiS.KD
 * @author detlef geppert
 * @version       1.0
 */

public class SpinCreationTool extends CreationTool implements SpinTool, ToolI {
  private Figure fCreatedFigure;
  private Point fAnchorPoint;
  /**
   * Initializes a CreationTool with the given prototype.
   */
  public SpinCreationTool(DrawingView view, Figure prototype) {
    super(view, prototype);
  }
  public SpinCreationTool(ComponentFigureI  prototype) 
  {
    super(null,(Figure)prototype);
  }
  public SpinCreationTool() 
  {
    super(null, null);
  }
  
  // implementation von Interface SpinTool
  public void setView(DrawingView view) {
    fView = view;
  }

  /**
   * Constructs a CreationTool without a prototype.
   * This is for subclassers overriding createFigure.
  */
  protected SpinCreationTool(DrawingView view) {
    super(view);
  }
  protected Figure createdFigure() {
    return fCreatedFigure;
  }
  public void addFigure(Point p1, Point p2) {
    fCreatedFigure = createFigure();
    fCreatedFigure.displayBox(p1, p2);
    view().add(fCreatedFigure);
  }
  public void addFigure(Point p1) {
    int s = SpinContext.IMAGE_SIZE;
    fCreatedFigure = createFigure();
    fCreatedFigure.displayBox(p1, new Point(p1.x + s, p1.y + s));
    view().add(fCreatedFigure);
  }

  // overwrite, because of the variable fCreatedFigure. in superclass = null;
  public void mouseDrag(MouseEvent e, int x, int y) {}
  public void mouseDown(MouseEvent e, int x, int y) {
    ((SpinDrawingView)view()).setInsertPoint(new Point(x,y));
    fCreatedFigure = createFigure();
    view().add(fCreatedFigure);
    ((SpinDrawingView)view()).setInsertPoint(null);// necessary??
  }
  public void mouseUp(MouseEvent e, int x, int y) {
    CoObject o = Application.getSelectedNode();
    editor().toolDone();
    Application.setSelectedNode(o);
  }

  // ToolI- Interface
  public void setPrototype(FigureI f) {
    fPrototype = (Figure)f;
  }
}