package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.figures.SpinLineConnection;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;

import cocon.CoConnection;
import cocon.CoModelConnection;
import cocon.CoObject;

import java.awt.Point;

import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.chInterface.ToolI;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinConnectionTool extends ConnectionTool implements SpinTool, ToolI {

  public SpinConnectionTool(DrawingView view, ConnectionFigure prototype) {
    super(view, prototype);
  }
  public SpinConnectionTool(FigureI prototype) 
  {
    super(null,(ConnectionFigure)prototype);
  }
  public SpinConnectionTool() 
  {
    super(null, null);
  }

  public void setView(DrawingView view) {
    fView = view;
  }

  /****************************************************************************
   * procedure inserts a connection between two given figures. the connection
   * isn't created in the view, but is given by external dependencies
   */
  public void createFigureConnection(Figure startTarget, Point startPoint,
      Figure endTarget, Point endPoint, CoConnection modelConnection) {
    Connector startConnector;
    Connector endConnector;
    ConnectionFigure connection;

    if ((startTarget != null) && (endTarget !=null)) {
      int x = startPoint.x;
      int y = startPoint.y;
      startConnector = findConnector(x, y, startTarget);
      if (startConnector != null) {
        connection = createConnection();
        connection.startPoint(x, y);
        x = endPoint.x;
        y = endPoint.y;
        endConnector = findConnector(x, y, endTarget);
        if (endConnector != null) {
          ((SpinLineConnection)connection).setConnection(modelConnection);
          connection.endPoint(x, y);
          connection.connectStart(startConnector);
          connection.connectEnd(endConnector);
          view().add(connection);
          connection.updateConnection();
        }
      }
    }
  }

  /**
   * is called in mouseUp to insert external dependencies for which the 
   * connection stands for.
   */
  public void doAdditionalWork() {
    ConnectionFigure fConnection = createdFigure();
    Figure start = ((SpinLineConnection)fConnection).startFigure();
    Figure end = ((SpinLineConnection)fConnection).endFigure();
    if (start instanceof ComponentFigure && end instanceof ComponentFigure) {
       //  delete from the Connection in view, will be inserted with CoConnection
      if (fConnection != null)
        view().remove(fConnection);
      CoObject startObject = ((ComponentFigure)start).getObject();
      startObject.addConnection(new CoModelConnection(), ((ComponentFigure)end).getObject());
    }
  }

  private Connector findConnector(int x, int y, Figure f) {
    return f.connectorAt(x, y);
  }

  // ToolI- Interface
  public void setPrototype(FigureI f) {
    fPrototype = (ConnectionFigure)f;
  }
}