package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.SpinTextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;

import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.chInterface.ToolI;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinConnectedTextTool extends ConnectedTextTool implements SpinTool, ToolI {

  public SpinConnectedTextTool(DrawingView view, Figure prototype) {
    super(view,prototype);
  }
  public SpinConnectedTextTool(FigureI prototype) 
  {
    super(null,(SpinTextFigure)prototype);
  }
  public SpinConnectedTextTool() {
    super(null, null);
  }
  public void setView(DrawingView view) {
    fView=view;
  }
  // ToolI- Interface
  public void setPrototype(FigureI f) {
    fPrototype = (SpinTextFigure)f;
  }
}