package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.figures.*;

import java.awt.event.*;
import java.util.*;

import miningmart.hci.gui.main.*;
import cocon.*;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class MergeTool extends SpinSelectionTool 
{
  public MergeTool() {
    super();
  }
  public MergeTool(DrawingView view) {
    super(view);
  }
  
  public void mouseReleasedInView(MouseEvent e) {
    super.mouseReleasedInView(e);
    // collect every selected step and folder
    Vector steps = new Vector();
    Vector selection = fView.selection();
    Figure f = null;
    CoObject o;
    for (Iterator it= selection.iterator(); it.hasNext(); ) {
      f = (Figure)it.next();
      if (f instanceof ComponentFigure) {
        o = ((ComponentFigure)f).getObject();
        steps.add(o);
      }
    }
    editor().toolDone();
    Application.dispatcher.mergeToChain(steps,e.getPoint());
  }
}