package CH.ifa.draw.internal;

import CH.ifa.draw.figures.ComponentFigure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.SpinDrawingView;
import CH.ifa.draw.standard.SpinSelectionTool;
import CH.ifa.draw.standard.SpinTool;
import CH.ifa.draw.standard.SpinToolButton;
import CH.ifa.draw.standard.StandardDrawingView;

import cocon.CoComponent;
import cocon.CoComponentList;
import cocon.CoObject;
import cocon.CoObjectHotdrawView;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.JButton;

import miningmart.hci.gui.main.Application;
import miningmart.hci.gui.chInterface.SpinPanelI;
import cocon.util.SpinTree;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinPanel extends DrawPanel implements SpinPanelI{ // implements MouseListener {

  /***************************************************************************
   * Own DrawingView, because of the mouseevent "mouse clicked"
   * so it's necessary to overwrite "createDrawingView", see below !!
   */
  private SpinDrawingView fView = (SpinDrawingView)createDrawingView();
  // jtree to react like the TreeView. changes and selections are passed.
  private SpinTree viewTree;

  // to change the scrollpane
  private JScrollPane sp = null;

  JPanel palette = null;

  public SpinPanel() {
    super();
    initSpinPanel();
  }
  private void initSpinPanel() {
    viewTree = new SpinTree();
    add(viewTree,BorderLayout.EAST);
  }
  public StandardDrawingView createDrawingView() {
    Dimension d = getDrawingViewSize();
    fView = new SpinDrawingView(this, d.width, d.height);
    return fView;
  }

  public void destroy() {
    super.destroy();
  }

  /////////////////////////////////////////////////////////////////////////////
  // here the settings are done in socrat. here only the view eg. the
  // PaletteListener has to be set in the tool for each button
  /////////////////////////////////////////////////////////////////////////////
  protected void createTools(JPanel palette) {
    //super.createTools(palette);
    this.palette = palette;
    Tool tool =null;
    CoObject comp;
    CoComponent compItem;
    SpinToolButton button;

    CoComponentList componentList = Application.componentList;
    for (Enumeration componentEnumeration = componentList.depthFirstEnumeration(); componentEnumeration.hasMoreElements(); ) {
      comp = (CoObject)componentEnumeration.nextElement();
      if (comp instanceof CoComponent) {
        compItem = (CoComponent)comp;
        if(compItem.getComponentClass()!=null) {
          // diese abfrage spaeter weg, wenn HotdrawCreationTool fuer folder
          if(!compItem.toString().equalsIgnoreCase("folder")){
            button=(SpinToolButton)compItem.getInsertButton();
            button.setPaletteListener(this);
            ((SpinTool)button.tool()).setView(view());
          }
        }
      }
    }
    setDefaultToolButton((JButton)Application.getDefaultToolButton());
  }

  protected Tool createSelectionTool() {
    return new SpinSelectionTool(view());
  }

  public StandardDrawingView getView() {
    return fView;
  }
  public JPanel getPalette() {
    return palette;
  }

  /**
   * Creates the contents component of the application
   * frame. By default the DrawingView is returned in
   * a ScrollPane.
   */
  protected JComponent createContents(StandardDrawingView view) {
    sp = new JScrollPane(view);
    JScrollBar vadjust = sp.getVerticalScrollBar();
    JScrollBar hadjust = sp.getHorizontalScrollBar();
    hadjust.setUnitIncrement(16);
    vadjust.setUnitIncrement(16);
    return sp;
  }

  public void setScrollPaneView(SpinDrawingView view) {
    sp.setViewportView(view);
  }

  public CoObject getSelectedNode() {
    ComponentFigure figure;
    SpinDrawingView view = (SpinDrawingView)getView();
    Vector v = view.selection();
    if (v.size()==1)
      if (v.elementAt(0) instanceof ComponentFigure) {
        figure = (ComponentFigure)v.elementAt(0);
        return figure.getObject();
      }
    // if the view doesn't contain a selected node, we return the (unvisible,
    // e.g. Workspace) selected node from the SpinTree
    if (getTree().getSelectionModel().getLeadSelectionPath()!=null && v.size()==0)
      return (CoObject)getTree().getSelectionModel().getLeadSelectionPath().getLastPathComponent();
    else
      return null;
  }
  public void setSelectedNode(CoObject node) {
    Object figure;
    SpinDrawingView view = (SpinDrawingView)getView();
    view.clearSelection(); // fhrt allerdings zu mehrmaligem Selection-event.
    if (node!=null) {
      for (Enumeration figures = view.drawing().figures();figures.hasMoreElements();) {
        figure = figures.nextElement();
        if (figure.getClass().isInstance(new ComponentFigure()))
          if (node.equals(((ComponentFigure)figure).getObject())) {
            view.addToSelection((ComponentFigure)figure);
            ((SpinTree)getTree()).setSelectedNode(node);
            return;
          }
      }
    }
    ((SpinTree)getTree()).setSelectedNode(node);
  }
  public int getSelectionCount() {
    return getView().selectionCount();
  }
  public void setModel(TreeModel newTreeModel) {
    viewTree.setModel(newTreeModel);
  }
  public TreeModel getModel() {
    return viewTree.getModel();
  }
  public JTree getTree() {
    return viewTree;
  }

  public ComponentFigure insertObject(CoObject o) {
    ((CoObject)getModel().getRoot()).add(o);
    return ((SpinDrawingView)view()).createAndInsertObjectFigure(o,((CoObjectHotdrawView)view()).getShownFolder());
  }

  /*************************************************************************
   * SpinPanelI- Interface
   */
  public void setDrawingViewSize(int x, int y) 
  {
    ((SpinDrawingView)getView()).setDrawingViewSize(x,y);
  }

}