package CH.ifa.draw.figures;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */


import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;

import java.awt.Font;
import java.awt.event.MouseEvent;

import java.util.Vector;

import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.main.Application;

public class SpinTextFigure extends TextFigure implements FigureI {

  private final int OFFSET_X = 0;
  private final int OFFSET_Y = 20;
  private final int FONTSIZE = 9;
  private Figure f;

  public SpinTextFigure() {
    super();
    setFont(new Font(super.getFont().getName(),super.getFont().getStyle(),FONTSIZE));
  }
  // overwritten, because we predefine an offset
  public void connect(Figure figure) {
    super.connect(figure);
    f = figure;
    moveBy(OFFSET_X, OFFSET_Y);
  }
  // overwrite, because we don't want the text to be resizeable
  public Vector handles() {
    Vector handles = new Vector();
    handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
    handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
    handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
    handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
    return handles;
  }
  /***************************************************************************
   * react on double-click. This method is called from selectionTool and not
   * because of the event directly
   */
  public void mouseClicked(MouseEvent e) {
    if(e.getClickCount()==2 && (f instanceof ComponentFigure)) {
      Application.setSelectedNode(((ComponentFigure)f).getObject());
      // open edit- Window
      Application.dispatcher.editProperties();
    }
  }
  public void mousePressed(MouseEvent e) {
    if (f instanceof ComponentFigure)
      Application.setSelectedNode(((ComponentFigure)f).getObject());
  }

  protected void updateLocation() {
    if (f instanceof ComponentFigure)
      setText(((ComponentFigure)f).getObject().getName());
    super.updateLocation();
  }
  public void moveBy(int x, int y) {
    boolean isSelected = false; // true, if the textfigure is selected
    boolean figureIsSelected = false; // true, if connected f is selected
    FigureEnumeration figures = (FigureEnumeration)Application.graphDocumentView.getSelectionElements();
    Figure fig;
    while (figures.hasMoreElements()) {
      fig = figures.nextFigure();
      isSelected = isSelected || this.equals(fig);
      figureIsSelected = figureIsSelected || f.equals(fig);
    }
    if(!(figureIsSelected&&isSelected))
      super.moveBy(x,y);
  }
}