package CH.ifa.draw.figures;

import CH.ifa.draw.framework.Figure;

import cocon.CiConnectable;
import cocon.CoConnection;
import cocon.CoConnectionChangeEvent;
import cocon.CoConnectionDescriptor;
import cocon.CoModelConnection;
import cocon.CoObject;
import cocon.CoObjectHotdrawView;
import cocon.CoObjectTreeView;

import java.awt.Color;
import java.awt.event.MouseEvent;

import miningmart.hci.gui.chInterface.FigureI;
import miningmart.hci.gui.main.Application;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class SpinLineConnection extends LineConnection implements FigureI {
  private CoConnection connection=null;
  private boolean isConnected = true;
  private boolean isDisconnected = false;
  public SpinLineConnection() {
    super();
    setStartDecoration(null);
    setEndDecoration(new ArrowTip());
    this.setFrameColor(Color.gray);
  }
  // method called from selectiontool and not a reaction on event directly
  public void mouseClicked(MouseEvent e) {
    // reacts only on doubleClick. Selection has to be done via mousePressed
    if(e.getClickCount()==2) {
      CoObject start = ((ComponentFigure)startFigure()).getObject();
      CoObject end = ((ComponentFigure)endFigure()).getObject();
      CoObject toSelect;
      // the active view is a graphview. if not, this object wouldn't react.
      CoObjectHotdrawView view = (CoObjectHotdrawView)Application.graphDocumentView;

      // one of the endings is in the shown folder. get it for selection
      // fixes a bug in the reaction on mouseclicks
      if (view.getShownFolder().equals(view.getFolder(start)))
        toSelect = start;
      else
        toSelect = end;

      Application.setSelectedNode(toSelect);
      // open edit Connection window
      Application.dispatcher.editConnections();
    }
  }
  public void mousePressed(MouseEvent e) {
    ((CoObjectTreeView)Application.documentView).setSelectedNode(null); // clear selection
  }

  // handles the disconnection of a connection
  protected void handleDisconnect(Figure start, Figure end) {
    //System.out.println("disConnect?");
    if (isConnected  && start!=null && end!=null) {
      /*System.out.println("+++ disconnect "+
        (((MMStep)((ComponentFigure)start).getObject())).getName()+" => "+
        (((MMStep)((ComponentFigure)end).getObject())).getName()
      );*/
      isConnected=false;
      isDisconnected = true;
    }
  }

  // handles the connection of a connection
  protected void handleConnect(Figure start, Figure end) {
    //System.out.println("connect??");
    if (isDisconnected && start!=null && end!=null) {
      /*System.out.println("++++ connect "+
        (((MMStep)((ComponentFigure)start).getObject())).getName()+" => "+
        (((MMStep)((ComponentFigure)end).getObject())).getName()
      );*/
      // remove the model connection, if a new endpoint is connected
     ((ComponentFigure)start).getObject().removeConnection(this.getConnection());

     (((ComponentFigure)start).getObject()).addConnection(new CoModelConnection(),((ComponentFigure)end).getObject());
      isConnected = true;
      isDisconnected = false;
    }
  }

  public boolean canConnect(Figure start, Figure end) {
    if (!super.canConnect(start, end))
      return false;
    if ((start instanceof ComponentFigure) && (end instanceof ComponentFigure)) {
      // Check if this connection can be added by asking all interested objects
      CoObject source = ((ComponentFigure)start).getObject();
      CoObject destination = ((ComponentFigure)end).getObject();
      CoConnection connection = new CoModelConnection();
      CoConnectionChangeEvent cce;

      // code from class CoObjectConnectionView
      int i, connectionCount;

      CoConnectionDescriptor[] srcCD = source.getConnectionDescriptors();
      for(i=0; i<srcCD.length; i++) {
        if(srcCD[i].direction != CiConnectable.DIRECTION_FOREWARD) continue;
        if(! srcCD[i].connectionClass.isAssignableFrom(connection.getClass())) continue;
        if(! srcCD[i].destinationClass.isAssignableFrom(destination.getClass())) continue;
        connectionCount = source.getOutConnectionCount(srcCD[i].connectionClass, srcCD[i].destinationClass);
        if(srcCD[i].maxConnections >= 0 && srcCD[i].maxConnections <= connectionCount) continue;
        break; // Satisfying connection found
      }
      if(i == srcCD.length) { // No satisfying connection has been found
        this.setFrameColor(Color.gray);
        return false;
      }
      CoConnectionDescriptor[] dstCD = destination.getConnectionDescriptors();
      for(i=0; i<dstCD.length; i++) {
        if(dstCD[i].direction != CiConnectable.DIRECTION_BACKWARD) continue;
        if(! dstCD[i].connectionClass.isAssignableFrom(connection.getClass())) continue;
        if(! dstCD[i].sourceClass.isAssignableFrom(source.getClass())) continue;
        connectionCount = destination.getInConnectionCount(dstCD[i].connectionClass, dstCD[i].sourceClass);
        if(dstCD[i].maxConnections >= 0 && dstCD[i].maxConnections <= connectionCount) continue;
        break; // Satisfying connection found
      }
      if(i == dstCD.length) { // No satisfying connection has been found
        this.setFrameColor(Color.gray);
        return false;
      }

      // necessary??
      cce = new CoConnectionChangeEvent(this, connection, source, destination);
      source.canAddConnection(cce);
      if(cce.getError() < 0) {
        this.setFrameColor(Color.gray);
        return false;
      }
      destination.canAddConnection(cce);
      if(cce.getError() < 0) {
        this.setFrameColor(Color.gray);
        return false;
      }
      this.setFrameColor(Color.black);
      return true;
    } else {
      this.setFrameColor(Color.gray);
      return false;
    }
  }
  public void setConnection(CoConnection connection) {
    this.connection=connection;
  }
  public CoConnection getConnection() {
    return connection;
  }
}