package CH.ifa.draw.figures;

import CH.ifa.draw.internal.*;
import CH.ifa.draw.standard.*;

import cocon.*;

import java.awt.*;
import java.awt.event.*;

import java.util.*;
import java.sql.SQLException;

import javax.swing.*;
import javax.swing.tree.*;

import miningmart.hci.gui.chInterface.*;
import miningmart.hci.gui.main.*;
import miningmart.hci.operators.*;

import miningmart.m4.*;

/**
 * berschrift:   ConnectionClasses
 * Beschreibung:  Implementation of additional functionality necessary for 
 *                Spin!
 * Copyright:     Copyright (c) 2000-2003
 * Organisation:  Fraunhofer Institut fr Autonome intelligente Systeme
 * @author detlef geppert
 * @version 1.0
 */

public class ComponentFigure extends ImageFigure implements ComponentFigureI {
  private CoObject object;
  private AbstractAction insertAction = null;
  private cocon.CoFolder folder = null;

  public ComponentFigure() {
    fFileName = null;
    fImage = null;
    fDisplayBox = null;
  }
  public ComponentFigure(Image image,String fileName, Point origin, CoFolder f) {
    super(image, fileName,origin);
    folder = f;
    init();
  }
  public ComponentFigure(AbstractAction action, Image image, String fileName, Point origin, CoFolder f) {
    super(image, fileName,origin);
    folder = f;
    insertAction = action;
    init();
  }
  public ComponentFigure(AbstractAction action, String fileName, Point origin) {
    this(action, null, fileName, origin, null);
    init();
  }

/*  public void setParameter(Image image,String fileName, Point origin, CoFolder f) {
    fFileName = fileName;
    fImage = image;
    fDisplayBox = new Rectangle(origin.x, origin.y, 0, 0);
    if (fImage != null) {
      fDisplayBox.width = fImage.getWidth(this);
      fDisplayBox.height = fImage.getHeight(this);
    }
    folder = f;
    init();
  }*/

  private void init() {
    setAttribute("Name","");
    setAttribute("Description","");
    setAttribute("URL","");
  }

  /***************************************************************************
   * react on double-click. This method is called from selectionTool and not
   * because of the event directly
   */
  public void mouseClicked(MouseEvent e) {
    Application.setSelectedNode(getObject());
    if(e.getClickCount()==2) {
      // open edit- Window
      //((CoObjectHotdrawView)Application.graphDocumentView
      if (getObject() instanceof CoFolder) {
        SpinPanel panel = (SpinPanel)Application.graphDocumentView.getViewPanel();
        SpinDrawingView view = (SpinDrawingView)panel.getView();
        // panel.setDrawing(new StandardDrawing()); // for clearing the view
        // @todo: set correct name in view
        view.drawFolder((CoFolder)getObject());
      } else {
        Application.dispatcher.editOpen();
      }
    }
  }
  int oldX, oldY;
  public void mousePressed(MouseEvent e) {
    oldX = e.getX();
    oldY = e.getY();
    Application.setSelectedNode(getObject());
  }

  public void mouseReleased(MouseEvent e) {
    // only change position if figure moved
    if (oldX != e.getX() || oldY!=e.getY()) {
      CoObject object = getObject();
      Point p = displayBox().getLocation();
      object.getPosition().setLocation(p, folder);
      if (!Application.mmWorkspace.isReadOnly()) {
        if (object instanceof MMStep) {
          Step step = ((MMStep)object).m4Step;
          step.setPoint(step.getChain(), p);
          try {
            step.store();
          } catch (StorageException ex) {
            ex.printStackTrace();
          }
        } else if (object instanceof CoMMFolder) {
          CoMMFolder f = (CoMMFolder)object; 
          Chain chain = f.getChain();
          try {
            chain.setPoint(f.getParentChain(), p); // the exception is catched in M4Interface
            chain.store();
          } catch (SQLException ex) {
            ex.printStackTrace();
          } catch (StorageException ex) {
            ex.printStackTrace();
          }
        }
      }
    }
  }
  protected void basicMoveBy(int x, int y) {
    super.basicMoveBy(x,y);
    Point p = displayBox().getLocation();
    SpinPanel panel = (SpinPanel)Application.graphDocumentView.getViewPanel();
    SpinDrawingView view = (SpinDrawingView)panel.getView();
    Dimension d = view.getMinimumSize();
    int newX = (p.x>d.width-50)?p.x+50:d.width;
    int newY = (p.y>d.height-50)?p.y+50:d.height;
    if (newX!=d.width || newY!=d.height) {
      view.setDrawingViewSize(newX,newY);
      panel.setScrollPaneView(view);
    }
  }
  public void setObject(CoObject newObject) {
    object = newObject;
  }
  public CoObject getObject() {
    return object;
  }
  public AbstractAction getAction() {
    return insertAction;
  }

  public Vector handles() {
    Vector handles = new Vector();
    handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
    handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
    handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
    handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
    return handles;
  }
  public void setFolder(cocon.CoFolder newFolder) {
    folder = newFolder;
  }
  public cocon.CoFolder getFolder() {
    return folder;
  }

  public String toString() {
    return (String)getAttribute("Name");
  }

}