#!/bin/sh

##############################################################
#                       ATTENTION !!!                        #
# Do not run this script if you have valuable data inside of #
# your tablespace. The script deletes all M4 tables !!       # 
#                                                            #
# Furthermore, the script installs tables, a sequence,       #
# functions, and stored procedures into the business data    #
# schema:						     #
#                                                            #
#                         Tables:                            #
# - ColStatist1_T					     #
# - ColStatist2_T                                            #
#                                                            #
#			 Sequence:                           #
# - All_Sq                                                   #
#                                                            #
#                         PL/SQL:                            #
# - procedure dbWindow                                       #
# - procedure EMA                                            #
# - procedure SMA                                            #
# - procedure WMA                                            #
# - procedure SimpleSTSP                                     #
# - procedure Updatecolumnstatistics                         #
# - procedure Timevaluestatist                               #
# - procedure Nominalvaluestatist                            #
# - procedure Ordinalvaluestatist                            #
#
# - function Get_Type                                        #
# - function Get_Type2                                       #
# - function M4RandomNr                                      #
# - function M4RandomSelect                                  #
# - function m4_sample                                       #
# - function m4_sampleInit                                   #
# - function m4_sampleTerminate                              #
# - function column_datatype                                 #
# - function m4_date_to_timestamp                            #
# - function m4_timestamp_to_date                            #
# - function mm_add                                          #
# - function mm_divide                                       #
# - function M4randomnr                                      #
# - function m4_sample                                       #
# - function time_interv_to_cat                              #
# - function num_interv_to_cat                               #
#                                                            #
#                     Java Classes:                          #
# - miningmart.Attribute                                     #
# - miningmart.OutputColumnset                               #
# - miningmart.TimeValue                                     #
# - miningmart.DataType                                      #
# - miningmart.Quicksort                                     #
# - miningmart.TimeValueArray                                #
# - miningmart.DbConnector                                   #
# - miningmart.SMF                                           #
# - miningmart.ToWindow                                      #
# - miningmart.EMF                                           #
# - miningmart.SimpleSTSP                                    #
# - miningmart.WMF                                           #
# - miningmart.M4Random                                      #
# - miningmart.TimeOperatorException                         #
# - miningmart.Windowing                                     #
#                                                            #
# Please  make sure, that no PL/SQL functions/procedures     #
# or JAVA classes are overwritten in the business data       #
# schema !!                                                  #
##############################################################

# Please set user,password and SID before running the script:
# M4 schema:
M4USER=
M4PASS=
M4SID=

# Business data schema:
BDUSER=
BDPASS=
BDSID=

# How to run SQLPlus? In some cases you might have to set
# this variable to the absolute path.
SQL_PLUS=

# How to run the loadjava command? In some cases you might
# have to set this variable to the absolute path.
LOAD_JAVA=

# -------------

echo M4 schema: Installing M4 tables! | tee installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @CreateM4Tables.sql | tee -a installer.log

echo M4 schema: Installing M4 operator information! | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Operators.sql | tee -a installer.log

echo M4 schema: Installing a sequence! | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @MM_Sequence.sql | tee -a installer.log

echo M4 schema: Installing Functions Part1! | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @MM_Functions_1.sql | tee -a installer.log

# Not necessary (but not tested without, yet):
echo M4 schema: Installing Java Stored Procedures! | tee -a installer.log
${LOAD_JAVA} -user ${M4USER}/${M4PASS}@${M4SID} JavaStoredProc/*.java | tee -a installer.log

# Not necessary (but not tested without, yet):
echo M4 schema: Installing embedding PL/SQL functions/procedures for Java procedures! | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @MM_Functions_2.sql | tee -a installer.log

echo M4 schema: Installing database triggers! | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Triggers/packages.sql   | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Triggers/functions.sql  | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Triggers/procedures.sql | tee -a installer.log
${SQL_PLUS} ${M4USER}/${M4PASS}@${M4SID} @Triggers/triggers.sql   | tee -a installer.log


echo Business Data Schema: Installing two tables for column statistics | tee -a installer.log
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @CreateBusinessTables.sql | tee -a installer.log

echo "Business Data Schema: Installing a (dummy) sequence" | tee -a installer.log
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @MM_Sequence.sql | tee -a installer.log

echo Business Data Schema: Installing Java Stored Procedures!  | tee -a installer.log
${LOAD_JAVA} -user ${BDUSER}/${BDPASS}@${BDSID} JavaStoredProc/*.java | tee -a installer.log

echo Business Data Schema: Installing Functions Part1 | tee -a installer.log
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @MM_Functions_1.sql | tee -a installer.log

echo Business Data Schema: Installing embedding PL/SQL functions/procedures for Java procedures! | tee -a installer.log
${SQL_PLUS} ${BDUSER}/${BDPASS}@${BDSID} @MM_Functions_2.sql | tee -a installer.log










