@echo off

REM *************************************************************
REM                        ATTENTION !!!                        
REM  Do not run this script if you have valuable data inside of 
REM  your tablespace. The script deletes all M4 tables !!        
REM                                                             
REM  Furthermore, the script installs tables, a sequence,       
REM  functions, and stored procedures into the business data    
REM  schema:						     
REM                                                             
REM                          Tables:                            
REM  - ColStatist1_T					     
REM  - ColStatist2_T                                            
REM                                                             
REM 			 Sequence:                           
REM  - All_Sq                                                   
REM                                                             
REM                          PL/SQL:                            
REM  - procedure dbWindow                                       
REM  - procedure EMA                                            
REM  - procedure SMA                                            
REM  - procedure WMA                                            
REM  - procedure SimpleSTSP                                     
REM  - procedure Updatecolumnstatistics                         
REM  - procedure Timevaluestatist                               
REM  - procedure Nominalvaluestatist                            
REM  - procedure Ordinalvaluestatist                            
REM 
REM  - function Get_Type                                        
REM  - function Get_Type2                                       
REM  - function M4RandomNr                                      
REM  - function M4RandomSelect                                  
REM  - function m4_sample                                       
REM  - function m4_sampleInit                                   
REM  - function m4_sampleTerminate                              
REM  - function column_datatype                                 
REM  - function m4_date_to_timestamp                            
REM  - function m4_timestamp_to_date                            
REM  - function mm_add                                          
REM  - function mm_divide                                       
REM  - function M4randomnr                                      
REM  - function m4_sample                                       
REM  - function time_interv_to_cat                              
REM  - function num_interv_to_cat                               
REM                                                             
REM                      Java Classes:                          
REM  - miningmart.Attribute                                     
REM  - miningmart.OutputColumnset                               
REM  - miningmart.TimeValue                                     
REM  - miningmart.DataType                                      
REM  - miningmart.Quicksort                                     
REM  - miningmart.TimeValueArray                                
REM  - miningmart.DbConnector                                   
REM  - miningmart.SMF                                           
REM  - miningmart.ToWindow                                      
REM  - miningmart.EMF                                           
REM  - miningmart.SimpleSTSP                                    
REM  - miningmart.WMF                                           
REM  - miningmart.M4Random                                      
REM  - miningmart.TimeOperatorException                         
REM  - miningmart.Windowing                                     
REM                                                             
REM  Please  make sure, that no PL/SQL functions/procedures     
REM  or JAVA classes are overwritten in the business data       
REM  schema !!                                                  
REM *************************************************************

REM Please set user,password and SID before running the script:

REM M4 schema:
set M4USER=
set M4PASS=
set M4SID=

REM Business data schema:
set BDUSER=
set BDPASS=
set BDSID=

REM *************************************************************

REM How to run SQLPlus? In some cases you might have to set
REM this variable to the absolute path.
set SQL_PLUS=

REM How to run the loadjava command? In some cases you might
REM have to set this variable to the absolute path.
set LOAD_JAVA=

REM *************************************************************

echo M4 schema: Installing M4 tables!
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @CreateM4Tables.sql

echo M4 schema: Installing M4 operator information!
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @Operators.sql

echo M4 schema: Installing a sequence!
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @MM_Sequence.sql

echo M4 schema: Installing Functions Part1!
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @MM_Functions_1.sql

REM Not necessary (but not tested without, yet):
echo M4 schema: Installing Java Stored Procedures!
%LOAD_JAVA% -user %M4USER%/%M4PASS%@%M4SID% JavaStoredProc\*.java

REM Not necessary (but not tested without, yet):
echo M4 schema: Installing embedding PL/SQL functions/procedures for Java procedures!
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @MM_Functions_2.sql

echo M4 schema: Installing database triggers!
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @Triggers\packages.sql  
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @Triggers\functions.sql 
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @Triggers\procedures.sql
%SQL_PLUS% %M4USER%/%M4PASS%@%M4SID% @Triggers\triggers.sql  


echo Business Data Schema: Installing two tables for column statistics
%SQL_PLUS% %BDUSER%/%BDPASS%@%BDSID% @CreateBusinessTables.sql

echo "Business Data Schema: Installing a (dummy) sequence"
%SQL_PLUS% %BDUSER%/%BDPASS%@%BDSID% @MM_Sequence.sql

echo Business Data Schema: Installing Java Stored Procedures! 
%LOAD_JAVA% -user %BDUSER%/%BDPASS%@%BDSID% JavaStoredProc\*.java

echo Business Data Schema: Installing Functions Part1
%SQL_PLUS% %BDUSER%/%BDPASS%@%BDSID% @MM_Functions_1.sql

echo Business Data Schema: Installing embedding PL/SQL functions/procedures for Java procedures!
%SQL_PLUS% %BDUSER%/%BDPASS%@%BDSID% @MM_Functions_2.sql
