CREATE OR REPLACE PROCEDURE DELETE_DOCUMENTATION
(p_objid   IN	 NUMBER
,p_objtype IN	 VARCHAR2) 
IS 
/******************************************************************************
   NAME:       DELETE_DOCUMENTATION
   PURPOSE:    To delete the documentation of a given object

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        19-03-2002  Olaf Rem         1. Created this procedure.

   PARAMETERS:
   INPUT:	  p_objid, p_objtype
   OUTPUT:
   RETURNED VALUE:
   CALLED BY:
   CALLS:
   EXAMPLE USE:     DELETE_DOCUMENTATION(3565, 'CON');
   ASSUMPTIONS:
   LIMITATIONS:
   ALGORITHM:
   NOTES:
******************************************************************************/
BEGIN
	  /* delete documentation for the given objid and objtype*/
	 DELETE FROM DOCU_T doc
	 WHERE doc.DOC_OBJID = p_objid
	 AND doc.DOC_OBJTYPE = p_objtype;

END DELETE_DOCUMENTATION;

/ 

commit;
quit
