CREATE OR REPLACE PACKAGE Glob_var_package
AS
	TYPE type_index_temp
	IS TABLE OF NUMBER
	INDEX BY BINARY_INTEGER;

	TYPE type_index_c10_temp
	IS TABLE OF VARCHAR2(10)
	INDEX BY BINARY_INTEGER;

	TYPE type_index_bool_temp
	IS TABLE OF BOOLEAN
	INDEX BY BINARY_INTEGER;

	t_ba_id 	 	 type_index_temp;  -- used by BASEATTRIB triggers
	t_ba_conid	 	 type_index_temp;
	t_ba_mcfid	 	 type_index_temp;

	t_bc_id			 type_index_temp;  -- used by BA_CONCEPT triggers
	t_bc_baid		 type_index_temp;
	t_bc_conid		 type_index_temp;

	t_ca_id	 	 	 type_index_temp;  -- used by CASE triggers

	t_caa_id 	 	 type_index_temp;  -- used by CASEATTRIB triggers
	t_caa_caid 	 	 type_index_temp;

	t_cai_id 	 	 type_index_temp;  -- used by CASEINPUT triggers
	t_cai_caid 	 	 type_index_temp;

	t_con_id     	 type_index_temp;  -- used by CONCEPT triggers

	t_cs_id     	 type_index_temp;  -- used by COLUMNSET triggers
	t_cs_conid		 type_index_temp;

	t_par_id	 	 type_index_temp;   -- used by PARAMETER triggers
	t_par_newstid	 type_index_temp;
	t_par_oldstid	 type_index_temp;
	t_par_newopid	 type_index_temp;
	t_par_oldopid	 type_index_temp;

	t_rr_conid   	 type_index_temp;  -- used by ROLERESTRICTION triggers

	t_st_id   	 	 type_index_temp;  -- used by STEP triggers
	t_st_opid    	 type_index_temp;
	t_st_caid    	 type_index_temp;
	t_st_p_objid   	 type_index_temp;
	t_st_p_objtype 	 type_index_c10_temp;
	t_st_p_found	 type_index_bool_temp;

	g_ba_counter	 NUMBER DEFAULT 0;  -- counter for BASEATTRIB triggers
	g_bc_counter	 NUMBER DEFAULT 0;  -- counter for BA_CONCEPT triggers
	g_ca_counter	 NUMBER DEFAULT 0;  -- counter for CASE triggers
	g_caa_counter	 NUMBER DEFAULT 0;  -- counter for CASEATTRIB triggers
	g_cai_counter	 NUMBER DEFAULT 0;  -- counter for CASEINPUT triggers
	g_con_counter	 NUMBER DEFAULT 0;  -- counter for CONCEPT triggers
	g_cs_counter	 NUMBER DEFAULT 0;  -- counter for COLUMNSET triggers
	g_par_counter	 NUMBER DEFAULT 0;  -- counter for PARAMETER triggers
	g_rr_counter	 NUMBER DEFAULT 0;  -- counter for ROLERESTRICTION triggers
	g_st_counter	 NUMBER DEFAULT 0;  -- counter for STEP triggers

	g_ba_deleted	 BOOLEAN DEFAULT FALSE;  --used by BASEATTRIB and BA_CONCEPT delete triggers
	g_con_deleted	 BOOLEAN DEFAULT FALSE;  --used by CONCEPT and BA_CONCEPT delete triggers
	g_col_deleted	 BOOLEAN DEFAULT FALSE;  --used by BA_COLUMN delete triggers
	g_step_deleted	 BOOLEAN DEFAULT FALSE;  --used by PARAMETER delete triggers

END Glob_var_package;
/


commit;
quit
