---------------------- M4 Operators --------------------------

INSERT INTO OPERATOR_T VALUES (34, 'MultiRelationalFeatureConstruction', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  500,   34,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  501,   34,    0,   NULL,    'TheConcepts',        'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  502,   34,    0,   NULL,    'TheRelations',       'IN', 'REL', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  503,   34,    1,   NULL,    'TheChainedFeatures', 'IN', 'FEA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  504,   34,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  505, 34, 'COMP',     'TheInputConcept',  'TheRelations',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  506, 34, 'COMP',        'TheRelations',   'TheConcepts',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  507, 34,   'IN',  'TheChainedFeatures',  'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  508, 34,   'IN',  'TheChainedFeatures',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  509, 34,   'IN',  'TheChainedFeatures',  'TheConcepts',      NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (37, 'RowSelectionByRandomSampling', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  510,   37,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  511,   37,    1,      1,             'HowMany',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  512,   37,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  513, 37, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  514, 37,      'TYPE',          'HowMany',         'NUMERIC',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  515, 37,        'GE',          'HowMany',                 1,  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  516, 37, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (38, 'DeleteRecordsWithMissingValues', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  517,   38,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  518,   38,    1,      1,  'TheTargetAttribute',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  519,   38,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  520, 38, 'SAME_FEAT',   'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  521, 38, 'IN',        'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  522, 38, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (39, 'RowSelectionByQuery', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  523,   39,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  524,   39,    1,      1,   'TheLeftCondition',    'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  525,   39,    1,      1,'TheConditionOperator',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  526,   39,    1,      1,   'TheRightCondition',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  527,   39,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  528, 39, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  529, 39,        'IN', 'TheLeftCondition', 'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  530, 39, 'IS_LOOPED', 'TheLeftCondition',              NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  531, 39, 'IS_LOOPED', 'TheConditionOperator',          NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  532, 39, 'IS_LOOPED', 'TheRightCondition',             NULL,  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  533, 39, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (40, 'SegmentationStratified', 'NO', 'YES','YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  534,   40,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  535,   40,    1,      1,        'TheAttribute',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  536,   40,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

-- 'TheAttribute' is missing in the OutputConcept:
-- INSERT INTO OP_CONSTR_T VALUES (
--   537, 40, 'SAME_FEAT', 'TheOutputConcept',  'TheInputConcept',  NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  538, 40,        'IN',     'TheAttribute',  'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  539, 40, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (42, 'SegmentationByPartitioning', 'NO', 'YES','YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  540,   42,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  541,   42,    1,      1,   'HowManyPartitions',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  542,   42,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  543, 42, 'SAME_FEAT',  'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  544, 42,        'GE', 'HowManyPartitions',                  1,  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  545, 42, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (43, 'FeatureSelectionByAttributes', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  546, 43, 1,    1,       'TheInputConcept',     'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  547, 43, 1,    1,       'TheOutputConcept',    'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  548, 43, 1, NULL,       'TheSelectedFeatures', 'OUT', 'FEA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  549, 43, 'IN',         'TheOutputConcept',    'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  550, 43, 'IN',         'TheSelectedFeatures', 'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  551, 43, 'IN',         'TheSelectedFeatures', 'TheOutputConcept', NULL, NULL);

-- Add constraint:
-- OutputConcept is conceptually (set of features) a subset of InputConcept 

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  552, 43, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (44, 'LinearScaling', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  553, 44, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  554, 44, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  555, 44, 1,    1,              'NewRangeMin',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  556, 44, 1,    1,              'NewRangeMax',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  557, 44, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  558, 44, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  559, 44, 'IS_LOOPED',   'NewRangeMin',                    NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  560, 44, 'IS_LOOPED',   'NewRangeMax',                    NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  561, 44, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  562, 44,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  563, 44,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  564, 44, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  565, 44,      'TYPE',   'NewRangeMin',         'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  566, 44,      'TYPE',   'NewRangeMax',         'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  567, 44,        'GT',   'NewRangeMax',         'NewRangeMin',         NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  568, 44, 'NOT_NULL', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  569, 44, 'NOT_NULL', 'TheOutputAttribute',          NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  570, 44, 'GE',       'TheOutputAttribute', 'NewRangeMin', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  571, 44, 'LE',       'TheOutputAttribute', 'NewRangeMax', NULL, NULL);


-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (45, 'LogScaling', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  572, 45, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  573, 45, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  574, 45, 1,    1,                  'LogBase',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  575, 45, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  576, 45, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  577, 45, 'IS_LOOPED',   'LogBase',                        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  578, 45, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  579, 45,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  580, 45,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  581, 45, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  582, 45,      'TYPE',   'LogBase',             'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  583, 45,        'GT',   'LogBase',             0,                     NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  584, 45, 'NOT_NULL', 'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  585, 45, 'GT',       'TheTargetAttribute', 0,    NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  586, 45, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (46, 'AssignDefault', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  587, 46, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  588, 46, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  589, 46, 1,   1,        'DefaultValue',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  590, 46, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  591, 46, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  592, 46, 'IS_LOOPED',   'DefaultValue',                   NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  593, 46, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  594, 46,        'IN',   'TheTargetAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  595, 46,        'IN',   'TheOutputAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  596, 46, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  597, 46, 'SAME_TYPE',         'DefaultValue',  'TheOutputAttribute',  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  598, 46, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  599, 46, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (47, 'AssignModalValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  600, 47, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  601, 47, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  602, 47, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  603, 47, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  604, 47, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  605, 47,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  606, 47,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  607, 47, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  608, 47, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  609, 47, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (48, 'AssignMedianValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  610, 48, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  611, 48, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  612, 48, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  613, 48, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  614, 48, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  615, 48,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  616, 48,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  617, 48, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  618, 48, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  619, 48, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (49, 'AssignAverageValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  620, 49, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  621, 49, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  622, 49, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  623, 49, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  624, 49, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  625, 49,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  626, 49,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  627, 49, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  628, 49, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  629, 49, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (50, 'AssignStochasticValue',  'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  630, 50, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  631, 50, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  632, 50, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  633, 50, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  634, 50, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  635, 50,        'IN',   'TheTargetAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  636, 50,        'IN',   'TheOutputAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  637, 50, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  638, 50, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  639, 50, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (53, 'MissingValuesWithRegressionSVM', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  640, 53, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  641, 53, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  642, 53, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  643, 53, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  644, 53, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  645, 53, 1,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  646, 53, 1,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  647, 53, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  648, 53, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  649, 53, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  650, 53, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  651, 53, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  652, 53, 'IS_LOOPED', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  653, 53, 'IS_LOOPED', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  654, 53, 'IS_LOOPED',        'KernelType',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  655, 53, 'IS_LOOPED',        'SampleSize',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  656, 53, 'IS_LOOPED',   'LossFunctionPos',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  657, 53, 'IS_LOOPED',   'LossFunctionNeg',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  658, 53, 'IS_LOOPED',                 'C',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  659, 53, 'IS_LOOPED',           'Epsilon',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  660, 53, 'IS_LOOPED','TheOutputAttribute',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  661, 53, 'IS_LOOPED',         'UseDB_SVM',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  662, 53, 'IS_LOOPED',            'TheKey',       NULL, NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  663, 53,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  664, 53,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  665, 53,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  666, 53, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  667, 53,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  668, 53,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  669, 53,      'TYPE',          'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  670, 53,      'TYPE',          'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  671, 53,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  672, 53,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  673, 53,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  674, 53,        'GE',          'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  675, 53,        'GE',          'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  676, 53,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  677, 53,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  678, 53,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  679, 53,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  680, 53, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  681, 53, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  682, 53, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  683, 53, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  684, 53, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (54, 'MissingValueWithDecisionTree','YES','NO','NO',NULL);

--- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  685, 54, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  686, 54, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  687, 54, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  688, 54, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  689, 54, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  690, 54, 1,    1,               'PruningConf',  'IN',   'V', NULL);

--- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  691, 54, 'IS_LOOPED',       'TheTargetAttribute',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  692, 54, 'IS_LOOPED',  'ThePredictingAttributes',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  693, 54, 'IS_LOOPED',               'SampleSize',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  694, 54, 'IS_LOOPED',       'TheOutputAttribute',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  695, 54, 'IS_LOOPED',              'PruningConf',  NULL,  NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  696, 54,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  697, 54,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  698, 54,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  699, 54, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  700, 54,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  701, 54,      'TYPE',  'ThePredictingAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  702, 54,      'TYPE',  'ThePredictingAttributes',  'ORDINAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  703, 54,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  704, 54,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  705, 54,      'TYPE',               'PruningConf',  'NUMERIC',          NULL, NULL);


INSERT INTO OP_COND_T VALUES (
  706, 54, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  707, 54, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  708, 54, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  709, 54, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  710, 54, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (63, 'SupportVectorMachineForRegression', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  711, 63, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  712, 63, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  713, 63, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  714, 63, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  715, 63, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  716, 63, 1,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  717, 63, 1,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  718, 63, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  719, 63, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  720, 63, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  721, 63, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  722, 63, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  723, 63, 'IS_LOOPED', 'TheTargetAttribute', NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  724, 63, 'IS_LOOPED', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  725, 63, 'IS_LOOPED',        'KernelType',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  726, 63, 'IS_LOOPED',        'SampleSize',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  727, 63, 'IS_LOOPED',   'LossFunctionPos',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  728, 63, 'IS_LOOPED',   'LossFunctionNeg',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  729, 63, 'IS_LOOPED',                 'C',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  730, 63, 'IS_LOOPED',           'Epsilon',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  731, 63, 'IS_LOOPED','TheOutputAttribute',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  732, 63, 'IS_LOOPED',         'UseDB_SVM',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  733, 63, 'IS_LOOPED',            'TheKey',  NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  734, 63,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  735, 63,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  736, 63,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  737, 63, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  738, 63,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  739, 63,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  740, 63,      'TYPE',          'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  741, 63,      'TYPE',          'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  742, 63,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  743, 63,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  744, 63,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  745, 63,        'GE',          'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  746, 63,        'GE',          'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  747, 63,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  748, 63,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  749, 63,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  750, 63,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  751, 63, 'HAS_NULLS',          'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  752, 63, 'HAS_VALUES',         'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  753, 63, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  754, 63, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  755, 63, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (67, 'Windowing', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  756,   67,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  757,   67,    1,    1,      'TimeBaseAttrib',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  758,   67,    1,    1,     'ValueBaseAttrib',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  759,   67,    1,    1,          'WindowSize',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  760,   67,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  761,   67,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  762,   67,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  763,   67,    1, NULL,    'WindowedValuesBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  764,   67,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  765, 67,        'IN',   'TimeBaseAttrib',    'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  766, 67,        'IN',   'ValueBaseAttrib',   'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  767, 67,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  768, 67,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  769, 67,        'IN',   'WindowedValuesBA',  'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  770, 67,      'TYPE',   'TimeBaseAttrib',                'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  771, 67, 'SAME_TYPE',   'OutputTimeStartBA',   'TimeBaseAttrib', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  772, 67, 'SAME_TYPE',   'OutputTimeEndBA',     'TimeBaseAttrib', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  773, 67, 'SAME_TYPE',   'ValueBaseAttrib',   'WindowedValuesBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  774, 67,      'TYPE',   'WindowSize',                 'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  775, 67,      'TYPE',   'Distance',                   'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  776, 67,        'GE',   'WindowSize',                        1,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  777, 67,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  778, 67, 'NOT_NULL', 'TimeBaseAttrib',  NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  779, 67, 'UNIQUE',   'TimeBaseAttrib',  NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  780, 67, 'ORDERED',  'TimeBaseAttrib', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  781, 67, 'NOT_NULL', 'OutputTimeStartBA',  NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  782, 67, 'UNIQUE',   'OutputTimeStartBA',  NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  783, 67, 'ORDERED',  'OutputTimeStartBA',  'INC',            NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  784, 67, 'NOT_NULL', 'OutputTimeEndBA',    NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  785, 67, 'UNIQUE',   'OutputTimeEndBA',    NULL,             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  786, 67, 'ORDERED',  'OutputTimeEndBA',    'INC',            NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  787, 67, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (68, 'SignalToSymbolProcessing', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  788,   68,    1,    1,     'TheInputConcept',   'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  789,   68,    1,    1,         'InputTimeBA',   'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  790,   68,    1,    1,        'InputValueBA',   'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  791,   68,    1,    1,           'Tolerance',   'IN',    'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  792,   68,    1,    1,      'AverageValueBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  793,   68,    1,    1,     'IncreaseValueBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  794,   68,    1,    1,   'OutputTimeStartBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  795,   68,    1,    1,     'OutputTimeEndBA',   'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  796,   68,    1,    1,    'TheOutputConcept',   'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  797, 68,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  798, 68,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  799, 68,        'IN',   'AverageValueBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  800, 68,        'IN',   'IncreaseValueBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  801, 68,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  802, 68,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  803, 68,      'TYPE',   'InputTimeBA',                  'TIME',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  804, 68,      'TYPE',   'InputValueBA',               'SCALAR',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  805, 68, 'SAME_TYPE',   'OutputTimeStartBA',     'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  806, 68, 'SAME_TYPE',   'OutputTimeEndBA',       'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  807, 68, 'SAME_TYPE',   'AverageValueBA',       'InputValueBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  808, 68, 'SAME_TYPE',   'IncreaseValueBA',      'InputValueBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  809, 68,      'TYPE',   'Tolerance',                  'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  810, 68,        'GE',   'Tolerance',                          1, NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  811, 68, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  812, 68, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  813, 68, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  814, 68, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  815, 68, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  816, 68, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  817, 68, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  818, 68, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  819, 68, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  820, 68, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  821, 68, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  822, 68, 'NOT_NULL', 'AverageValueBA',    NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  823, 68, 'NOT_NULL', 'IncreaseValueBA',   NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (70, 'SimpleMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  824,   70,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  825,   70,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  826,   70,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  827,   70,    1,    1,          'WindowSize',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  828,   70,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  829,   70,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  830,   70,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  831,   70,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  832,   70,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  833, 70,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  834, 70,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  835, 70,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  836, 70,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  837, 70,        'IN',   'OutputValueBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  838, 70,      'TYPE',   'InputTimeBA',                   'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  839, 70,      'TYPE',   'InputValueBA',                'SCALAR', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  840, 70, 'SAME_TYPE',   'OutputTimeStartBA',      'InputTimeBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  841, 70, 'SAME_TYPE',   'OutputTimeEndBA',        'InputTimeBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  842, 70, 'SAME_TYPE',   'InputValueBA',         'OutputValueBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  843, 70,      'TYPE',   'WindowSize',                 'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  844, 70,      'TYPE',   'Distance',                   'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  845, 70,        'GE',   'WindowSize',                        1,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  846, 70,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  847, 70, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  848, 70, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  849, 70, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  850, 70, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  851, 70, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  852, 70, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  853, 70, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  854, 70, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  855, 70, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  856, 70, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  857, 70, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  858, 70, 'NOT_NULL', 'OutputValueBA',     NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (71, 'WeightedMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  859,   71,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  860,   71,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  861,   71,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  862,   71,    1, NULL,             'Weights',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  863,   71,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  864,   71,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  865,   71,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  866,   71,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  867,   71,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  868, 71,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  869, 71,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  870, 71,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  871, 71,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  872, 71,        'IN',   'OutputValueBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  873, 71,      'TYPE',   'InputTimeBA',                   'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  874, 71,      'TYPE',   'InputValueBA',                'SCALAR', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  875, 71, 'SAME_TYPE',   'OutputTimeStartBA',     'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  876, 71, 'SAME_TYPE',   'OutputTimeEndBA',       'InputTimeBA',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  877, 71, 'SAME_TYPE',   'InputValueBA',         'OutputValueBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  878, 71,      'TYPE',   'Weights',                   'NUMERIC',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  879, 71,      'TYPE',   'Distance',                  'NUMERIC',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  880, 71,       'SUM',   'Weights',                           1,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  881, 71,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  882, 71, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  883, 71, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  884, 71, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  885, 71, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  886, 71, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  887, 71, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  888, 71, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  889, 71, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  890, 71, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  891, 71, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  892, 71, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  893, 71, 'NOT_NULL', 'OutputValueBA',     NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (72, 'ExponentialMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  894,   72,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  895,   72,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  896,   72,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  897,   72,    1,    1,          'HeadWeight',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  898,   72,    1,    1,          'TailWeight',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  899,   72,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  900,   72,    1,    1,        'OutputTimeBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  901,   72,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  902,   72,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  903, 72,        'IN',   'InputTimeBA',       'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  904, 72,        'IN',   'InputValueBA',      'TheInputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  905, 72,        'IN',   'OutputTimeBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  906, 72,        'IN',   'OutputValueBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  907, 72,      'TYPE',   'InputTimeBA',                  'TIME', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  908, 72,      'TYPE',   'InputValueBA',               'SCALAR', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  909, 72, 'SAME_TYPE',   'OutputTimeBA',          'InputTimeBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  910, 72, 'SAME_TYPE',   'InputValueBA',        'OutputValueBA', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  911, 72,      'TYPE',   'HeadWeight',                'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  912, 72,      'TYPE',   'TailWeight',                'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  913, 72,      'TYPE',   'Distance',                  'NUMERIC', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  914, 72,       'SUM',   'HeadWeight,TailWeight',             1, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  915, 72,        'GE',   'Distance',                          1, NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  916, 72, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  917, 72, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  918, 72, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  919, 72, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  920, 72, 'NOT_NULL', 'OutputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  921, 72, 'UNIQUE',   'OutputTimeBA',  NULL,  NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  922, 72, 'ORDERED',  'OutputTimeBA',  'INC', NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  923, 72, 'NOT_NULL', 'OutputValueBA', NULL,  NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (73, 'ComputeSVMError', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  924, 73, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  925, 73, 1,    1,       'TheTargetValueAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  926, 73, 1,    1,   'ThePredictedValueAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  927, 73, 0,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  928, 73, 0,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  929, 73, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  930, 73, 1,    1,                  'Epsilon',  'IN',   'V', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  931, 73,        'IN',      'TheTargetValueAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  932, 73,        'IN',   'ThePredictedValueAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  933, 73,       'TYPE',     'TheTargetValueAttribute',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  934, 73,       'TYPE',  'ThePredictedValueAttribute',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  935, 73,       'TYPE',         'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  936, 73,       'TYPE',         'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  937, 73,       'TYPE',                       'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  938, 73,       'TYPE',                 'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  939, 73,         'GE',         'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  940, 73,         'GE',         'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  941, 73,         'GE',                       'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  942, 73,         'GE',                 'Epsilon',          0,           NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  943, 73, 'NOT_NULL',      'ThePredictedValueAttribute', NULL, NULL, NULL);

-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (74, 'Unsegment', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  944,   74,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  945,   74,    1,      1,    'UnsegmentAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  946,   74,    1,      1,    'TheOutputConcept',   'OUT', 'CON', NULL);

-- constraint: 'UnsegmentAttribute' in 'TheOutputConcept' or pseudo-BA,
--       In one of the preceding steps: Segment by 'UnsegmentAttribute'
-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (75, 'SegmentationWithKMean', 'NO', 'YES', 'NO', NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  947, 75, 1,    1,       'TheInputConcept',          'IN',   'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  948, 75, 1, NULL,       'ThePredictingAttributes',  'IN',   'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  949, 75, 1,    1,       'SampleSize',               'IN',   'V',   NULL);
INSERT INTO OP_PARAMS_T VALUES (
  950, 75, 1,    1,       'TheOutputConcept',         'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  951, 75, 1,    1,       'HowManyPartitions',        'IN',   'V',   NULL);
INSERT INTO OP_PARAMS_T VALUES (
  952, 75, 1,    1,       'OptimizePartitionsNum',    'IN',   'V',   NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  953, 75,        'IN',  'TheAttributes', 'TheOutputConcept',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  954, 75,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  955, 75,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  956, 75,      'TYPE',  'ThePredictingAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  957, 75,      'TYPE',  'ThePredictingAttributes',  'ORDINAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  958, 75,      'TYPE',  'TheAttributes',            'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  959, 75,      'TYPE',  'SampleSize',               'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  960, 75,      'TYPE',  'HowManyPartitions',        'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  961, 75,      'TYPE',  'OptimizePartitionsNum',     'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  962,  75,     'GT',    'SampleSize',                        0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  963,  75,     'ONE_OF','OptimizePartitionsNum', 'TRUE,FALSE,true,false', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  964,  75,     'GT',    'HowManyPartitions',                 0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  965, 75, 'SAME_FEAT',   'TheOutputConcept',  'TheInputConcept',          NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  966,  75, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (76, 'JoinByKey', 'YES', 'NO', 'YES', NULL);

-- (the operator is not applied in loops but 
--  uses the loop mechanism for parameter specification)

INSERT INTO OP_PARAMS_T VALUES (
  967,   76,    2,   NULL,    'TheConcepts',       'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  968,   76,    2,   NULL,    'TheKeys',           'IN',  'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  969,   76,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  970,   76,    0,   1,    'MapInput',             'IN',  'FEA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  971,   76,    0,   1,    'MapOutput',            'OUT', 'FEA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  972, 76, 'IS_LOOPED',   'MapInput',             NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  973, 76, 'IS_LOOPED',   'MapOutput',            NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  974, 76,   'IN',  'TheKeys',  'TheConcepts', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  975, 76,   'IN',  'MapInput',  'TheConcepts', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  976, 76,   'IN',  'MapOutput',  'TheOutputConcept', NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (77, 'SpecifiedStatistics', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  977,   77,    1,   1,    'TheInputConcept',          'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  978,   77,    0,   NULL, 'AttributesComputeSum',     'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  979,   77,    0,   NULL, 'AttributesComputeCount',   'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  980,   77,    0,   NULL, 'AttributesComputeUnique',  'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  981,   77,    0,   NULL, 'AttributesComputeDistrib', 'IN', 'BA',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  982,   77,    0,   NULL, 'DistribValues',            'IN', 'V',   NULL);
INSERT INTO OP_PARAMS_T VALUES (
  983,   77,    1,      1, 'TheOutputConcept',        'OUT', 'CON', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  984,  77,  'IN',   'AttributesComputeSum',     'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  985,  77,  'IN',   'AttributesComputeUnique',  'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  986,  77,  'IN',   'AttributesComputeDistrib', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  987,  77,  'TYPE', 'AttributesComputeSum',     'NUMERIC',            NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (79, 'MissingValueWithDecisionRules','YES','NO','NO',NULL);

--- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  988, 79, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  989, 79, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  990, 79, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  991, 79, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  992, 79, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  993, 79, 1,    1,              'PruningConf',  'IN',   'V', NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  994, 79, 'IS_LOOPED',       'TheTargetAttribute',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  995, 79, 'IS_LOOPED',  'ThePredictingAttributes',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  996, 79, 'IS_LOOPED',               'SampleSize',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  997, 79, 'IS_LOOPED',       'TheOutputAttribute',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  998, 79, 'IS_LOOPED',              'PruningConf',  NULL, NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  999, 79,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1000, 79,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1001, 79,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1002, 79, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1003, 79,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1004, 79,      'TYPE',  'ThePredictingAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1005, 79,      'TYPE',  'ThePredictingAttributes',  'ORDINAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1006, 79,      'TYPE',  'TheTargetAttribute',    'CATEGORIAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1007, 79,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1008, 79,      'TYPE',               'PruningConf',  'NUMERIC',          NULL, NULL);


INSERT INTO OP_COND_T VALUES (
  1009, 79, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1010, 79, 'HAS_VALUES', 'TheTargetAttribute',         NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1011, 79, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1012, 79, 'NOT_NULL', 'TheOutputAttribute',         NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1013, 79, 'NOT_NULL', 'ThePredictingAttributes',    NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (81, 'AssignPredictedValueCategorial','YES','NO','YES',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1014, 81, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1015, 81, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1016, 81, 1, NULL,    'ThePredictedAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1017, 81, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1018, 81, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1019, 81, 'IS_LOOPED',   'ThePredictedAttribute',          NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1020, 81, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1021, 81,        'IN',      'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1022, 81,        'IN',   'ThePredictedAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1023, 81,        'IN',      'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1024, 81,      'TYPE',  'ThePredictedAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1025, 81,      'TYPE',  'ThePredictedAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1026, 81,      'TYPE',  'ThePredictedAttributes',  'ORDINAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1027, 81,      'TYPE',  'TheOutputAttribute',      'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1028, 81,      'TYPE',  'TheTargetAttribute',      'CATEGORIAL',        NULL, NULL);

-- further constraints still missing
-- conditions still missing
-- assertions still missing
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (82, 'PredictionWithDecisionTree','YES','NO','NO',NULL);

--- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1029, 82, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1030, 82, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1031, 82, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1032, 82, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1033, 82, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1034, 82, 1,    1,               'PruningConf',  'IN',   'V', NULL);

--- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1035, 82, 'IS_LOOPED',       'TheTargetAttribute',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1036, 82, 'IS_LOOPED',  'ThePredictingAttributes',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1037, 82, 'IS_LOOPED',               'SampleSize',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1038, 82, 'IS_LOOPED',       'TheOutputAttribute',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1039, 82, 'IS_LOOPED',               'PruningConf', NULL, NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1040, 82,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1041, 82,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1042, 82,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1043, 82, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1044, 82,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1045, 82,      'TYPE',  'ThePredictingAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1046, 82,      'TYPE',  'ThePredictingAttributes',  'ORDINAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1047, 82,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1048, 82,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1049, 82,      'TYPE',               'PruningConf',  'NUMERIC',           NULL, NULL);

-- conditions

INSERT INTO OP_COND_T VALUES (
  1050, 82, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1051, 82, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1052, 82, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

-- assertions

INSERT INTO OP_ASSERT_T VALUES (
  1053, 82, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1054, 82, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (83, 'PredictionWithDecisionRules','YES','NO','NO',NULL);

--- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1055, 83, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1056, 83, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1057, 83, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1058, 83, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1059, 83, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1060, 83, 1,    1,               'PruningConf',  'IN',   'V', NULL);

--- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1061, 83, 'IS_LOOPED',       'TheTargetAttribute',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1062, 83, 'IS_LOOPED',  'ThePredictingAttributes',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1063, 83, 'IS_LOOPED',               'SampleSize',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1064, 83, 'IS_LOOPED',       'TheOutputAttribute',  NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1065, 83, 'IS_LOOPED',               'PruningConf', NULL, NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1066, 83,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1067, 83,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1068, 83,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1069, 83, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1070, 83,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1071, 83,      'TYPE',  'ThePredictingAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1072, 83,      'TYPE',  'ThePredictingAttributes',  'ORDINAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1073, 83,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1074, 83,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1075, 83,      'TYPE',               'PruningConf',  'NUMERIC',           NULL, NULL);

-- Conditions

INSERT INTO OP_COND_T VALUES (
  1076, 83, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1077, 83, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1078, 83, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

-- Assertions

INSERT INTO OP_ASSERT_T VALUES (
  1079, 83, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1080, 83, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (84, 'Apriori', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
1081, 84, 1, 1, 'TheInputConcept',  'IN',  'CON', NULL );
INSERT INTO OP_PARAMS_T VALUES (
1082, 84, 1, 1, 'TheOutputConcept', 'OUT', 'CON', NULL );
INSERT INTO OP_PARAMS_T VALUES (
1083, 84, 1, 1, 'CustID',           'IN',  'BA',  NULL );
INSERT INTO OP_PARAMS_T VALUES (
1084, 84, 1, 1, 'TransID',          'IN',  'BA',  NULL );
INSERT INTO OP_PARAMS_T VALUES (
1085, 84, 1, 1, 'Item',             'IN',  'BA',  NULL );
INSERT INTO OP_PARAMS_T VALUES (
1086, 84, 1, 1, 'MinSupport',       'IN',  'V',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
1087, 84, 1, 1, 'MinConfidence',    'IN',  'V',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
1088, 84, 1, 1, 'SampleSize',       'IN',  'V',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
1089, 84, 1, 1, 'PremiseBA',       'OUT', 'BA',   NULL );
INSERT INTO OP_PARAMS_T VALUES (
1090, 84, 1, 1, 'ConclusionBA',    'OUT', 'BA',   NULL );


INSERT INTO OP_CONSTR_T VALUES (
  1091, 84,        'IN',   'CustID',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1092, 84,        'IN',   'TransID',      'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1093, 84,        'IN',   'Item',         'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1094, 84,        'IN',   'PremiseBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1095, 84,        'IN',   'ConclusionBA', 'TheOutputConcept', NULL, NULL);

-- further constraints still missing
-- conditions still missing
-- assertions still missing
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (85, 'StatisticalFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1096, 85, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1097, 85, 1,    NULL,       'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1098, 85, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1099, 85, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1100, 85, 1,    1,               'Threshold',  'IN',   'V', NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1101, 85,        'IN',       'TheAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1102, 85,      'TYPE',  'TheAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1103, 85,      'TYPE',  'TheAttributes',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1104, 85,      'TYPE',  'TheAttributes',  'ORDINAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1105, 85,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1106, 85,      'TYPE',               'Threshold',  'NUMERIC',           NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1107, 85, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO OP_ASSERT_T VALUES (
  1108, 85, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (86, 'GeneticFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1109, 86, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1110, 86, 1,    NULL,       'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1111, 86, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1112, 86, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1113, 86, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1114, 86, 1,    1,               'PopDim',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1115, 86, 1,    1,               'StepNum',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1116, 86, 1,    1,               'ProbMut',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1117, 86, 1,    1,               'ProbCross',  'IN',   'V', NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1118, 86,        'IN',  'TheAttributes',       'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1119, 86,        'IN',  'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1120, 86,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1121, 86,      'TYPE',  'TheAttributes',       'SCALAR',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1122, 86,      'TYPE',  'TheAttributes',       'CATEGORIAL',       NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1123, 86,      'TYPE',  'TheAttributes',       'ORDINAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1124, 86,      'TYPE',  'SampleSize',          'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1125, 86,      'TYPE',  'PopDim',              'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1126, 86,      'TYPE',  'StepNum',             'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1127, 86,      'TYPE',  'ProbMut',             'NUMERIC',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1128, 86,      'TYPE',  'ProbCross',           'NUMERIC',          NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1129, 86, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO OP_ASSERT_T VALUES (
  1130, 86, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (87, 'SGFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO OP_PARAMS_T VALUES (
  1131, 87, 1,    1,       'TheInputConcept',  'IN',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1132, 87, 1,    NULL,    'TheAttributes',    'IN',   'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1133, 87, 1,    1,       'TheTargetAttribute', 'IN', 'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1134, 87, 1,    1,       'SampleSize',       'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1135, 87, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1136, 87, 1,    1,       'Threshold',        'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1137, 87, 1,    1,       'PopDim',           'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1138, 87, 1,    1,       'StepNum',          'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1139, 87, 1,    1,       'ProbMut',          'IN',   'V',  NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1140, 87, 1,    1,       'ProbCross',        'IN',   'V',  NULL);

-- Constraints

INSERT INTO OP_CONSTR_T VALUES (
  1141, 87,        'IN',  'TheAttributes',       'TheInputConcept',   NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1142, 87,        'IN',  'TheTargetAttribute',  'TheInputConcept',   NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1143, 87,      'TYPE',  'TheTargetAttribute',  'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1144, 87,      'TYPE',  'TheAttributes',       'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1145, 87,      'TYPE',  'TheAttributes',       'CATEGORIAL',        NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1146, 87,      'TYPE',  'TheAttributes',       'ORDINAL',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1147, 87,      'TYPE',  'SampleSize',          'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1148, 87,      'TYPE',  'PopDim',              'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1149, 87,      'TYPE',  'StepNum',             'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1150, 87,      'TYPE',  'ProbMut',             'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1151, 87,      'TYPE',  'ProbCross',           'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1152, 87,      'TYPE',  'Threshold',           'NUMERIC',           NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1153, 87, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO OP_ASSERT_T VALUES (
  1154, 87, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (88, 'FeatureSelectionWithSVM', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1155, 88, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1156, 88, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1157, 88, 1, NULL,            'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1158, 88, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1159, 88, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1160, 88, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1161, 88, 1,    1,          'SearchDirection',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1162, 88, 1,    1,      'PositiveTargetValue',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1163, 88, 1,    1,                   'TheKey',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1164, 88, 1,    1,       'TheOutputConcept',   'OUT', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1165, 88, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1166, 88, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1167, 88,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1168, 88,        'IN',            'TheAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1169, 88, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1170, 88,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1171, 88,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1172, 88,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1173, 88,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1174, 88,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1175, 88,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1176, 88,    'ONE_OF',               'KernelType',   'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1177, 88,    'ONE_OF',          'SearchDirection',   'backward forward', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1178, 88,    'ONE_OF',                'UseDB_SVM',      'true false',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1179, 88,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1180, 88, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO OP_ASSERT_T VALUES (
  1181, 88, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
-------------------------------------------------------

INSERT INTO OPERATOR_T VALUES (89, 'SupportVectorMachineForClassification', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1182, 89, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1183, 89, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1184, 89, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1185, 89, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1186, 89, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1187, 89, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1188, 89, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1189, 89, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1190, 89, 1,    1,      'PositiveTargetValue',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1191, 89, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1192, 89, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1193, 89, 'IS_LOOPED',  'TheTargetAttribute',      NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1194, 89, 'IS_LOOPED',  'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1195, 89, 'IS_LOOPED',         'KernelType',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1196, 89, 'IS_LOOPED',         'SampleSize',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1197, 89, 'IS_LOOPED',                  'C',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1198, 89, 'IS_LOOPED',            'Epsilon',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1199, 89, 'IS_LOOPED', 'TheOutputAttribute',       NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1200, 89, 'IS_LOOPED', 'PositiveTargetValue',      NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1201, 89, 'IS_LOOPED',         'UseDB_SVM',        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1202, 89, 'IS_LOOPED',            'TheKey',        NULL,  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1203, 89,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1204, 89,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1205, 89,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1206, 89, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1207, 89,      'TYPE',  'ThePredictingAttributes',  'SCALAR',            NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1208, 89,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1209, 89,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1210, 89,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1211, 89,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1212, 89,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1213, 89,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1214, 89,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1215, 89,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1216, 89, 'HAS_NULLS',          'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1217, 89, 'HAS_VALUES',         'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1218, 89, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1219, 89, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO OP_ASSERT_T VALUES (
  1220, 89, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (90, 'GenericFeatureConstruction', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1221, 90, 1,    1,           'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1222, 90, 1,    1,        'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1223, 90, 1,    1,                'SQL_String',  'IN',   'V', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1224, 90, 1,    1,        'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1225, 90,         'IN', 'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1226, 90,         'IN', 'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1227, 90,  'SAME_TYPE', 'TheOutputAttribute',  'TheTargetAttribute',  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1228, 90, 'IS_LOOPED',  'TheTargetAttribute',  NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1229, 90, 'IS_LOOPED',  'SQL_String',          NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1230, 90, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1231, 90,      'TYPE',  'SQL_String',          'NOMINAL',             NULL, NULL);


-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (91, 'UnionByKey', 'NO', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1232,	91,	2,	NULL,	'TheConcepts',		'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1233,	91,	2,	NULL,	'TheKeys',		'IN',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1234,	91,	0,	1,	'MapInput',		'IN',	'FEA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1235,	91,	0,	1,	'MapOutput',		'OUT',	'FEA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1236,	91,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1237, 91, 'IS_LOOPED',  'MapInput',                 NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1238, 91, 'IS_LOOPED',  'MapOutput',                NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1239, 91,   'IN',       'TheKeys',    'TheConcepts',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1240, 91,   'IN',       'MapInput',   'TheConcepts',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1241, 91,   'IN',       'MapOutput',  'TheOutputConcept', NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (92, 'TimeIntervalManualDiscretization', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1242,	92,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1243,	92,	1,	1,	'TheTargetAttribute',	'IN',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1244,	92,	1,	NULL,	'IntervalStart',	'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1245,	92,	1,	NULL,	'IntervalEnd',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1246,	92,	1,	NULL,	'MapTo',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1247,	92,	1,	NULL,	'StartIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1248,	92,	1,	NULL,	'EndIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1249,	92,	1,	1,	'DefaultValue',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1250,	92,	1,	1,	'TimeFormat',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1251,	92,	1,	1,	'TheOutputAttribute',	'OUT',	'BA',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1252, 92, 'IS_LOOPED',  'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1253, 92, 'IS_LOOPED',  'TheOutputAttribute', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1254, 92, 'IS_LOOPED',  'IntervalStart',      NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1255, 92, 'IS_LOOPED',  'StartIncExc',        NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1256, 92, 'IS_LOOPED',  'IntervalEnd',        NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1257, 92, 'IS_LOOPED',  'EndIncExc',          NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1258, 92, 'IS_LOOPED',  'MapTo',              NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1259, 92, 'IS_LOOPED',  'DefaultValue',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1260, 92, 'IS_LOOPED',  'TimeFormat',         NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1261, 92,   'IN',     'TheTargetAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1262, 92,   'IN',     'TheOutputAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1263, 92,   'TYPE',   'TheTargetAttribute',  'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1264, 92,   'TYPE',	'IntervalStart',    'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1265, 92,   'TYPE',	'IntervalEnd',      'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1266, 92,   'TYPE',	'MapTo',            'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1267, 92,   'TYPE',	'StartIncExc',      'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1268, 92,   'TYPE',	'EndIncExc',        'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1269, 92,   'TYPE',	'DefaultValue',     'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1270, 92,   'TYPE',	'TimeFormat',       'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1271, 92,   'TYPE',   'TheOutputAttribute',  'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1272, 92,   'ONE_OF', 'StartIncExc',         'I E',                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1273, 92,   'ONE_OF', 'EndIncExc',           'I E',                 NULL, NULL);

-- conditions still missing
-- assertions still missing
-------------------------------------------------------
INSERT INTO OPERATOR_T VALUES (93, 'NumericalIntervalManualDiscretization', 'YES', 'NO', 'YES', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1274,	93,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1275,	93,	1,	1,	'TheTargetAttribute',	'IN',	'BA',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1276,	93,	1,	NULL,	'IntervalStart',	'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1277,	93,	1,	NULL,	'IntervalEnd',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1278,	93,	1,	NULL,	'MapTo',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1279,	93,	1,	NULL,	'StartIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1280,	93,	1,	NULL,	'EndIncExc',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1281,	93,	1,	1,	'DefaultValue',		'IN',	'V',	NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1282,	93,	1,	1,	'TheOutputAttribute',	'OUT',	'BA',	NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1283, 93, 'IS_LOOPED',  'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1284, 93, 'IS_LOOPED',  'TheOutputAttribute', NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1285, 93, 'IS_LOOPED',  'IntervalStart',      NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1286, 93, 'IS_LOOPED',  'StartIncExc',        NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1287, 93, 'IS_LOOPED',  'IntervalEnd',        NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1288, 93, 'IS_LOOPED',  'EndIncExc',          NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1289, 93, 'IS_LOOPED',  'MapTo',              NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1290, 93, 'IS_LOOPED',  'DefaultValue',       NULL, NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1291, 93,   'IN',     'TheTargetAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1292, 93,   'IN',     'TheOutputAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1293, 93,   'ONE_OF', 'StartIncExc',         'I E',                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1294, 93,   'ONE_OF', 'EndIncExc',           'I E',                 NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1295, 93,   'TYPE',   'TheTargetAttribute',  'NUMERIC',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1296, 93,   'TYPE',	'IntervalStart',    'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1297, 93,   'TYPE',	'IntervalEnd',      'TIME',                NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1298, 93,   'TYPE',	'MapTo',            'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1299, 93,   'TYPE',	'StartIncExc',      'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1300, 93,   'TYPE',	'EndIncExc',        'CATEGORIAL',          NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1301, 93,   'TYPE',	'DefaultValue',     'NOMINAL',             NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1302, 93,   'TYPE',   'TheOutputAttribute',  'CATEGORIAL',          NULL, NULL);

-- conditions still missing
-- assertions still missing
--------------------------------------------------------------------------------------------------------------
--- M4-Definition of the Subgroup-Mining operator.
--- The operator ONLY has input parameters. The results are printed out to the console.
--- Therefore, the operator has no output parameters.

INSERT INTO OPERATOR_T VALUES (94, 'SubgroupMining', 'NO', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1303, 94, 1, 1,    'TheInputConcept',   'IN', 'CON', 'Table name for subgroup discovery');
INSERT INTO OP_PARAMS_T VALUES (
  1304, 94, 1, 1,    'TheTargetAttribute',         'IN', 'BA',  'Target attribute in the table for subgroup discovery');
INSERT INTO OP_PARAMS_T VALUES (
  1305, 94, 1, 1,    'TheKey',            'IN', 'BA',  'Key attribute in the table for subgroup discovery');
INSERT INTO OP_PARAMS_T VALUES (
  1306, 94, 1, NULL, 'ThePredictingAttributes', 'IN', 'BA',  'Data-mining attributes in the table for subgroup discovery');
INSERT INTO OP_PARAMS_T VALUES (
  1307, 94, 1, 1,    'TargetValue',    'IN', 'V',   'Value from the target column in the input table for subgroup discovery');
INSERT INTO OP_PARAMS_T VALUES (
  1308, 94, 1, 1,    'SearchDepth',    'IN', 'V',   'Search depth for generating hypotheses');
INSERT INTO OP_PARAMS_T VALUES (
  1309, 94, 1, 1,    'MinSupport',     'IN', 'V',   'Minimal support for generating hypotheses');  
INSERT INTO OP_PARAMS_T VALUES (
  1310, 94, 1, 1,    'MinConfidence',  'IN', 'V',   'Minimal confidence for generating hypotheses');  
INSERT INTO OP_PARAMS_T VALUES (
  1311, 94, 1, 1,    'NumHypotheses',  'IN', 'V',   'Number of hypotheses to be generated');  
INSERT INTO OP_PARAMS_T VALUES (
  1312, 94, 1, 1,    'RuleClusters',   'IN', 'V',   'Perform or not clustering as a final step of the algorithm');

INSERT INTO OP_CONSTR_T VALUES (
  1313, 94, 'IN', 'Target',              'InputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1314, 94, 'IN', 'Key',                 'InputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1315, 94, 'IN', 'AttributeSpace',      'InputConcept', NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1316, 94, 'ONE_OF', 'RuleClusters',          'YES NO', NULL, NULL);

----------------------------------------------------------------------
---------------------- M4 Operators from UEP -------------------------
----------------------------------------------------------------------

-------------------------------------------------------
-- WP16: 1.1.1
INSERT INTO OPERATOR_T VALUES (95, 'EquidistantDiscretizationGivenWidth', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1317, 95, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1318, 95, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1319, 95, 0,   1,  'StartPoint', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (
  1320, 95, 0,   1,  'EndPoint', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1321, 95, 1,   1,  'IntervalWidth', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1322, 95, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1323, 95, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1324, 95, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1325, 95, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1326, 95, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1327, 95,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1328, 95, 'TYPE', 'IntervalWidth', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1329, 95, 'GT', 'IntervalWidth', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1330, 95, 'TYPE', 'StartPoint', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1331, 95, 'TYPE', 'EndPoint', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1332, 95, 'GT', 'EndPoint', 'StartPoint', 
NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1333, 95, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1334, 95, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with given width IntWidth starting at StartPoint and ending at EndPoint. The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels ');


-------------------------------------------------------
-- WP16: 1.1.2
INSERT INTO OPERATOR_T VALUES (96, 'EquidistantDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1335, 96, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1336, 96, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1337, 96, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1338, 96, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1339, 96, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1340, 96, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1341, 96, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1342, 96, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1343, 96, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1344, 96,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1345, 96, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1346, 96, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1347, 96, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1348, 96, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1349, 96, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into given number of intervals NoOfIntervals with the same width. The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.1.3
INSERT INTO OPERATOR_T VALUES (97, 'EquifrequentDiscretizationGivenCardinality', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1350, 97, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1351, 97, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1352, 97, 1,   1,  'Cardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1353, 97, 1,   1,  'CardinalityType', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1354, 97, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1355, 97, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1356, 97, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1357, 97, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1358, 97, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1359, 97,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1360, 97, 'TYPE', 'Cardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1361, 97, 'GT', 'Cardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1362, 97, 'ONE_OF', 'CardinalityType', 'absolute relative', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1363, 97, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1364, 97, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1365, 97, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with given cardinality Cardinality (number of examples with values within the interval). The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels (this makes sense only if CardinalityType is relative.');


-------------------------------------------------------
-- WP16: 1.1.4
INSERT INTO OPERATOR_T VALUES (98, 'EquifrequentDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1366, 98, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1367, 98, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1368, 98, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1369, 98, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1370, 98, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1371, 98, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1372, 98, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1373, 98, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1374, 98, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1375, 98,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1376, 98, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1377, 98, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1378, 98, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1379, 98, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1380, 98, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1381, 98, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into given number of intervals NoOfIntervals. The intervals have the same cardinality (number of examples with values within the interval). The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.1.5
INSERT INTO OPERATOR_T VALUES (99, 'UserDefinedDiscretization', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1382, 99, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1383, 99, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1384, 99, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1385, 99, 1,   NULL,   'TheCutpoints', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1386, 99, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1387, 99, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1388, 99, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1389, 99, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1390, 99, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1391, 99,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1392, 99, 'TYPE', 'TheCutpoints', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1393, 99, 'ORDERED', 'TheCutpoints', 'INC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1394, 99, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1395, 99, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1396, 99, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals according to user given cutpoints TheCutpoints. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.2.1
INSERT INTO OPERATOR_T VALUES (100, 'ImplicitErrorBasedDiscretization', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1397, 100, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1398, 100, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1399, 100, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1400, 100, 1,   1,   'FullMerge', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (  
  1401, 100, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1402, 100, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1403, 100, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1404, 100, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1405, 100, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1406, 100, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1407, 100, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1408, 100, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1409, 100,  'ONE_OF',  'FullMerge', 'yes no',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1410, 100,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1411, 100, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1412, 100, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1413, 100, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1414, 100, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1415, 100, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1416, 100, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals by merging subsequent values with the same majority class (or classes) given in TheClassAttribute. The resulting intervals  minimize the classification error. If FullMerge is set to yes, then an interval with two or more majority classes is merged with its neighbour, if both intervals share the same majority class.');



-------------------------------------------------------
-- WP16: 2.1.1
INSERT INTO OPERATOR_T VALUES (101, 'GroupingGivenMinCardinality', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1417, 101, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1418, 101, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1419, 101, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1420, 101, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1421, 101, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1422, 101, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1423, 101, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1424, 101, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1425, 101, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1426, 101, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1427, 101, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1428, 101, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1429, 101, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1430, 101, 'OPERATOR', 
'This operator groups values of TheTargetAttribute by iteratively merging in each step two groups with the lowest frequencies until all groups have the cardinality (number of examples with values within the interval) at least MinCardinality.');


-------------------------------------------------------
-- WP16: 2.1.2
INSERT INTO OPERATOR_T VALUES (102, 'GroupingGivenNoOfGroups', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1431, 102, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1432, 102, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1433, 102, 1,   1,  'NoOfGroups', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1434, 102, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (
  1435, 102, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1436, 102, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1437, 102, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1438, 102, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1439, 102, 'TYPE', 'NoOfGroups', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1440, 102, 'GT', 'NoOfGroups', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1441, 102, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1442, 102, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1443, 102, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1444, 102, 'OPERATOR', 
'This operator groups values of TheTargetAttribute by iteratively  merging in each step two groups with the lowest frequencies until the number of groups NoOfGroups is reached. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.1.3
INSERT INTO OPERATOR_T VALUES (103, 'UserDefinedGrouping', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1445, 103, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1446, 103, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1447, 103, 1,   NULL,  'TheGroupings', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1448, 103, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (
  1449, 103, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1450, 103, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1451, 103, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1452, 103, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1453, 103, 'TYPE', 'TheGroupings', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1454, 103, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

-- no conditions 

INSERT INTO OP_ASSERT_T VALUES (
  1455, 103, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1456, 103, 'OPERATOR', 
'This operator creates groups of TheTargetAttribute according to specifications given by the user in TheGroupings. Values not specified for grouping retain their original values. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.1.4
INSERT INTO OPERATOR_T VALUES (104, 'UserDefinedGroupingWithDefaultValue', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1457, 104, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1458, 104, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1459, 104, 0,   1,  'Default', 'IN',  'V',  NULL);    
INSERT INTO OP_PARAMS_T VALUES (  
  1460, 104, 1,   NULL,  'TheGroupings', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1461, 104, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (
  1462, 104, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO OP_CONSTR_T VALUES (
  1463, 104, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1464, 104, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1465, 104, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1466, 104, 'TYPE', 'Default', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1467, 104, 'TYPE', 'TheGroupings', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1468, 104, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

-- no conditions 

INSERT INTO OP_ASSERT_T VALUES (
  1469, 104, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  1470, 104, 'OPERATOR', 
'This operator creates groups of TheTargetAttribute according to specifications given by the user in TheGroupings. Values not specified for grouping are grouped into default group Default. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.2.2
INSERT INTO OPERATOR_T VALUES (105, 'ErrorBasedDiscretizationGivenMinCardinality', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1471, 105, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1472, 105, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1473, 105, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1474, 105, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1475, 105, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);        
INSERT INTO OP_PARAMS_T VALUES (  
  1476, 105, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1477, 105, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1478, 105, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1479, 105, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1480, 105, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1481, 105, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1482, 105, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1483, 105, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1484, 105,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1485, 105, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1486, 105, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1487, 105, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1488, 105, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1489, 105, 'GT', 'SampleSize', 0, 
NULL, NULL);
-- If CardinalityType is 'relative', then Cardinality < 0.5

INSERT INTO OP_COND_T VALUES (
  1490, 105, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1491, 105, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- If CardinalityType is 'absolute', then Cardinality < TheTargetAttribute.allNumber/2

INSERT INTO OP_ASSERT_T VALUES (
  1492, 105, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2320, 105, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with cardinality greater or equal to MinCardinality. The numeric attribute is divided into intervals with respect to TheClassAttribute, but unlike the implicit discretization, intervals with single majority class are further merged if they do not have the required cardinality. This will increase the classification error.');


-------------------------------------------------------
-- WP16: 1.2.3
INSERT INTO OPERATOR_T VALUES (106, 'ErrorBasedDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'NO', NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1493, 106, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1494, 106, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1495, 106, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1496, 106, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (  
  1497, 106, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1498, 106, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1499, 106, 0,   NULL,   'Labels', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (
  1500, 106, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1501, 106, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1502, 106, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1503, 106, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1504, 106, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1505, 106, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1506, 106,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1507, 106, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1508, 106, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1509, 106, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1510, 106, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1511, 106, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1512, 106, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1513, 106, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- INSERT INTO OP_COND_T VALUES (2369, 106, 'LT', 'NoOfIntervals', TheTargetAttribute.unique, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1514, 106, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2371, 106, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into at most NoOfIntervals intervals. The numeric attribute is divided into intervals with respect to TheClassAttribute, but unlike the implicit discretization, if the number of interval exceeds NoOfIntervals, intervals are further merged. This will increase the classification error. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.2.1
INSERT INTO OPERATOR_T VALUES (107, 'ImplicitErrorBasedGrouping', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1515, 107, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1516, 107, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1517, 107, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1518, 107, 1,   1,   'FullMerge', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (  
  1519, 107, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1520, 107, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1521, 107, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1522, 107, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1523, 107, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1524, 107, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1525, 107, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1526, 107,  'ONE_OF',  'FullMerge', 'yes no',
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1527, 107, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1528, 107, 'GT', 'SampleSize', 0, 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1529, 107, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1530, 107, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1531, 107, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2615, 107, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into groups with the same majority class (or classes) given in TheClassAttribute. If FullMerge is set to yes, then a group with two or more majority classes is merged with a group that have the same majority class. The resulting grouping  minimize the classification error.');


-------------------------------------------------------
-- WP16: 2.2.2
INSERT INTO OPERATOR_T VALUES (108, 'ErrorBasedGroupingGivenMinCardinality', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1532, 108, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1533, 108, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1534, 108, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1535, 108, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1536, 108, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);        
INSERT INTO OP_PARAMS_T VALUES (  
  1537, 108, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1538, 108, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1539, 108, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1540, 108, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1541, 108, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1542, 108, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1543, 108, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1544, 108, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1545, 108, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1546, 108, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1547, 108, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1548, 108, 'GT', 'SampleSize', 0, 
NULL, NULL);
-- If CardinalityType is 'relative', then Cardinality < 0.5

INSERT INTO OP_COND_T VALUES (
  1549, 108, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1550, 108, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- If CardinalityType is 'absolute', then Cardinality < TheTargetAttribute.allNumber/2

INSERT INTO OP_ASSERT_T VALUES (
  1551, 108, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2668, 108, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into groups with the cardinality above given threshold MinCardinality. The grouping is performed with respect to TheClassAttribute, but unlike implicit grouping, groups with single majority class are further merged if they do not have the required cardinality. This will increase the classification error.');


-------------------------------------------------------
-- WP16: 2.2.3
INSERT INTO OPERATOR_T VALUES (109, 'ErrorBasedGroupingGivenNoOfGroups', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1552, 109, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1553, 109, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1554, 109, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1555, 109, 1,   1,  'NoOfGroups', 'IN',  'V',  NULL);       
INSERT INTO OP_PARAMS_T VALUES (  
  1556, 109, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1557, 109, 0,   NULL,   'Labels', 'IN',  'V',  NULL);      
INSERT INTO OP_PARAMS_T VALUES (
  1558, 109, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO OP_CONSTR_T VALUES (
  1559, 109, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1560, 109, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1561, 109, 'TYPE', 'TheTargetAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1562, 109, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1563, 109, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1564, 109, 'TYPE', 'NoOfGroups', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1565, 109, 'GT', 'NoOfGroups', 1, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1566, 109, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1567, 109, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1568, 109, 'TYPE', 'Labels', 'CATEGORIAL', 
NULL, NULL);

INSERT INTO OP_COND_T VALUES (
  1569, 109, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1570, 109, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- INSERT INTO OP_COND_T VALUES (2717, 109, 'LT', 'NoOfGroups', TheTargetAttribute.unique, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1571, 109, 'TYPE', 'TheOutputAttribute', 'CATEGORIAL', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2719, 109, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into at most  NoOfGropus groups. The grouping is performed with respect to TheClassAttribute, but unlike the implicit discretization, if the number of groups exceeds NoOfGroups, groups are further merged. Values of TheOutputAttribute can be specified in Labels.');



---------------------- M4 Operators from UEP--------------------------
----------------------------------------------------------------------

-------------------------------------------------------
-- WP14: 1.1
INSERT INTO OPERATOR_T VALUES (110, 'SimpleForwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1572, 110,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1573, 110, 1,   NULL,  'TheAttributes',  'IN',  'BA', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1574, 110, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1575, 110, 1,   1,  'NoOfAttributes', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1576, 110, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1577, 110,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1578, 110, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1579, 110, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1580, 110, 'IN',   'TheAttributes',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1581, 110, 'TYPE', 'TheAttributes', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1582, 110, 'TYPE', 'NoOfAttributes', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1583, 110, 'GT', 'NoOfAttributes', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1584, 110, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1585, 110, 'GT', 'SampleSize', 0, 
NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2762, 110, 'LT', 'NoOfAttributes', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1586, 110, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1587, 110, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1588, 110, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2766, 110, 'OPERATOR', 
'This operator adds one feature a time starting from empty set until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Use this operator if only a small number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.2
INSERT INTO OPERATOR_T VALUES (111, 'SimpleBackwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1589, 111,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1590, 111, 1,   NULL,  'TheAttributes',  'IN',  'BA', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1591, 111, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1592, 111, 1,   1,  'NoOfAttributes', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1593, 111, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1594, 111,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1595, 111, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1596, 111, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1597, 111, 'IN',   'TheAttributes',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1598, 111, 'TYPE', 'TheAttributes', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1599, 111, 'TYPE', 'NoOfAttributes', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1600, 111, 'GT', 'NoOfAttributes', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1601, 111, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1602, 111, 'GT', 'SampleSize', 0, 
NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2812, 111, 'LT', 'NoOfIntervals', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1603, 111, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1604, 111, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1605, 111, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2816, 111, 'OPERATOR', 
'This operator removes one feature a time starting from all attributes until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Use this operator if  a large number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.3
INSERT INTO OPERATOR_T VALUES (112, 'FloatingForwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1606, 112,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1607, 112, 1,   NULL,  'TheAttributes',  'IN',  'BA', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1608, 112, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1609, 112, 1,   1,  'NoOfAttributes', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1610, 112, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1611, 112,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1612, 112, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1613, 112, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1614, 112, 'IN',   'TheAttributes',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1615, 112, 'TYPE', 'TheAttributes', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1616, 112, 'TYPE', 'NoOfAttributes', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1617, 112, 'GT', 'NoOfAttributes', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1618, 112, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1619, 112, 'GT', 'SampleSize', 0, 
NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2862, 112, 'LT', 'NoOfIntervals', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1620, 112, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1621, 112, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1622, 112, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2866, 112, 'OPERATOR', 
'This operator adds one feature a time starting from empty set until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Unlike the simple operator, after adding a feature a check is performed if another feature should be removed. Use this operator if only a small number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.4
INSERT INTO OPERATOR_T VALUES (113, 'FloatingBackwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1623, 113,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (
  1624, 113, 1,   NULL,  'TheAttributes',  'IN',  'BA', NULL);    
INSERT INTO OP_PARAMS_T VALUES (
  1625, 113, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);  
INSERT INTO OP_PARAMS_T VALUES (  
  1626, 113, 1,   1,  'NoOfAttributes', 'IN',  'V',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (  
  1627, 113, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO OP_PARAMS_T VALUES (
  1628, 113,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1629, 113, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1630, 113, 'TYPE', 'TheClassAttribute', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1631, 113, 'IN',   'TheAttributes',  'TheInputConcept',    
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1632, 113, 'TYPE', 'TheAttributes', 'CATEGORIAL', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1633, 113, 'TYPE', 'NoOfAttributes', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1634, 113, 'GT', 'NoOfAttributes', 0, 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1635, 113, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO OP_CONSTR_T VALUES (
  1636, 113, 'GT', 'SampleSize', 0, 
NULL, NULL);

-- INSERT INTO OP_COND_T VALUES (2912, 113, 'LT', 'NoOfAttributes', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1637, 113, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO OP_COND_T VALUES (
  1638, 113, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1639, 113, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2916, 113, 'OPERATOR', 
'This operator removes one feature a time starting from all attributes until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Unlike the simple operator, after removing a feature a check is performed if another feature should be added. Use this operator if  a large number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');

-------------------------------------------------------
-- WP14: 1.5
INSERT INTO OPERATOR_T VALUES (114, 'UserDefinedFeatureSelection', 'NO', 'NO', 'YES', 
NULL);

INSERT INTO OP_PARAMS_T VALUES (
  1640, 114,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO OP_PARAMS_T VALUES (  
  1641, 114, 1,   NULL,  'TheSelectedAttributes', 'IN',  'BA',  NULL);   
INSERT INTO OP_PARAMS_T VALUES (
  1642, 114,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO OP_CONSTR_T VALUES (
  1643, 114, 'IN',   'TheSelectedAttributes',  'TheInputConcept',    
NULL, NULL);

INSERT INTO OP_ASSERT_T VALUES (
  1644, 114, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

INSERT INTO DOCU_T VALUES (
  2956, 114, 'OPERATOR', 
'This operator selects the attributes TheSelectedAttributes given by the user.');

--------------------------------------------------------------------------------------------------------------

COMMIT;
exit
