-----------------------------------------------------------
--                    A windowing operator               --
-----------------------------------------------------------

CREATE OR REPLACE PROCEDURE
     dbWindow( NameColumnSet VARCHAR2,
               TimeAttrib    VARCHAR2,
               ValueAttrib   VARCHAR2,
               Target        VARCHAR2,
               OutTimeStart  VARCHAR2,
               OutTimeEnd    VARCHAR2,
               OutWindowCols VARCHAR2,
               distance      NUMBER)
AS LANGUAGE java NAME
'miningmart.ToWindow.dbWindow(java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, int)';
/

-----------------------------------------------------------
-- Interface procedures for the operators EMA, SMA, WMA. --
-----------------------------------------------------------

CREATE OR REPLACE PROCEDURE
     EMA( InputColumnSet  VARCHAR2,
          TimeAttribIn    VARCHAR2,
          ValueAttribIn   VARCHAR2,
          TargetColumnSet VARCHAR2,
          TimeAttribOut   VARCHAR2,
          ValueAttribOut  VARCHAR2,
          headWeight      NUMBER,
          tailWeight      NUMBER,
          distance        NUMBER)
AS LANGUAGE java NAME
'miningmart.EMF.dbEMA(java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String,
double, double, int)';
/

CREATE OR REPLACE PROCEDURE
     SMA( InputColumnSet     VARCHAR2,
          TimeAttribIn       VARCHAR2,
          ValueAttribIn      VARCHAR2,
          TargetColumnSet    VARCHAR2,
          TimeStartAttribOut VARCHAR2,
          TimeEndAttribOut   VARCHAR2,
          ValueAttribOut     VARCHAR2,
          winsize            NUMBER,
          distance           NUMBER)
AS LANGUAGE java NAME
'miningmart.SMF.dbSMF(java.lang.String, java.lang.String,
java.lang.String, java.lang.String,
java.lang.String, java.lang.String,
java.lang.String, int, int)';
/

CREATE OR REPLACE PROCEDURE
     WMA( InputColumnSet     VARCHAR2,
          TimeAttribIn       VARCHAR2,
          ValueAttribIn      VARCHAR2,
          TargetColumnSet    VARCHAR2,
          TimeStartAttribOut VARCHAR2,
          TimeEndAttribOut   VARCHAR2,
          ValueAttribOut     VARCHAR2,
          weights            VARCHAR2,
          distance           NUMBER)
AS LANGUAGE java NAME
'miningmart.WMF.dbWMA(java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, int)';
/

-- A simple signal to (more or less) symbol operator:

--     SimpleSTSP( InputColumnSet  VARCHAR2,
--                 TimeAttribIn    VARCHAR2,
--                 ValueAttribIn   VARCHAR2,
--                 TargetColumnSet VARCHAR2,
--                 TimeStartOut    VARCHAR2,
--                 TimeEndOut      VARCHAR2,
--                 AvgColumnOut    VARCHAR2,
--                 IncColumnOut    VARCHAR2,
--                 tolerance       NUMBER,

CREATE OR REPLACE PROCEDURE
       SimpleSTSP( InputColumnSet  VARCHAR2,
                   TimeAttribIn    VARCHAR2,
                   ValueAttribIn   VARCHAR2,
                   TargetColumnSet VARCHAR2,
                   TimeStartOut    VARCHAR2,
                   TimeEndOut      VARCHAR2,
		   AvgColumnOut    VARCHAR2,
		   IncColumnOut    VARCHAR2,
                   tolerance       NUMBER)
AS LANGUAGE java NAME
'miningmart.SimpleSTSP.dbSTSP(java.lang.String, java.lang.String, java.lang.String,
java.lang.String, java.lang.String, java.lang.String, java.lang.String,
java.lang.String, double)';
/


---------------------------------------------------------
-- A helper function called by JAVA stored procedures: --
---------------------------------------------------------

CREATE OR REPLACE FUNCTION
GET_TYPE(TAB IN VARCHAR2, ATT IN VARCHAR2)
RETURN VARCHAR2
IS THE_TYPE VARCHAR2(20);
BEGIN
	SELECT DATA_TYPE INTO THE_TYPE FROM COLS
	WHERE ((TABLE_NAME=TAB) AND (COLUMN_NAME=ATT));
RETURN(THE_TYPE);
END;
/

CREATE OR REPLACE FUNCTION
GET_TYPE2(OWN IN VARCHAR2, TAB IN VARCHAR2, ATT IN VARCHAR2)
RETURN VARCHAR2
IS THE_TYPE VARCHAR2(20);
BEGIN
	SELECT DATA_TYPE INTO THE_TYPE FROM ALL_TAB_COLUMNS
	WHERE ((OWNER=OWN) AND (TABLE_NAME=TAB) AND (COLUMN_NAME=ATT));
RETURN(THE_TYPE);
END;
/

---------------------------------------------------------
-- Instead of package DBMS_RANDOM:


CREATE OR REPLACE FUNCTION M4RandomNr (Seed NUMBER, RowNum NUMBER, maxNr NUMBER) RETURN NUMBER
--- Parameter: seed - the seed to use if rownum = 1
---            rownum - the actual rownum within the select
---            maxNr    1 <=  M4RandomNr(...) <= maxNr
--- As it is based on java.util.Random it should be stable,
--- i.e. for a fixed seed it should assign always the same RandomNr to the same Rownum,
--- IF it is called with all rownums from 1 to the actual one
 AS LANGUAGE java
    NAME 'miningmart.M4Random.RandomNr(java.lang.Long, java.lang.Integer, java.lang.Integer) return java.lang.Integer';
/

create or replace function M4RandomSelect (Seed NUMBER, RowNum NUMBER, SelProb NUMBER) RETURN NUMBER
--- Parameter: seed - the seed to use if rownum = 1
---            rownum - the actual rownum within the select
---            selection probability - an integer between 0 and 1000000
---                                    the probability that 1 is returned
--- As it is based on java.util.Random it should be stable,
--- i.e. for a fixed seed it should assign always the same value to the same Rownum
--- IF it is called with all rownums from 1 to the actual one
 AS LANGUAGE java
    NAME 'miningmart.M4Random.RandomSelect(java.lang.Long, java.lang.Integer, java.lang.Integer) return java.lang.Integer';
/


-----------------------------------------------------------------------------
--									   --
-- 		Old functions for Sampling and random numbers!!		   --
--									   --
-----------------------------------------------------------------------------


CREATE OR REPLACE function m4_sample (sampleParam in number)
return number
as
  rv number;
begin
	rv := ( sampleParam * 1000000 );
	rv := M4RandomSelect(0, 2, rv);
return rv;
end;
/

CREATE OR REPLACE function m4_sampleInit
return number
as
  rv number;
begin
        rv := M4RandomNr(98765432, 1, 1);
	-- DBMS_RANDOM.INITIALIZE(98765432);
return 0;
end;
/

CREATE OR REPLACE function m4_sampleTerminate
return number
as
  rv number := 0;
begin
	-- DBMS_RANDOM.TERMINATE;
return rv;
end;
/

-----------------------------------------------------------------------------

COMMIT;
exit
