CREATE OR REPLACE function column_datatype (
	   	  		  		   con_datatype in number)
-- This function converts a concept-datatype
-- into a columnset-datatype.
--
-- Parameters:
-- con_datatype- datatype of concept
-- Return; column_datatype
--
-- Author: Regina Zcker, Swiss Life, Zrich.
-- Date: June 20th, 2001.

return number
as
  rV number := 0;
begin
	 --nominal to string
	 if con_datatype = 1 then rV := 13;
	 --categorial to number
	 elsif con_datatype = 2 then rV := 12;
	 --keyattrib to key
     elsif con_datatype = 3 then rV := 15;
	 --constant to number
	 elsif con_datatype = 4 then rV := 12;
	 --timegroup to date
	 elsif con_datatype = 5 then rV := 14;
	 --spatial to number
	 elsif con_datatype = 6 then rV := 12;
	 --numeric to number
	 elsif con_datatype = 7 then rV := 12;
	 --ordinal to number
	 elsif con_datatype = 8 then rV := 12;
     --scalar to number
	 elsif con_datatype = 9 then rV := 12;
	 --time to date
	 elsif con_datatype = 10 then rV := 14;
     --binary to number
	 elsif con_datatype = 11 then rV := 12;
	 end if;

return rV;
end;
/

CREATE OR REPLACE FUNCTION m4_date_to_timestamp(d in DATE) return NUMBER is
begin
        return TO_CHAR(d,'J')*86400+TO_CHAR(d,'SSSSS');
end;
/

CREATE OR REPLACE FUNCTION m4_timestamp_to_date(d in NUMBER) return DATE is
begin
        return TO_DATE(TO_char(trunc(d/86400)) || '-' || TO_CHAR(mod(d,86400)) ,'J-SSSSS');
--        return TO_DATE(trunc(d/86400),'J')+TO_DATE(mod(d,86400),'SSSSS');
end;
/

CREATE OR REPLACE function mm_add (value in number, addValue in number)
return number
as
begin
return(value + addValue);
end;
/

CREATE OR REPLACE function mm_divide (value in number, divideValue in number)
return number
as
begin
return(value / divideValue);
end;
/

COMMIT;



-----------------------------------------------------------------------------------

CREATE OR REPLACE PROCEDURE Nominalvaluestatist (
                            csName IN VARCHAR2,
							attribId IN NUMBER,
							attribName IN VARCHAR2,
							attribSQL IN VARCHAR2,
							rowcount IN NUMBER
							)
-- This procedure calculates distribution-information
-- for columns with datatype nominal (coldtid = 13).
-- For every different value the existence within the
-- columnSet is counted. Null-values are not counted.
--
-- Parameters:
-- csName - name of the columnSet.
-- attribId - id of the column which shall be calculated.
-- attribName - name of the column.
-- attribSQL - SQL-definition of the column
--
-- Author: Regina Zcker, Swiss Life, Zrich.
-- Date: June 18th, 2001.
AS
  cur NUMBER;
  rows_processed NUMBER;
  modal_val VARCHAR2(500);
  modal_count NUMBER;
  median_val VARCHAR2(500);
  median_sum NUMBER;

  BEGIN
    DECLARE
      v_attribName VARCHAR2(30);
      v_attribCount NUMBER;

  BEGIN
--  calculate min value, max value of column.
    cur:= DBMS_SQL.open_cursor;
    DBMS_SQL.parse(cur,
            'UPDATE COLSTATIST1_T SET (colst1_min, colst1_max) = ' ||
            '(SELECT MIN(' || attribSQl || '), ' ||
			'		 MAX(' || attribSQl || ') ' ||
            '  FROM ' || csName || ') ' ||
            ' WHERE colst1_colid = ' || attribId,
            DBMS_SQL.native);
    rows_processed := DBMS_SQL.EXECUTE(cur);
    DBMS_SQL.CLOSE_CURSOR(cur);

--  calculate distribution for column.
    cur:= DBMS_SQL.open_cursor;
    DBMS_SQL.parse(cur,
           'SELECT ' || attribSQL ||  ' , count(*) FROM ' || csName ||
           ' WHERE ' || attribSQL || ' IS NOT NULL GROUP BY ' || attribSQL ||
		   ' ORDER BY ' || attribSQL,
           DBMS_SQL.native);
    DBMS_SQL.define_column(cur, 1, v_attribName, 30);
    DBMS_SQL.define_column(cur, 2, v_attribCount);
    rows_processed := DBMS_SQL.EXECUTE(cur);
--  insert distribution-information into colstatist2_t.

	modal_count := 0;
	median_sum := 0;

    LOOP
      rows_processed := DBMS_SQL.fetch_rows(cur);
      EXIT WHEN rows_processed = 0;
      DBMS_SQL.column_value(cur, 1, v_attribName);
      DBMS_SQL.column_value(cur, 2, v_attribCount);

	  IF v_attribCount > modal_count THEN
	  	 modal_count := v_attribCount;
		 modal_val := v_attribName;
	  END IF;

	  IF median_sum <= rowcount/2 AND rowcount/2 <= median_sum + v_attribCount THEN
	     median_val := v_attribName;
	  END IF;
	  median_sum := median_sum + v_attribCount;

      INSERT INTO COLSTATIST2_T(colst2_id, colst2_colid,
        colst2_distvalue, colst2_distcount)
        VALUES (ALL_SQ.NEXTVAL, attribId, v_attribName, v_attribCount);
    END LOOP;
    DBMS_SQL.CLOSE_CURSOR(cur);

	UPDATE COLSTATIST1_T
	   SET colst1_modal = modal_val, colst1_median = median_val
	 WHERE colst1_colid = attribId;

---  EXCEPTION
---  WHEN OTHERS THEN
---     DBMS_SQL.CLOSE_CURSOR(cur);
---     RAISE_APPLICATION_ERROR(-20001,'Error IN NominalStatement', TRUE);
  END;
END;
/

CREATE OR REPLACE PROCEDURE Ordinalvaluestatist (
       	  		  			csName IN VARCHAR2,
							attribId IN NUMBER,
							attribName IN VARCHAR2,
							attribSQL IN VARCHAR2,
							rowcount IN NUMBER
							)
-- This procedure calculates distribution-information
-- for columns with datatype ordinal (coldtid = 12).
-- For every different value the existence within the
-- columnSet is counted. Null-values are not counted.
-- For every distribution value, the min and max-value
-- of the distribution range is also saved.
-- Furthermore for every column the average, standard
-- deviation and variance is calculated.
--
-- Parameters:
-- csName - name of the columnSet.
-- attribId - id of the column which shall be calculated.
-- attribName - name of the column.
-- attribSQL  - SQL-Definition of the column
--
-- Author: Regina Zcker, Swiss Life, Zrich.
-- Date: June 18th, 2001.

AS
  cur NUMBER;
  rows_processed NUMBER;
  minVal NUMBER;
  maxVal NUMBER;
  modal_val NUMBER;
  modal_count NUMBER;
  median_val NUMBER;
  median_sum NUMBER;

  BEGIN
    DECLARE
       v_attribAvg NUMBER;
	   v_attribCount NUMBER;
	   v_attribMin NUMBER;
	   v_attribMax NUMBER;

  BEGIN
  --  calculate min value, max value of column.
    cur:= DBMS_SQL.open_cursor;
    DBMS_SQL.parse(cur,
            'UPDATE COLSTATIST1_T SET (colst1_min, colst1_max) = ' ||
            '(SELECT MIN(' || attribSQl || '), ' ||
			'		 MAX(' || attribSQl || ') ' ||
            '  FROM ' || csName || ') ' ||
            ' WHERE colst1_colid = ' || attribId,
            DBMS_SQL.native);
    rows_processed := DBMS_SQL.EXECUTE(cur);
    DBMS_SQL.CLOSE_CURSOR(cur);

--  read min and max for this column.
    SELECT colst1_min, colst1_max INTO minVal, maxVal
      FROM COLSTATIST1_T WHERE colst1_colid = attribId AND ROWNUM < 2;
--  calculate avg, stddev, variance for this column using min and max.
    cur:= DBMS_SQL.open_cursor;
-- Added the modulo to avoid overflows of the 38 precision in the storage field
	DBMS_SQL.parse(cur,
	       'UPDATE COLSTATIST1_T SET (colst1_avg, colst1_stddev, ' ||
		   'colst1_variance) = ' ||
		   '(SELECT ROUND(AVG(' || attribSQL || '),5), ' ||
		   ' ROUND(STDDEV(' || attribSQL || '),5), ' ||
		   ' ROUND(MOD(VARIANCE(' || attribSQL ||'),100000000000000000000000000000000000000),5) ' ||
		   ' FROM ' || csName || ') ' ||
		   ' WHERE colst1_colid = ' || attribId,
		   DBMS_SQL.native);
	rows_processed := DBMS_SQL.EXECUTE(cur);
	DBMS_SQL.CLOSE_CURSOR(cur);
	COMMIT;
--  calculate distribution for column.
	IF (maxVal - minVal) > 0 THEN
      cur:= DBMS_SQL.open_cursor;

DBMS_OUTPUT.PUT_LINE('SELECT AVG(' || attribSQL || ') , COUNT(*), ' );
DBMS_OUTPUT.PUT_LINE(		    ' MIN(' || attribSQL ||'), MAX(' || attribSQL || ') '  );
DBMS_OUTPUT.PUT_LINE(		    ' FROM ' || csName  );
DBMS_OUTPUT.PUT_LINE(		    ' WHERE ' || attribSQL || ' IS NOT NULL '  );
DBMS_OUTPUT.PUT_LINE(		    ' GROUP BY ROUND ((' || attribSQL || ' - '  );
DBMS_OUTPUT.PUT_LINE(			  TO_CHAR(minVal,'99999999999999999990.99999') || ') '  );
DBMS_OUTPUT.PUT_LINE(		    ' / (' || TO_CHAR(maxVal,'99999999999999999990.99999') || ' - '  );
DBMS_OUTPUT.PUT_LINE(			  TO_CHAR(minVal,'99999999999999999990.99999') || ' ) * 1000)'  );
DBMS_OUTPUT.PUT_LINE(			' ORDER BY AVG(' || attribSQL || ')' );

	  DBMS_SQL.parse(cur,
  		    'SELECT AVG(' || attribSQL || ') , COUNT(*), ' ||
		    ' MIN(' || attribSQL ||'), MAX(' || attribSQL || ') ' ||
		    ' FROM ' || csName ||
		    ' WHERE ' || attribSQL || ' IS NOT NULL ' ||
		    ' GROUP BY ROUND ((' || attribSQL || ' - ' ||
			  TO_CHAR(minVal,'99999999999999999990.99999') || ') ' ||
		    ' / (' || TO_CHAR(maxVal,'99999999999999999990.99999') || ' - ' ||
			          TO_CHAR(minVal,'99999999999999999990.99999') || ' ) * 1000)' ||
			' ORDER BY AVG(' || attribSQL || ')',
		    DBMS_SQL.native);
	  DBMS_SQL.define_column(cur, 1, v_attribAvg);
	  DBMS_SQL.define_column(cur, 2, v_attribCount);
	  DBMS_SQL.define_column(cur, 3, v_attribMin);
	  DBMS_SQL.define_column(cur, 4, v_attribMax);
	  rows_processed := DBMS_SQL.EXECUTE(cur);

--    insert one distribution range of a column into colstatist2_t.
--    for every column the average-value for this distribution
--    range, number of elements belonging to this distribution
--    range, min-value and max value of this distribution range
--    are saved.

	  modal_count := 0;
	  median_sum := 0;

	  LOOP
	    rows_processed := DBMS_SQL.fetch_rows(cur);
	    EXIT WHEN rows_processed = 0;
	    DBMS_SQL.column_value(cur, 1, v_attribAvg);
	    DBMS_SQL.column_value(cur, 2, v_attribCount);
	    DBMS_SQL.column_value(cur, 3, v_attribMin);
	    DBMS_SQL.column_value(cur, 4, v_attribMax);

	  	IF v_attribCount > modal_count THEN
	  	   modal_count := v_attribCount;
		   modal_val := v_attribAvg;
	    END IF;

	    IF median_sum <= rowcount/2 AND rowcount/2 <= median_sum + v_attribCount THEN
	       median_val := v_attribAvg;
	    END IF;
	  	median_sum := median_sum + v_attribCount;

	    INSERT INTO COLSTATIST2_T(colst2_id, colst2_colid,
	      colst2_distvalue, colst2_distcount, colst2_distmin,
		  colst2_distmax)
	      VALUES (ALL_SQ.NEXTVAL, attribId,
		  TO_CHAR(v_attribAvg,'99999999999999999990.99999'),
		  v_attribCount, v_attribMin, v_attribMax);
	  END LOOP;
	  DBMS_SQL.CLOSE_CURSOR(cur);

	  UPDATE COLSTATIST1_T
	     SET colst1_modal = TO_CHAR(modal_val,'99999999999999999990.99999'),
		 	 colst1_median = TO_CHAR(median_val,'99999999999999999990.99999')
	   WHERE colst1_colid = attribId;

	END IF;

---  EXCEPTION
---  WHEN OTHERS THEN
---    DBMS_SQL.CLOSE_CURSOR(cur);
---	RAISE_APPLICATION_ERROR(-20002, 'Error IN OrdinalStatement',TRUE);
  END;
END;
/

-- CREATE OR REPLACE FUNCTION M4randomnr (
--        seed IN NUMBER,
--        cROWNUM IN NUMBER,
--        maxNr IN NUMBER)
-- RETURN NUMBER
--  --- Parameter: seed - the seed to use if rownum = 1
--  ---            rownum - the actual rownum within the select
--  ---            maxNr    1 <=  M4RandomNr(...) <= maxNr
--  --- As it is based on java.util.Random it should be stable,
--  --- i.e. for a fixed seed it should assign always the same RandomNr to the same Rownum,
--  --- IF it is called with all rownums from 1 to the actual one
--  AS
--  BEGIN
--    IF cROWNUM = 1 THEN
--       DBMS_RANDOM.INITIALIZE(seed);
--    END IF;
--    RETURN 1 + ROUND(ABS(DBMS_RANDOM.RANDOM / 2147483647) * maxNr,0);
--  END;
--  /

--  CREATE OR REPLACE function m4_sample (sampleParam in number)
-- This function converts a datatype
-- of old metadata-schema
-- into a columnset-datatype.
--
-- Parameters:
-- datatype- datatype of old metadata-schema
-- Return; column_datatype
--
-- Author: Regina Zcker, Swiss Life, Zrich.
-- Date: July 20th, 2001.

-- return number
-- as
--   rv number := 0;
-- begin
-- 	IF abs(DBMS_RANDOM.RANDOM / 2147483647) < sampleParam THEN
-- 	  rv := 1;
-- 	END IF;
-- return rv;
-- end;
-- /

CREATE OR REPLACE PROCEDURE Timevaluestatist (
       	  		  			csName IN VARCHAR2,
							attribId IN NUMBER,
							attribName IN VARCHAR2,
							attribSQL IN VARCHAR2,
							rowcount IN NUMBER
							)
-- This procedure calculates distribution-information
-- for columns with datatype date (coldtid = 14).
-- For every different value the existence within the
-- columnSet is counted. Null-values are not counted.
-- For every distribution value, the min and max-value
-- of the distribution range is also saved.
-- Dependent on the range between the minimal and maximal
-- value of the column, distribution information
-- is calculated on a yearly, quarterly, monthly or
-- daily basis.
--
-- Parameters:
-- csName - name of the columnSet.
-- attribId - id of the column which shall be calculated.
-- attribName - name of the column.
-- attribSQL  - SQL-Definition of the column
--
-- Author: Regina Zcker, Swiss Life, Zrich.
-- Date: June 18th, 2001.

AS
  cur NUMBER;
  rows_processed NUMBER;
  modal_val VARCHAR2(500);
  modal_count NUMBER;
  median_val VARCHAR2(500);
  median_sum NUMBER;


  BEGIN
    DECLARE
       v_months NUMBER(6,2);
	   tmpString VARCHAR2(500);
	   v_attribValue VARCHAR2(500);
	   v_attribCount NUMBER;
	   v_attribMin DATE;
	   v_attribMax DATE;

  BEGIN
  --  calculate min value, max value of column.
    cur:= DBMS_SQL.open_cursor;
    DBMS_SQL.parse(cur,
            'UPDATE COLSTATIST1_T SET (colst1_min, colst1_max) = ' ||
            '(SELECT MIN(' || attribSQl || '), ' ||
			'		 MAX(' || attribSQl || ') ' ||
            '  FROM ' || csName || ') ' ||
            ' WHERE colst1_colid = ' || attribId,
            DBMS_SQL.native);
    rows_processed := DBMS_SQL.EXECUTE(cur);
    DBMS_SQL.CLOSE_CURSOR(cur);
--  read number of months between min and max value of column.
    cur:= DBMS_SQL.open_cursor;
	DBMS_SQL.parse(cur,
    	   'SELECT MONTHS_BETWEEN(MAX(' || attribSQL || '), ' ||
		   ' MIN(' || attribSQL || ')) FROM ' || csName,
		   DBMS_SQL.native);
    DBMS_SQL.define_column(cur, 1, v_months);
	rows_processed := DBMS_SQL.EXECUTE(cur);
    LOOP
	  rows_processed := DBMS_SQL.fetch_rows(cur);
	  EXIT WHEN rows_processed = 0;
	  DBMS_SQL.column_value(cur, 1, v_months);
	END LOOP;
	DBMS_SQL.CLOSE_CURSOR(cur);
	DBMS_OUTPUT.PUT_LINE('MONTHS_BETWEEN ok ' || TO_CHAR(v_months));

--  distribution base is years.
	IF v_months > 600 THEN
	  tmpString := 'SELECT TO_CHAR(' || attribSQL || ', ''YYYY''), ' ||
	    		 	' COUNT(*), ' ||
	   			 	' MIN( ' || attribSQL || '), MAX( ' || attribSQL ||
					') FROM ' || csName ||
					' WHERE ' || attribSQL || ' IS NOT NULL ' ||
					' GROUP BY TO_CHAR(' || attribSQL || ', ''YYYY'') ' ||
					' ORDER BY TO_CHAR(' || attribSQL || ', ''YYYY'') ';
--  distribution base is quarter years
	ELSIF v_months > 60 THEN
	  tmpString := 'SELECT TO_CHAR(' || attribSQL || ', ''YYYYQ''), ' ||
	   			 	' COUNT(*), ' ||
	   			 	' MIN( ' || attribSQL || '), MAX( ' || attribSQL ||
					') FROM ' || csName ||
					' WHERE ' || attribSQL || ' IS NOT NULL ' ||
					' GROUP BY TO_CHAR(' || attribSQL || ', ''YYYYQ'') ' ||
					' ORDER BY TO_CHAR(' || attribSQL || ', ''YYYYQ'') ';
--  distribution base is months
	ELSIF v_months > 3 THEN
	   tmpString := 'SELECT TO_CHAR(' || attribSQL || ', ''YYYYMM''), ' ||
	   			 	' COUNT(*), ' ||
	   			 	' MIN( ' || attribSQL || '), MAX( ' || attribSQL ||
					') FROM ' || csName ||
					' WHERE ' || attribName || ' IS NOT NULL ' ||
					' GROUP BY TO_CHAR(' || attribName || ', ''YYYYMM'') ' ||
					' ORDER BY TO_CHAR(' || attribName || ', ''YYYYMM'') ';
--  distribution base is days
	ELSIF v_months > 0 THEN
	   tmpString := 'SELECT TO_CHAR(' || attribName || ', ''YYYYMMDD''), ' ||
	   			 	' COUNT(*), ' ||
	   			 	' MIN( ' || attribName || '), MAX( ' || attribName ||
					') FROM ' || csName ||
					' WHERE ' || attribName || ' IS NOT NULL ' ||
					' GROUP BY TO_CHAR(' || attribName || ', ''YYYYMMDD'') ' ||
					' ORDER BY TO_CHAR(' || attribName || ', ''YYYYMMDD'') ';
					
--  NIT: distribtion base is days (this was added as a bugfix)
	ELSE 
	   tmpString := 'SELECT TO_CHAR(' || attribName || ', ''YYYYMMDD''), ' ||
	   			 	' COUNT(*), ' ||
	   			 	' MIN( ' || attribName || '), MAX( ' || attribName ||
					') FROM ' || csName ||
					' WHERE ' || attribName || ' IS NOT NULL ' ||
					' GROUP BY TO_CHAR(' || attribName || ', ''YYYYMMDD'') ' ||
					' ORDER BY TO_CHAR(' || attribName || ', ''YYYYMMDD'') ';
	END IF;
	DBMS_OUTPUT.PUT_LINE(tmpString);

--  calculate distribution for column, depending on months.
    cur:= DBMS_SQL.open_cursor;
    DBMS_SQL.parse(cur,tmpString, DBMS_SQL.native);
    DBMS_SQL.define_column(cur, 1, v_attribValue, 500);
	DBMS_SQL.define_column(cur, 2, v_attribCount);
	DBMS_SQL.define_column(cur, 3, v_attribMin);
	DBMS_SQL.define_column(cur, 4, v_attribMax);
	rows_processed := DBMS_SQL.EXECUTE(cur);

--  insert one distribution range of a column into colstatist2_t.
--  for every column the value for this distribution
--  range, number of elements belonging to this distribution
--  range, min-value and max value of this distribution range
--  are saved.
	modal_count := 0;
	median_sum := 0;

	LOOP
	  rows_processed := DBMS_SQL.fetch_rows(cur);
	  EXIT WHEN rows_processed = 0;
	  DBMS_SQL.column_value(cur, 1, v_attribValue);
	  DBMS_SQL.column_value(cur, 2, v_attribCount);
	  DBMS_SQL.column_value(cur, 3, v_attribMin);
	  DBMS_SQL.column_value(cur, 4, v_attribMax);
--	  DBMS_OUTPUT.PUT_LINE('READ FETCH ok' || v_attribValue);

	  IF v_attribCount > modal_count THEN
	  	 modal_count := v_attribCount;
		 modal_val := v_attribValue;
	  END IF;

	  IF median_sum <= rowcount/2 AND rowcount/2 <= median_sum + v_attribCount THEN
	     median_val := v_attribValue;
	  END IF;
	  median_sum := median_sum + v_attribCount;

	  INSERT INTO COLSTATIST2_T(colst2_id, colst2_colid,
	    colst2_distvalue, colst2_distcount, colst2_distmin,
	    colst2_distmax)
	    VALUES (ALL_SQ.NEXTVAL, attribId, v_attribValue, v_attribCount,
		TO_NUMBER(TO_CHAR(v_attribMin, 'YYYYMMDD')),
		TO_NUMBER(TO_CHAR(v_attribMax, 'YYYYMMDD')));
	END LOOP;
	DBMS_SQL.CLOSE_CURSOR(cur);

	UPDATE COLSTATIST1_T
	   SET colst1_modal = modal_val, colst1_median = median_val
	 WHERE colst1_colid = attribId;

---  EXCEPTION
---  WHEN OTHERS THEN
---    DBMS_SQL.CLOSE_CURSOR(cur);
---	RAISE_APPLICATION_ERROR(-20002, 'Error IN TimeStatement',TRUE);
  END;
END;
/


CREATE OR REPLACE PROCEDURE Updatecolumnstatistics (
       	  		  			attribCsName IN VARCHAR2,
							attribId IN NUMBER,
							attribName IN VARCHAR2,
							attribColdtid IN NUMBER,
							attribCONDTID IN NUMBER,
							attribSQL IN VARCHAR2,
							rowcount IN NUMBER)
-- This procedure calculates all column-statistics
-- which are datatype-independent, like number of
-- unique values, number of missing values etc.
-- in the columnSet.
--
-- Parameters:
-- attribCsName - name of the columnSet.
-- attribId - id of the column which shall be calculated.
-- attribName - name of the column.
-- attribSQL - the definition of the column
--
-- Author: Regina Zcker, Swiss Life, Zrich.
-- Date: June 18th, 2001.
AS
  cur NUMBER;
  rows_processed NUMBER;
  tmp VARCHAR2(500);

  BEGIN
--  delete old values in colstatist1_t and colstatist2_t.
    DELETE FROM COLSTATIST1_T WHERE colst1_colid = attribId;
    DELETE FROM COLSTATIST2_T WHERE colst2_colid = attribId;
--  insert one new row.
	DBMS_OUTPUT.PUT_LINE('AttribName: ' || attribName || ' AttribId: ' || attribId );
    INSERT INTO COLSTATIST1_T (colst1_id, colst1_colid)
      VALUES (ALL_SQ.NEXTVAL, attribId);
	DBMS_OUTPUT.PUT_LINE('new line colstatist1 ok');
--  count unique value of column.
    cur:= DBMS_SQL.open_cursor;
---    DBMS_OUTPUT.PUT_LINE(
---            'UPDATE COLSTATIST1_T SET colst1_unique = ' ||
---            '(SELECT COUNT(DISTINCT ' || attribSQL ||
---			') FROM ' || attribCsName || ') ' ||
---            ' WHERE colst1_colid = ' || attribId
---			);
    DBMS_SQL.parse(cur,
            'UPDATE COLSTATIST1_T SET colst1_unique = ' ||
            '(SELECT COUNT(DISTINCT ' || attribSQL ||
			') FROM ' || attribCsName || ') ' ||
            ' WHERE colst1_colid = ' || attribId,
            DBMS_SQL.native);
    rows_processed := DBMS_SQL.EXECUTE(cur);
    DBMS_SQL.CLOSE_CURSOR(cur);
	DBMS_OUTPUT.PUT_LINE('colst1_unique ok');
--  count missing value of column.
    cur:= DBMS_SQL.open_cursor;
    DBMS_SQL.parse(cur,
            'UPDATE COLSTATIST1_T SET colst1_missing = ' ||
            '(SELECT COUNT(*) FROM ' || attribCsName ||
            ' WHERE ' || attribSQL || ' IS NULL) ' ||
            ' WHERE colst1_colid = ' || attribId,
            DBMS_SQL.native);
    rows_processed := DBMS_SQL.EXECUTE(cur);
    DBMS_SQL.CLOSE_CURSOR(cur);
	DBMS_OUTPUT.PUT_LINE('colst1_missing ok');

--    statistics for (var)char columns, if conc_data_type is not key/timegroup/spatial.
	  IF attribColdtid IN (13,15) AND attribCONDTID NOT IN (3,5,6) THEN
		Nominalvaluestatist(attribCsName, attribId, attribName, attribSql, rowcount);
	  END IF;
--    statistics for numeric columns, if conc_data_type is not key/timegroup/spatial.
  	  IF attribColdtid = 12 AND attribCONDTID NOT IN (3,5,6) THEN
		Ordinalvaluestatist(attribCsName, attribId, attribName, attribSql, rowcount);
	  END IF;
--    statistics for date columns, if conc_data_type is not key/timegroup/spatial.
  	  IF attribColdtid = 14 AND attribCONDTID NOT IN (3,5,6) THEN
		Timevaluestatist(attribCsName, attribId, attribName, attribSql, rowcount);
	  END IF;

	DBMS_OUTPUT.PUT_LINE('colst1_min_max ok');
---  EXCEPTION
---  WHEN OTHERS THEN
---     DBMS_SQL.CLOSE_CURSOR(cur);
---     RAISE_APPLICATION_ERROR(-20001,'Error IN CommonStatement', TRUE);
END;
/



-----------------------------------------------------------------
-- SQL functions for intervals mapping (discretization) by NIT --
-----------------------------------------------------------------

create or replace function time_interv_to_cat (
   time date, 
   time_format in varchar2,
   disc_table in varchar2,
   default_val in varchar2
)
return varchar2 is
  cur number;
  rows_processed number;
  ret_val varchar2(100); -- I think it's enough!
  the_query varchar2(500);
  time_string varchar2(200);
begin

  cur := dbms_sql.open_cursor;
  the_query := 'select value from ' || disc_table || ' where ' || 
     '(int_start < :time_v and int_end > :time_v and left_b = ''E'' and right_b = ''E'') or ' ||
     '(int_start <= :time_v and int_end > :time_v and left_b = ''I'' and right_b = ''E'') or ' ||
     '(int_start < :time_v and int_end >= :time_v and left_b = ''E'' and right_b = ''I'') or ' ||
     '(int_start <= :time_v and int_end >= :time_v and left_b = ''I'' and right_b = ''I'')';

  dbms_sql.parse(cur, the_query, dbms_sql.native);
  dbms_sql.bind_variable(cur, ':time_v', time);
  dbms_sql.define_column(cur,  1, ret_val, 30);
  rows_processed := dbms_sql.execute(cur);

  loop 
   rows_processed := dbms_sql.fetch_rows(cur);
   exit when rows_processed = 0;
   dbms_sql.column_value(cur, 1, ret_val);   -- last interval that time falls in is returned
  end loop;
  
  if ret_val is null then
     ret_val := default_val;
  end if;

  dbms_sql.close_cursor(cur);

  return ret_val;
 
end;
/


create or replace function num_interv_to_cat (
   num in number, 		-- numerical value
   disc_table in varchar2,	-- discretization table
   default_val in varchar2	-- default value
)
return varchar2 is
  cur number;
  rows_processed number;
  ret_val varchar2(100); -- I think it's enough!
begin

  cur := dbms_sql.open_cursor;
  dbms_sql.parse(cur, 
     'select value from ' || disc_table || ' where ' ||
     '(int_start < :num_v and int_end > :num_v and left_b = ''E'' and right_b = ''E'') or ' ||
      '(int_start <= :num_v and int_end > :num_v and left_b = ''I'' and right_b = ''E'') or ' ||
       '(int_start < :num_v and int_end >= :num_v and left_b = ''E'' and right_b = ''I'') or ' ||
       '(int_start <= :num_v and int_end >= :num_v and left_b = ''I'' and right_b = ''I'')',
     dbms_sql.native);
  dbms_sql.bind_variable(cur, ':num_v', num);
  dbms_sql.define_column(cur, 1, ret_val, 30);
  rows_processed := dbms_sql.execute(cur);

  loop 
   rows_processed := dbms_sql.fetch_rows(cur);
   exit when rows_processed = 0;
   dbms_sql.column_value(cur, 1, ret_val);   -- last interval that num falls in is returned
  end loop;
  
  if ret_val is null then
     ret_val := default_val;
  end if;

  dbms_sql.close_cursor(cur);
  return ret_val;
 
end;
/

----------------------------
COMMIT;

exit
