package miningmart;
import java.util.Vector;

public class TimeValueArray {

    final private long   startTime;
    final private double startValue;

    private long   endTime;
    private double endValue;
    private int    size;
    private double sum;

    /** Initializes the object with a first entry which must not be <i>null</i>! */
    public TimeValueArray(TimeValue t) {
	startTime  = t.getTimeAsLong();
	startValue = t.getValue();
	endTime    = startTime;
	endValue   = startValue;
	size = 1;
	sum = startValue;
    }

    public long getStartTime() {
	return startTime;
    }

    public double getStartValue() {
	return startValue;
    }

    public long getLatestTime() {
	return endTime;
    }

    public double getLatestValue() {
	return endValue;
    }

    public int getSize() {
	return size;
    }

    public double getSum() {
	return sum;
    }

    public void add(TimeValue t) {
	if (t == null)
	    return;
	size++;
	endTime  = t.getTimeAsLong();
	endValue = t.getValue();
	sum += endValue;
    }

    public double getAverageValue() {
	return (getSum() / getSize());
    }

    public double getIncreaseByTime() {
	double valueDiff = getLatestValue() - getStartValue();
	long   timeDiff  = getLatestTime()  - getStartTime();
	if (timeDiff == 0)
	    return 0;
	else return (valueDiff / timeDiff);
    }

    public double extrapolateValueFor(long time) {
	double increase = getIncreaseByTime() * (time - getLatestTime());
	return (getLatestValue() + increase);
    }

}
