package miningmart;
import java.sql.*;
import java.util.Vector;
import java.io.*;

public class DbConnector {

    private static final String urlPrefix = "jdbc:oracle:thin:@kiste:1521:";
    private static String dbName="MMart";
    private static String user="deleteme";
    private static String passwd="deleteme";
    private static String compilerHome="~/m4c";
    private static final String dbSpecsFile="/db.config";


    // If you want to use these functions as stored procedures, set storedProcedure to true

    private static final boolean storedProcedure = true;

    // If you need debug-messages via System.out.println(..), set to "true":
    private static final boolean debugMessages	 = false;

    private final Connection con;

    public DbConnector() throws SQLException {
	try {
	    if (!storedProcedure) {
		Class.forName("oracle.jdbc.driver.OracleDriver");
		readDBParams();
	    }
	    this.con = (storedProcedure) ? DriverManager.getConnection("jdbc:default:connection:") :
		DriverManager.getConnection(getDBConnection(), getUser(), getPassword());
	}
	catch (Exception e) {
	    infoOutput("Error while connecting: " + e.getMessage());
	    throw new SQLException("Database connection failed!");
	}
	if (this.con == null)
	    throw new SQLException("Database connection failed!");
    }

    private static void readDBParams() {
	if ((compilerHome == null) || (dbName == null) || (user == null) || (passwd == null)) {

	    compilerHome = System.getProperty("COMPILER_HOME");
	    try {
		BufferedReader in  = new BufferedReader(new FileReader(compilerHome + dbSpecsFile));

		String inputLine;
		Vector v=new Vector();
		while ((inputLine = in.readLine()) != null)
		    v.addElement(inputLine);
		if (v.size() >= 3) {
		    dbName = (String)(v.elementAt(0));
		    user   = (String)(v.elementAt(1));
		    passwd = (String)(v.elementAt(2));
		}
		in.close();
	    }
	    catch (IOException e) {
		infoOutput("IO-Error reading database specifications from file "
			   + compilerHome + dbSpecsFile + " !");
	    }
	}
    }

    public Connection getConnection() {
	return this.con;
    }

    public void close() {
	final Connection c = this.getConnection();
	try {
	    if (c != null && !c.isClosed()) {
		c.commit();
		c.close();
	    }
	} catch (SQLException e) {
	    infoOutput("Closing Connection in class DbConnector failed:\n" + e);
	}
    }

    public static void infoOutput(String out) {
	if (debugMessages == true)
	    System.out.println(out);
    }

    public static void main (String[] argv) throws SQLException {
	DbConnector mycon=new DbConnector();
    }



    /* ----------- private helper methods ----------- */

    // getUser
    // returns the username that should be used for the database connection
    private String getUser() {
	return user;
    }

    // getPassword
    // returns the password that should be used for the database connection
    private String getPassword() {
	return passwd;
    }

    // getConnection
    // returns the connection string to the database
    private String getDBConnection() {
	return urlPrefix+dbName;
    }

}
