package miningmart;
import java.sql.*;

class DataType {

    public static final short UNKNOWN  = -1;
    public static final short NUMBER   = 0;
    public static final short DATE     = 1;
    public static final short CHAR     = 2;
    public static final short VARCHAR2 = 3;

    private static final String DT_NAME_UNKNOWN = "UNKNOWN";
    
    private static final String[] dtNames = new String[]
	{ "NUMBER", "DATE", "CHAR", "VARCHAR2" };


    public static short getTypeFor(String dtString) {
	if (dtString == null)
	    return UNKNOWN;

	short ret = UNKNOWN;
	for (short i=0; i<dtNames.length && ret == UNKNOWN; i++)
	    if (dtNames[i].equalsIgnoreCase(dtString))
		ret = i;
		return ret;
    }

    public static String getNameFor(short dtConstant) {
	if (dtConstant < 0 || dtConstant >= dtNames.length)
	    return DT_NAME_UNKNOWN;
	return dtNames[dtConstant];
    }

    /**
     * @param tableName the name of a table int the database
     * @param columnName the name of a column of the given table
     * @return the datatype of the specified column
     */
    public static short getColumnDataType(String tableName, String columnName, DbConnector dbc) {
	if (tableName == null || columnName == null) {
	    DbConnector.infoOutput
		("Warning: Trying to call DataType.getColumnDataType("
		 + tableName + ", " + columnName +") with null values!");
	    return DataType.UNKNOWN;
	}


	String query;
	int lastDotIndex = tableName.lastIndexOf('.');
	if (lastDotIndex == -1) {
	    query = "SELECT GET_TYPE('" + tableName.toUpperCase() + "', '"
		+ columnName.toUpperCase() + "') FROM DUAL";
	}
	else {
	    final String justTableName = tableName.substring(lastDotIndex + 1);
	    final String owner =  tableName.substring(0, lastDotIndex);
	    query = "SELECT GET_TYPE2('" + owner.toUpperCase() + "', '"
		+ justTableName.toUpperCase() + "', '" + columnName.toUpperCase()
		+ "') FROM DUAL";
	}

	String dtString = null;
	try {
	    if (dbc == null) {
		DbConnector.infoOutput
		    ("Warning: Trying to call DataType.getColumnDataType("
		     + tableName + ", " + columnName +") without valid DB connection!");
		dbc = new DbConnector();
	    }
	    Statement stmt = dbc.getConnection().createStatement();
	    DbConnector.infoOutput("DB Query: " + query);
	    ResultSet rset = stmt.executeQuery(query);
	    if (rset.next())
		dtString = rset.getString(1);
	    rset.close();
	    stmt.close();
	} catch (SQLException e) {DbConnector.infoOutput(e.getMessage());}
	return (DataType.getTypeFor(dtString));
    }

    public static void wrongDataType(String table, Attribute column) throws SQLException {
	throw new SQLException("Column '" + column + "' of table '" + table +
			       "' has unsupported relational datatype: '" + 
			       column.getDataTypeName() + "'!");
    }

}
