REM ----------------------------------------------
REM ------------    Delete Tables    -------------
REM ----------------------------------------------

DROP TABLE COLSTATIST1_T     CASCADE CONSTRAINTS ;
DROP TABLE COLSTATIST2_T     CASCADE CONSTRAINTS ;

REM ----------------------------------------------
REM ------------    Create Tables    -------------
REM ----------------------------------------------

REM Table COLSTATIST1_T
CREATE TABLE COLSTATIST1_T (
  COLST1_ID        NUMBER        NOT NULL,
  COLST1_COLID     NUMBER        NOT NULL,
  COLST1_UNIQUE    NUMBER    (20),
  COLST1_MISSING   NUMBER    (20),
  COLST1_MIN       VARCHAR2 (100),
  COLST1_MAX       VARCHAR2 (100),
  COLST1_AVG       NUMBER  (20,5),
  COLST1_STDDEV    NUMBER  (20,5),
  COLST1_VARIANCE  NUMBER  (38,5),
  COLST1_MEDIAN    VARCHAR2 (100),
  COLST1_MODAL     VARCHAR2 (100),
  CONSTRAINT COLST1ID_PK
    PRIMARY KEY ( COLST1_ID )
);

REM Table COLSTATIST2_T
CREATE TABLE COLSTATIST2_T (
  COLST2_ID         NUMBER         NOT NULL,
  COLST2_COLID      NUMBER         NOT NULL,
  COLST2_DISTVALUE  VARCHAR2 (100) NOT NULL,
  COLST2_DISTCOUNT  NUMBER    (20) NOT NULL,
  COLST2_DISTMIN    NUMBER  (20,5),
  COLST2_DISTMAX    NUMBER  (20,5),
  CONSTRAINT COLST2ID_PK
    PRIMARY KEY ( COLST2_ID )
);

REM --------------------------------------------------

COMMIT;
exit
