#!/bin/sh

# Read environment variables:
. runtime/etc/properties

# ---------------------------------------------------------

# Exit in case of obvious errors:
if [ -r ${PID_FILE} ]; then
  echo "Found another instance of the server running with PID: `cat ${PID_FILE}`"
fi

# ---------------------------------------------------------

# Setting the java CLASSPATH variable:
CLASSPATH="${CLASSPATH}:${COMPILER_JAR}:${JDBC_ZIP}"
export CLASSPATH

# ---------------------------------------------------------

# Looking for a running rmiregistry-process of the current user.
# If no such process is found, launch one!

RMI_CANDIDATE="`${PROCESSES} | grep ${RMI_REGISTRY} | grep -v grep`"

if [ "${RMI_CANDIDATE}" = "" ]; then

  echo "No rmiregistry process found. I am going to launch one."
  ${NOHUP} ${RMI_REGISTRY} -J-Djava.security.manager -J-Djava.security.policy=${JAVA_POLICY} >/dev/null 2>&1 &
  echo "I hope it succeeded. The process ID is: $!"

else

  echo "${RMIREGISTRY} process candidate found:"
  echo ${RMI_CANDIDATE}
  echo "I will not start another one."

fi

# ---------------------------------------------------------

echo ""
echo "Starting the server."

${NOHUP} java -Djava.security.manager -Djava.security.policy=${JAVA_POLICY} -DML_HOME=${ML_HOME}/ -DLOG_FILES=${LOGFILE} -DTEMP_DIR=${TEMP_DIR}/ -DDEFAULT_VERBOSITY=${VERBOSITY} -DRMI_HOST=${COMPILERSERVER} miningmart.compilerInterface.CompilerAccessServer ${DB_CONFIG} >${LOGFILE} 2>&1 &

echo $! > ${PID_FILE}

echo "Server process started. Process ID is: $!"
echo "Please use showlog.sh to view the current status."
echo "To shutdown the server, please use stop.sh."
echo ""
echo "Thank you for using the MiningMart system!"
echo ""

