#!/bin/sh

# Read environment variables:
. runtime/etc/properties

# ---------------------------------------------------------

# Setting the java CLASSPATH variable:
CLASSPATH="${CLASSPATH}:${COMPILER_JAR}:${JDBC_ZIP}"
export CLASSPATH

# ---------------------------------------------------------

# Looking for a running rmiregistry-process of the current user.
# If no such process is found, launch one!

RMI_CANDIDATE="`${PROCESSES} | grep ${RMI_REGISTRY} | grep -v grep`"

if [ "${RMI_CANDIDATE}" = "" ]; then

  echo "No rmiregistry process found. Please start one!"
  exit -1

fi

# ---------------------------------------------------------

echo "Starting the server."

java -Djava.security.manager -Djava.security.policy=${JAVA_POLICY} -DML_HOME=${ML_HOME}/ -DLOG_FILES=${LOGFILE} -DTEMP_DIR=${TEMP_DIR}/ -DDEFAULT_VERBOSITY=${VERBOSITY} -DRMI_HOST=${COMPILERSERVER} miningmart.compilerInterface.CompilerAccessServer ${DB_CONFIG}
