/*
 * Decompiled with CFR 0.152.
 */
package miningmart.tools.DM.Sequence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.ResultSet;
import miningmart.compiler.exception.M4CompilerThreadKilledException;
import miningmart.tools.DM.DMException;
import miningmart.tools.DM.MD.ColumnInfo;
import miningmart.tools.DM.Sequence.CorrelResult;
import miningmart.tools.DM.Sequence.CorrelResult2PLSql;
import miningmart.tools.DM.Sequence.CorrelResultParser;
import miningmart.tools.DM.Wrapper.Wrapper;

public class CorrelWrapper
extends Wrapper {
    protected String m_file_name;
    protected PrintWriter m_data;
    CorrelResult m_correl_result;

    public void checkMetaData() throws Exception {
        if (this.m_md.getColumnToLearn() != null) {
            throw new DMException("Sequence Correl is an unsupervised learningalgoritm.  It don't require a column to learn");
        }
        if (this.m_md.getColumnInfos().size() != 1) {
            throw new DMException("Sequence Correl require only one column");
        }
        ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(0);
        if (ci.getConceptType() != 4 && ci.getDataType() != 0) {
            throw new DMException("Sequence Correl  requite a column with a String oracol type and with a scalar concept type");
        }
    }

    protected String makeQuery() throws DMException, M4CompilerThreadKilledException {
        double sample_ratio;
        String q = "select ";
        ColumnInfo ci = (ColumnInfo)this.m_md.getColumnInfos().elementAt(0);
        q = String.valueOf(q) + ci.getSqlName();
        q = String.valueOf(q) + " from " + this.m_md.getTableName() + " ";
        String where = null;
        if (this.m_md.getColumnToLearn() != null) {
            where = String.valueOf(this.m_md.getColumnToLearn().getSqlName()) + " is not null ";
        }
        if ((sample_ratio = this.m_md.getColumnToLearn() != null ? this.getSampleRatio(this.m_sample_size, this.m_md.getTableName(), this.m_md.getColumnToLearn().getSqlName()) : this.getSampleRatio(this.m_sample_size, this.m_md.getTableName(), null)) < 1.0) {
            where = where == null ? "" : String.valueOf(where) + " and ";
            where = String.valueOf(where) + " DMRandomSelect(98765432,ROWNUM," + (int)(sample_ratio * 100000.0) + ")=1";
        }
        if (where != null) {
            q = String.valueOf(q) + "where " + where;
        }
        System.out.print(String.valueOf(q) + "\n");
        return q;
    }

    protected void exportTable() throws Exception {
        this.m_file_name = String.valueOf(this.m_ml_home) + "/tmp/seq_" + this.m_md.getTableName();
        BufferedWriter w = new BufferedWriter(new FileWriter(String.valueOf(this.m_file_name) + ".obj"));
        this.m_data = new PrintWriter(w);
        this.exportData();
        this.m_data.close();
        this.m_data = null;
    }

    protected void exportData() throws Exception {
        ResultSet res = this.getM4Db().executeBusinessSqlRead(this.makeQuery());
        int i = 0;
        while (res.next()) {
            this.m_data.print(i);
            this.m_data.print(" 1 0 ");
            this.m_data.print(res.getString(1));
            this.m_data.print("\n");
            ++i;
        }
        res.close();
    }

    protected void callTool() throws Exception {
        this.callScript("cp " + this.m_ml_home + "/etc/correl_param.txt " + this.m_ml_home + "/tmp/.param");
        this.callScript("ftextract " + this.m_file_name + ".obj");
        this.callScript("seq_pattern2dlf " + this.m_file_name + ".obj.result " + this.m_file_name);
    }

    protected void clean() throws Exception {
        this.callScript("rm -f " + this.m_ml_home + "/tmp/.list " + this.m_file_name + ".* " + this.m_file_name + "_* " + this.m_ml_home + "/tmp/.param " + this.m_ml_home + "/tmp/_listl " + this.m_ml_home + "/tmp/*.str " + this.m_ml_home + "/tmp/*.bpath " + this.m_ml_home + "/tmp/*.cor " + this.m_ml_home + "/tmp/*.fcor " + this.m_ml_home + "/tmp/*.path " + this.m_ml_home + "/tmp/*.sim " + this.m_ml_home + "/tmp/_list " + this.m_ml_home + "/tmp/_ll " + this.m_ml_home + "/tmp/*.no " + this.m_ml_home + "/tmp/*.tmpl ");
    }

    protected void importResult() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(String.valueOf(this.m_file_name) + "_seq_pattern.dlf"));
        CorrelResultParser crp = new CorrelResultParser(r);
        this.m_correl_result = crp.parse();
    }

    protected void saveResult() throws Exception {
        CorrelResult2PLSql cr2sql = new CorrelResult2PLSql();
        cr2sql.setMetaData(this.m_md);
        cr2sql.setConnection(this.getM4Db());
        cr2sql.setResultName(this.m_result_name);
        cr2sql.convert(this.m_correl_result);
    }
}

