/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compilerInterface;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Case;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.exception.M4CompilerThreadKilledException;
import miningmart.compiler.operator.Operator;
import miningmart.compiler.utils.ConfigReader;
import miningmart.compiler.utils.DB;
import miningmart.compiler.utils.Print;
import miningmart.compilerInterface.CompilerThreadControl;
import miningmart.compilerInterface.M4CompilerInterfaceError;

public class CompilerAccessLogic {
    private static final String DB_CONFIG_FILE = "/home/mmcoord/compiler/runtime/etc/db.config";
    private static final String LOGFILE = "/home/mmcoord/compiler/runtime/tmp/m4c.log";
    private static final CompilerThreadControl ctc = new CompilerThreadControl();
    private static final int MAX_STEPS_PER_CONNECTION = 150;
    private int stepsDuringDbConnection = 0;
    private boolean stopThread = false;
    private final DB m4db;
    private final Print defaultPrintObject;
    private Print casePrintObject;
    private Case caseObj;
    private final Integer verbosity;

    public CompilerAccessLogic() throws IOException, SQLException {
        this(DB_CONFIG_FILE, null);
    }

    public CompilerAccessLogic(int verbosity) throws IOException, SQLException {
        this(DB_CONFIG_FILE, new Integer(verbosity));
    }

    public CompilerAccessLogic(String myDbConfigFile) throws IOException, SQLException {
        this(myDbConfigFile, null);
    }

    public CompilerAccessLogic(String myDbConfigFile, int verbosity) throws IOException, SQLException {
        this(myDbConfigFile, new Integer(verbosity));
    }

    private CompilerAccessLogic(String myDbConfigFile, Integer verbosity) throws IOException, SQLException {
        this.verbosity = verbosity == null || verbosity < 0 ? null : verbosity;
        this.defaultPrintObject = this.initDefaultPrint();
        ConfigReader cr = new ConfigReader(myDbConfigFile);
        String m4dbname = cr.getLine();
        String m4user = cr.getLine();
        String m4password = cr.getLine();
        String m4driver = cr.getLine();
        String m4dbLocation = cr.getLine();
        if (cr.hasMoreLines()) {
            cr.getLine();
            String dataDbname = cr.getLine();
            String dataUser = cr.getLine();
            String dataPassword = cr.getLine();
            String dataDriver = cr.getLine();
            String dataDbLocation = cr.getLine();
            this.m4db = new DB(String.valueOf(m4driver) + m4dbLocation, m4dbname, m4user, m4password, String.valueOf(dataDriver) + dataDbLocation, dataDbname, dataUser, dataPassword, true, this);
        } else {
            this.m4db = new DB(String.valueOf(m4driver) + m4dbLocation, m4dbname, m4user, m4password, null, null, null, null, true, this);
        }
    }

    public void compileStep(long stepID, boolean lazyMode) throws M4CompilerInterfaceError {
        long caseId = this.getCaseIdByStepId(stepID);
        this.setCase(caseId);
        this.deleteTrashBeforeCompilingStep(stepID);
        this.compileStepMultiStepControl(stepID, lazyMode, false);
        this.printStepExecInfo(stepID, lazyMode);
    }

    public void compileStep(String stepName, boolean lazyMode) throws M4CompilerInterfaceError {
        long stepId = this.findStepId(stepName);
        this.compileStep(stepId, lazyMode);
    }

    private void compileStepMultiStepControl(long stepID, boolean lazyMode, boolean computeStatistics) throws M4CompilerInterfaceError {
        try {
            long[] inConIDs = this.getM4db().getInputConceptIDsForStep(stepID);
            this.getM4db().setComputeStatistics(computeStatistics);
            Step step = new Step(stepID, this.getM4db());
            Vector<Concept> multiCSConcepts = new Vector<Concept>();
            int i = 0;
            while (i < inConIDs.length) {
                Concept c = (Concept)this.getM4db().m4cache(inConIDs[i], new Concept(this.getM4db()));
                Columnset[] colsets = c.getColumnSets();
                if (colsets.length > 1) {
                    c.initMultiStepSupport(colsets);
                    multiCSConcepts.add(c);
                }
                ++i;
            }
            if (multiCSConcepts.size() == 0) {
                this.compileStepBody(step, lazyMode);
            } else if (lazyMode) {
                this.compileStepBody(step, true);
            } else {
                Object[] multiCon = multiCSConcepts.toArray();
                do {
                    this.compileStepBody(step, lazyMode);
                } while (this.nextCSSetting(multiCon, 0));
            }
        }
        catch (SQLException ex) {
            throw new M4CompilerInterfaceError("SQLException trying to compile step " + stepID + " in " + (lazyMode ? "lazy" : "eager") + " mode:\n" + ex.getMessage());
        }
        catch (M4CompilerError ex) {
            throw new M4CompilerInterfaceError("M4CompilerError trying to compile step " + stepID + " in " + (lazyMode ? "lazy" : "eager") + " mode:\n" + ex.getMessage());
        }
    }

    private boolean nextCSSetting(Object[] multiCon, int index) throws M4CompilerError {
        int length = multiCon.length;
        if (index + 1 < length && this.nextCSSetting(multiCon, index + 1)) {
            return true;
        }
        Concept c = (Concept)multiCon[index];
        if (c.hasNextColumnSet()) {
            c.getNextColumnSet();
            return true;
        }
        c.resetColumnSets();
        return false;
    }

    private void compileStepBody(long stepId, boolean lazyMode, boolean computeStatistics) throws M4CompilerInterfaceError {
        try {
            this.getM4db().setComputeStatistics(computeStatistics);
            Step step = new Step(stepId, this.getM4db());
            this.compileStepBody(step, lazyMode);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("An M4CompilerError occured executing step no." + stepId + " in " + (lazyMode ? "lazy" : "eager") + " Mode:\n" + ex.getMessage());
        }
        catch (SQLException ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("An SQLException occured executing step no." + stepId + " in " + (lazyMode ? "lazy" : "eager") + " Mode:\n" + ex.getMessage());
        }
    }

    private void compileStepBody(Step step, boolean lazyMode) throws SQLException, M4CompilerError {
        this.doPrint(16, "Waiting for resources to compile step " + step.getId() + ".");
        ctc.addThread((short)2);
        try {
            if (this.stepsDuringDbConnection++ >= 150) {
                try {
                    this.getM4db().getFreshM4Connection();
                    this.stepsDuringDbConnection = 0;
                }
                catch (SQLException sqle) {
                    this.doPrint(18, "CompilerAccessLogic: Could not refresh DB connection!\n" + sqle);
                }
            }
            Operator op = step.getOperator();
            this.doPrint(16, "Executing step " + step.getId() + ".");
            op.execute(lazyMode);
            this.getM4db().addStepCompiledToTrash(step.getId());
            this.getM4db().commitM4Transactions();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ctc.subThread((short)2);
            this.doPrint(16, "Compilation of step " + step.getId() + " done.");
            throw throwable;
        }
        Object var5_7 = null;
        ctc.subThread((short)2);
        this.doPrint(16, "Compilation of step " + step.getId() + " done.");
    }

    public void compileAll(long caseId, boolean lazyMode) throws M4CompilerInterfaceError {
        try {
            this.setCase(caseId);
            Iterator stepIds = this.getCase().iterator();
            HashSet garbageCollected = new HashSet();
            while (stepIds.hasNext()) {
                Long currentStepIdL = (Long)stepIds.next();
                long currentStepId = currentStepIdL;
                if (!garbageCollected.contains(currentStepIdL)) {
                    this.deleteTrashBeforeCompilingStep(currentStepId);
                    Collection col = this.getCase().getDependentStepIdsFor(currentStepId);
                    garbageCollected.addAll(col);
                }
                this.printBeforeStepInfo(currentStepId, lazyMode);
                this.compileStepMultiStepControl(currentStepId, lazyMode, false);
                this.printStepExecInfo(currentStepId, lazyMode);
            }
        }
        catch (M4CompilerError e) {
            throw new M4CompilerInterfaceError("Caught an M4CompilerError trying to compile case " + caseId + "\n" + e.getMessage());
        }
    }

    public void compileStepFrom(long stepId, boolean lazyMode) throws M4CompilerInterfaceError {
        try {
            long caseId = this.getCaseIdByStepId(stepId);
            this.setCase(caseId);
            boolean garbageCollected = false;
            Iterator stepIds = this.getCase().getDependentStepIdsFor(stepId).iterator();
            while (stepIds.hasNext()) {
                long currentStepId = (Long)stepIds.next();
                if (!garbageCollected) {
                    this.deleteTrashBeforeCompilingStep(currentStepId);
                    garbageCollected = true;
                }
                this.printBeforeStepInfo(currentStepId, lazyMode);
                this.compileStepMultiStepControl(currentStepId, lazyMode, false);
                this.printStepExecInfo(currentStepId, lazyMode);
            }
        }
        catch (M4CompilerError e) {
            throw new M4CompilerInterfaceError("Caught an M4CompilerError trying to compileStepFrom " + stepId + "\n" + e.getMessage());
        }
    }

    private void deleteTrashBeforeCompilingStep(long stepId) throws M4CompilerInterfaceError {
        this.deleteTrashFromStep(stepId);
        this.doPrint(16, String.valueOf(this.systemTime()) + " : Preparing execution of step " + stepId + ", checking for MultiSteps...");
    }

    private void deleteTrashFromStep(long stepId) throws M4CompilerInterfaceError {
        try {
            this.doPrint(16, String.valueOf(this.systemTime()) + " Waiting for resource to run garbage collection for step " + stepId + ".");
            ctc.addThread((short)1);
            try {
                this.doPrint(16, String.valueOf(this.systemTime()) + " Running garbage collection for step " + stepId + ".");
                this.getM4db().deleteTrashFromStep(stepId);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ctc.subThread((short)1);
                throw throwable;
            }
            Object var4_5 = null;
            ctc.subThread((short)1);
        }
        catch (M4CompilerError e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
    }

    private long findStepId(String stepName) throws M4CompilerInterfaceError {
        String msg = "";
        try {
            String query = "SELECT st_id FROM step_t WHERE st_name = '" + stepName + "'";
            Long stepId = this.getM4db().executeM4SingleValueSqlReadL(query);
            if (stepId != null) {
                return stepId;
            }
        }
        catch (SQLException e) {
            msg = "\nAn SQLException occured:\n" + e.getMessage();
        }
        catch (M4CompilerThreadKilledException m) {
            msg = "\nCompiler Thread was killed!\n" + m.getMessage();
        }
        msg = "M4 Database: Step with name '" + stepName + "' not found!" + msg;
        throw new M4CompilerInterfaceError(msg);
    }

    private void printBeforeStepInfo(long stepID, boolean lazyMode) {
        this.doPrint(16, "\n--- " + this.systemTime() + " ---");
        this.doPrint(16, "Trying to execute Step " + stepID + " in " + (lazyMode ? "lazy" : "eager") + " mode ...");
    }

    private void printStepExecInfo(long stepID, boolean lazyMode) {
        this.doPrint(16, "\n--- " + this.systemTime() + " ---");
        this.doPrint(16, "Execution for Step " + stepID + " without errors");
        this.doPrint(16, "Mode was set to " + (lazyMode ? "lazy" : "eager"));
    }

    private void printStepExecInfo(String stepName, boolean lazyMode) {
        this.doPrint(16, "\n--- " + this.systemTime() + " ---");
        this.doPrint(16, "Execution for Step " + stepName + " without errors");
        this.doPrint(16, "Mode was set to " + (lazyMode ? "lazy" : "eager"));
    }

    private String systemTime() {
        Calendar calendar = Calendar.getInstance();
        String day = this.fillUpToTwoDigits(calendar.get(5));
        String month = this.fillUpToTwoDigits(calendar.get(2) + 1);
        int year = calendar.get(1);
        String hour = this.fillUpToTwoDigits(calendar.get(11));
        String minutes = this.fillUpToTwoDigits(calendar.get(12));
        String seconds = this.fillUpToTwoDigits(calendar.get(13));
        String s = String.valueOf(day) + "." + month + "." + year + " " + hour + ":" + minutes + ":" + seconds;
        return s;
    }

    private String fillUpToTwoDigits(int number) {
        String s = Integer.toString(number);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    public void updateColumnStatistics(long columnID) throws M4CompilerInterfaceError {
        try {
            this.doPrint(16, "Waiting for resources to updateColumnStatistics of column " + columnID + ".");
            ctc.addThread((short)2);
            this.doPrint(16, "Starting calculations for updating Column statistics (column id: " + columnID + ").");
            try {
                Column myColumn2 = new Column(this.getM4db());
                myColumn2.load(columnID);
                BaseAttribute ba = myColumn2.getBaseAttribute();
                if (ba == null) {
                    throw new M4CompilerInterfaceError("updateColumnStatistics: Trying to calculate statistics for Column not attached to a BaseAttribute!\nColumn ID is: " + columnID);
                }
                this.getM4db().updateColumnStatistics(myColumn2, ba.getConceptualDataType());
                this.doPrint(16, "Updated column statistics of column " + columnID + ".");
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ctc.subThread((short)2);
                throw throwable;
            }
            Object var6_8 = null;
            ctc.subThread((short)2);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("M4CompilerError trying to update ColumnStatistics for Column " + columnID + ":\n");
        }
        catch (SQLException ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("SQLException trying to update ColumnStatistics for Column " + columnID + ":\n");
        }
    }

    public void updateColumnsetStatistics(long columnsetID) throws M4CompilerInterfaceError {
        try {
            this.doPrint(16, "Waiting for resources to updateColumnsetStatistics of columnset " + columnsetID + ".");
            ctc.addThread((short)2);
            this.doPrint(16, "Starting calculations for updating Columnset statistics (columnset id: " + columnsetID + ").");
            try {
                Columnset myCol = new Columnset(this.getM4db());
                myCol.load(columnsetID);
                this.getM4db().updateColumnsetStatistics(myCol);
                this.doPrint(16, "Updated columnset statistics of columnset " + columnsetID + ".");
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ctc.subThread((short)2);
                throw throwable;
            }
            Object var5_7 = null;
            ctc.subThread((short)2);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("M4CompilerError trying to update ColumnsetStatistics for ColumnSet " + columnsetID + ":\n");
        }
        catch (SQLException ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("SQLException trying to update ColumnsetStatistics for ColumnSet " + columnsetID + ":\n");
        }
    }

    public void updateStatisticsForConcept(long conceptID) throws M4CompilerInterfaceError {
        Concept myConcept = new Concept(this.getM4db());
        try {
            this.doPrint(16, "Waiting for resources to updateStatisticsForConcept of concept " + conceptID + ".");
            ctc.addThread((short)2);
            this.doPrint(16, "Starting calculations for updating Concept statistics (Concept id: " + conceptID + ").");
            try {
                myConcept.load(conceptID);
                Columnset[] cols = myConcept.getColumnSets();
                int i = 0;
                while (i <= cols.length - 1) {
                    this.getM4db().updateColumnsetStatistics(cols[i]);
                    ++i;
                }
                this.doPrint(16, "Updated statistics for concept " + conceptID + ".");
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ctc.subThread((short)2);
                throw throwable;
            }
            Object var7_9 = null;
            ctc.subThread((short)2);
        }
        catch (M4CompilerError ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("M4CompilerError trying to update statistics for concept " + conceptID + ":\n");
        }
        catch (SQLException ex) {
            this.doPrint(ex);
            throw new M4CompilerInterfaceError("SQLException trying to update statistics for concept " + conceptID + ":\n");
        }
    }

    public void deleteTrashForStep(long stepId) throws M4CompilerInterfaceError {
        if (this.getCase() == null) {
            long caseId = this.getCaseIdByStepId(stepId);
            this.setCase(caseId);
        }
        this.deleteTrashFromStep(stepId);
    }

    public void deleteTrashForCase(long caseId) throws M4CompilerInterfaceError {
        if (this.getCase() == null) {
            this.setCase(caseId);
        }
        HashSet gcDone = new HashSet();
        try {
            Iterator it = this.getCase().iterator();
            while (it.hasNext()) {
                Long stepIdL = (Long)it.next();
                if (gcDone.contains(stepIdL)) continue;
                long stepId = stepIdL;
                this.deleteTrashFromStep(stepId);
                Collection col = this.getCase().getDependentStepIdsFor(stepId);
                gcDone.addAll(col);
            }
        }
        catch (M4CompilerError e) {
            throw new M4CompilerInterfaceError("CompilerAccessLogic.deleteTrashForCase(" + caseId + ") - Exception caught:\n" + e.getMessage());
        }
    }

    public String getStatusMessage(long caseId, int numberOfLines) throws M4CompilerInterfaceError {
        BufferedReader in;
        StringBuffer ret = new StringBuffer("");
        String fileName = this.defaultPrintObject.getFileNameForCase(caseId);
        try {
            in = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException e) {
            return null;
        }
        LinkedList<String> ll = new LinkedList<String>();
        try {
            String s;
            while ((s = in.readLine()) != null) {
                ll.addLast(s);
                if (ll.size() <= numberOfLines) continue;
                ll.removeFirst();
            }
            Iterator it = ll.iterator();
            while (it.hasNext()) {
                ret.append((String)it.next());
                ret.append("\n");
            }
        }
        catch (IOException e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
        return ret.toString();
    }

    public String getStatusFromLine(long caseId, int lineNumber) throws M4CompilerInterfaceError {
        StringBuffer sb = new StringBuffer(100);
        BufferedReader lnr = null;
        int curentLineNr = 0;
        try {
            try {
                String line;
                String fileName = this.defaultPrintObject.getFileNameForCase(caseId);
                lnr = new BufferedReader(new FileReader(fileName));
                while ((line = lnr.readLine()) != null) {
                    if (curentLineNr++ >= lineNumber) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    ++curentLineNr;
                }
            }
            catch (IOException e) {
                throw new M4CompilerInterfaceError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Object var11_11 = null;
        if (lnr != null) {
            try {
                lnr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return String.valueOf(++curentLineNr) + "\n" + sb.toString();
    }

    public boolean isReadyForCompilation(long stepId) throws M4CompilerInterfaceError {
        try {
            if (this.getM4db().isCompiledStep(stepId)) {
                return true;
            }
            Collection predecessors = this.getM4db().getStepsPredecessors(stepId);
            Iterator it = predecessors.iterator();
            while (it.hasNext()) {
                long predStepId = (Long)it.next();
                if (this.getM4db().isCompiledStep(predStepId)) continue;
                return false;
            }
            return true;
        }
        catch (M4CompilerError e) {
            throw new M4CompilerInterfaceError(e.getMessage());
        }
    }

    public void compileRestOfCase(long caseId, boolean lazyMode) throws M4CompilerInterfaceError {
        try {
            this.setCase(caseId);
            Iterator stepIds = this.getCase().iterator();
            HashSet garbageCollected = new HashSet();
            while (stepIds.hasNext()) {
                Long currentStepIdL = (Long)stepIds.next();
                long currentStepId = currentStepIdL;
                if (this.getM4db().isCompiledStep(currentStepId) || !this.isReadyForCompilation(currentStepId)) continue;
                if (!garbageCollected.contains(currentStepIdL)) {
                    this.deleteTrashBeforeCompilingStep(currentStepId);
                    Collection col = this.getCase().getDependentStepIdsFor(currentStepId);
                    garbageCollected.addAll(col);
                }
                this.printBeforeStepInfo(currentStepId, lazyMode);
                this.compileStepMultiStepControl(currentStepId, lazyMode, false);
                this.printStepExecInfo(currentStepId, lazyMode);
            }
        }
        catch (M4CompilerError e) {
            throw new M4CompilerInterfaceError("Caught an M4CompilerError trying to compile case " + caseId + "\n" + e.getMessage());
        }
    }

    public DB getM4db() {
        return this.m4db;
    }

    public Print getCasePrintObject() {
        if (this.casePrintObject != null) {
            return this.casePrintObject;
        }
        return this.defaultPrintObject;
    }

    private Print initDefaultPrint() {
        if (this.verbosity != null) {
            return new Print(this.verbosity);
        }
        return new Print();
    }

    private void initCasePrint(long caseId) {
        if (this.casePrintObject == null) {
            try {
                this.casePrintObject = this.verbosity != null ? new Print(caseId, this.verbosity) : new Print(caseId);
            }
            catch (IOException e) {
                this.defaultPrintObject.doPrint(20, "Warning: Could not generate logfile.");
                this.defaultPrintObject.doPrint(e);
                this.casePrintObject = this.getCasePrintObject();
            }
        }
    }

    void setStopRequest() {
        this.stopThread = true;
    }

    public boolean getStopRequest() {
        return this.stopThread;
    }

    private void setCase(long caseId) throws M4CompilerInterfaceError {
        this.initCasePrint(caseId);
        Case caseObj = new Case(this.getM4db());
        try {
            caseObj.load(caseId);
            this.caseObj = caseObj;
        }
        catch (Exception e) {
            throw new M4CompilerInterfaceError(e.getClass() + " while loading case for caseId " + caseId + "\nin method CompilerAccessLogic.setCase(caseId):\n" + e.getMessage());
        }
    }

    public Case getCase() {
        return this.caseObj;
    }

    private long getCaseIdByStepId(long stepId) throws M4CompilerInterfaceError {
        try {
            return this.getM4db().readCaseIdForStepId(stepId);
        }
        catch (Exception e) {
            throw new M4CompilerInterfaceError(e.getClass() + " while loading caseId for stepId " + stepId + "\nin method CompilerAccessLogic.getCaseIdByStepId(stepId):\n" + e.getMessage());
        }
    }

    private void doPrint(int verbosity, String message) {
        this.getCasePrintObject().doPrint(verbosity, message);
    }

    private void doPrint(Exception e) {
        this.getCasePrintObject().doPrint(e);
    }
}

