/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import miningmart.compiler.Columnset;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.exception.M4CompilerThreadKilledException;
import miningmart.compiler.utils.ExtendedResultSet;
import miningmart.compilerInterface.CompilerAccessLogic;
import oracle.jdbc.driver.OracleDriver;

class DbCore {
    private Connection m4Con = null;
    private Connection dataCon = null;
    private final HashMap m4ReadResultSets = new HashMap();
    private final HashMap businessReadResultSets = new HashMap();
    private Statement m4StatementWrite;
    private Statement businessStatementWrite;
    private static final int MAX_OPEN_STATEMENTS = 20;
    private final String url;
    private final String user;
    private final String passwd;
    private final String dataurl;
    private final String datauser;
    private final String datapasswd;
    private final CompilerAccessLogic cal;

    public DbCore(String m4Url, String m4DbName, String m4User, String m4Passwd, String dataUrl, String dataDbName, String dataUser, String dataPasswd, CompilerAccessLogic cal) throws SQLException {
        this.url = String.valueOf(m4Url) + m4DbName;
        this.user = m4User;
        this.passwd = m4Passwd;
        this.dataurl = String.valueOf(dataUrl) + dataDbName;
        this.datauser = dataUser;
        this.datapasswd = dataPasswd;
        this.cal = cal;
        this.getFreshM4Connection();
        if (dataUrl == null || dataDbName == null || dataUser == null || dataPasswd == null) {
            this.dataCon = this.m4Con;
            this.doPrint(18, "Using same DB for metadata and business data.");
        } else {
            this.getBusinessDBConnection(String.valueOf(dataUrl) + dataDbName, dataUser, dataPasswd);
        }
    }

    public void finalize() throws SQLException {
        try {
            this.switchTriggersOn();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.closeM4DbStatements();
        this.closeBusinessDbStatements();
        if (this.m4Con != null) {
            this.m4Con.close();
            this.m4Con = null;
            this.doPrint(18, "M4-DB disconnected");
        }
        if (this.dataCon != null) {
            this.dataCon.close();
            this.dataCon = null;
            this.doPrint(18, "Business-DB disconnected");
        }
    }

    String getDataUrl() {
        return this.dataurl;
    }

    String getDataUser() {
        return this.datauser;
    }

    String getDataPw() {
        return this.datapasswd;
    }

    void getFreshM4Connection() throws SQLException {
        boolean onlyOneCon = false;
        if (this.m4Con != null && this.m4Con == this.dataCon) {
            onlyOneCon = true;
        }
        if (this.m4Con != null) {
            this.switchTriggersOn();
            this.m4Con.commit();
            this.closeM4DbStatements();
            this.m4Con.close();
        } else {
            DriverManager.registerDriver((Driver)new OracleDriver());
        }
        this.m4Con = DriverManager.getConnection(this.url, this.user, this.passwd);
        if (onlyOneCon) {
            this.dataCon = this.m4Con;
        }
        this.m4Con.setAutoCommit(false);
        DatabaseMetaData m4md = this.m4Con.getMetaData();
        this.doPrint(18, "\n--- Refreshing M4 database connection ---");
        this.doPrint(18, "JDBC-Driver-Version: " + m4md.getDriverVersion() + "  " + m4md.getDatabaseProductName());
        this.doPrint(18, "M4-DB-Connection ok");
        this.switchTriggersOff();
    }

    private void getBusinessDBConnection(String dUrl, String dUser, String dPasswd) throws SQLException {
        if (this.dataCon != null) {
            this.dataCon.close();
        } else {
            DriverManager.registerDriver((Driver)new OracleDriver());
        }
        this.dataCon = DriverManager.getConnection(dUrl, dUser, dPasswd);
        this.dataCon.setAutoCommit(false);
        DatabaseMetaData dmd = this.dataCon.getMetaData();
        this.doPrint(18, "\n--- Refreshing business database connection ---");
        this.doPrint(18, "JDBC-Driver-Version: " + dmd.getDriverVersion() + "  " + dmd.getDatabaseProductName());
        this.doPrint(18, "Business-DB-Connection ok");
    }

    public void commitM4Transactions() throws SQLException {
        this.closeM4DbStatements();
        this.switchTriggersOn();
        this.getDatabaseConnectionForM4().commit();
        this.doPrint(10, "M4-DB: Batch executed, updates committed!");
        this.switchTriggersOff();
    }

    public void commitBusinessTransactions() throws SQLException {
        if (this.getDatabaseConnectionForData() != this.getDatabaseConnectionForM4()) {
            this.closeBusinessDbStatements();
            this.getDatabaseConnectionForData().commit();
            this.doPrint(10, "Business-DB: Batch executed, updates committed!");
        }
    }

    public void rollbackOnM4() throws SQLException {
        this.closeM4DbStatements();
        this.getDatabaseConnectionForM4().rollback();
        this.doPrint(10, "M4-DB: Updates rolled back!");
        this.switchTriggersOff();
    }

    private Connection getDatabaseConnectionForM4() {
        return this.m4Con;
    }

    private Statement getM4DbReadStatement() throws SQLException, M4CompilerThreadKilledException {
        this.checkKillThread();
        Statement stmt = DbCore.findFreeStatement(this.m4ReadResultSets);
        if (stmt == null) {
            stmt = this.getDatabaseConnectionForM4().createStatement();
            this.m4ReadResultSets.put(stmt, new ExtendedResultSet(stmt));
        }
        if (this.m4ReadResultSets.size() > 20) {
            this.openStatementsWarning(true, this.m4ReadResultSets.size());
        }
        return stmt;
    }

    private Statement getM4DbWriteStatement() throws SQLException, M4CompilerThreadKilledException {
        this.checkKillThread();
        if (this.m4StatementWrite == null) {
            Statement stmt = this.getDatabaseConnectionForM4().createStatement();
            stmt.clearBatch();
            this.m4StatementWrite = stmt;
        }
        return this.m4StatementWrite;
    }

    private void closeM4DbStatements() {
        if (this.m4StatementWrite != null) {
            try {
                DbCore.commitBatch(this.m4StatementWrite);
                this.m4StatementWrite.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m4StatementWrite = null;
        }
        DbCore.clearStatementMap(this.m4ReadResultSets);
    }

    private Connection getDatabaseConnectionForData() {
        return this.dataCon;
    }

    Connection getExternalDatabaseConnectionForData() throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection newDataCon = DriverManager.getConnection(this.getDataUrl(), this.getDataUser(), this.getDataPw());
        newDataCon.setAutoCommit(false);
        DatabaseMetaData dmd = newDataCon.getMetaData();
        this.doPrint(18, "\n--- Setting up new business database connection for external use ---");
        this.doPrint(18, "JDBC-Driver-Version: " + dmd.getDriverVersion() + "  " + dmd.getDatabaseProductName());
        this.doPrint(18, "Business-DB-Connection ok");
        return newDataCon;
    }

    private Statement getBusinessDbReadStatement() throws SQLException, M4CompilerThreadKilledException {
        this.checkKillThread();
        Statement stmt = DbCore.findFreeStatement(this.businessReadResultSets);
        if (stmt == null) {
            stmt = this.getDatabaseConnectionForData().createStatement();
            this.businessReadResultSets.put(stmt, new ExtendedResultSet(stmt));
        }
        if (this.businessReadResultSets.size() > 20) {
            this.openStatementsWarning(false, this.businessReadResultSets.size());
        }
        return stmt;
    }

    private Statement getBusinessDbWriteStatement() throws SQLException, M4CompilerThreadKilledException {
        this.checkKillThread();
        if (this.businessStatementWrite == null) {
            Statement stmt = this.getDatabaseConnectionForData().createStatement();
            stmt.clearBatch();
            this.businessStatementWrite = stmt;
        }
        return this.businessStatementWrite;
    }

    private void closeBusinessDbStatements() {
        if (this.businessStatementWrite != null) {
            try {
                DbCore.commitBatch(this.businessStatementWrite);
                this.businessStatementWrite.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.businessStatementWrite = null;
        }
        DbCore.clearStatementMap(this.businessReadResultSets);
    }

    public void executeM4SqlWrite(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getM4DbWriteStatement();
        this.executeSqlWrite(query, stmt);
    }

    public void createSQLView(Columnset cs, long stepId, boolean materialize) throws SQLException, M4CompilerError {
        String sqlTemp = cs.getSQLDefinition();
        sqlTemp = sqlTemp.substring(1, sqlTemp.length() - 1);
        String query = "CREATE " + (materialize ? "TABLE " : "OR REPLACE VIEW ") + cs.getName() + " AS " + sqlTemp;
        this.executeBusinessSqlWrite(query);
    }

    public void createSQLFunction(String myFunction) throws SQLException, M4CompilerThreadKilledException {
        String query = "CREATE OR REPLACE " + myFunction;
        this.executeBusinessSqlWrite(query);
    }

    public String createSqlIndex(String tableName, String[] attributes) throws SQLException, M4CompilerThreadKilledException {
        if (attributes == null || attributes.length == 0) {
            return null;
        }
        String indexName = String.valueOf(tableName) + "_IDX";
        String query = "CREATE INDEX " + indexName + " ON " + tableName + " (";
        int i = 0;
        while (i < attributes.length) {
            query = String.valueOf(query) + attributes[i] + ", ";
            ++i;
        }
        query = query.subSequence(0, query.length() - 2) + ")";
        this.executeBusinessSqlWrite(query);
        return indexName;
    }

    public void executeBusinessSqlWrite(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getBusinessDbWriteStatement();
        this.executeSqlWrite(query, stmt);
    }

    public ResultSet executeM4SqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getM4DbReadStatement();
        return this.executeSqlRead(query, stmt);
    }

    public ResultSet executeBusinessSqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getBusinessDbReadStatement();
        return this.executeSqlRead(query, stmt);
    }

    private void executeSqlWrite(String query, Statement stmt) throws SQLException {
        if (DbCore.isBatchableWriteQuery(query)) {
            stmt.addBatch(query);
            this.doPrint(10, "DB write (to batch): " + query);
        } else {
            DbCore.commitBatch(stmt);
            stmt.executeUpdate(query);
            this.doPrint(10, "DB execute/update: " + query);
        }
    }

    private ResultSet executeSqlRead(String query, Statement stmt) throws SQLException {
        this.doPrint(2, "DB Query (Read): " + query);
        ExtendedResultSet rs = new ExtendedResultSet(stmt.executeQuery(query));
        if (this.businessReadResultSets.containsKey(stmt)) {
            this.businessReadResultSets.put(stmt, rs);
        } else {
            this.m4ReadResultSets.put(stmt, rs);
        }
        return rs;
    }

    private String executeSingleValueSqlRead(String query, Statement stmt) throws SQLException {
        ResultSet rs = this.executeSqlRead(query, stmt);
        if (rs.next()) {
            String s = rs.getString(1);
            rs.close();
            return s;
        }
        return null;
    }

    private Long executeSingleValueSqlReadL(String query, Statement stmt) throws SQLException {
        ResultSet rs = this.executeSqlRead(query, stmt);
        if (rs.next()) {
            Long l = new Long(rs.getLong(1));
            rs.close();
            return l;
        }
        return null;
    }

    public Long executeM4SingleValueSqlReadL(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getM4DbReadStatement();
        return this.executeSingleValueSqlReadL(query, stmt);
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getBusinessDbReadStatement();
        return this.executeSingleValueSqlReadL(query, stmt);
    }

    public String executeM4SingleValueSqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getM4DbReadStatement();
        return this.executeSingleValueSqlRead(query, stmt);
    }

    public String executeBusinessSingleValueSqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        Statement stmt = this.getBusinessDbReadStatement();
        return this.executeSingleValueSqlRead(query, stmt);
    }

    private long getNextM4SequenceValue(Statement stmt) throws M4CompilerError {
        String query = "select all_sq.nextval from dual";
        Long nextval = null;
        String sqle = "";
        try {
            nextval = this.executeSingleValueSqlReadL(query, stmt);
        }
        catch (SQLException e) {
            sqle = "\nAn SQLException occured during invokation:\n" + e.getMessage();
        }
        if (nextval == null) {
            String msg = "Error in method DbCore.getNextM4SequenceValue(Statement):\nSequence 'all_sq.nextval' did not return a value!" + sqle;
            throw new M4CompilerError(msg);
        }
        return nextval;
    }

    long getNextM4SequenceValue() throws M4CompilerError {
        try {
            Statement stmt = this.getM4DbReadStatement();
            return this.getNextM4SequenceValue(stmt);
        }
        catch (SQLException e) {
            String msg = "Error in method DbCore.getNextM4SequenceValue():\nCould not create Statement:\n" + e.getMessage();
            throw new M4CompilerError(msg);
        }
    }

    public void executeDBProcedure(String procedureName, String[] parameters, boolean businessDb) throws SQLException, M4CompilerError {
        Statement stmt = businessDb ? this.getBusinessDbWriteStatement() : this.getM4DbWriteStatement();
        DbCore.commitBatch(stmt);
        String queryStart = "BEGIN " + procedureName + "(";
        String queryEnd = "); END; ";
        String queryParameters = "";
        int i = 0;
        while (i < parameters.length) {
            queryParameters = String.valueOf(queryParameters) + parameters[i];
            if (i < parameters.length - 1) {
                queryParameters = String.valueOf(queryParameters) + ", ";
            }
            ++i;
        }
        String query = String.valueOf(queryStart) + queryParameters + queryEnd;
        this.doPrint(2, "DB Query: " + query);
        if (this.getDatabaseConnectionForData() == this.getDatabaseConnectionForM4()) {
            this.switchTriggersOn();
            stmt.executeUpdate(query);
            this.switchTriggersOff();
        } else {
            stmt.executeUpdate(query);
        }
    }

    private void openStatementsWarning(boolean m4schema, int number) {
        this.doPrint(20, "( Warning: The number of open statements for the " + (m4schema ? "m4" : "business") + " schema is " + number + ".");
        this.doPrint(20, "  Probably some of the ResultSets are not closed after usage! )");
    }

    private void checkKillThread() throws M4CompilerThreadKilledException {
        if (this.cal.getStopRequest()) {
            this.doPrint(20, "Thread was requested to stop. Closing database resources.");
            try {
                if (this.m4StatementWrite != null) {
                    this.m4StatementWrite.clearBatch();
                }
                DbCore.clearStatementMap(this.m4ReadResultSets);
                if (this.m4Con != null) {
                    this.m4Con.rollback();
                    this.m4Con.close();
                    this.m4Con = null;
                }
                this.doPrint(10, "M4-DB: Rollback and closing of connection successful!");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.m4Con != this.dataCon) {
                try {
                    if (this.businessStatementWrite != null) {
                        this.businessStatementWrite.clearBatch();
                    }
                    DbCore.clearStatementMap(this.businessReadResultSets);
                    if (this.dataCon != null) {
                        this.dataCon.rollback();
                        this.dataCon.close();
                        this.dataCon = null;
                    }
                    this.doPrint(10, "Business-DB: Rollback and closing of connection successful!");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new M4CompilerThreadKilledException();
            }
        }
    }

    private void switchTriggersOff() throws SQLException {
        try {
            this.executeM4SqlWrite("INSERT INTO trigger_flag_t VALUES ( '-' )");
        }
        catch (M4CompilerThreadKilledException m4CompilerThreadKilledException) {
            // empty catch block
        }
    }

    private void switchTriggersOn() throws SQLException {
        try {
            this.executeM4SqlWrite("DELETE FROM trigger_flag_t");
        }
        catch (M4CompilerThreadKilledException m4CompilerThreadKilledException) {
            // empty catch block
        }
    }

    private void doPrint(int verbosity, String message) {
        this.cal.getCasePrintObject().doPrint(verbosity, message);
    }

    private void doPrint(Exception ex) {
        this.cal.getCasePrintObject().doPrint(ex);
    }

    private static void commitBatch(Statement stmt) throws SQLException {
        stmt.executeBatch();
        stmt.clearBatch();
    }

    private static boolean isBatchableWriteQuery(String query) {
        String tmp = query.trim().toLowerCase();
        return tmp.startsWith("update ") || tmp.startsWith("insert ") && tmp.indexOf("trigger_flag_t") == -1;
    }

    private static void clearStatementMap(HashMap theMap) {
        if (theMap == null || theMap.isEmpty()) {
            return;
        }
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            if (stmt == null) continue;
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        theMap.clear();
    }

    private static Statement findFreeStatement(HashMap theMap) {
        Iterator it = theMap.keySet().iterator();
        while (it.hasNext()) {
            ExtendedResultSet rs;
            Statement stmt = (Statement)it.next();
            if (stmt == null || (rs = (ExtendedResultSet)theMap.get(stmt)) == null || !rs.isClosed()) continue;
            return stmt;
        }
        return null;
    }
}

