/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Case;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.Key;
import miningmart.compiler.M4Object;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.OpParam;
import miningmart.compiler.Parameter;
import miningmart.compiler.Relation;
import miningmart.compiler.Step;
import miningmart.compiler.Value;
import miningmart.compiler.ValueCount;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.exception.M4CompilerThreadKilledException;
import miningmart.compiler.exception.ParameterError;
import miningmart.compiler.exception.ParameterNotFoundException;
import miningmart.compiler.operator.Operator;
import miningmart.compiler.utils.DbCore;
import miningmart.compilerInterface.CompilerAccessLogic;

public class DB {
    private final DbCore dbc;
    private static final String c_yes = "YES";
    private static final String c_no = "NO";
    private static final String c_output = "OUT";
    private static final String c_db = "DB";
    public static String C_VAL = "V";
    public static String C_CONC = "CON";
    public static String C_REL = "REL";
    public static String C_BA = "BA";
    public static String C_MCF = "MCF";
    private boolean computeAllStat;
    private CompilerAccessLogic cal;
    private Hashtable loadedObjects = new Hashtable();
    private static Random dbSeed = new Random();

    public DB(String m4Url, String m4DbName, String m4User, String m4Passwd, String dataUrl, String dataDbName, String dataUser, String dataPasswd, boolean computeStatistics, CompilerAccessLogic cal) throws SQLException {
        this.computeAllStat = computeStatistics;
        this.cal = cal;
        this.dbc = new DbCore(m4Url, m4DbName, m4User, m4Passwd, dataUrl, dataDbName, dataUser, dataPasswd, cal);
    }

    public String getDataUrl() {
        return this.dbc.getDataUrl();
    }

    public String getDataUser() {
        return this.dbc.getDataUser();
    }

    public String getDataPw() {
        return this.dbc.getDataPw();
    }

    public void getFreshM4Connection() throws SQLException {
        this.dbc.getFreshM4Connection();
    }

    public M4Object m4loaded(long Id) {
        return (M4Object)this.loadedObjects.get(new Long(Id));
    }

    public void commitM4Transactions() throws SQLException {
        this.dbc.commitM4Transactions();
    }

    public void commitBusinessTransactions() throws SQLException {
        this.dbc.commitBusinessTransactions();
    }

    public void rollbackOnM4() throws SQLException {
        this.dbc.rollbackOnM4();
    }

    public Connection getDatabaseConnectionForData() throws M4CompilerError {
        try {
            return this.dbc.getExternalDatabaseConnectionForData();
        }
        catch (SQLException e) {
            throw new M4CompilerError("DB.getDatabaseConnectionForData(): Could not create new Connection for external usage:\n" + e.getMessage());
        }
    }

    public void setComputeStatistics(boolean computeStatistics) {
        this.computeAllStat = computeStatistics;
    }

    public boolean getComputeStatistics() {
        return this.computeAllStat;
    }

    public M4Object m4cache(long Id, M4Object emptyObject) throws SQLException, M4CompilerError {
        if (Id == 0L) {
            return null;
        }
        M4Object tmp = (M4Object)this.loadedObjects.get(new Long(Id));
        if (tmp == null) {
            this.doPrint(8, "Loading object from database");
            return emptyObject.load(Id);
        }
        this.doPrint(8, "Returning already loaded Object");
        return tmp;
    }

    public void clearM4Cache() {
        if (this.loadedObjects == null) {
            return;
        }
        this.loadedObjects.clear();
    }

    public long readCaseIdForStepId(long stepId) throws SQLException, M4CompilerError {
        String query = "SELECT st_caid FROM step_t WHERE st_id = " + stepId;
        Long caseId = this.executeM4SingleValueSqlReadL(query);
        if (caseId == null) {
            throw new M4CompilerError("M4 Database: Case not found");
        }
        return caseId;
    }

    public Case readCaseForStepId(Case ca, long stepId) throws SQLException, M4CompilerError {
        long caseId = this.readCaseIdForStepId(stepId);
        try {
            ca = (Case)this.getCompilerAccessLogic().getM4db().m4cache(caseId, ca);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to readCaseForStepId for case with id " + caseId + ": DB error: " + sqle.getMessage());
        }
        return ca;
    }

    public void readCaseFromDb(Case ca) throws SQLException, M4CompilerError {
        String query = "SELECT ca_name FROM case_t WHERE ca_id = " + ca.getId();
        String caName = this.executeM4SingleValueSqlRead(query);
        if (caName == null) {
            throw new M4CompilerError("M4 Database: Case not found");
        }
        ca.setName(caName);
        query = "SELECT st_id FROM step_t WHERE st_caid = " + ca.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        while (rs.next()) {
            ca.addStepId(new Long(rs.getLong("ST_ID")));
        }
        rs.close();
        query = "SELECT sts_stid, sts_successorstid FROM stepsequence_t, step_t WHERE sts_stid = st_id AND st_caid = " + ca.getId();
        rs = this.executeM4SqlRead(query);
        while (rs.next()) {
            Long stId = new Long(rs.getLong("STS_STID"));
            Long succStId = new Long(rs.getLong("STS_SUCCESSORSTID"));
            if (rs.wasNull()) continue;
            ca.addStepDependency(stId, succStId);
        }
        rs.close();
        this.loadedObjects.put(new Long(ca.getId()), ca);
    }

    public void readStepFromDB(Step st) throws SQLException, M4CompilerError {
        Case caseObj;
        String query = "SELECT st_caid, st_nr, st_opid, st_loopnr, st_multistepcond, op_name  FROM step_t, operator_t WHERE st_opid = op_id AND st_id = " + st.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (rs.next()) {
            st.setNumber(rs.getLong("ST_NR"));
            st.setOperatorId(rs.getLong("ST_OPID"));
            st.setOperatorClass(rs.getString("OP_NAME"));
            st.setLoopCount(rs.getInt("ST_LOOPNR"));
            st.setMultiStepCondition(rs.getString("ST_MULTISTEPCOND"));
            long caseId = rs.getLong("ST_CAID");
            caseObj = (Case)this.m4cache(caseId, new Case(this));
            if (caseObj.getM4Db() == null) {
                throw new M4CompilerError("DB.readStepFromDB(" + st.getId() + "): Case not found in Cache while loading Step!");
            }
        } else {
            throw new M4CompilerError("M4 Database: Step not found");
        }
        st.setCase(caseObj);
        this.loadedObjects.put(new Long(st.getId()), st);
        rs.close();
    }

    public void readOperatorFromDB(Operator op) throws SQLException, M4CompilerError {
        String query = "SELECT op_name, op_manual, op_loop, op_multi, op_realize FROM operator_t WHERE op_id = " + op.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (!rs.next()) {
            rs.close();
            throw new M4CompilerError("M4 Database: Operator not found");
        }
        op.setName(rs.getString("OP_NAME"));
        op.setManual(c_yes.equals(rs.getString("OP_MANUAL")));
        op.setLoopable(c_yes.equals(rs.getString("OP_LOOP")));
        op.setStepable(c_yes.equals(rs.getString("OP_MULTI")));
        op.setRealize(rs.getString("OP_REALIZE"));
        this.loadedObjects.put(new Long(op.getId()), op);
        rs.close();
    }

    public void readParameterFromDB(Parameter par, String type) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        if (!(type.equals(C_BA) || type.equals(C_CONC) || type.equals(C_MCF) || type.equals(C_REL) || type.equals(C_VAL))) {
            throw new ParameterError("Unknown Parameter type specified to be read from DB: " + type);
        }
        String LoopCondition = par.getLoopNr() == 0 ? "(par_stloopnr IS NULL or par_stloopnr = 0)" : "par_stloopnr = " + par.getLoopNr();
        String query = "SELECT par_id, par_objid, par_objtype, par_type, par_stloopnr FROM parameter_t WHERE par_opid = " + par.getOperator().getId() + " AND " + this.attribPrefix("par_name", par.getParameterName()) + " = " + DB.quote(par.getParameterName()) + " AND par_stid = " + par.getStep().getId() + " AND par_objtype = " + DB.quote(type) + " AND " + LoopCondition;
        ResultSet rs = this.executeM4SqlRead(query);
        if (!rs.next()) {
            rs.close();
            throw new ParameterNotFoundException("M4 Database: Parameter " + par.getParameterName() + " for Operator " + par.getOperator().getId() + " not found");
        }
        par.setParameterId(rs.getLong("PAR_ID"));
        par.setParObjectId(rs.getLong("PAR_OBJID"));
        par.setParObjectType(rs.getString("PAR_OBJTYPE"));
        par.setIsInputParam(!c_output.equals(rs.getString("PAR_TYPE")));
        par.setLoopNr(rs.getInt("PAR_STLOOPNR"));
        this.loadedObjects.put(new Long(par.getId()), par);
        rs.close();
    }

    public Parameter[] readParameterListFromDB(Parameter par, String type) throws SQLException, ParameterError, M4CompilerThreadKilledException {
        if (!(type.equals(C_BA) || type.equals(C_CONC) || type.equals(C_MCF) || type.equals(C_REL) || type.equals(C_VAL))) {
            throw new ParameterError("Unknown Parameter type specified to be read from DB: " + type);
        }
        String LoopCondition = par.getLoopNr() == 0 ? "(par_stloopnr IS NULL or par_stloopnr = 0)" : "par_stloopnr = " + par.getLoopNr();
        Parameter newParam = null;
        Parameter[] paramList = null;
        String query = "SELECT par_id, par_objid, par_objtype, par_type, par_stloopnr FROM parameter_t WHERE par_opid = " + par.getOperator().getId() + " AND " + this.attribPrefix("par_name", par.getParameterName()) + " = " + DB.quote(par.getParameterName()) + " AND par_stid = " + par.getStep().getId() + " AND par_objtype = " + DB.quote(type) + " AND " + LoopCondition + " ORDER BY par_nr";
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<Parameter> theParams = new Vector<Parameter>();
        while (rs.next()) {
            newParam = par.createNewInstance();
            newParam.setParameterName(par.getParameterName());
            newParam.setOperator(par.getOperator());
            newParam.setStep(par.getStep());
            newParam.setLoopNr(par.getLoopNr());
            newParam.setParameterId(rs.getLong("PAR_ID"));
            newParam.setParObjectId(rs.getLong("PAR_OBJID"));
            newParam.setParObjectType(rs.getString("PAR_OBJTYPE"));
            newParam.setIsInputParam(!c_output.equals(rs.getString("PAR_TYPE")));
            newParam.setLoopNr(rs.getInt("PAR_STLOOPNR"));
            this.loadedObjects.put(new Long(newParam.getParameterId()), newParam);
            theParams.add(newParam);
        }
        rs.close();
        theParams.trimToSize();
        int paramCount = theParams.size();
        if (paramCount < 1) {
            throw new ParameterNotFoundException("No Parameters found for Operator Id " + par.getOperator().getId() + " and parameter name " + DB.quote(par.getParameterName()) + "!");
        }
        if (newParam instanceof Concept) {
            paramList = new Concept[paramCount];
            int i = 0;
            while (i < paramCount) {
                paramList[i] = (Concept)theParams.get(i);
                ++i;
            }
        } else if (newParam instanceof Relation) {
            paramList = new Relation[paramCount];
            int i = 0;
            while (i < paramCount) {
                paramList[i] = (Relation)theParams.get(i);
                ++i;
            }
        } else if (newParam instanceof BaseAttribute) {
            paramList = new BaseAttribute[paramCount];
            int i = 0;
            while (i < paramCount) {
                paramList[i] = (BaseAttribute)theParams.get(i);
                ++i;
            }
        } else if (newParam instanceof Value) {
            paramList = new Value[paramCount];
            int i = 0;
            while (i < paramCount) {
                paramList[i] = (Value)theParams.get(i);
                ++i;
            }
        } else if (newParam instanceof MultiColumnFeature) {
            paramList = new MultiColumnFeature[paramCount];
            int i = 0;
            while (i < paramCount) {
                paramList[i] = (MultiColumnFeature)theParams.get(i);
                ++i;
            }
        } else {
            throw new ParameterError("Unknown type of parameter: " + newParam.getClass());
        }
        return paramList;
    }

    public void readValueFromDB(Value val) throws SQLException, M4CompilerError {
        String theVal;
        String query = "SELECT v_value, v_condtid  FROM value_t  WHERE v_id = " + val.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (rs.next()) {
            val.setType(rs.getLong("V_CONDTID"));
            theVal = rs.getString("V_VALUE");
            if (val.getType() == 7L || val.getType() == 9L) {
                theVal = this.checkDouble(theVal);
            }
        } else {
            rs.close();
            throw new M4CompilerError("M4 Database: Value not found");
        }
        val.setValue(theVal);
        this.loadedObjects.put(new Long(val.getId()), val);
        rs.close();
    }

    public void readMCFFromDB(MultiColumnFeature mcf) throws SQLException, M4CompilerError {
        String query = "SELECT mcf_name, mcf_conid FROM mcfeature_t  WHERE mcf_id = " + mcf.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (!rs.next()) {
            rs.close();
            throw new M4CompilerError("M4 Database: Multi Column Feature not found");
        }
        mcf.setName(rs.getString("MCF_NAME"));
        long conceptId = rs.getLong("MCF_CONID");
        this.loadedObjects.put(new Long(mcf.getId()), mcf);
        mcf.setConcept((Concept)this.m4cache(conceptId, new Concept(this)));
        rs.close();
    }

    public void readBaseAttributeFromDB(BaseAttribute ba) throws SQLException, M4CompilerError {
        String query = "SELECT ba_name, ba_condtid, CONDT_NAME,        ba_relevance, ba_attribtype, ba_mcfid, ba_hide  FROM baseattrib_t, con_datatype_t  WHERE ba_condtid = condt_id and ba_id = " + ba.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (!rs.next()) {
            rs.close();
            throw new M4CompilerError("M4 Database: Base Attribute not found");
        }
        ba.setName(rs.getString("BA_NAME"));
        ba.setConceptualDataType(rs.getLong("BA_CONDTID"));
        ba.setConceptualDataTypeName(rs.getString("CONDT_NAME"));
        ba.setRelevant(c_yes.equals(rs.getString("BA_RELEVANCE")));
        ba.setDBAttrib(c_db.equals(rs.getString("BA_ATTRIBTYPE")));
        ba.setMCFeature((MultiColumnFeature)this.m4cache(rs.getLong("BA_MCFID"), new MultiColumnFeature(this)));
        ba.setHidden(c_yes.equals("BA_HIDE"));
        this.loadedObjects.put(new Long(ba.getId()), ba);
        rs.close();
    }

    public void readConceptFromDB(Concept conc) throws SQLException, M4CompilerError {
        String query = "SELECT con_name, con_type, con_subconrestr   FROM concept_t  WHERE con_id = " + conc.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (!rs.next()) {
            rs.close();
            throw new M4CompilerError("M4 Database: Concept not found");
        }
        conc.setName(rs.getString("CON_NAME"));
        conc.setType(rs.getString("CON_TYPE"));
        conc.setSubConceptRestriction(rs.getString("CON_SUBCONRESTR"));
        this.loadedObjects.put(new Long(conc.getId()), conc);
        rs.close();
    }

    public void readRelationFromDB(Relation rel) throws SQLException, M4CompilerError {
        String query = "SELECT rel_name, rel_fromconid, rel_toconid, rel_fromkid, rel_tokid, rel_subrelrestr, rel_csid FROM relation_t  WHERE rel_id = " + rel.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (rs.next()) {
            rel.setName(rs.getString("REL_NAME"));
            rel.setFromConcept((Concept)this.m4cache(rs.getLong("REL_FROMCONID"), new Concept(this)));
            rel.setFromKey((Key)this.m4cache(rs.getLong("REL_FROMKID"), new Key(this)));
            rel.setToConcept((Concept)this.m4cache(rs.getLong("REL_TOCONID"), new Concept(this)));
            long csId = rs.getLong("REL_CSID");
            if (!rs.wasNull()) {
                rel.setCrossLinkColumnSet((Columnset)this.m4cache(csId, new Columnset(this)));
            } else {
                rel.setCrossLinkColumnSet(null);
            }
            long toKeyId = rs.getLong("REL_TOKID");
            if (!rs.wasNull()) {
                rel.setToKey((Key)this.m4cache(toKeyId, new Key(this)));
            } else {
                rel.setToKey(null);
            }
        } else {
            rs.close();
            throw new M4CompilerError("M4 Database: Relation not found");
        }
        rel.setSubRelationRestriction(rs.getString("REL_SUBRELRESTR"));
        this.loadedObjects.put(new Long(rel.getId()), rel);
        rs.close();
    }

    public void readColumnsetFromDB(Columnset cs) throws SQLException, M4CompilerError {
        String query = "SELECT cs_name, cs_schema,        cs_type, cs_sql, cs_conid, cs_msbranch   FROM columnset_t  WHERE cs_id = " + cs.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (rs.next()) {
            cs.setName(rs.getString("CS_NAME"));
            cs.setSchema(rs.getString("CS_SCHEMA"));
            cs.setType(rs.getString("CS_TYPE"));
            cs.setSQLDefinition(rs.getString("CS_SQL"));
            cs.setMultiStepBranch(rs.getString("CS_MSBRANCH"));
            if (rs.wasNull() || cs.getSQLDefinition().equals("")) {
                cs.setSQLDefinition(cs.getName());
            }
        } else {
            rs.close();
            throw new M4CompilerError("M4 Database: Columnset not found");
        }
        cs.setConcept((Concept)this.m4cache(rs.getLong("CS_CONID"), new Concept(this)));
        this.loadedObjects.put(new Long(cs.getId()), cs);
        rs.close();
    }

    public Value[] getDistinctElements(Column col) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        try {
            String query = "SELECT distinct(" + col.getName() + ") " + "FROM " + col.getColumnSet().getName();
            ResultSet rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                Value v = new Value(this);
                v.setValue(rs.getString(col.getName()));
                theElements.add(v);
            }
            rs.close();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
        }
        theElements.trimToSize();
        Value[] distEl = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            distEl[i] = (Value)theElements.get(i);
            ++i;
        }
        return distEl;
    }

    public Value[] getDistinctElements(long columnId) throws M4CompilerError {
        try {
            return this.getDistinctElements((Column)this.m4cache(columnId, new Column(this)));
        }
        catch (SQLException e) {
            throw new M4CompilerError("Could not load Column object for ID " + columnId + "SQLException:\n" + e.getMessage());
        }
    }

    public Value[] getDistinctElementsWithoutNull(Column col) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        try {
            String query = "SELECT distinct(" + col.getName() + ") " + "FROM " + col.getColumnSet().getName();
            ResultSet rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                String s = rs.getString(col.getName());
                if (rs.wasNull()) continue;
                Value v = new Value(this);
                v.setValue(s);
                theElements.add(v);
            }
            rs.close();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
        }
        theElements.trimToSize();
        Value[] distEl = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            distEl[i] = (Value)theElements.get(i);
            ++i;
        }
        return distEl;
    }

    public void readColumnsetStatistFromDB(Columnset cs) throws SQLException, M4CompilerError {
        String query;
        ResultSet rs;
        if (this.computeAllStat) {
            this.updateColumnsetStatistics(cs);
        }
        if ((rs = this.executeM4SqlRead(query = "SELECT csst_all, csst_nom, csst_ord, csst_time FROM csstatist_t  WHERE csst_csid = " + cs.getId())).next()) {
            cs.setStatisticsAll(rs.getInt("CSST_ALL"));
            cs.setStatisticsNominal(rs.getInt("CSST_NOM"));
            cs.setStatisticsOrdinal(rs.getInt("CSST_ORD"));
            cs.setStatisticsTime(rs.getInt("CSST_TIME"));
            rs.close();
        } else {
            rs.close();
        }
    }

    public void readColumnStatistFromDB(Column col) throws SQLException, M4CompilerError {
        if (col.getBaseAttribute() != null && !col.areStatisticsUpToDate() && col.getId() != 0L) {
            long conceptualDataType = col.getBaseAttribute().getConceptualDataType();
            String query = "SELECT colst1_unique, colst1_missing, colst1_min, colst1_max,       colst1_avg, colst1_stddev, colst1_median, colst1_modal  FROM colstatist1_t  WHERE colst1_colid = " + col.getId();
            ResultSet rs = this.executeM4SqlRead(query);
            if (rs.next()) {
                col.setNumberOfUniqueValues(rs.getInt("COLST1_UNIQUE"));
                col.setNumberOfMissingValues(rs.getInt("COLST1_MISSING"));
                if (conceptualDataType == 7L || conceptualDataType == 9L) {
                    col.setMinValue(this.checkDouble(rs.getString("COLST1_MIN")));
                    col.setMaxValue(this.checkDouble(rs.getString("COLST1_MAX")));
                    col.setAverageValue(rs.getString("COLST1_AVG"));
                    col.setStandardDeviation(rs.getString("COLST1_STDDEV"));
                    col.setMedianValue(this.checkDouble(rs.getString("COLST1_MEDIAN")));
                    col.setModalValue(this.checkDouble(rs.getString("COLST1_MODAL")));
                } else {
                    col.setMinValue(rs.getString("COLST1_MIN"));
                    col.setMaxValue(rs.getString("COLST1_MAX"));
                    col.setAverageValue(rs.getString("COLST1_AVG"));
                    col.setStandardDeviation(rs.getString("COLST1_STDDEV"));
                    col.setMedianValue(rs.getString("COLST1_MEDIAN"));
                    col.setModalValue(rs.getString("COLST1_MODAL"));
                }
                rs.close();
                query = "SELECT COLST2_DISTVALUE, COLST2_DISTCOUNT,        COLST2_DISTMIN, COLST2_DISTMAX  FROM colstatist2_T WHERE colst2_colid = " + col.getId();
                rs = this.executeM4SqlRead(query);
                Vector<ValueCount> theValueCounts = new Vector<ValueCount>();
                while (rs.next()) {
                    ValueCount vc = new ValueCount();
                    vc.setCount(rs.getInt("COLST2_DISTCOUNT"));
                    vc.setValue(rs.getString("COLST2_DISTVALUE"));
                    vc.setMin(rs.getDouble("COLST2_DISTMIN"));
                    vc.setMax(rs.getDouble("COLST2_DISTMAX"));
                    theValueCounts.add(vc);
                }
                rs.close();
                theValueCounts.trimToSize();
                ValueCount[] theValueArray = new ValueCount[theValueCounts.size()];
                int i = 0;
                while (i < theValueCounts.size()) {
                    theValueArray[i] = (ValueCount)theValueCounts.get(i);
                    ++i;
                }
                col.setValueDistribution(theValueArray);
            } else {
                rs.close();
            }
        }
        col.declareStatisticsUpToDate();
    }

    public void readColumnsForColumnsetFromDB(Columnset cs) throws SQLException, M4CompilerError {
        String query = "SELECT col_id, col_name, col_coldtid, coldt_name, col_sql FROM column_t, col_datatype_t WHERE col_coldtid = coldt_id and col_csid = " + cs.getId();
        this.doPrint(2, "DB Query: " + query);
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<Column> theColumns = new Vector<Column>();
        while (rs.next()) {
            long colId = rs.getLong("COL_ID");
            Column theCol = (Column)this.loadedObjects.get(new Long(colId));
            if (theCol == null) {
                theCol = new Column(this);
                theCol.setId(colId);
                theCol.setName(rs.getString("COL_NAME"));
                theCol.setColumnSet(cs);
                theCol.setColumnDataType(rs.getLong("COL_COLDTID"));
                theCol.setColumnDataTypeName(rs.getString("COLDT_NAME"));
                theCol.setSQLDefinition(rs.getString("COL_SQL"));
                if (rs.wasNull() || theCol.getSQLDefinition().equals("")) {
                    theCol.setSQLDefinition(theCol.getName());
                }
            }
            this.readColumnStatistFromDB(theCol);
            this.loadedObjects.put(new Long(theCol.getId()), theCol);
            theColumns.add(theCol);
        }
        rs.close();
        theColumns.trimToSize();
        Column[] theColumnArray = new Column[theColumns.size()];
        int i = 0;
        while (i < theColumns.size()) {
            theColumnArray[i] = (Column)theColumns.get(i);
            ++i;
        }
        cs.setColumns(theColumnArray);
    }

    public void readColumnFromDB(Column col) throws SQLException, M4CompilerError {
        String query = "SELECT col_name, col_csid, col_coldtid, coldt_name, col_sql FROM column_t, col_datatype_t  WHERE col_coldtid = coldt_id and col_id = " + col.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (rs.next()) {
            col.setName(rs.getString("COL_NAME"));
            col.setColumnSet((Columnset)this.m4cache(rs.getLong("COL_CSID"), new Columnset(this)));
            col.setColumnDataType(rs.getLong("COL_COLDTID"));
            col.setColumnDataTypeName(rs.getString("COLDT_NAME"));
            col.setSQLDefinition(rs.getString("COL_SQL"));
            if (rs.wasNull() || col.getSQLDefinition().equals("")) {
                col.setSQLDefinition(col.getName());
            }
        } else {
            rs.close();
            throw new M4CompilerError("M4 Database: Column not found");
        }
        rs.close();
        this.readColumnStatistFromDB(col);
        this.loadedObjects.put(new Long(col.getId()), col);
    }

    public void readColumnsForBA(BaseAttribute ba) throws SQLException, M4CompilerError {
        String query = "SELECT col_id, col_name, col_csid, col_coldtid, coldt_name, col_sql FROM column_t, col_datatype_t, ba_column_t WHERE col_coldtid = coldt_id and col_id = bac_colid and bac_baid = " + ba.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<Column> theColumns = new Vector<Column>();
        while (rs.next()) {
            long colId = rs.getLong("COL_ID");
            Column theCol = (Column)this.loadedObjects.get(new Long(colId));
            if (theCol == null) {
                theCol = new Column(this);
                theCol.setId(colId);
                theCol.setName(rs.getString("COL_NAME"));
                theCol.setColumnSet((Columnset)this.m4cache(rs.getLong("COL_CSID"), new Columnset(this)));
                theCol.setColumnDataType(rs.getLong("COL_COLDTID"));
                theCol.setColumnDataTypeName(rs.getString("COLDT_NAME"));
                theCol.setSQLDefinition(rs.getString("COL_SQL"));
                if (rs.wasNull() || theCol.getSQLDefinition().equals("")) {
                    theCol.setSQLDefinition(theCol.getName());
                }
            }
            theCol.setBaseAttribute(ba);
            this.readColumnStatistFromDB(theCol);
            this.loadedObjects.put(new Long(theCol.getId()), theCol);
            theColumns.add(theCol);
        }
        rs.close();
        theColumns.trimToSize();
        Column[] theColumnArray = new Column[theColumns.size()];
        int i = 0;
        while (i < theColumns.size()) {
            theColumnArray[i] = (Column)theColumns.get(i);
            ++i;
        }
        ba.setColumns(theColumnArray);
    }

    public void readConceptForBA(BaseAttribute ba) throws SQLException, M4CompilerError {
        String query = "SELECT con_id, con_name, con_type, con_subconrestr   FROM concept_t, ba_concept_t  WHERE con_id = bc_conid and bc_baid = " + ba.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        Concept conc = null;
        if (rs.next()) {
            long conId = rs.getLong("CON_ID");
            conc = (Concept)this.loadedObjects.get(new Long(conId));
            if (conc == null) {
                conc = new Concept(this);
                conc.setId(conId);
                conc.setName(rs.getString("CON_NAME"));
                conc.setType(rs.getString("CON_TYPE"));
                conc.setSubConceptRestriction(rs.getString("CON_SUBCONRESTR"));
            }
            this.loadedObjects.put(new Long(conc.getId()), conc);
        }
        rs.close();
        ba.setConcept(conc);
    }

    public void readBaseAttributeForColumnFromDB(Column col) throws SQLException, M4CompilerError {
        String query = "SELECT ba_id, ba_name, ba_condtid, CONDT_NAME, ba_relevance, ba_attribtype, ba_mcfid, ba_hide FROM baseattrib_t, con_datatype_t, ba_column_t WHERE ba_condtid = condt_id and ba_id = bac_baid and bac_colid = " + col.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<BaseAttribute> theBAs = new Vector<BaseAttribute>();
        while (rs.next()) {
            long baId = rs.getLong("BA_ID");
            BaseAttribute ba = (BaseAttribute)this.loadedObjects.get(new Long(baId));
            if (ba == null) {
                ba = new BaseAttribute(this);
                ba.setId(baId);
                ba.setName(rs.getString("BA_NAME"));
                ba.setConceptualDataType(rs.getLong("BA_CONDTID"));
                ba.setConceptualDataTypeName(rs.getString("CONDT_NAME"));
                ba.setRelevant(c_yes.equals(rs.getString("BA_RELEVANCE")));
                ba.setDBAttrib(c_db.equals(rs.getString("BA_ATTRIBTYPE")));
                ba.setMCFeature((MultiColumnFeature)this.m4cache(rs.getLong("BA_MCFID"), new MultiColumnFeature(this)));
                ba.setHidden(c_yes.equals("BA_HIDE"));
                this.loadedObjects.put(new Long(ba.getId()), ba);
            }
            theBAs.add(ba);
        }
        rs.close();
        theBAs.trimToSize();
        if (theBAs.size() > 1) {
            this.doPrint(20, "Warning: found more than one BaseAttribute for Column with col_id = " + col.getId() + "!");
        }
        if (theBAs.size() > 0) {
            col.setBaseAttribute((BaseAttribute)theBAs.get(0));
        }
    }

    public void readKeyFromDB(Key theKey) throws SQLException, M4CompilerError {
        String query = "SELECT kh_id, kh_name, kh_pkcsid, kh_fkcsid FROM keyhead_T WHERE kh_id = " + theKey.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        if (!rs.next()) {
            throw new M4CompilerError("M4 Database: Key not found (ID: " + theKey.getId() + ")!");
        }
        theKey.setName(rs.getString("KH_NAME"));
        theKey.setForeignKeyColumnSet((Columnset)this.m4cache(rs.getLong("KH_FKCSID"), new Columnset(this)));
        theKey.setPrimaryKeyColumnSet((Columnset)this.m4cache(rs.getLong("KH_PKCSID"), new Columnset(this)));
        rs.close();
        query = "SELECT km_pkcolid, km_fkcolid FROM keymember_T WHERE km_khid = " + theKey.getId();
        rs = this.executeM4SqlRead(query);
        if (rs.next()) {
            theKey.setForeignKeyColumn((Column)this.m4cache(rs.getLong("KM_FKCOLID"), new Column(this)));
            theKey.setPrimaryKeyColumn((Column)this.m4cache(rs.getLong("KM_PKCOLID"), new Column(this)));
        }
        this.loadedObjects.put(new Long(theKey.getId()), theKey);
        rs.close();
    }

    public void readBaseAttributesForMCFFromDB(MultiColumnFeature mcf) throws SQLException, M4CompilerError {
        String query = "SELECT ba_id, ba_name, ba_condtid, CONDT_NAME, ba_relevance, ba_attribtype, ba_hide FROM baseattrib_t, con_datatype_t   WHERE ba_condtid = condt_id and ba_mcfid = " + mcf.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<BaseAttribute> theBAs = new Vector<BaseAttribute>();
        while (rs.next()) {
            long baId = rs.getLong("BA_ID");
            BaseAttribute ba = (BaseAttribute)this.loadedObjects.get(new Long(baId));
            if (ba == null) {
                ba = new BaseAttribute(this);
                ba.setId(baId);
                ba.setName(rs.getString("BA_NAME"));
                ba.setConceptualDataType(rs.getLong("BA_CONDTID"));
                ba.setConceptualDataTypeName(rs.getString("CONDT_NAME"));
                ba.setRelevant(c_yes.equals(rs.getString("BA_RELEVANCE")));
                ba.setDBAttrib(c_db.equals(rs.getString("BA_ATTRIBTYPE")));
                ba.setMCFeature(mcf);
                ba.setHidden(c_yes.equals("BA_HIDE"));
                this.loadedObjects.put(new Long(ba.getId()), ba);
            }
            theBAs.add(ba);
        }
        rs.close();
        theBAs.trimToSize();
        if (theBAs.size() < 2) {
            throw new M4CompilerError("Found MultiColumnFeature (Id: " + mcf.getId() + ") with less than 2 BaseAttributes!");
        }
        BaseAttribute[] theBA_Array = new BaseAttribute[theBAs.size()];
        int i = 0;
        while (i < theBAs.size()) {
            theBA_Array[i] = (BaseAttribute)theBAs.get(i);
            ++i;
        }
        mcf.setBaseAttributes(theBA_Array);
    }

    public void readColumnSetsForConceptFromDB(Concept conc) throws SQLException, M4CompilerError {
        String query = "SELECT cs_id, cs_name, cs_schema,        cs_type, cs_sql, cs_msbranch  FROM columnset_t WHERE cs_conid = " + conc.getId() + " ORDER BY cs_id";
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<Columnset> theColumnSets = new Vector<Columnset>();
        while (rs.next()) {
            long csId = rs.getLong("CS_ID");
            Columnset cs = (Columnset)this.loadedObjects.get(new Long(csId));
            if (cs == null) {
                cs = new Columnset(this);
                cs.setId(csId);
                cs.setName(rs.getString("CS_NAME"));
                cs.setSchema(rs.getString("CS_SCHEMA"));
                cs.setType(rs.getString("CS_TYPE"));
                cs.setSQLDefinition(rs.getString("CS_SQL"));
                cs.setMultiStepBranch(rs.getString("CS_MSBRANCH"));
                cs.setConcept(conc);
                this.loadedObjects.put(new Long(cs.getId()), cs);
            }
            theColumnSets.add(cs);
        }
        rs.close();
        theColumnSets.trimToSize();
        Columnset[] theCS_Array = new Columnset[theColumnSets.size()];
        int i = 0;
        while (i < theColumnSets.size()) {
            theCS_Array[i] = (Columnset)theColumnSets.get(i);
            ++i;
        }
        conc.setColumnSets(theCS_Array);
    }

    public void readFeaturesForConcept(Concept conc) throws SQLException, M4CompilerError {
        Feature f;
        String query = "SELECT bc_baid FROM ba_concept_t WHERE bc_conid = " + conc.getId();
        String secondQuery = "SELECT mcf_id FROM mcfeature_t WHERE mcf_conid = " + conc.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<BaseAttribute> theFeatures = new Vector<BaseAttribute>();
        while (rs.next()) {
            long baId = rs.getLong("BC_BAID");
            BaseAttribute ba = f = (BaseAttribute)this.m4cache(baId, new BaseAttribute(this));
            ba.setConcept(conc);
            theFeatures.add((BaseAttribute)f);
        }
        rs.close();
        rs = this.executeM4SqlRead(secondQuery);
        while (rs.next()) {
            long id = rs.getLong("MCF_ID");
            f = (MultiColumnFeature)this.m4cache(id, new MultiColumnFeature(this));
            MultiColumnFeature mcf = (MultiColumnFeature)f;
            mcf.setConcept(conc);
            theFeatures.add((BaseAttribute)f);
        }
        rs.close();
        theFeatures.trimToSize();
        if (theFeatures.size() < 1) {
            throw new M4CompilerError("Found Concept (Id: " + conc.getId() + ") without Features!");
        }
        Feature[] theFeatureArray = new Feature[theFeatures.size()];
        int i = 0;
        while (i < theFeatures.size()) {
            theFeatureArray[i] = (Feature)theFeatures.get(i);
            ++i;
        }
        conc.setFeatures(theFeatureArray);
    }

    public Vector readOpParamsForOp(Operator op) throws SQLException, M4CompilerError {
        String query = "SELECT param_id, name, minarg, maxarg, io, type FROM op_params_t WHERE op_id = " + op.getId();
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<OpParam> results = new Vector<OpParam>();
        while (rs.next()) {
            OpParam par = new OpParam(this);
            par.setId(rs.getLong("PARAM_ID"));
            par.setParamName(rs.getString("NAME"));
            par.setMinArg(rs.getInt("MINARG"));
            par.setMaxArg(rs.getInt("MAXARG"));
            if (rs.wasNull()) {
                par.setMaxArg(-1);
            }
            par.setInput(rs.getString("IO"));
            par.setType(rs.getString("TYPE"));
            results.add(par);
        }
        rs.close();
        return results;
    }

    public long testSQLColumn(Column col) throws SQLException, M4CompilerError {
        String query = "SELECT " + col.getSQLDefinition() + " FROM " + col.getColumnSet().getSchema() + "." + col.getColumnSet().getName() + " WHERE rownum < 1";
        ResultSet rs = this.executeBusinessSqlRead(query);
        ResultSetMetaData md = rs.getMetaData();
        String dataType = md.getColumnTypeName(1);
        rs.close();
        if (dataType != null) {
            if (dataType.startsWith("NUMBER")) {
                return 12L;
            }
            if (dataType.startsWith("VARCHAR")) {
                return 13L;
            }
            if (dataType.startsWith("DATE")) {
                return 14L;
            }
            if (dataType.startsWith("CHAR")) {
                return 13L;
            }
        }
        throw new M4CompilerError("SQL-Datatype returned for column not known: Got " + dataType + " but expected NUMBER or VARCHAR or DATE or CHAR");
    }

    public void updateColumnStatistics(Column col, long conceptualDataType) throws SQLException, M4CompilerError {
        if (!this.computeAllStat) {
            return;
        }
        this.executeM4SqlWrite("DELETE FROM COLSTATIST1_T WHERE COLST1_COLID = " + col.getId());
        this.executeM4SqlWrite("DELETE FROM COLSTATIST2_T WHERE COLST2_COLID = " + col.getId());
        String query = "begin updatecolumnstatistics(" + DB.quote(col.getColumnSet().getSchemaPlusName()) + ", " + col.getId() + ", " + DB.quote(col.getName()) + ", " + col.getColumnDataType() + ", " + conceptualDataType + ", " + DB.quote(col.getSQLDefinition()) + ", " + col.getColumnSet().getStatisticsAll() + "); end; ";
        this.executeBusinessSqlWrite(query);
        query = "SELECT COLST1_UNIQUE, COLST1_MISSING, COLST1_MIN, COLST1_MAX, COLST1_AVG, COLST1_STDDEV, COLST1_VARIANCE, COLST1_MEDIAN, COLST1_MODAL FROM COLSTATIST1_T WHERE COLST1_COLID = " + col.getId();
        ResultSet rs = this.executeBusinessSqlRead(query);
        while (rs.next()) {
            query = String.valueOf(DB.nullToNULL(rs.getString(1))) + ", " + DB.nullToNULL(rs.getString(2)) + ", " + DB.nullToNULLquote(rs.getString(3)) + ", " + DB.nullToNULLquote(rs.getString(4)) + ", " + DB.nullToNULL(rs.getString(5)) + ", " + DB.nullToNULL(rs.getString(6)) + ", " + DB.nullToNULL(rs.getString(7)) + ", " + DB.nullToNULLquote(rs.getString(8)) + ", " + DB.nullToNULLquote(rs.getString(9));
            query = "INSERT INTO COLSTATIST1_T (COLST1_ID, COLST1_COLID, COLST1_UNIQUE, COLST1_MISSING, COLST1_MIN, COLST1_MAX, COLST1_AVG, COLST1_STDDEV, COLST1_VARIANCE, COLST1_MEDIAN, COLST1_MODAL) VALUES (ALL_SQ.NEXTVAL, " + col.getId() + ", " + query + ")";
            this.executeM4SqlWrite(query);
        }
        rs.close();
        this.executeBusinessSqlWrite("DELETE FROM COLSTATIST1_T WHERE COLST1_COLID = " + col.getId());
        query = "SELECT COLST2_DISTVALUE, COLST2_DISTCOUNT, COLST2_DISTMIN, COLST2_DISTMAX FROM COLSTATIST2_T WHERE COLST2_COLID = " + col.getId();
        rs = this.executeBusinessSqlRead(query);
        while (rs.next()) {
            query = String.valueOf(DB.nullToNULLquote(rs.getString(1))) + ", " + DB.nullToNULL(rs.getString(2)) + ", " + DB.nullToNULL(rs.getString(3)) + ", " + DB.nullToNULL(rs.getString(4));
            query = "INSERT INTO COLSTATIST2_T (COLST2_ID, COLST2_COLID, COLST2_DISTVALUE , COLST2_DISTCOUNT, COLST2_DISTMIN, COLST2_DISTMAX) VALUES (ALL_SQ.NEXTVAL, " + col.getId() + ", " + query + ")";
            this.executeM4SqlWrite(query);
        }
        rs.close();
        this.executeBusinessSqlWrite("DELETE FROM COLSTATIST2_T WHERE COLST2_COLID = " + col.getId());
        this.commitM4Transactions();
        this.executeBusinessSqlWrite("commit");
        col.declareStatisticsOutOfDate();
        col.readStatisticsFromDB();
    }

    private static String nullToNULL(String s) {
        return s == null ? "NULL" : s;
    }

    private static String nullToNULLquote(String s) {
        return s == null ? "NULL" : "'" + s.trim() + "'";
    }

    public void updateColumnsetStatistics(Columnset cs) throws SQLException, M4CompilerError {
        if (!this.computeAllStat) {
            return;
        }
        this.executeM4SqlWrite("DELETE FROM CSSTATIST_T WHERE csst_csid = " + cs.getId());
        String csstAll = this.executeBusinessSingleValueSqlRead("SELECT COUNT(*) FROM " + cs.getName());
        String pre = "SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = ";
        String post = " AND col_csid = " + cs.getId();
        String csstOrd = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 12" + post);
        String csstNom = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 13" + post);
        String csstTime = this.executeM4SingleValueSqlRead("SELECT COUNT(*) FROM COLUMN_T WHERE col_coldtid = 14" + post);
        if (csstAll == null || csstOrd == null || csstNom == null || csstTime == null) {
            throw new M4CompilerError("DB.updateColumnsetStatistics for ColumnSet with ID " + cs.getId() + ":\nReceived a null value from query.");
        }
        this.executeM4SqlWrite("INSERT INTO CSSTATIST_T VALUES (ALL_SQ.NEXTVAL, " + cs.getId() + ", " + csstAll + ", " + csstOrd + ", " + csstNom + ", " + csstTime + ")");
        try {
            cs.setStatisticsAll(csstAll == null ? 0 : Integer.parseInt(csstAll));
            cs.setStatisticsOrdinal(csstOrd == null ? 0 : Integer.parseInt(csstOrd));
            cs.setStatisticsNominal(csstNom == null ? 0 : Integer.parseInt(csstNom));
            cs.setStatisticsTime(csstTime == null ? 0 : Integer.parseInt(csstTime));
        }
        catch (NumberFormatException e) {
            throw new M4CompilerError("DB.updateColumnsetStatistics for ColumnSet with ID " + cs.getId() + ":\nStatistic calculation yielded a String not parseable to Integer.");
        }
        Column[] colArray = cs.getColumns();
        int i = 0;
        while (i < colArray.length) {
            Column column = colArray[i];
            long conceptualDT = column.getBaseAttribute().getConceptualDataType();
            this.updateColumnStatistics(column, conceptualDT);
            ++i;
        }
        this.commitM4Transactions();
    }

    public void writeNewColumnsetToM4(Columnset cs, long stepId) throws SQLException, M4CompilerError {
        if (cs.getId() != 0L) {
            throw new M4CompilerError("Tried to write a columnset with Id not zero to M4! Id: " + cs.getId());
        }
        cs.setId(this.getNextM4SequenceValue());
        String query = "INSERT INTO COLUMNSET_T (cs_id, cs_schema, cs_name, cs_type, cs_sql, cs_conid, cs_msbranch)   VALUES ( " + cs.getId() + ", " + DB.quote(cs.getSchema()) + ", " + DB.quote(cs.getName()) + ", " + DB.quote(cs.getType()) + ", " + DB.quote(cs.getSQLDefinition()) + ", " + cs.getConcept().getId() + ", " + DB.quote(cs.getMultiStepBranch()) + ")";
        this.executeM4SqlWrite(query);
        this.loadedObjects.put(new Long(cs.getId()), cs);
        this.addColumnSetToTrash(cs, stepId);
        this.doPrint(10, "Nr of Columns: " + cs.getColumns().length);
        int i = 0;
        while (i < cs.getColumns().length) {
            cs.getColumn(i).setId(0L);
            this.writeNewColumnToM4(cs.getColumn(i), stepId);
            ++i;
        }
        query = "UPDATE CONCEPT_T SET con_valid = 'YES' WHERE con_id = " + cs.getConcept().getId();
        this.executeM4SqlWrite(query);
    }

    public void writeNewColumnToM4(Column col, long stepId) throws SQLException, M4CompilerError {
        if (col.getId() != 0L) {
            throw new M4CompilerError("Tried to enter a column with Id not zero to M4! Id: " + col.getId());
        }
        col.setId(this.getNextM4SequenceValue());
        String query = "INSERT INTO COLUMN_T (COL_ID, COL_NAME, COL_CSID, COL_COLDTID, COL_SQL) VALUES (" + col.getId() + ", " + DB.quote(col.getName()) + ", " + col.getColumnSet().getId() + ", " + col.getColumnDataType() + ", " + DB.quote(col.getSQLDefinition()) + " )";
        this.executeM4SqlWrite(query);
        BaseAttribute theBA = col.getBaseAttribute();
        if (theBA != null) {
            if (theBA.getId() == 0L) {
                throw new M4CompilerError("Found BaseAttribute with Id 0! Name: " + theBA.getName());
            }
            query = "INSERT INTO ba_column_t (BAC_ID, BAC_COLID, BAC_BAID) VALUES (" + this.getNextM4SequenceValue() + ", " + col.getId() + ", " + theBA.getId() + ")";
            this.executeM4SqlWrite(query);
            query = "UPDATE BASEATTRIB_T SET ba_valid = 'YES' WHERE ba_id = " + theBA.getId();
            this.executeM4SqlWrite(query);
        }
        this.loadedObjects.put(new Long(col.getId()), col);
        this.addColumnToTrash(col, stepId);
        this.updateColumnStatistics(col, theBA.getConceptualDataType());
    }

    public boolean isSuccessorOf(long StepId_1, long StepId_2) throws SQLException, M4CompilerError {
        long successor = 0L;
        String query = "SELECT st_id FROM step_t WHERE st_nr >= (SELECT st_nr FROM step_t WHERE st_id = " + StepId_2 + ")" + " AND st_chid = (SELECT st_chid FROM step_t WHERE st_id = " + StepId_2 + ")" + " AND st_caid = (SELECT st_caid FROM step_t WHERE st_id = " + StepId_2 + ")";
        ResultSet rs = this.executeM4SqlRead(query);
        while (rs.next()) {
            successor = rs.getLong("ST_ID");
            if (successor != StepId_1) continue;
            rs.close();
            return true;
        }
        rs.close();
        return false;
    }

    public Collection getStepsPredecessors(long stepId) throws M4CompilerError {
        try {
            String query = "SELECT sts_stid FROM stepsequence_t WHERE sts_successorstid = " + stepId;
            ResultSet rs = this.executeM4SqlRead(query);
            Vector<Long> v = new Vector<Long>();
            while (rs.next()) {
                v.add(new Long(rs.getLong("STS_STID")));
            }
            rs.close();
            return v;
        }
        catch (SQLException e) {
            throw new M4CompilerError("An SQLException occured when trying to read the predecessors of step " + stepId + " from table STEPSEQUENCE_T:\n" + e.getMessage());
        }
    }

    public long[] getInputConceptIDsForStep(long stepID) throws SQLException, M4CompilerThreadKilledException {
        String query = "SELECT PAR_OBJID FROM PARAMETER_T WHERE ((PAR_STID = " + stepID + ") AND (PAR_OBJTYPE = 'CON') AND (PAR_TYPE = 'IN'))";
        ResultSet rs = this.executeM4SqlRead(query);
        Vector<Long> ids = new Vector<Long>();
        while (rs.next()) {
            ids.add(new Long(rs.getLong("PAR_OBJID")));
        }
        rs.close();
        long[] result = new long[ids.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Long)ids.get(i);
            ++i;
        }
        return result;
    }

    public Long getOutputConceptIdForStep(long stepID) throws SQLException, M4CompilerThreadKilledException {
        String query = "SELECT PAR_OBJID FROM PARAMETER_T WHERE ((PAR_STID = " + stepID + ") AND (PAR_OBJTYPE = 'CON') AND (PAR_TYPE = 'OUT'))";
        Long conIdL = this.executeM4SingleValueSqlReadL(query);
        return conIdL;
    }

    public long loadOutputBAforConcept(long conceptId, long stepId) throws M4CompilerError {
        try {
            String query = "SELECT PAR_OBJID, PAR_STID FROM PARAMETER_T, BA_CONCEPT_T WHERE (PAR_OBJTYPE = 'BA') AND (PAR_TYPE = 'OUT') AND (PAR_OBJID = BC_BAID) AND (BC_CONID = " + conceptId + ")";
            ResultSet rs = this.executeM4SqlRead(query);
            long id = 0L;
            while (rs.next()) {
                id = rs.getLong("PAR_OBJID");
                long par_stepid = rs.getLong("PAR_STID");
                if (par_stepid != stepId && !this.isSuccessorOf(par_stepid, stepId)) continue;
                return id;
            }
            rs.close();
            return id;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error with DB access when trying to find an output BaseAttribte for concept with Id " + conceptId + ": " + sqle.getMessage());
        }
    }

    public Long getStepWhereBAisOutput(BaseAttribute ba, Step currentStep) throws M4CompilerError {
        try {
            String query = "SELECT PAR_STID FROM PARAMETER_T, STEP_T WHERE (PAR_OBJTYPE = 'BA') AND (PAR_TYPE = 'OUT') AND (PAR_OBJID = " + ba.getId() + ") AND (PAR_STID = ST_ID) AND (ST_CAID = " + currentStep.getCaseId() + ")";
            Long stepId = this.executeM4SingleValueSqlReadL(query);
            return stepId;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error with DB access when trying to find an output BaseAttribte related to step with Id " + currentStep.getId() + ": " + sqle.getMessage());
        }
    }

    public Long getStepWhereConceptisOutput(Concept concept, Step currentStep) throws M4CompilerError {
        try {
            String query = "SELECT PAR_STID FROM PARAMETER_T, STEP_T WHERE (PAR_OBJTYPE = 'CON') AND (PAR_TYPE = 'OUT') AND (PAR_OBJID = " + concept.getId() + ") AND (PAR_STID = ST_ID) AND (ST_CAID = " + currentStep.getCaseId() + ")";
            Long stepId = this.executeM4SingleValueSqlReadL(query);
            return stepId;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error with DB access when trying to find an output Concept related to step with Id " + currentStep.getId() + ": " + sqle.getMessage());
        }
    }

    public void executeDBProcedure(String procedureName, String[] parameters, boolean businessDb) throws SQLException, M4CompilerError {
        this.dbc.executeDBProcedure(procedureName, parameters, businessDb);
    }

    public String attribPrefix(String attributeName, String prefix) {
        String ret = "SUBSTR(" + attributeName + ", 1, " + prefix.length() + ")";
        return ret;
    }

    public static String quote(String sql) {
        if (sql == null) {
            return null;
        }
        String tmp1 = sql;
        String tmp2 = "'";
        int i = tmp1.indexOf("'");
        while (i >= 0) {
            tmp2 = String.valueOf(tmp2) + tmp1.substring(0, i + 1) + "'";
            tmp1 = tmp1.substring(i + 1);
            i = tmp1.indexOf("'");
        }
        return String.valueOf(tmp2) + tmp1 + "'";
    }

    public static int getRandomSeedNr() {
        return 1000000000 + dbSeed.nextInt(1147483647);
    }

    public String readOrComputeMinimum(Column c) throws M4CompilerError {
        String min = this.readColumnStatistField("colst1_min", 1, c.getId());
        if (min == null) {
            try {
                Columnset cs = c.getColumnSet();
                String query = "SELECT MIN(" + c.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
                min = this.executeBusinessSingleValueSqlRead(query);
                if (min == null) {
                    throw new M4CompilerError("Could not compute minimum for column '" + c.getName() + "', M4 id " + c.getId() + " in columnset '" + cs.getName() + "'!");
                }
                this.insertColumnStatistField("colst1_min", 1, c.getId(), min);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error when trying to compute minimum value for Column '" + c.getName() + "' with Id " + c.getId() + ": " + sqle.getMessage());
            }
        }
        return min;
    }

    public String readOrComputeCount(Columnset cs) throws M4CompilerError {
        String count = this.readColumnSetStatistField("csst_all", cs.getId());
        if (count == null) {
            try {
                String query = "SELECT COUNT(*) FROM " + cs.getSchemaPlusName();
                count = this.executeBusinessSingleValueSqlRead(query);
                if (count == null) {
                    throw new M4CompilerError("Could not compute count for columnset '" + cs.getName() + "'!");
                }
                this.insertColumnSetStatistField("csst_all", cs.getId(), count);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error when trying to compute number of rows for ColumnSet '" + cs.getName() + "' with Id " + cs.getId() + ": " + sqle.getMessage());
            }
        }
        return count;
    }

    public String computeNumberOfElementsForValue(Column col, String value) throws SQLException, M4CompilerThreadKilledException {
        Columnset cs = col.getColumnSet();
        String valueForQuery = col.getColumnDataType() == 13L ? DB.quote(value) : value;
        String query = "SELECT COUNT(*) FROM " + cs.getSchemaPlusName() + " WHERE " + col.getSQLDefinition() + " = " + valueForQuery;
        String sum = this.executeBusinessSingleValueSqlRead(query);
        return sum;
    }

    public Value[] getCountOfElements(Column colCA, Column colTA, long sampleSize) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        try {
            String query = "SELECT COUNT(*) FROM " + colTA.getColumnSet().getName();
            String x = this.executeBusinessSingleValueSqlRead(query);
            this.doPrint(12, "Sample " + sampleSize + " of " + x);
            double sampleRatio = (double)sampleSize / (double)Long.parseLong(x) * 100.0;
            if (sampleRatio > 100.0) {
                sampleRatio = 100.0;
            } else if (sampleRatio < 1.0E-6) {
                sampleRatio = 1.0E-6;
            }
            this.doPrint(12, "SampleRatio:" + sampleRatio + "%");
            query = "SELECT " + colTA.getName() + ", " + colCA.getName() + ", COUNT(" + colTA.getName() + ") AS ItemsCount " + " FROM " + colTA.getColumnSet().getName();
            if (sampleRatio < 100.0) {
                query = String.valueOf(query) + " SAMPLE BLOCK ( " + sampleRatio + ") ";
            }
            query = String.valueOf(query) + " GROUP BY " + colTA.getName() + ", " + colCA.getName() + " ORDER BY " + colTA.getName();
            this.doPrint(2, "DB Query: " + query);
            ResultSet rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                Value v = new Value(this);
                v.setValue(String.valueOf(rs.getString("ItemsCount")) + "," + rs.getString(colCA.getName()) + "," + rs.getString(colTA.getName()));
                theElements.add(v);
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to read distinct values in column " + colTA.getName() + "," + colCA.getName() + ": " + sqle.getMessage());
        }
        theElements.trimToSize();
        Value[] El = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (Value)theElements.get(i);
            ++i;
        }
        return El;
    }

    /*
     * Unable to fully structure code
     */
    public Value[][] getFrquencyTable(Column theClassAttribute, Feature[] theAttributes, Value[] classValues) throws M4CompilerError {
        block17: {
            CA = classValues;
            Attr = new ArrayList<String>();
            AVal = new ArrayList<long[]>();
            query = "SELECT * FROM ";
            t = "";
            i = 0;
            while (i < theAttributes.length) {
                t = i == 0 ? theAttributes[i].getName() : String.valueOf(t) + ", " + theAttributes[i].getName();
                s = "SELECT DISTINCT " + theAttributes[i].getName() + " FROM " + theClassAttribute.getColumnSet().getName() + " ORDER BY " + theAttributes[i].getName();
                if (i != 0) {
                    query = String.valueOf(query) + ", ";
                }
                query = String.valueOf(query) + "(" + s + ")";
                ++i;
            }
            query = String.valueOf(query) + " ORDER BY " + t;
            try {
                rs = this.executeBusinessSqlRead(query);
                while (rs.next()) {
                    s = rs.getString(theAttributes[0].getName());
                    i = 1;
                    while (i < theAttributes.length) {
                        s = String.valueOf(s) + ", " + rs.getString(theAttributes[i].getName());
                        ++i;
                    }
                    Attr.add(s);
                    AVal.add(new long[CA.length + 1]);
                }
                rs.close();
                Attr.add("Total");
                AVal.add(new long[CA.length + 1]);
                break block17;
            }
            catch (SQLException sqle) {
                s = "Error trying to read distinct values in columns " + theAttributes[0].getName();
                i = 1;
                ** while (i < theAttributes.length)
            }
lbl-1000:
            // 1 sources

            {
                s = String.valueOf(s) + ", " + theAttributes[i].getName();
                ++i;
                continue;
            }
lbl43:
            // 1 sources

            s = String.valueOf(s) + ": " + sqle.getMessage();
            throw new M4CompilerError(s);
        }
        try {
            i = 0;
            while (i < CA.length) {
                s = theAttributes[0].getName();
                n = 1;
                while (n < theAttributes.length) {
                    s = String.valueOf(s) + " || ', ' || " + theAttributes[n].getName();
                    ++n;
                }
                query = "SELECT (" + s + ") AS Label, Count(*) as Freq " + " FROM " + theClassAttribute.getColumnSet().getName() + " WHERE " + theClassAttribute.getName() + " = '" + CA[i].getValue() + "'" + " GROUP BY ";
                s = theAttributes[0].getName();
                n = 1;
                while (n < theAttributes.length) {
                    s = String.valueOf(s) + ", " + theAttributes[n].getName();
                    ++n;
                }
                query = String.valueOf(query) + s;
                rs = this.executeBusinessSqlRead(query);
                n = 0;
                while (rs.next()) {
                    s = rs.getString("Label");
                    while (!s.equals(Attr.get(n))) {
                        ++n;
                    }
                    ((long[])AVal.get((int)n))[i] = Long.parseLong(rs.getString("Freq"));
                }
                rs.close();
                ++i;
            }
        }
        catch (SQLException n) {
            // empty catch block
        }
        retVal = new Value[Attr.size()][CA.length + 2];
        sumCA = new long[CA.length + 1];
        i = 0;
        while (i < Attr.size() - 1) {
            retVal[i][0] = new Value(this);
            retVal[i][0].setValue((String)Attr.get(i));
            val = (long[])AVal.get(i);
            sum = 0L;
            n = 0;
            while (n < CA.length) {
                retVal[i][n + 1] = new Value(this);
                sum += val[n];
                retVal[i][n + 1].setValue(Long.toString(val[n]));
                sumCA[n] = sumCA[n] + val[n];
                ++n;
            }
            retVal[i][CA.length + 1] = new Value(this);
            retVal[i][CA.length + 1].setValue(Long.toString(sum));
            ++i;
        }
        i = Attr.size() - 1;
        retVal[i][0] = new Value(this);
        retVal[i][0].setValue((String)Attr.get(i));
        sum = 0L;
        n = 0;
        while (n < CA.length) {
            retVal[i][n + 1] = new Value(this);
            sum += sumCA[n];
            retVal[i][n + 1].setValue(Long.toString(sumCA[n]));
            ++n;
        }
        retVal[i][CA.length + 1] = new Value(this);
        retVal[i][CA.length + 1].setValue(Long.toString(sum));
        return retVal;
    }

    public Value[] getCountOfElements(Column col) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        try {
            String query = "SELECT " + col.getName() + ", COUNT(" + col.getName() + ") AS ItemsCount " + "FROM " + col.getColumnSet().getName() + "\tGROUP BY " + col.getName() + " ORDER BY " + col.getName();
            ResultSet rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                Value v = new Value(this);
                v.setValue(String.valueOf(rs.getString("ItemsCount")) + "," + rs.getString(col.getName()));
                theElements.add(v);
            }
            rs.close();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
        }
        theElements.trimToSize();
        Value[] El = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (Value)theElements.get(i);
            ++i;
        }
        return El;
    }

    public Value[] getCountOfElements(Column colCA, Column colTA) throws M4CompilerError {
        Vector<Value> theElements = new Vector<Value>();
        try {
            String query = "SELECT " + colTA.getName() + ", " + colCA.getName() + ", COUNT(" + colTA.getName() + ") AS ItemsCount " + "FROM " + colTA.getColumnSet().getName() + " GROUP BY " + colTA.getName() + ", " + colCA.getName() + " ORDER BY " + colTA.getName();
            this.doPrint(2, "DB Query: " + query);
            ResultSet rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                Value v = new Value(this);
                v.setValue(String.valueOf(rs.getString("ItemsCount")) + "," + rs.getString(colCA.getName()) + "," + rs.getString(colTA.getName()));
                theElements.add(v);
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to read distinct values in column " + colTA.getName() + "," + colCA.getName() + ": " + sqle.getMessage());
        }
        theElements.trimToSize();
        Value[] El = new Value[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (Value)theElements.get(i);
            ++i;
        }
        return El;
    }

    public String computeSum(Column col) throws SQLException, M4CompilerThreadKilledException {
        Columnset cs = col.getColumnSet();
        String query = "SELECT SUM(" + col.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
        String sum = this.executeBusinessSingleValueSqlRead(query);
        return sum;
    }

    public String computeNumberOfDistinctElements(Column col) throws SQLException, M4CompilerThreadKilledException {
        Columnset cs = col.getColumnSet();
        String query = "SELECT COUNT(DISTINCT(" + col.getSQLDefinition() + ")) FROM " + cs.getSchemaPlusName();
        String sum = this.executeBusinessSingleValueSqlRead(query);
        return sum;
    }

    public String readOrComputeMaximum(Column c) throws M4CompilerError {
        String max = this.readColumnStatistField("colst1_max", 1, c.getId());
        if (max == null) {
            try {
                Columnset cs = c.getColumnSet();
                String query = "SELECT MAX(" + c.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
                max = this.executeBusinessSingleValueSqlRead(query);
                if (max == null) {
                    throw new M4CompilerError("Could not compute maximum for column '" + c.getName() + "', M4 id " + c.getId() + " in columnset '" + cs.getName() + "'!");
                }
                this.insertColumnStatistField("colst1_max", 1, c.getId(), max);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error when trying to compute maximum value for Column '" + c.getName() + "' with Id " + c.getId() + ": " + sqle.getMessage());
            }
        }
        return max;
    }

    public String readOrComputeAverage(Column c) throws M4CompilerError {
        String avg = this.readColumnStatistField("colst1_avg", 1, c.getId());
        if (avg == null) {
            try {
                Columnset cs = c.getColumnSet();
                String query = "SELECT AVG(" + c.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
                avg = this.executeBusinessSingleValueSqlRead(query);
                if (avg == null) {
                    throw new M4CompilerError("Could not compute average for column '" + c.getName() + "', M4 id " + c.getId() + " in columnset '" + cs.getName() + "'!");
                }
                this.insertColumnStatistField("colst1_avg", 1, c.getId(), avg);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error when trying to compute average value for Column '" + c.getName() + "' with Id " + c.getId() + ": " + sqle.getMessage());
            }
        }
        return avg;
    }

    private void addColumnSetToTrash(Columnset cs, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO M4Trash_T (M4Id, M4Table, StepId) VALUES (" + cs.getId() + ", 'COLUMNSET_T', " + stepId + ")";
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with Columnset " + cs.getId() + ", for step " + stepId + ": " + sqle.getMessage());
        }
    }

    private void addColumnToTrash(Column col, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO M4Trash_T (M4Id, M4Table, StepId) VALUES (" + col.getId() + ", 'COLUMN_T', " + stepId + ")";
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with Column " + col.getId() + ", for step " + stepId + ": " + sqle.getMessage());
        }
    }

    private void addBAToTrash(BaseAttribute ba, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO M4Trash_T (M4Id, M4Table, StepId) VALUES (" + ba.getId() + ", 'BASEATTRIB_T', " + stepId + ")";
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with BaseAttribute " + ba.getId() + ", for step " + stepId + ": " + sqle.getMessage());
        }
    }

    public void addStepCompiledToTrash(long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO M4Trash_T (M4Id, M4Table, StepId) VALUES (0, ' ', " + stepId + ")";
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when marking step " + stepId + " as successfully compiled in the trashindex.\n:" + sqle.getMessage());
        }
    }

    public boolean isCompiledStep(long stepId) throws M4CompilerError {
        try {
            String query = "SELECT COUNT(*) FROM M4Trash_T WHERE (M4Id = 0) AND (M4Table = ' ') AND (StepId = " + stepId + ")";
            Long count = this.executeM4SingleValueSqlReadL(query);
            if (count == null) {
                throw new M4CompilerError("Error when trying to look for 'successfully compiled' flag of step " + stepId + "in the M4Trash table. The following query did not yield any result:\n" + query);
            }
            return count > 0L;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when trying to read marking step " + stepId + " as successfully compiled in the trashindex.\n" + sqle.getMessage());
        }
    }

    public void addTableToTrash(String tableName, String schemaName, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO DBTrash_T (ObjType, ObjName, SchemaName, StepId) VALUES ('T', " + DB.quote(tableName) + ", " + DB.quote(schemaName) + ", " + stepId + ")";
            if (schemaName == null || schemaName.equals("")) {
                query = "INSERT INTO DBTrash_T (ObjType, ObjName, StepId) VALUES ('T', " + DB.quote(tableName) + ", " + stepId + ")";
            }
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with new table '" + schemaName + "." + tableName + "', for step " + stepId + ": " + sqle.getMessage());
        }
    }

    public void addFunctionToTrash(String functionName, String schemaName, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO DBTrash_T (ObjType, ObjName, SchemaName, StepId) VALUES ('F', " + DB.quote(functionName) + ", " + DB.quote(schemaName) + ", " + stepId + ")";
            if (schemaName == null || schemaName.equals("")) {
                query = "INSERT INTO DBTrash_T (ObjType, ObjName, StepId) VALUES ('F', " + DB.quote(functionName) + ", " + stepId + ")";
            }
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with new function '" + schemaName + "." + functionName + "', for step " + stepId + ": " + sqle.getMessage());
        }
    }

    public void addIndexToTrash(String indexName, String schemaName, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO DBTrash_T (ObjType, ObjName, SchemaName, StepId) VALUES ('I', " + DB.quote(indexName) + ", " + DB.quote(schemaName) + ", " + stepId + ")";
            if (schemaName == null || schemaName.equals("")) {
                query = "INSERT INTO DBTrash_T (ObjType, ObjName, StepId) VALUES ('I', " + DB.quote(indexName) + ", " + stepId + ")";
            }
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with new index '" + schemaName + "." + indexName + "', for step " + stepId + ": " + sqle.getMessage());
        }
    }

    public void addViewToTrash(String viewName, String schemaName, long stepId) throws M4CompilerError {
        try {
            String query = "INSERT INTO DBTrash_T (ObjType, ObjName, SchemaName, StepId) VALUES ('V', " + DB.quote(viewName) + ", " + DB.quote(schemaName) + ", " + stepId + ")";
            if (schemaName == null || schemaName.equals("")) {
                query = "INSERT INTO DBTrash_T (ObjType, ObjName, StepId) VALUES ('V', " + DB.quote(viewName) + ", " + stepId + ")";
            }
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when updating the trashindex with new view '" + schemaName + "." + viewName + "', for step " + stepId + ": " + sqle.getMessage());
        }
    }

    public void deleteTrash(long stepId) throws M4CompilerError {
        try {
            long id;
            String query = "SELECT m4id, m4table FROM M4Trash_T WHERE stepId = " + stepId;
            ResultSet rs = this.executeM4SqlRead(query);
            Vector<Long> columnIds = new Vector<Long>();
            Vector<Long> columnSetIds = new Vector<Long>();
            Vector<Long> baIds = new Vector<Long>();
            while (rs.next()) {
                String table = rs.getString("M4Table");
                id = rs.getLong("M4Id");
                if (table.equalsIgnoreCase("column_t")) {
                    columnIds.add(new Long(id));
                    continue;
                }
                if (table.equalsIgnoreCase("columnset_t")) {
                    columnSetIds.add(new Long(id));
                    continue;
                }
                if (table.equalsIgnoreCase("baseattrib_t")) {
                    baIds.add(new Long(id));
                    continue;
                }
                if (table.equals(" ") && id == 0L) continue;
                throw new M4CompilerError("Error when deleting trash: Found unknown table name '" + table + "' in M4Trash_T!");
            }
            rs.close();
            if (baIds.size() > 0) {
                String bids = "";
                String bacids = "";
                String bcids = "";
                int i = 0;
                while (i < baIds.size()) {
                    id = (Long)baIds.get(i);
                    bids = String.valueOf(bids) + "ba_id = " + id + " OR ";
                    bcids = String.valueOf(bcids) + "bc_baid = " + id + " OR ";
                    bacids = String.valueOf(bacids) + "bac_baid = " + id + " OR ";
                    ++i;
                }
                bids = bids.substring(0, bids.length() - 4);
                bcids = bcids.substring(0, bcids.length() - 4);
                bacids = bacids.substring(0, bacids.length() - 4);
                query = "DELETE FROM BA_COLUMN_T WHERE " + bacids;
                this.executeM4SqlWrite(query);
                query = "DELETE FROM BA_CONCEPT_T WHERE " + bcids;
                this.executeM4SqlWrite(query);
                query = "DELETE FROM BASEATTRIB_T WHERE " + bids;
                this.executeM4SqlWrite(query);
            }
            if (columnIds.size() > 0) {
                String colids = "";
                String colst1ids = "";
                String colst2ids = "";
                String bacolids = "";
                int i = 0;
                while (i < columnIds.size()) {
                    id = (Long)columnIds.get(i);
                    colids = String.valueOf(colids) + "col_id = " + id + " OR ";
                    colst1ids = String.valueOf(colst1ids) + "colst1_colid = " + id + " OR ";
                    colst2ids = String.valueOf(colst2ids) + "colst2_colid = " + id + " OR ";
                    bacolids = String.valueOf(bacolids) + "bac_colid = " + id + " OR ";
                    ++i;
                }
                colids = colids.substring(0, colids.length() - 4);
                colst1ids = colst1ids.substring(0, colst1ids.length() - 4);
                colst2ids = colst2ids.substring(0, colst2ids.length() - 4);
                bacolids = bacolids.substring(0, bacolids.length() - 4);
                query = "DELETE FROM BA_COLUMN_T WHERE " + bacolids;
                this.executeM4SqlWrite(query);
                query = "DELETE FROM COLSTATIST1_T WHERE " + colst1ids;
                this.executeM4SqlWrite(query);
                query = "DELETE FROM COLSTATIST2_T WHERE " + colst2ids;
                this.executeM4SqlWrite(query);
                query = "DELETE FROM COLUMN_T WHERE " + colids;
                this.executeM4SqlWrite(query);
            }
            if (columnSetIds.size() > 0) {
                String csids = "";
                String cstatids = "";
                int i = 0;
                while (i < columnSetIds.size()) {
                    id = (Long)columnSetIds.get(i);
                    csids = String.valueOf(csids) + "cs_id = " + id + " OR ";
                    cstatids = String.valueOf(cstatids) + "csst_csid = " + id + " OR ";
                    ++i;
                }
                csids = csids.substring(0, csids.length() - 4);
                cstatids = cstatids.substring(0, cstatids.length() - 4);
                query = "DELETE FROM CSSTATIST_T WHERE " + cstatids;
                this.executeM4SqlWrite(query);
                query = "DELETE FROM COLUMNSET_T WHERE " + csids;
                this.executeM4SqlWrite(query);
            }
            query = "DELETE FROM M4TRASH_T WHERE stepId = " + stepId;
            this.executeM4SqlWrite(query);
            query = "SELECT ObjType, ObjName, SchemaName FROM DBTrash_T WHERE stepId = " + stepId;
            rs = this.executeM4SqlRead(query);
            while (rs.next()) {
                String obj = rs.getString("ObjName");
                String type = rs.getString("ObjType");
                String schema = rs.getString("SchemaName");
                if (rs.wasNull()) {
                    schema = null;
                }
                if (type.equalsIgnoreCase("T")) {
                    query = "DROP TABLE ";
                } else if (type.equalsIgnoreCase("V")) {
                    query = "DROP VIEW ";
                } else if (type.equalsIgnoreCase("F")) {
                    query = "DROP FUNCTION ";
                } else if (type.equalsIgnoreCase("I")) {
                    query = "DROP INDEX ";
                }
                if (schema != null) {
                    query = String.valueOf(query) + schema + ".";
                }
                query = String.valueOf(query) + obj;
                try {
                    this.executeBusinessSqlWrite(query);
                }
                catch (SQLException sqle) {
                    this.doPrint(20, "WARNING: Error when attempting to remove a database object according to DBTrash_T: " + sqle.getMessage());
                }
            }
            rs.close();
            query = "DELETE FROM DBTRASH_T WHERE stepId = " + stepId;
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
            this.commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error when deleting trash for step " + stepId + ": " + sqle.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void deleteCompleteTrash(long caseId) throws M4CompilerError {
        theCase = new Case(this);
        try {
            theCase = (Case)this.getCompilerAccessLogic().getM4db().m4cache(caseId, theCase);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Error trying to delete trash for case with id " + caseId + ": DB error: " + sqle.getMessage());
        }
        reverseStepOrder = theCase.getReverseIterator();
        if (reverseStepOrder.hasNext()) ** GOTO lbl12
        this.doPrint(18, "No entries found in the trash index for Case with Id " + theCase.getId() + ". Nothing deleted.");
        return;
lbl-1000:
        // 1 sources

        {
            this.deleteTrash((Long)reverseStepOrder.next());
lbl12:
            // 2 sources

            ** while (reverseStepOrder.hasNext())
        }
lbl13:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void deleteTrashFromStep(long startStepId) throws M4CompilerError {
        ca = this.getCompilerAccessLogic().getCase();
        if (ca == null) {
            ca = new Case(this);
            try {
                caseId = this.readCaseIdForStepId(startStepId);
                ca.load(caseId);
            }
            catch (Exception e) {
                throw new M4CompilerError(e.getClass() + " while loading case for stepId " + startStepId + "\nin method DB.deleteTrashFromStep(long stepId):\n" + e.getMessage());
            }
        }
        theCase = ca;
        dependentSteps = theCase.getDependentStepIdsFor(startStepId);
        rev = new LinkedList<E>();
        it = dependentSteps.iterator();
        while (it.hasNext()) {
            rev.addFirst(it.next());
        }
        reverseStepOrder = rev.iterator();
        if (reverseStepOrder.hasNext()) ** GOTO lbl24
        this.doPrint(18, "No entries found in the trash index for Case with Id " + theCase.getId() + ". Nothing deleted.");
        return;
lbl-1000:
        // 1 sources

        {
            nextStepIdToDelete = (Long)reverseStepOrder.next();
            this.deleteTrash(nextStepIdToDelete);
lbl24:
            // 2 sources

            ** while (reverseStepOrder.hasNext())
        }
lbl25:
        // 1 sources

    }

    private void insertColumnStatistField(String fieldName, int tableNumber, long colId, String value) throws M4CompilerError {
        if (tableNumber != 1 && tableNumber != 2) {
            throw new M4CompilerError("DB.java: updateColumnStatistFieldAndTrash called with wrong table number " + tableNumber);
        }
        try {
            long statId = this.getNextM4SequenceValue();
            String query = "INSERT INTO COLSTATIST" + tableNumber + "_T " + "(colst" + tableNumber + "_id, colst" + tableNumber + "_colid, " + fieldName + ") VALUES (" + statId + ", " + colId + ", " + value + ")";
            this.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB.insertColumnStatistField: DB access error: " + sqle.getMessage());
        }
    }

    private String readColumnStatistField(String fieldName, int tableNumber, long colId) throws M4CompilerError {
        if (tableNumber != 1 && tableNumber != 2) {
            throw new M4CompilerError("DB.java: readColumnStatistField called with wrong table number " + tableNumber);
        }
        String query = "SELECT " + fieldName + " FROM COLSTATIST" + tableNumber + "_T " + "WHERE colst" + tableNumber + "_colid = " + colId;
        try {
            String value = this.executeM4SingleValueSqlRead(query);
            return value;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB.readColumnStatistField: DB access error: " + sqle.getMessage());
        }
    }

    private void insertColumnSetStatistField(String fieldName, long csId, String value) throws M4CompilerError {
        try {
            long statId = this.getNextM4SequenceValue();
            String query = "INSERT INTO CSSTATIST_T (csst_id, csst_csid, " + fieldName + ") VALUES (" + statId + ", " + csId + ", " + value + ")";
            this.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB.insertColumnSetStatistField: DB access error: " + sqle.getMessage());
        }
    }

    private String readColumnSetStatistField(String fieldName, long csId) throws M4CompilerError {
        String query = "SELECT " + fieldName + " FROM CSSTATIST_T " + "WHERE csst_csid = " + csId;
        try {
            String value = this.executeM4SingleValueSqlRead(query);
            return value;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB.readColumnSetStatistField: DB access error: " + sqle.getMessage());
        }
    }

    private String checkDouble(String test) throws M4CompilerError {
        if (test == null) {
            return null;
        }
        int a = test.indexOf(",");
        if (a > -1) {
            String pre = test.substring(0, a);
            String post = test.substring(a + 1);
            test = String.valueOf(pre) + "." + post;
        }
        if (test.startsWith(".")) {
            test = "0" + test;
        }
        try {
            Double.parseDouble(test);
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("Error trying to convert '" + test + "' into double, when reading a Value from the DB.");
        }
        return test;
    }

    public boolean dropBusinessTable(String tableName) throws M4CompilerError {
        String sql_test = "SELECT * FROM " + tableName + " WHERE ROWNUM=1";
        boolean tableExists = true;
        try {
            this.executeBusinessSqlRead(sql_test);
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().indexOf("does not exist") > -1 || sqle.getMessage().startsWith("ORA-00942:")) {
                tableExists = false;
            }
            throw new M4CompilerError("Error trying to access business table '" + tableName + "': " + sqle.getMessage());
        }
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeBusinessSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("Error trying to remove the business table '" + tableName + "': " + sqle.getMessage());
            }
        }
        return tableExists;
    }

    public void createSQLView(Columnset cs, Step step) throws SQLException, M4CompilerError {
        long stepId = step.getId();
        boolean materialized = this.hasToBeMaterialized(cs, step);
        this.dbc.createSQLView(cs, stepId, materialized);
        if (materialized) {
            this.addTableToTrash(cs.getName(), cs.getSchema(), stepId);
        } else {
            this.addViewToTrash(cs.getName(), cs.getSchema(), stepId);
        }
    }

    private boolean hasToBeMaterialized(Columnset cs, Step step) {
        return false;
    }

    public void createSQLFunction(String myFunction) throws SQLException, M4CompilerError {
        this.dbc.createSQLFunction(myFunction);
    }

    public void createSqlIndex(Columnset cs, Column[] cols, long stepId) throws SQLException, M4CompilerError {
        if (cols == null || cols.length == 0) {
            return;
        }
        String csName = cs.getName();
        String[] attributes = new String[cols.length];
        int i = 0;
        while (i < attributes.length) {
            attributes[i] = cols[i].getName();
            ++i;
        }
        String indexName = this.dbc.createSqlIndex(csName, attributes);
        if (indexName == null) {
            StringBuffer msg = new StringBuffer("Could not create index on " + csName + " for columns ( ");
            int i2 = 0;
            while (i2 < attributes.length) {
                msg.append(String.valueOf(attributes[i2]) + " ");
                ++i2;
            }
            msg.append(")");
            throw new M4CompilerError(msg.toString());
        }
        this.addIndexToTrash(indexName, cs.getSchema(), stepId);
    }

    public void executeM4SqlWrite(String query) throws SQLException, M4CompilerThreadKilledException {
        this.dbc.executeM4SqlWrite(query);
    }

    public void executeBusinessSqlWrite(String query) throws SQLException, M4CompilerThreadKilledException {
        this.dbc.executeBusinessSqlWrite(query);
    }

    public ResultSet executeM4SqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        return this.dbc.executeM4SqlRead(query);
    }

    public ResultSet executeBusinessSqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        return this.dbc.executeBusinessSqlRead(query);
    }

    public Long executeM4SingleValueSqlReadL(String query) throws SQLException, M4CompilerThreadKilledException {
        return this.dbc.executeM4SingleValueSqlReadL(query);
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws SQLException, M4CompilerThreadKilledException {
        return this.dbc.executeBusinessSingleValueSqlReadL(query);
    }

    public String executeM4SingleValueSqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        return this.dbc.executeM4SingleValueSqlRead(query);
    }

    public String executeBusinessSingleValueSqlRead(String query) throws SQLException, M4CompilerThreadKilledException {
        return this.dbc.executeBusinessSingleValueSqlRead(query);
    }

    public long getNextM4SequenceValue() throws M4CompilerError {
        return this.dbc.getNextM4SequenceValue();
    }

    private void doPrint(int verbosity, String message) {
        this.getCompilerAccessLogic().getCasePrintObject().doPrint(verbosity, message);
    }

    private void doPrint(Exception ex) {
        this.getCompilerAccessLogic().getCasePrintObject().doPrint(ex);
    }

    public CompilerAccessLogic getCompilerAccessLogic() {
        return this.cal;
    }
}

