/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.utils;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.utils.DB;
import miningmart.compilerInterface.CompilerAccessLogic;

public class CreateMetaData {
    private static String tableNamesFile;
    private static DB m4db;
    private static String sqlNextId;
    private static ResultSet rsNextId;

    static {
        sqlNextId = "select all_sq.nextval from dual";
    }

    public static void main(String[] args) {
        try {
            CompilerAccessLogic myCal = new CompilerAccessLogic(args[0]);
            tableNamesFile = args[1];
            long caseId = Long.parseLong(args[2]);
            String schema = args[3];
            m4db = myCal.getM4db();
            Vector theTables = CreateMetaData.getTableNames(tableNamesFile);
            int i = 0;
            while (i < theTables.size()) {
                CreateMetaData.createM4Objects((String)theTables.get(i), caseId, schema);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("CreateMetaData: Error: " + e.getMessage());
            System.exit(-1);
        }
    }

    private static DB getM4Db() {
        return m4db;
    }

    private static Vector getTableNames(String fileName) {
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(fileName));
            String line = lnr.readLine();
            Vector<String> v = new Vector<String>();
            while (line != null) {
                v.add(line.trim());
                line = lnr.readLine();
            }
            v.trimToSize();
            lnr.close();
            return v;
        }
        catch (IOException ioe) {
            System.out.println("CreateMetaData: Error accessing file with table names: " + ioe.getMessage());
            System.exit(-1);
            return null;
        }
    }

    private static void createM4Objects(String tableName, long caseId, String schema) throws Exception {
        try {
            String query = "SELECT * FROM " + tableName;
            ResultSet rs = CreateMetaData.getM4Db().executeBusinessSqlRead(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int noOfColumns = rsmd.getColumnCount();
            String[] theColumnNames = new String[noOfColumns];
            String[] theColumnTypes = new String[noOfColumns];
            String[] theConceptualTypes = new String[noOfColumns];
            String m4type = null;
            String conceptType = null;
            int i = 1;
            while (i <= noOfColumns) {
                theColumnNames[i - 1] = rsmd.getColumnName(i);
                String oracleType = rsmd.getColumnTypeName(i);
                if (oracleType.toLowerCase().startsWith("number")) {
                    m4type = "12";
                    conceptType = "7";
                }
                if (oracleType.toLowerCase().startsWith("varchar") || oracleType.toLowerCase().startsWith("char")) {
                    m4type = "13";
                    conceptType = "1";
                }
                if (oracleType.toLowerCase().startsWith("date")) {
                    m4type = "14";
                    conceptType = "10";
                }
                if (m4type == null || conceptType == null) {
                    throw new Exception("Found unkown column type: " + oracleType + "!");
                }
                theColumnTypes[i - 1] = m4type;
                theConceptualTypes[i - 1] = conceptType;
                ++i;
            }
            long conId = CreateMetaData.nextID();
            query = "insert into CONCEPT_T values (" + conId + ", " + caseId + ", '" + tableName + "', 'DB', NULL, 'YES')";
            CreateMetaData.getM4Db().executeM4SqlWrite(query);
            long csId = CreateMetaData.nextID();
            query = "insert into COLUMNSET_T values (" + csId + ", '" + schema + "', '" + tableName + "', NULL, NULL, NULL, 'T', '" + tableName + "', " + conId + ", NULL)";
            CreateMetaData.getM4Db().executeM4SqlWrite(query);
            long baconId = 0L;
            int i2 = 0;
            while (i2 < noOfColumns) {
                long colId = CreateMetaData.nextID();
                query = "insert into COLUMN_T values (" + colId + ", '" + theColumnNames[i2] + "', " + csId + ", " + theColumnTypes[i2] + ", NULL)";
                CreateMetaData.getM4Db().executeM4SqlWrite(query);
                long baId = CreateMetaData.nextID();
                query = "insert into BASEATTRIB_T values (" + baId + ", '" + theColumnNames[i2] + "', " + theConceptualTypes[i2] + ", NULL, 'DB', NULL, 'NO', 'YES')";
                CreateMetaData.getM4Db().executeM4SqlWrite(query);
                long bacolId = CreateMetaData.nextID();
                query = "insert into BA_COLUMN_T values (" + bacolId + ", " + baId + ", " + colId + ")";
                CreateMetaData.getM4Db().executeM4SqlWrite(query);
                baconId = CreateMetaData.nextID();
                query = "insert into BA_CONCEPT_T values (" + baconId + ", " + baId + ", " + conId + ")";
                CreateMetaData.getM4Db().executeM4SqlWrite(query);
                ++i2;
            }
            CreateMetaData.getM4Db().commitM4Transactions();
            System.out.println("All metadata successfully created. Concept Id is " + conId + ", Columnset Id is " + csId + ", highest Id used is " + baconId + ".");
        }
        catch (SQLException sqle) {
            System.out.println("CreateMetaData: Error accessing database: " + sqle.getMessage());
            System.exit(-1);
        }
    }

    private static long nextID() throws Exception {
        return CreateMetaData.getM4Db().getNextM4SequenceValue();
    }
}

