/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.uep;

import miningmart.compiler.Column;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.uep.Discretization;

public class EquidistantDiscretizationGivenWidth
extends Discretization {
    public Value[] getStartPoint() {
        return (Value[])this.getParameter("StartPoint", this.getCurrentLoopNumber());
    }

    public Value[] getEndPoint() {
        return (Value[])this.getParameter("EndPoint", this.getCurrentLoopNumber());
    }

    public Value getIntervalWidth() {
        return (Value)this.getSingleParameter("IntervalWidth", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        this.doPrint(12, "EquidistantDiscretizationGivenWidth:");
        double start = this.getStartPointOrMinum(theTargetAttributeColumn);
        double width = Double.parseDouble(this.getIntervalWidth().getValue());
        double end = this.getEndPointOrMaximum(theTargetAttributeColumn);
        int numOfIntervals = (int)Math.ceil((end - start) / width);
        double[] cutPoints = new double[numOfIntervals];
        int i = 0;
        while (i < numOfIntervals) {
            cutPoints[i] = start + (double)i * width;
            ++i;
        }
        return cutPoints;
    }

    public double getStartPointOrMinum(Column theTargetAttributeColumn) throws M4CompilerError {
        Value[] myVal = this.getStartPoint();
        if (myVal.length == 0) {
            String min = theTargetAttributeColumn.getMinValue();
            if (min == null) {
                return Double.parseDouble(this.getM4Db().readOrComputeMinimum(theTargetAttributeColumn));
            }
            return Double.parseDouble(min);
        }
        return Double.parseDouble(myVal[0].getValue());
    }

    public double getEndPointOrMaximum(Column theTargetAttributeColumn) throws M4CompilerError {
        Value[] myVal = this.getEndPoint();
        if (myVal.length == 0) {
            String max = theTargetAttributeColumn.getMaxValue();
            if (max == null) {
                return Double.parseDouble(this.getM4Db().readOrComputeMaximum(theTargetAttributeColumn));
            }
            return Double.parseDouble(max);
        }
        return Double.parseDouble(myVal[0].getValue());
    }
}

