/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;
import miningmart.tools.DM.MD.ColumnInfo;
import miningmart.tools.DM.MD.MetaData;
import miningmart.tools.DM.Wrapper.Wrapper;

public abstract class DistaTool {
    protected DB m4db;
    protected String m_nameForDatabaseUse;
    protected MetaData m_md;
    protected double myPruningConfidence;

    public DistaTool(DB m4db) throws Exception {
        this.m4db = m4db;
    }

    protected abstract Wrapper getWrapperInstance() throws Exception;

    protected abstract String getPrefix();

    public DB getM4Db() {
        return this.m4db;
    }

    public void call(Concept theInputConcept, BaseAttribute[] thePredictingAttributes, Column colToFill, long sampleSize) throws M4CompilerError {
        Wrapper wrapper = null;
        try {
            wrapper = this.getWrapperInstance();
            wrapper.setConnection(this.getM4Db());
        }
        catch (Exception e) {
            throw new M4CompilerError("Error creating wrapper: " + e);
        }
        Columnset theColumnSet = theInputConcept.getCurrentColumnSet();
        this.m_md = new MetaData();
        this.m_md.setTableName(String.valueOf(theColumnSet.getSchema()) + "." + theColumnSet.getName());
        try {
            int i = 0;
            while (i < thePredictingAttributes.length) {
                if (!thePredictingAttributes[i].isHidden()) {
                    ColumnInfo ci = new ColumnInfo();
                    ci.setName(thePredictingAttributes[i].getCurrentColumn().getName());
                    ci.setDataType(thePredictingAttributes[i].getCurrentColumn().getColumnDataTypeName());
                    ci.setConceptType(thePredictingAttributes[i].getConceptualDataTypeName());
                    ci.setSqlName(thePredictingAttributes[i].getCurrentColumn().getSQLDefinition());
                    this.m_md.addColumnInfo(ci);
                }
                ++i;
            }
            if (colToFill != null) {
                ColumnInfo ci = new ColumnInfo();
                ci.setName(colToFill.getName());
                ci.setSqlName(colToFill.getSQLDefinition());
                ci.setDataType(colToFill.getColumnDataTypeName());
                ci.setConceptType(colToFill.getBaseAttribute().getConceptualDataTypeName());
                this.m_md.setColumnToLearn(ci);
            }
        }
        catch (Exception e) {
            throw new M4CompilerError("Error loading meta data: " + e);
        }
        String ss = "";
        if (colToFill != null) {
            ss = "_" + colToFill.getName();
        }
        this.m_nameForDatabaseUse = String.valueOf(this.getPrefix()) + "_" + theInputConcept.getId() + ss + theInputConcept.getCurrentSuffix();
        try {
            wrapper.setSampleSize(sampleSize);
            wrapper.setResultName(this.m_nameForDatabaseUse);
            wrapper.setMetaData(this.m_md);
            wrapper.run();
        }
        catch (Exception e) {
            throw new M4CompilerError("Error running wrapper: " + e);
        }
    }

    public String getNameForDBUse() {
        return this.m_nameForDatabaseUse;
    }

    public void setPruningConfidence(double newPC) {
        this.myPruningConfidence = newPC;
    }

    public String getNameFunction() {
        return String.valueOf(this.getNameForDBUse()) + "_FCT";
    }

    public String getNameFunctionCall() {
        String s = String.valueOf(this.getNameFunction()) + "(";
        int i = 0;
        while (i < this.m_md.getColumnInfos().size()) {
            if (i != 0) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + ((ColumnInfo)this.m_md.getColumnInfos().elementAt(i)).getSqlName();
            ++i;
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

