/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator.dista;

import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Feature;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.FeatureSelection;
import miningmart.compiler.operator.dista.FS;

public abstract class DistaFeatureSelection
extends FeatureSelection {
    protected Feature[] theSelectedFeatures;
    long sampleSize;

    protected abstract void loadParameters() throws M4CompilerError;

    protected abstract void initialiseWrapper() throws M4CompilerError;

    protected abstract void callWrapper(BaseAttribute[] var1) throws M4CompilerError;

    protected abstract FS getWrapper() throws M4CompilerError;

    protected Feature[] computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError {
        this.callStatement(theSuperset);
        return this.theSelectedFeatures;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getSampleSize() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("SampleSize");
        String errorMessage = String.valueOf(this.getName()) + ": Parameter SampleSize must be specified and must be a positive integer!";
        if (v == null) throw new M4CompilerError(errorMessage);
        String s = v.getValue();
        if (s == null) throw new M4CompilerError(errorMessage);
        try {
            void var2_4;
            long samplesize = Long.parseLong(s);
            return (long)var2_4;
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError(errorMessage);
        }
    }

    private void callStatement(Feature[] theSuperset) throws M4CompilerError {
        this.initialiseWrapper();
        this.loadParameters();
        this.sampleSize = this.getSampleSize();
        BaseAttribute[] theSupersetAsBAs = null;
        try {
            theSupersetAsBAs = new BaseAttribute[theSuperset.length];
            int j = 0;
            while (j < theSuperset.length) {
                theSupersetAsBAs[j] = (BaseAttribute)theSuperset[j];
                ++j;
            }
        }
        catch (ClassCastException cce) {
            throw new M4CompilerError(String.valueOf(this.getName()) + ": this operator can only handle BaseAttributes " + "for the parameter 'TheAttributes'!");
        }
        this.callWrapper(theSupersetAsBAs);
        Vector selF = this.getWrapper().m_feature_selected;
        this.theSelectedFeatures = new Feature[selF.size()];
        int i = 0;
        while (i < selF.size()) {
            this.theSelectedFeatures[i] = this.find(theSuperset, (String)selF.get(i));
            ++i;
        }
    }

    private Feature find(Feature[] theSet, String name) throws M4CompilerError {
        int i = 0;
        while (i < theSet.length) {
            if (name.equalsIgnoreCase(theSet[i].getName())) {
                return theSet[i];
            }
            ++i;
        }
        throw new M4CompilerError("Fatal Error in DistaFeatureSelection: wrapper selected unknown feature...!");
    }
}

