/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.MultipleCSOperator;

public class Unsegment
extends MultipleCSOperator {
    private static final String UNSEGMENT_ATTRIB_PARAM = "UnsegmentAttribute";
    private static final String TYPE_OF_OUTPUT_CS = "V";
    private static final int VIEW_SIZE_RESTRICTION = 2000;
    private HashMap colsetsByMsbInfo = null;

    public int numberOfColumnSets() throws M4CompilerError {
        return this.getColsetsKeySet().size();
    }

    private String[] getDistinctMsbInfos() throws M4CompilerError {
        Set keys = this.getColsetsKeySet();
        return keys.toArray(new String[keys.size()]);
    }

    public String getTypeOfNewColumnSet(int index) {
        return TYPE_OF_OUTPUT_CS;
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return !nameOfFeature.equals(this.getUnsegmentAttribute().getName());
    }

    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError {
        Object[] keyArray = this.getColsetsKeySet().toArray();
        String key = (String)keyArray[index];
        Vector theColSets = this.getColsetVectorByKey(key);
        return this.sqlUnionOfColsets(theColSets, index);
    }

    private String sqlUnionOfColsets(Vector theColsets, int index) throws M4CompilerError {
        if (theColsets == null || theColsets.size() == 0) {
            throw new M4CompilerError("Unsegment: No Columnsets found when trying to generate an SQL-view for union of ColumnSets.");
        }
        Iterator it = ((AbstractList)theColsets).iterator();
        Vector<String> sqlDefs = new Vector<String>();
        while (it.hasNext()) {
            String refined = this.refineSqlDef((Columnset)it.next());
            sqlDefs.add(refined);
        }
        return this.concatenateOrSubView(sqlDefs, index, 1);
    }

    private String concatenateOrSubView(Vector viewDefs, int index, int nameSuffix) throws M4CompilerError {
        if (viewDefs == null || viewDefs.size() < 1) {
            return null;
        }
        Iterator it = ((AbstractList)viewDefs).iterator();
        StringBuffer sbuf = new StringBuffer((String)it.next());
        String viewNamePre = String.valueOf(this.getNewCSName(index)) + "_V_" + index + "_";
        Vector<String> meta = new Vector<String>();
        while (it.hasNext()) {
            String nextView = (String)it.next();
            if (sbuf.length() + nextView.length() < 2000) {
                sbuf.append(" union " + nextView);
                continue;
            }
            String intermediateView = "(" + sbuf.toString() + ")";
            String completeName = String.valueOf(viewNamePre) + nameSuffix++;
            this.createView(intermediateView, completeName);
            meta.add("(select * from " + completeName + ")");
            sbuf = new StringBuffer(nextView);
        }
        if (meta.isEmpty()) {
            if (viewDefs.size() == 1) {
                return sbuf.toString();
            }
            return "(" + sbuf.toString() + ")";
        }
        String intermediateView = "(" + sbuf.toString() + ")";
        String completeName = String.valueOf(viewNamePre) + nameSuffix++;
        this.createView(intermediateView, completeName);
        meta.add("(select * from " + completeName + ")");
        return this.concatenateOrSubView(meta, index, nameSuffix);
    }

    private void createView(String viewDef, String viewName) throws M4CompilerError {
        String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
        String sql = "create view " + schema + "." + viewName + " as (" + viewDef + ")";
        try {
            this.getM4Db().executeBusinessSqlWrite(sql);
            this.getM4Db().addViewToTrash(viewName, schema, this.getStep().getId());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Unsegment: Could not create intermediate view. SQL:\n" + sql + "\n" + e.getMessage());
        }
    }

    private String refineSqlDef(Columnset c) throws M4CompilerError {
        String srcDef = c.getSchemaPlusName();
        StringBuffer sql = new StringBuffer("(select ");
        Column[] columns = Unsegment.sortColsByName(c.getColumns());
        int i = 0;
        while (i < columns.length) {
            String colName;
            String sqlDef = columns[i].getSQLDefinition();
            if (sqlDef.equals(colName = columns[i].getName())) {
                sql.append(String.valueOf(colName) + ", ");
            } else {
                sql.append(String.valueOf(sqlDef) + " " + colName + ", ");
            }
            ++i;
        }
        String unsegAttrName = this.getUnsegmentAttribute().getName();
        String value = c.getMSBranchSelectionValue(unsegAttrName);
        if (value == null || value.length() == 0) {
            throw new M4CompilerError("Unsegment: Could not find information for unsegment-attribute " + unsegAttrName + " in SQL definition of Columnset " + c.getName() + ", id: " + c.getId() + "\nSQL definition is:\n" + c.getSQLDefinition());
        }
        String sqlS = this.unsegmentBaToBeWritten() ? String.valueOf(sql.toString()) + value + " " + unsegAttrName : sql.substring(0, sql.length() - 2);
        return String.valueOf(sqlS) + " from " + srcDef + ")";
    }

    private static Column[] sortColsByName(Column[] cols) throws M4CompilerError {
        if (cols == null) {
            throw new M4CompilerError("Error in Unsegment operator: Found null value instead of input Column[] when trying to sortColsByName!");
        }
        TreeMap<String, Column> tm = new TreeMap<String, Column>();
        int i = 0;
        while (i < cols.length) {
            Column c = cols[i];
            if (c == null) {
                throw new M4CompilerError("Error in Unsegment operator: Found null value in Column[] input when trying to sortColsByName!");
            }
            tm.put(c.getName().toUpperCase(), c);
            ++i;
        }
        return tm.values().toArray(new Column[cols.length]);
    }

    public BaseAttribute getUnsegmentAttribute() {
        return (BaseAttribute)this.getSingleParameter(UNSEGMENT_ATTRIB_PARAM);
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = super.generateColumns(csForOutputConcept);
        if (this.unsegmentBaToBeWritten()) {
            BaseAttribute outBA = this.getUnsegmentAttribute();
            Column outputColumn = new Column(this.getM4Db());
            outputColumn.setId(0L);
            outputColumn.setName(outBA.getName());
            outputColumn.setColumnSet(csForOutputConcept);
            outputColumn.setBaseAttribute(outBA);
            outBA.addColumn(outputColumn);
            outputColumn.setSQLDefinition(outBA.getName());
            outputColumn.setColumnDataType(13L);
            outputColumn.setColumnDataTypeName("STRING");
            csForOutputConcept.addColumn(outputColumn);
            columnExpr = String.valueOf(columnExpr) + ", " + outBA.getName() + " " + outBA.getName();
        }
        return columnExpr;
    }

    private boolean unsegmentBaToBeWritten() {
        return !this.getUnsegmentAttribute().getName().startsWith("(");
    }

    private Set getColsetsKeySet() throws M4CompilerError {
        this.aggregateColsets();
        return this.colsetsByMsbInfo.keySet();
    }

    private Vector getColsetVectorByKey(String key) throws M4CompilerError {
        this.aggregateColsets();
        return (Vector)this.colsetsByMsbInfo.get(key);
    }

    private void aggregateColsets() throws M4CompilerError {
        if (this.colsetsByMsbInfo != null) {
            return;
        }
        Columnset[] csArray = this.getInputConcept().getColumnSets();
        if (csArray == null) {
            throw new M4CompilerError("InputConcept " + this.getId() + " of operator Unsegment has no Columnset(s) !");
        }
        String baName = this.getUnsegmentAttribute().getName();
        HashMap hm = new HashMap();
        int i = 0;
        while (i < csArray.length) {
            String msbDef = csArray[i].getMsbInfoWithoutAttrib(baName);
            if (!hm.containsKey(msbDef)) {
                hm.put(msbDef, new Vector());
            }
            Vector v = (Vector)hm.get(msbDef);
            v.add(csArray[i]);
            ++i;
        }
        this.colsetsByMsbInfo = hm;
    }

    public void execute(boolean lazy) throws SQLException, M4CompilerError {
        super.execute(lazy);
        if (!lazy) {
            Concept inputConcept = this.getInputConcept();
            while (inputConcept.hasNextColumnSet()) {
                inputConcept.getNextColumnSet();
            }
        }
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        Object[] keys = this.getColsetsKeySet().toArray();
        newCS.setMultiStepBranch((String)keys[index]);
    }

    public String getNewCSName(int index) {
        String name = "CS_" + this.getStep().getId() + "_" + index;
        return name;
    }
}

