/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.SingleCSOperator;

public class UnionByKey
extends SingleCSOperator {
    private BaseAttribute theOutputId = null;
    private Vector conceptsData;

    public Concept[] getTheConcepts() {
        return (Concept[])this.getParameter("TheConcepts");
    }

    public BaseAttribute[] getTheKeys() {
        return (BaseAttribute[])this.getParameter("TheKeys");
    }

    protected Feature[][] getInOutMap() throws M4CompilerError {
        int noOfMappings = this.getNumberOfLoops();
        Feature[][] theMap = new Feature[2][noOfMappings];
        int l = 0;
        while (l < noOfMappings) {
            theMap[0][l] = (Feature)this.getSingleParameter("MapInput", l);
            theMap[1][l] = (Feature)this.getSingleParameter("MapOutput", l);
            if (theMap[0][l] == null || theMap[1][l] == null) {
                throw new M4CompilerError("Operator JoinByKey: mapping information is incomplete!");
            }
            ++l;
        }
        return theMap;
    }

    public BaseAttribute getOutputIdAttribute() throws M4CompilerError {
        if (this.theOutputId != null) {
            return this.theOutputId;
        }
        BaseAttribute[] keys = this.getTheKeys();
        int i = 0;
        while (i < keys.length) {
            Feature f = this.getMappedFeature(keys[i]);
            if (f != null && f instanceof BaseAttribute) {
                this.theOutputId = (BaseAttribute)f;
                return this.theOutputId;
            }
            ++i;
        }
        throw new M4CompilerError("Operator UnionByKey: No Key found in output Concept!");
    }

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        this.checkKeys();
    }

    public Concept getInputConcept() {
        return this.getTheConcepts()[0];
    }

    private void checkKeys() throws M4CompilerError {
        if (this.getTheKeys().length != this.getTheConcepts().length) {
            throw new M4CompilerError("UnionByKey: number of JoinAttributes and number of Concepts must be equal!");
        }
        int i = 0;
        while (i < this.getTheKeys().length) {
            Concept theConcept = this.getTheKeys()[i].getConcept();
            boolean found = false;
            if (theConcept.getId() == this.getTheConcepts()[i].getId()) {
                found = true;
            }
            if (!found) {
                throw new M4CompilerError("Attribute " + this.getTheKeys()[i] + " does not belong to the concept " + this.getTheConcepts()[i].getName() + " !");
            }
            ++i;
        }
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    public String generateSQLDefinition(String selectPart) {
        return this.getNewCSName();
    }

    private String determineDBTypeOfColumn(Column col) {
        if (col.getColumnDataType() == 12L) {
            return "NUMBER";
        }
        if (col.getColumnDataType() == 13L || col.getColumnDataType() == 15L) {
            return "VARCHAR2(500)";
        }
        if (col.getColumnDataType() == 14L) {
            return "DATE";
        }
        return "VARCHAR2(500)";
    }

    private void createTable(Columnset cs) throws M4CompilerError {
        try {
            this.getM4Db().executeBusinessSqlWrite("DROP TABLE " + cs.getName());
        }
        catch (SQLException sqle) {
            this.doPrint(6, "Error dropping table " + cs.getName() + ". Probably harmless (:");
        }
        String cQuery = "CREATE TABLE " + cs.getName() + " (";
        cQuery = String.valueOf(cQuery) + this.getOutputIdAttribute().getName() + " " + this.determineDBTypeOfColumn(this.getTheKeys()[0].getCurrentColumn()) + ", ";
        int i = 0;
        while (i < this.conceptsData.size()) {
            ConceptData cd = (ConceptData)this.conceptsData.get(i);
            cd.resetBA();
            while (cd.hasNextBA()) {
                BaseAttribute attr = cd.nextBA();
                cQuery = String.valueOf(cQuery) + this.getMappedName(attr) + " " + this.determineDBTypeOfColumn(attr.getCurrentColumn()) + ", ";
            }
            ++i;
        }
        cQuery = cQuery.substring(0, cQuery.length() - 2);
        cQuery = String.valueOf(cQuery) + ")";
        try {
            this.getM4Db().executeBusinessSqlWrite(cQuery);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("UnionByKey: SQL error: " + sqle.getMessage());
        }
        this.getM4Db().addTableToTrash(cs.getName(), cs.getSchema(), this.getStep().getId());
    }

    private void collectKeys(Columnset cs) throws M4CompilerError {
        String iQuery = "INSERT INTO " + cs.getName() + " (" + this.getOutputIdAttribute().getName() + ") (SELECT ID FROM (";
        int i = 0;
        while (i < this.conceptsData.size()) {
            ConceptData cd = (ConceptData)this.conceptsData.get(i);
            iQuery = String.valueOf(iQuery) + "(SELECT " + cd.getIdAttribute().getCurrentColumn().getSQLDefinition() + " ID FROM " + cd.getConcept().getCurrentColumnSet().getSQLDefinition() + ") UNION ";
            ++i;
        }
        iQuery = String.valueOf(iQuery.substring(0, iQuery.length() - 7)) + "))";
        try {
            this.getM4Db().executeBusinessSqlWrite(iQuery);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("UnionByKey: SQL error occured: " + sqle.getMessage());
        }
    }

    private void fillAttributes(Columnset cs) throws M4CompilerError {
        String commonPart = "UPDATE " + cs.getName() + " CS " + " SET ";
        try {
            int i = 0;
            while (i < this.conceptsData.size()) {
                ConceptData cd = (ConceptData)this.conceptsData.get(i);
                String csSql = cd.getConcept().getCurrentColumnSet().getName();
                cd.resetBA();
                while (cd.hasNextBA()) {
                    BaseAttribute ba = cd.nextBA();
                    String iQuery = String.valueOf(this.getMappedName(ba)) + " = (SELECT " + ba.getCurrentColumn().getSQLDefinition() + " FROM " + csSql + " WHERE CS." + this.getOutputIdAttribute().getName() + " = " + cd.getIdAttribute().getCurrentColumn().getSQLDefinition() + ")";
                    this.getM4Db().executeBusinessSqlWrite(String.valueOf(commonPart) + iQuery);
                }
                ++i;
            }
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("UnionByKey: SQL exception occured: " + sqle.getMessage());
        }
    }

    private void checkOutputConceptFeatures() throws M4CompilerError {
        Feature[] outConFeas = this.getOutputConcept().getFeatures();
        Concept[] cons = this.getTheConcepts();
        int i = 0;
        while (i < outConFeas.length) {
            if (outConFeas[i].getId() != this.getOutputIdAttribute().getId()) {
                boolean found = false;
                int j = 0;
                while (j < cons.length) {
                    int k = 0;
                    while (k < cons[j].getFeatures().length) {
                        if (outConFeas[i].correspondsTo(cons[j].getFeatures()[k])) {
                            found = true;
                        }
                        ++k;
                    }
                    ++j;
                }
                if (!found) {
                    this.doPrint(12, "UnionByKey: No Feature with id " + outConFeas[i].getId() + " (" + outConFeas[i].getName() + ") found in any of the input concepts. Skipping.");
                }
            }
            ++i;
        }
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        Column oldColumn = null;
        Column copiedColumn = null;
        oldColumn = this.getTheKeys()[0].getCurrentColumn();
        copiedColumn = oldColumn.copyColTo(csForOutputConcept);
        copiedColumn.setBaseAttribute(this.getOutputIdAttribute());
        this.getOutputIdAttribute().addColumn(copiedColumn);
        copiedColumn.setSQLDefinition(this.getOutputIdAttribute().getName());
        this.conceptsData = new Vector();
        int i = 0;
        while (i < this.getTheConcepts().length) {
            this.generateConceptData(this.getTheConcepts()[i], this.getTheKeys()[i], csForOutputConcept);
            ++i;
        }
        this.createTable(csForOutputConcept);
        this.collectKeys(csForOutputConcept);
        this.fillAttributes(csForOutputConcept);
        return "";
    }

    private boolean isAKey(Feature f) {
        int i = 0;
        while (i < this.getTheKeys().length) {
            if (f.getId() == this.getTheKeys()[i].getId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void generateConceptData(Concept current, BaseAttribute idBA, Columnset csForOutputConcept) throws M4CompilerError {
        ConceptData cData = new ConceptData();
        this.conceptsData.add(cData);
        Vector<Feature> selectedFeaturesOfCurrentConcept = new Vector<Feature>();
        Feature[] concFeatures = current.getFeatures();
        int i = 0;
        while (i < concFeatures.length) {
            int j = 0;
            while (j < this.getOutputConcept().getFeatures().length) {
                if (this.getMappedFeature(concFeatures[i]) == null) {
                    this.doPrint(12, "UnionByKey: Feature '" + concFeatures[i].getName() + "' not found in Mapping or in output concept; skipping!");
                    break;
                }
                if (this.getMappedFeature(concFeatures[i]).correspondsTo(this.getOutputConcept().getFeatures()[j]) && !this.isAKey(concFeatures[i]) && !this.isDeselectedParameter(concFeatures[i])) {
                    selectedFeaturesOfCurrentConcept.add(concFeatures[i]);
                }
                ++j;
            }
            ++i;
        }
        cData.setConcept(current);
        cData.setIdAttribute(idBA);
        int i2 = 0;
        while (i2 < selectedFeaturesOfCurrentConcept.size()) {
            Column copiedColumn;
            Column oldColumn;
            BaseAttribute oldBA;
            BaseAttribute newBA;
            Feature oldF = (Feature)selectedFeaturesOfCurrentConcept.get(i2);
            Feature newF = this.getMappedFeature(oldF);
            if (oldF instanceof BaseAttribute) {
                newBA = (BaseAttribute)newF;
                oldBA = (BaseAttribute)oldF;
                oldColumn = oldBA.getCurrentColumn();
                copiedColumn = oldColumn.copyColTo(csForOutputConcept);
                copiedColumn.setBaseAttribute(newBA);
                newBA.addColumn(copiedColumn);
                copiedColumn.setName(newBA.getName());
                copiedColumn.setSQLDefinition(newBA.getName());
                cData.addBA(oldBA);
            } else if (oldF instanceof MultiColumnFeature) {
                if (!newF.correspondsTo(oldF)) {
                    throw new M4CompilerError("Operator UnionByKey: Mapping of MultiColumnFeatures not implemented, yet!");
                }
                MultiColumnFeature newMCF = (MultiColumnFeature)newF;
                MultiColumnFeature oldMCF = (MultiColumnFeature)oldF;
                BaseAttribute[] theBAs = newMCF.getBaseAttributes();
                if (theBAs != null) {
                    int j = 0;
                    while (j < theBAs.length) {
                        newBA = theBAs[j];
                        oldBA = oldMCF.getBaseAttributes()[j];
                        oldColumn = oldBA.getCurrentColumn();
                        copiedColumn = oldColumn.copyColTo(csForOutputConcept);
                        copiedColumn.setBaseAttribute(newBA);
                        newBA.addColumn(copiedColumn);
                        copiedColumn.setSQLDefinition(newBA.getName());
                        cData.addBA(oldBA);
                        ++j;
                    }
                }
            } else {
                throw new M4CompilerError("Unknown Feature type found in Concept with id: " + current.getId() + "; Feature id is " + oldF.getId());
            }
            ++i2;
        }
    }

    private int getNumberOfLoops() {
        int loops = this.getHighestLoopNr();
        return loops;
    }

    private String getMappedName(BaseAttribute ba) throws M4CompilerError {
        Feature outF = this.getMappedFeature(ba);
        if (outF == null || !(outF instanceof BaseAttribute)) {
            throw new M4CompilerError("UnionByKey.getMappedName: No output BaseAttribute found for InputBA: " + ba.getName() + ", id: " + ba.getId());
        }
        return outF.getName();
    }

    private Feature getMappedFeature(Feature oldF) throws M4CompilerError {
        Feature[][] theMap = this.getInOutMap();
        int i = 0;
        while (i < theMap[0].length) {
            Feature feature = theMap[0][i];
            if (feature.getId() == oldF.getId()) {
                return theMap[1][i];
            }
            ++i;
        }
        Feature newF = null;
        int k = 0;
        while (k < this.getOutputConcept().getFeatures().length && !(newF = this.getOutputConcept().getFeature(k)).correspondsTo(oldF)) {
            ++k;
        }
        if (newF.correspondsTo(oldF)) {
            return newF;
        }
        return null;
    }

    private class ConceptData {
        private Concept concept;
        private Vector attributes = new Vector();
        private BaseAttribute attribId;
        private Iterator it = null;

        public Concept getConcept() {
            return this.concept;
        }

        public void setConcept(Concept cs) {
            this.concept = cs;
        }

        public BaseAttribute getIdAttribute() {
            return this.attribId;
        }

        public void setIdAttribute(BaseAttribute id) {
            this.attribId = id;
        }

        public void resetBA() {
            this.it = ((AbstractList)this.attributes).iterator();
        }

        public boolean hasNextBA() {
            if (this.it == null) {
                this.it = ((AbstractList)this.attributes).iterator();
            }
            return this.it.hasNext();
        }

        public BaseAttribute nextBA() {
            if (this.it.hasNext()) {
                return (BaseAttribute)this.it.next();
            }
            this.it = null;
            return null;
        }

        public void addBA(BaseAttribute ba) {
            this.attributes.add(ba);
        }
    }
}

