/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.SingleCSOperator;
import miningmart.compiler.utils.DB;

public abstract class TimeOperator
extends SingleCSOperator {
    protected abstract String getColumnSetSuffix();

    protected abstract void runStoredProcedure(String var1) throws SQLException, M4CompilerError;

    protected abstract void createJavaColumns(Columnset var1) throws SQLException, M4CompilerError;

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return null;
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    protected Columnset createSingleColumnSet(int index) throws M4CompilerError {
        try {
            String columnSetName = this.getNewCSName();
            this.runStoredProcedure(String.valueOf(this.getInputConcept().getCurrentColumnSet().getSchema()) + "." + columnSetName);
            Columnset newCS = this.createJavaColumnset(columnSetName);
            this.createJavaColumns(newCS);
            long step = this.getStep().getId();
            String schema = this.getInputConcept().getCurrentColumnSet().getSchema();
            this.getM4Db().addTableToTrash(columnSetName, schema, step);
            return newCS;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("TimeOperator: SQL error: " + sqle.getMessage());
        }
    }

    private Columnset createJavaColumnset(String columnSetName) throws SQLException, M4CompilerError {
        Columnset newCS = new Columnset(this.getM4Db());
        newCS.setId(0L);
        newCS.setName(columnSetName);
        Columnset inputColumnSet = this.getInputConcept().getCurrentColumnSet();
        newCS.setSchema(inputColumnSet.getSchema());
        newCS.setType(this.getTypeOfNewColumnSet());
        newCS.setSQLDefinition(columnSetName);
        newCS.setConcept(this.getOutputConcept());
        newCS.setMultiStepBranch(inputColumnSet.getMultiStepBranch());
        return newCS;
    }

    protected Column createM4Column(BaseAttribute outputBA, Columnset newCS, Column columnForType) throws SQLException, M4CompilerError {
        String newColumnName = outputBA.getName();
        Column newColumn = new Column(this.getM4Db());
        newColumn.setId(0L);
        newColumn.setName(newColumnName);
        newColumn.setColumnSet(newCS);
        newColumn.setBaseAttribute(outputBA);
        newColumn.setColumnDataType(columnForType.getColumnDataType());
        newColumn.setColumnDataTypeName(columnForType.getColumnDataTypeName());
        newColumn.setSQLDefinition(newColumnName);
        outputBA.addColumn(newColumn);
        newCS.addColumn(newColumn);
        return newColumn;
    }

    protected static String getQuotedColNameforInpBA(BaseAttribute ba) throws M4CompilerError {
        return DB.quote(ba.getColumn(0).getName().toUpperCase());
    }

    protected static String getQuotedColNameforOutBA(BaseAttribute ba) throws M4CompilerError {
        return DB.quote(ba.getName());
    }

    protected static String getQuotedColSetNameforCon(Concept c) throws M4CompilerError {
        Columnset cs = c.getCurrentColumnSet();
        return DB.quote(String.valueOf(cs.getSchema().toUpperCase()) + "." + cs.getName().toUpperCase());
    }

    protected static String getUnquotedIntFromValue(Value v) {
        return v.getValue().trim();
    }

    protected void valueIsLong(Value v, String name) throws M4CompilerError {
        if (v == null || !v.isLong()) {
            this.createParameterException(name);
        }
    }

    protected void valueIsDouble(Value v, String name) throws M4CompilerError {
        if (v == null || !v.isDouble()) {
            this.createParameterException(name);
        }
    }

    protected void baseattribHasColumns(BaseAttribute b, String name) throws M4CompilerError {
        if (b == null || !b.hasColumns()) {
            this.createParameterException(name);
        }
    }

    private void createParameterException(String name) throws M4CompilerError {
        throw new M4CompilerError("Parameter '" + name + "' of step " + this.getStep().getId() + " of wrong data type (or BA without column)!");
    }
}

