/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.DB_SVM_RG;
import miningmart.compiler.operator.FeatureConstruction;
import miningmart.compiler.operator.SVM_RG;
import miningmart.compiler.operator.SVM_Wrapper;

public class SupportVectorMachineForRegression
extends FeatureConstruction {
    private static final String ENV_VARIABLE_ML_HOME = "ML_HOME";
    private static final String MLTOOL = "mysvm";
    private static final String MLTOOLPARAMS = "";
    private SVM_Wrapper mysvm = null;
    private boolean useDatabaseSVM = false;

    public String generateSQL(Column columnToFill) throws M4CompilerError {
        this.callStatement(columnToFill);
        String fctCall = String.valueOf(this.mysvm.getDecisionFunctionName()) + "(";
        int i = 0;
        while (i < this.getThePredictingAttributes(this.getCurrentLoopNumber()).length) {
            fctCall = String.valueOf(fctCall) + this.getThePredictingAttributes(this.getCurrentLoopNumber())[i].getCurrentColumn().getSQLDefinition() + ", ";
            ++i;
        }
        fctCall = String.valueOf(fctCall.substring(0, fctCall.length() - 2)) + ")";
        return fctCall;
    }

    private void callStatement(Column columnToFill) throws M4CompilerError {
        int l;
        block14: {
            this.mysvm = null;
            l = this.getCurrentLoopNumber();
            this.useDatabaseSVM = this.getUseDatabaseSVM(l);
            try {
                long sample;
                Value v;
                if (this.useDatabaseSVM) {
                    long sample2;
                    BaseAttribute keyBA = this.getKey(l);
                    String key = null;
                    if (keyBA != null) {
                        key = keyBA.getCurrentColumn().getName();
                    }
                    if ((v = this.getSampleSize(l)) == null) {
                        this.mysvm = new DB_SVM_RG(this.getM4Db(), this.getM4Db().getCompilerAccessLogic().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, this.getLossFunctionPos(l).getValue(), this.getLossFunctionNeg(l).getValue());
                        break block14;
                    }
                    try {
                        sample2 = Long.parseLong(v.getValue());
                    }
                    catch (NumberFormatException nfe) {
                        throw new M4CompilerError("SupportVectorMachineForRegression: SampleSize must be an integer! Found: " + v.getValue());
                    }
                    this.mysvm = new DB_SVM_RG(this.getM4Db(), this.getM4Db().getCompilerAccessLogic().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), key, sample2, this.getLossFunctionPos(l).getValue(), this.getLossFunctionNeg(l).getValue());
                    break block14;
                }
                v = null;
                try {
                    v = this.getSampleSize(l);
                    sample = v == null ? 10000L : Long.parseLong(v.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("SupportVectorMachineForRegression: SampleSize must be an integer! Found: " + v.getValue());
                }
                this.mysvm = new SVM_RG(this.getM4Db(), this.getM4Db().getCompilerAccessLogic().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getStep().getId(), sample, this.getLossFunctionPos(l).getValue(), this.getLossFunctionNeg(l).getValue());
            }
            catch (InterruptedException e) {
                this.doPrint(20, "Error while constructing SVM: " + e.getMessage());
            }
            catch (Exception e) {
                this.doPrint(20, "Error with SVM for Regression: " + e.getMessage());
            }
        }
        Columnset theColumnSet = this.getTheInputConcept().getCurrentColumnSet();
        String fctSchema = theColumnSet.getSchema();
        if (fctSchema.length() == 0) {
            fctSchema = null;
        }
        Vector<String> theColNames = new Vector<String>();
        int i = 0;
        while (i < this.getThePredictingAttributes(l).length) {
            theColNames.add(this.getThePredictingAttributes(l)[i].getCurrentColumn().getName());
            ++i;
        }
        theColNames.trimToSize();
        this.mysvm.callSVM(theColumnSet.getSchemaPlusName(), columnToFill.getName(), this.getTheInputConcept().getId(), this.getC(l).getValue(), this.getKernelType(l).getValue(), this.getEpsilon(l).getValue(), theColNames);
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM-Wrapper: could not commit DB updates: " + sqle.getMessage());
        }
    }

    private String getPrefixForDatabaseObjects() throws M4CompilerError {
        String loopIdentification = MLTOOLPARAMS;
        if (this.getHighestLoopNr() > 1) {
            loopIdentification = "L" + this.getCurrentLoopNumber();
        }
        return String.valueOf(this.getTheInputConcept().getCurrentColumnSet().getName()) + loopIdentification;
    }

    public Value getC(int loopNr) {
        return (Value)this.getSingleParameter("C", loopNr);
    }

    public BaseAttribute getKey(int loopNr) {
        return (BaseAttribute)this.getSingleParameter("TheKey", loopNr);
    }

    public Value getEpsilon(int loopNr) {
        return (Value)this.getSingleParameter("Epsilon", loopNr);
    }

    public Value getKernelType(int loopNr) {
        return (Value)this.getSingleParameter("KernelType", loopNr);
    }

    public Value getLossFunctionNeg(int loopNr) {
        return (Value)this.getSingleParameter("LossFunctionNeg", loopNr);
    }

    public Value getLossFunctionPos(int loopNr) {
        return (Value)this.getSingleParameter("LossFunctionPos", loopNr);
    }

    public Value getSampleSize(int loopNr) {
        return (Value)this.getSingleParameter("SampleSize", loopNr);
    }

    public BaseAttribute[] getThePredictingAttributes(int loopNr) {
        return (BaseAttribute[])this.getParameter("ThePredictingAttributes", loopNr);
    }

    public boolean getUseDatabaseSVM(int loopNr) {
        Value v = (Value)this.getSingleParameter("UseDB_SVM", loopNr);
        if (v == null) {
            return this.useDatabaseSVM;
        }
        String s = v.getValue();
        return s.equalsIgnoreCase("true");
    }
}

