/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.SingleCSOperator;

public class SpecifiedStatistics
extends SingleCSOperator {
    private Vector columnNames;
    private Vector entries;

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String columnExpr = "";
        Feature inF = null;
        int iIn = 0;
        Feature outF = null;
        int iOut = 0;
        iOut = 0;
        while (iOut < this.getOutputConcept().getFeatures().length) {
            outF = this.getOutputConcept().getFeature(iOut);
            if (this.mustCopyFeature(outF.getName())) {
                Column outputColumn;
                Column inputColumn;
                BaseAttribute outBA;
                BaseAttribute inBA;
                iIn = 0;
                do {
                    inF = this.getInputConcept().getFeature(iIn);
                } while (++iIn < this.getInputConcept().getFeatures().length && !this.correspondsTo(outF, inF));
                if (!this.correspondsTo(outF, inF)) {
                    this.doPrint(12, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because no corresponding input feature was found.");
                } else if (this.isDeselectedParameter(inF)) {
                    this.doPrint(6, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                } else if (outF instanceof BaseAttribute) {
                    inBA = (BaseAttribute)inF;
                    outBA = (BaseAttribute)outF;
                    inputColumn = inBA.getCurrentColumn();
                    outputColumn = inputColumn.copyColTo(csForOutputConcept);
                    outputColumn.setBaseAttribute(outBA);
                    outBA.addColumn(outputColumn);
                    outputColumn.setSQLDefinition(outBA.getName());
                    outputColumn.setName(outBA.getName());
                } else {
                    if (!(outF instanceof MultiColumnFeature)) {
                        throw new M4CompilerError("Unknown Feature type found in Concept with id: " + this.getOutputConcept().getId() + "; Feature id: " + outF.getId());
                    }
                    MultiColumnFeature outMCF = (MultiColumnFeature)outF;
                    MultiColumnFeature inMCF = (MultiColumnFeature)inF;
                    BaseAttribute[] theBAs = outMCF.getBaseAttributes();
                    if (theBAs != null) {
                        try {
                            int i = 0;
                            while (i < theBAs.length) {
                                outBA = theBAs[i];
                                inBA = inMCF.getBaseAttributes()[i];
                                inputColumn = inBA.getCurrentColumn();
                                outputColumn = inputColumn.copyColTo(csForOutputConcept);
                                outputColumn.setBaseAttribute(outBA);
                                outBA.addColumn(outputColumn);
                                outputColumn.setSQLDefinition(outBA.getName());
                                outputColumn.setName(outBA.getName());
                                ++i;
                            }
                        }
                        catch (NullPointerException nfe) {
                            throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                        }
                        catch (ArrayIndexOutOfBoundsException aie) {
                            throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                        }
                    }
                }
            }
            ++iOut;
        }
        return columnExpr;
    }

    private boolean correspondsTo(Feature out, Feature in) {
        if (out == null) {
            return false;
        }
        String outName = out.getName().toUpperCase();
        String inName = in.getName().toUpperCase();
        if (outName.endsWith("_SUM")) {
            outName = outName.substring(0, outName.length() - 4);
        }
        if (outName.endsWith("_COUNT")) {
            outName = outName.substring(0, outName.length() - 6);
        }
        if (outName.endsWith("_UNIQUE")) {
            outName = outName.substring(0, outName.length() - 7);
        }
        Value[] theDistribValues = (Value[])this.getParameter("DistribValues");
        int i = 0;
        while (i < theDistribValues.length) {
            String[] vals = this.getSingleValues(theDistribValues[i]);
            int j = 0;
            while (j < vals.length) {
                if (outName.endsWith("_" + vals[j])) {
                    outName = outName.substring(0, outName.length() - vals[j].length() - 1);
                }
                ++j;
            }
            ++i;
        }
        return out.getClass() == in.getClass() && outName.equalsIgnoreCase(inName);
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String count;
        int i;
        this.doPrint(12, "Operator SpecifiedStatistics is computing...");
        this.columnNames = new Vector();
        this.entries = new Vector();
        BaseAttribute[] theBAs = (BaseAttribute[])this.getParameter("AttributesComputeSum");
        if (theBAs != null) {
            i = 0;
            while (i < theBAs.length) {
                String sum = this.computeSum(theBAs[i]);
                this.addToTable(String.valueOf(theBAs[i].getName()) + "_SUM", sum);
                ++i;
            }
        }
        if ((theBAs = (BaseAttribute[])this.getParameter("AttributesComputeCount")) != null) {
            i = 0;
            while (i < theBAs.length) {
                count = this.computeCount(theBAs[i]);
                this.addToTable(String.valueOf(theBAs[i].getName()) + "_COUNT", count);
                ++i;
            }
        }
        if ((theBAs = (BaseAttribute[])this.getParameter("AttributesComputeUnique")) != null) {
            i = 0;
            while (i < theBAs.length) {
                String unique = this.computeUnique(theBAs[i]);
                this.addToTable(String.valueOf(theBAs[i].getName()) + "_UNIQUE", unique);
                ++i;
            }
        }
        theBAs = (BaseAttribute[])this.getParameter("AttributesComputeDistrib");
        Value[] theDistribValues = (Value[])this.getParameter("DistribValues");
        if (theBAs != null && theBAs.length > 0 && theDistribValues == null || theBAs != null && theDistribValues != null && theBAs.length != theDistribValues.length) {
            throw new M4CompilerError("Operator SpecifiedStatistics: expected as many parameters 'DistribValues' as 'AttributesComputeDistrib'!");
        }
        if (theBAs != null) {
            int i2 = 0;
            while (i2 < theBAs.length) {
                String[] vals = this.getSingleValues(theDistribValues[i2]);
                int j = 0;
                while (j < vals.length) {
                    count = this.computeDistCount(theBAs[i2], vals[j]);
                    this.addToTable(String.valueOf(theBAs[i2].getName()) + "_" + vals[j], count);
                    ++j;
                }
                ++i2;
            }
        }
        this.createTable(this.getNewCSName());
        this.doPrint(12, "Operator SpecifiedStatistics is ready.");
        return this.getNewCSName();
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return true;
    }

    private void addToTable(String columnName, String value) throws M4CompilerError {
        Concept outC = this.getOutputConcept();
        Feature[] fs = outC.getFeatures();
        boolean found = false;
        int i = 0;
        while (i < fs.length) {
            if (fs[i].getName().equalsIgnoreCase(columnName)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            throw new M4CompilerError("Operator SpecifiedStatistics: TheOutputConcept must contain a BaseAttribute named '" + columnName + "'!");
        }
        this.columnNames.add(columnName);
        this.entries.add(value);
    }

    private void createTable(String tableName) throws M4CompilerError {
        try {
            this.getM4Db().dropBusinessTable(tableName);
            String create = "create table " + tableName + " (";
            int i = 0;
            while (i < this.columnNames.size()) {
                create = String.valueOf(create) + (String)this.columnNames.get(i) + " NUMBER, ";
                ++i;
            }
            create = String.valueOf(create.substring(0, create.length() - 2)) + ")";
            this.getM4Db().executeBusinessSqlWrite(create);
            String insert = "insert into " + tableName + " values (";
            int i2 = 0;
            while (i2 < this.entries.size()) {
                insert = String.valueOf(insert) + (String)this.entries.get(i2) + ", ";
                ++i2;
            }
            insert = String.valueOf(insert.substring(0, insert.length() - 2)) + ")";
            this.getM4Db().executeBusinessSqlWrite(insert);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not create table with the computed values, SQL error: " + sqle.getMessage());
        }
        this.getM4Db().addTableToTrash(tableName, this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
    }

    private String[] getSingleValues(Value v) {
        String s = v.getValue();
        StringTokenizer st = new StringTokenizer(s, ", ");
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = st.nextToken();
            ++i;
        }
        return ret;
    }

    private String computeSum(BaseAttribute sumBA) throws M4CompilerError {
        Column c = sumBA.getCurrentColumn();
        String sum = null;
        try {
            sum = this.getM4Db().computeSum(c);
            if (sum == null) {
                this.doPrint(12, "Warning: Operator SpecifiedStatistics: output table contains NULL values!");
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not compute sum of values for BaseAttribute '" + sumBA.getName() + "', SQL error: " + sqle.getMessage());
        }
        return sum;
    }

    private String computeCount(BaseAttribute countBA) throws M4CompilerError {
        Column c = countBA.getCurrentColumn();
        Columnset cs = c.getColumnSet();
        String count = null;
        try {
            count = this.getM4Db().readOrComputeCount(cs);
            if (count == null) {
                this.doPrint(12, "Warning: Operator SpecifiedStatistics: output table contains NULL values!");
            }
        }
        catch (M4CompilerError m4e) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not compute count of entries for BaseAttribute '" + countBA.getName() + "', error: " + m4e.getMessage());
        }
        return count;
    }

    private String computeUnique(BaseAttribute uniqueBA) throws M4CompilerError {
        Column c = uniqueBA.getCurrentColumn();
        String un = null;
        try {
            un = this.getM4Db().computeNumberOfDistinctElements(c);
            if (un == null) {
                this.doPrint(12, "Warning: Operator SpecifiedStatistics: output table contains NULL values!");
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not compute number of distinct entries for BaseAttribute '" + uniqueBA.getName() + "', SQL error: " + sqle.getMessage());
        }
        return un;
    }

    private String computeDistCount(BaseAttribute distBA, String value) throws M4CompilerError {
        Column c = distBA.getCurrentColumn();
        String d = null;
        try {
            d = this.getM4Db().computeNumberOfElementsForValue(c, value);
            if (d == null) {
                this.doPrint(12, "Warning: Operator SpecifiedStatistics: output table contains NULL values!");
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not compute distribution count, for BaseAttribute '" + distBA.getName() + "' and distribution value '" + value + "', SQL error: " + sqle.getMessage());
        }
        return d;
    }
}

