/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Value;
import miningmart.compiler.ValueCount;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.Segmentation;
import miningmart.compiler.utils.DB;

public final class SegmentationStratified
extends Segmentation {
    private Value[] distribution;

    public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
        Column theColumn = this.getTheAttribute().getCurrentColumn();
        if (this.distribution == null) {
            if (this.getTheAttribute().getConceptualDataType() != 7L && this.getTheAttribute().getConceptualDataType() != 9L) {
                this.distribution = this.getM4Db().getDistinctElements(theColumn);
            } else {
                try {
                    this.doPrint(12, "Computing value distribution for TheAttribute for SegmentationStratified...");
                    this.getM4Db().updateColumnStatistics(theColumn, this.getTheAttribute().getConceptualDataType());
                    theColumn.readStatisticsFromDB();
                    ValueCount[] distrib = theColumn.getValueDistribution();
                    this.distribution = new Value[distrib.length];
                    int i = 0;
                    while (i < distrib.length) {
                        this.distribution[i] = new Value(this.getM4Db());
                        this.distribution[i].setValue(distrib[i].getValue());
                        ++i;
                    }
                }
                catch (SQLException sqle) {
                    throw new M4CompilerError("SegmentationStratified: error when computing statistics for TheAttribute's column: " + sqle.getMessage());
                }
            }
        }
        if (this.distribution.length == 0) {
            throw new M4CompilerError("Error in SegmentationStratified: no values found for segmenting column!");
        }
        if (columnSetIndex < 0 || columnSetIndex >= this.distribution.length) {
            throw new M4CompilerError("Error in SegmentationStratified: wrong index for ColumnSet condition!");
        }
        Value oneValue = this.distribution[columnSetIndex];
        String curr = oneValue.getValue();
        if (this.getTheAttribute().getConceptualDataType() != 7L && this.getTheAttribute().getConceptualDataType() != 9L) {
            curr = DB.quote(curr);
        }
        String sqlCondition = String.valueOf(theColumn.getSQLDefinition()) + " = " + curr;
        return sqlCondition;
    }

    public BaseAttribute getTheAttribute() {
        return (BaseAttribute)this.getSingleParameter("TheAttribute");
    }

    public int numberOfSegments() throws M4CompilerError {
        Columnset inCS = this.getInputConcept().getCurrentColumnSet();
        Column theColumn = this.getTheAttribute().getCurrentColumn();
        if (theColumn == null) {
            throw new M4CompilerError("Operator SegmentationStratified: could not find the Column for parameter TheAttribute ('" + this.getTheAttribute().getName() + "') that belongs to the current ColumnSet '" + inCS.getName() + "'!");
        }
        this.distribution = this.getM4Db().getDistinctElements(theColumn);
        if (this.distribution == null) {
            return 0;
        }
        return this.distribution.length;
    }

    public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError {
        String sqlDef = SegmentationStratified.unBracket(cs.getSQLDefinition());
        String value = SegmentationStratified.lastAssignmentValue(sqlDef);
        cs.addMultiStepBranchInfo(inputMultiStepBranch, this.getTheAttribute().getName(), value);
    }

    private static String unBracket(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String lastAssignmentValue(String s) {
        if (s == null) {
            return null;
        }
        int eqIdx = s.lastIndexOf(61);
        s = eqIdx != -1 ? s.substring(eqIdx + 1).trim() : "";
        return s;
    }
}

