/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import miningmart.compiler.Columnset;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.Segmentation;
import miningmart.compiler.utils.DB;

public final class SegmentationByPartitioning
extends Segmentation {
    private static final String MULTISTEPBRANCH_ATTRIBUTE = "(Random)";

    public String generateSQLDefinition(String selectPart, int index) throws M4CompilerError {
        int howMany = new Integer(this.getHowManyPartitions().getValue());
        int curr = index + 1;
        String artCol = this.getArtificalColumnName(selectPart);
        String random = " m4randomnr(" + DB.getRandomSeedNr() + ", ROWNUM, " + howMany + ")";
        String viewDef = "(select * from (select " + selectPart + ", " + random + " " + artCol + " from " + this.getInputConcept().getCurrentColumnSet().getSchemaPlusName() + ") where " + artCol + " = " + curr + ")";
        return viewDef;
    }

    public String generateConditionForOp(int columnSetIndex) throws M4CompilerError {
        return null;
    }

    public Value getHowManyPartitions() {
        return (Value)this.getSingleParameter("HowManyPartitions");
    }

    public int numberOfSegments() throws M4CompilerError {
        try {
            return Integer.parseInt(this.getHowManyPartitions().getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SegmentationByPartitioning: Parameter 'HowManyPartitions' must be an integer!");
        }
    }

    public void setCSSegmentInfo(String inputMultiStepBranch, Columnset cs, int index) throws M4CompilerError {
        cs.addMultiStepBranchInfo(inputMultiStepBranch, MULTISTEPBRANCH_ATTRIBUTE, Integer.toString(index));
    }
}

