/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.utils.DB;
import miningmart.compiler.utils.Print;

public abstract class SVM_Wrapper {
    public static final long DEFAULTSAMPLESIZE = 10000L;
    protected long sampleSize;
    protected final DB databaseObj;
    protected final Print pr;
    protected final String dbPrefix;
    protected String lossPos;
    protected String lossNeg;
    protected String[][] symbolsForBooleanValues;
    protected Vector implementationalColumnTypes;
    private Vector theKernelParams;
    protected String targetColSQLDefinition;
    protected String schema;
    protected String inputTableName;
    protected long myStepId;
    protected String targetPositive = null;
    protected boolean forClassification;
    protected double b;
    protected double xiAlphaEstimation;
    protected int noSV;

    public SVM_Wrapper(DB databaseObj, Print printObj, String nameForDatabaseUse, long stepId) throws M4CompilerError {
        this.databaseObj = databaseObj;
        this.pr = printObj;
        this.dbPrefix = nameForDatabaseUse;
        this.myStepId = stepId;
        this.xiAlphaEstimation = 0.0;
        if (this.getDatabaseObj() == null) {
            throw new M4CompilerError("Error in Support Vector Machine: got invalid db connection (null).");
        }
        this.lossPos = null;
        this.lossNeg = null;
    }

    public abstract void callSVM(String var1, String var2, long var3, String var5, String var6, String var7, Vector var8) throws M4CompilerError;

    public double getXiAlphaEstimation() {
        return this.xiAlphaEstimation;
    }

    public int getNumberOfSupportVectors() {
        return this.noSV;
    }

    protected abstract void extractXiAlpha() throws M4CompilerError;

    protected abstract void extractNumberSV() throws M4CompilerError;

    protected String[] checkForConversion(String tableNameInputConcept, long conceptId, Vector colNamesPredictingAttribs, String colNameTargetAttrib, Vector convertThisColumn) throws M4CompilerError {
        ResultSet rs;
        if (colNamesPredictingAttribs.isEmpty()) {
            throw new M4CompilerError("SVM wrapper: set of attributes to predict from is empty!");
        }
        if (tableNameInputConcept.indexOf(".") <= -1) {
            throw new M4CompilerError("SVM wrapper: did not find schema name!");
        }
        this.schema = tableNameInputConcept.substring(0, tableNameInputConcept.indexOf("."));
        String tableName = tableNameInputConcept.substring(tableNameInputConcept.indexOf(".") + 1);
        String sql_getMetadata = "SELECT col_id, col_sql, SUBSTR(col_name,1,100), SUBSTR(condt_name,1,100), SUBSTR(coldt_name,1,100), cs_type, cs_schema, cs_name FROM columnset_t, baseattrib_t, column_t, con_datatype_T, col_datatype_t, ba_column_t, ba_concept_t WHERE cs_name = '" + tableName + "' AND " + "bc_conid = " + conceptId + " AND " + "cs_conid = bc_conid AND bc_baid = bac_baid AND bac_colid = col_id AND " + "cs_id = col_csid AND col_coldtid = coldt_id AND ba_condtid = condt_id AND bc_baid = ba_id";
        this.inputTableName = tableName;
        try {
            rs = this.getDatabaseObj().executeM4SqlRead(sql_getMetadata);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM wrapper: could not read metadata: " + sqle.getMessage());
        }
        int numberOfLearnAttribs = colNamesPredictingAttribs.size();
        convertThisColumn.setSize(numberOfLearnAttribs + 1);
        this.implementationalColumnTypes = new Vector(numberOfLearnAttribs + 1);
        String[] stringsToSelectColumns = new String[numberOfLearnAttribs + 1];
        this.symbolsForBooleanValues = new String[2][numberOfLearnAttribs + 1];
        int i = 0;
        while (i < numberOfLearnAttribs + 1) {
            convertThisColumn.set(i, null);
            this.implementationalColumnTypes.add(null);
            stringsToSelectColumns[i] = null;
            this.symbolsForBooleanValues[0][i] = "-1";
            this.symbolsForBooleanValues[1][i] = "1";
            ++i;
        }
        convertThisColumn.trimToSize();
        this.implementationalColumnTypes.trimToSize();
        int attNr = -1;
        boolean someColumnsRead = false;
        this.targetColSQLDefinition = null;
        try {
            while (rs.next()) {
                String columnId = rs.getString("col_id");
                String columnSQL = rs.getString("col_sql");
                String columnName = rs.getString("SUBSTR(col_name,1,100)");
                String conceptualType = rs.getString("SUBSTR(condt_name,1,100)");
                String columnType = rs.getString("SUBSTR(coldt_name,1,100)");
                String colSetType = rs.getString("cs_type");
                this.checkColSetType(colSetType);
                if (columnSQL == null || columnSQL.equals("")) {
                    columnSQL = columnName;
                }
                someColumnsRead = true;
                if (columnName.equalsIgnoreCase(colNameTargetAttrib)) {
                    attNr = numberOfLearnAttribs;
                    this.targetColSQLDefinition = columnSQL;
                    if (this.forClassification && !conceptualType.equalsIgnoreCase("BINARY")) {
                        throw new M4CompilerError("SVM wrapper: Error with target attribute: must be binary for SVM_CL!");
                    }
                } else {
                    attNr = -1;
                    boolean found = false;
                    while (attNr < numberOfLearnAttribs - 1 && !found) {
                        if (!((String)colNamesPredictingAttribs.get(++attNr)).equalsIgnoreCase(columnName)) continue;
                        found = true;
                    }
                    if (!found) continue;
                }
                if (conceptualType.equalsIgnoreCase("SCALAR") || conceptualType.equalsIgnoreCase("TIME") || conceptualType.equalsIgnoreCase("NUMERIC")) {
                    stringsToSelectColumns[attNr] = columnType.equalsIgnoreCase("DATE") ? "to_number(to_char(" + columnSQL + ", 'J'))" : columnSQL;
                    convertThisColumn.set(attNr, null);
                    this.implementationalColumnTypes.set(attNr, columnType);
                    continue;
                }
                if (conceptualType.equalsIgnoreCase("BINARY")) {
                    if (columnType.equalsIgnoreCase("VARCHAR")) {
                        convertThisColumn.set(attNr, columnId);
                    } else {
                        convertThisColumn.set(attNr, null);
                    }
                    stringsToSelectColumns[attNr] = columnSQL;
                    this.implementationalColumnTypes.set(attNr, columnType);
                    continue;
                }
                return null;
            }
            rs.close();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM wrapper: could not read metadata: " + sqle.getMessage());
        }
        if (!someColumnsRead) {
            throw new M4CompilerError("SVM wrapper: no metadata found!");
        }
        if (this.targetColSQLDefinition == null) {
            throw new M4CompilerError("SVM wrapper: could not find target column with given name '" + colNameTargetAttrib + "'!");
        }
        return stringsToSelectColumns;
    }

    protected String getSampleRatio(long maxSample, String tableName) throws M4CompilerError {
        if (maxSample <= 0L) {
            throw new M4CompilerError("Wrapper for SupportVectorMachine: Sample Size must be positive! Found: " + maxSample + ".");
        }
        String sql_getNumberOfRecords = "SELECT count(*) FROM " + tableName + " WHERE " + this.targetColSQLDefinition + " is not null";
        long count = 0L;
        try {
            Long countL = this.getDatabaseObj().executeBusinessSingleValueSqlReadL(sql_getNumberOfRecords);
            if (countL == null) {
                throw new M4CompilerError("Wrapper for SVM: Could not read result from query: " + sql_getNumberOfRecords);
            }
            count = countL;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Wrapper for SVM: Could not read result from query: " + sql_getNumberOfRecords + ", Database problem: " + sqle.getMessage());
        }
        if (maxSample > count) {
            maxSample = count;
        }
        double sampleRatio = (double)maxSample / (double)count;
        String integerSampleRatio = Double.toString(sampleRatio *= 1000000.0);
        if (integerSampleRatio.indexOf(".") > -1) {
            integerSampleRatio = integerSampleRatio.substring(0, integerSampleRatio.indexOf("."));
        }
        return integerSampleRatio;
    }

    protected void createDecisionFunctionAsSQL_Function(String kernelType, Vector colNamesPredictingAttribs, Vector columnsToConvert) throws M4CompilerError {
        String theFunction = this.createDecisionFunctionTemplate(colNamesPredictingAttribs, columnsToConvert);
        String declaration = this.createDeclaration(kernelType, colNamesPredictingAttribs);
        if (declaration == null) {
            throw new M4CompilerError("Error: null-declaration in SQL decision function; check kernel type!");
        }
        String body = this.createBody(kernelType, colNamesPredictingAttribs);
        if (body == null) {
            throw new M4CompilerError("Error trying to create body of SQL decision function; check kernel type!");
        }
        theFunction = this.replace(theFunction, "$DECLARATION", declaration);
        theFunction = this.replace(theFunction, "$BODY", body);
        this.insertFunctionIntoDB(theFunction);
    }

    protected String createDeclaration(String kernelType, Vector colNamesPredictingAttribs) {
        Vector colNamesInput = this.getColNamesInput(colNamesPredictingAttribs);
        String declaration = "    CURSOR supportvectors IS\n      SELECT ";
        int i = 0;
        while (i < colNamesInput.size()) {
            declaration = String.valueOf(declaration) + (String)colNamesInput.get(i) + ", ";
            ++i;
        }
        declaration = String.valueOf(declaration) + "Alpha FROM " + this.getModelTablePlusCondition() + ";\n";
        declaration = String.valueOf(declaration) + "    currentrow supportvectors%ROWTYPE;\n";
        declaration = String.valueOf(declaration) + "    kernel NUMBER;\n";
        declaration = String.valueOf(declaration) + "    inner NUMBER;\n";
        return declaration;
    }

    protected String createBody(String kernelType, Vector colNamesPredictingAttribs) throws M4CompilerError {
        String body = null;
        String param1 = null;
        String param2 = null;
        int dimension = colNamesPredictingAttribs.size();
        if (kernelType.equalsIgnoreCase("dot") && this.theKernelParams != null || (kernelType.equalsIgnoreCase("polynomial") || kernelType.equalsIgnoreCase("radial")) && this.theKernelParams.size() != 1 || (kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("anova")) && this.theKernelParams.size() != 2) {
            throw new M4CompilerError("SVM Wrapper error: Found wrong number of kernel parameters!");
        }
        if (!kernelType.equalsIgnoreCase("dot")) {
            String params = (String)this.theKernelParams.get(0);
            StringTokenizer st = new StringTokenizer(params);
            if (!st.hasMoreTokens()) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            params = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            param1 = st.nextToken();
            try {
                Double.parseDouble(param1);
            }
            catch (NumberFormatException nfe) {
                throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
            }
            if (kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("anova")) {
                params = (String)this.theKernelParams.get(1);
                st = new StringTokenizer(params);
                if (!st.hasMoreTokens()) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
                params = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
                param2 = st.nextToken();
                try {
                    Double.parseDouble(param2);
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("Error: wrong parameter declaration for mySVM.");
                }
            }
        }
        String operator = null;
        Vector colNamesInput = this.getColNamesInput(colNamesPredictingAttribs);
        operator = kernelType.equalsIgnoreCase("polynomial") || kernelType.equalsIgnoreCase("neural") || kernelType.equalsIgnoreCase("dot") ? " * " : " - ";
        body = "    retValue := 0;\n";
        body = String.valueOf(body) + "    FOR currentrow IN supportvectors\n    LOOP\n      inner := ";
        String component = null;
        int i = 0;
        while (i < dimension) {
            component = !this.symbolsForBooleanValues[0][i].equals("-1") ? "(currentrow." + (String)colNamesInput.get(i) + operator + "help" + i + ")" : (((String)this.implementationalColumnTypes.get(i)).equalsIgnoreCase("DATE") ? "(currentrow." + (String)colNamesInput.get(i) + operator + "help" + i + i + ")" : "(currentrow." + (String)colNamesInput.get(i) + operator + "X_" + (String)colNamesPredictingAttribs.get(i) + ")");
            body = kernelType.equalsIgnoreCase("radial") ? String.valueOf(body) + component + " * " + component : (kernelType.equalsIgnoreCase("anova") ? String.valueOf(body) + "EXP( -" + param1 + " * " + component + ")" : String.valueOf(body) + component);
            if (i < dimension - 1) {
                body = String.valueOf(body) + "\n               + ";
            }
            ++i;
        }
        if (kernelType.equalsIgnoreCase("polynomial")) {
            body = String.valueOf(body) + ";\n      kernel := POWER(inner + 1, " + param1 + ") ";
        }
        if (kernelType.equalsIgnoreCase("neural")) {
            body = String.valueOf(body) + ";\n      kernel := TANH(inner * " + param1 + " + " + param2 + ") ";
        }
        if (kernelType.equalsIgnoreCase("dot")) {
            body = String.valueOf(body) + ";\n      kernel := inner ";
        }
        if (kernelType.equalsIgnoreCase("radial")) {
            body = String.valueOf(body) + ";\n      kernel := EXP( -(" + param1 + ") * inner) ";
        }
        if (kernelType.equalsIgnoreCase("anova")) {
            body = String.valueOf(body) + ";\n      kernel := POWER(inner, " + param2 + ") ";
        }
        body = String.valueOf(body) + "* currentrow.Alpha;\n";
        body = String.valueOf(body) + "      retValue := retValue + kernel;\n";
        body = String.valueOf(body) + "    END LOOP;\n";
        body = String.valueOf(body) + "    retValue := retValue + (" + this.b + ");\n";
        return body;
    }

    protected void insertFunctionIntoDB(String theFunction) throws M4CompilerError {
        try {
            DB db = this.getDatabaseObj();
            db.executeBusinessSqlWrite(theFunction);
            db.commitBusinessTransactions();
            db.addFunctionToTrash(this.getDecisionFunctionName(), this.schema, this.myStepId);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SVM wrapper: Error trying to insert SQL result function into database: " + sqle.getMessage());
        }
    }

    protected String replace(String theString, String searchFor, String replaceBy) {
        int i = theString.indexOf(searchFor);
        String newString = "";
        int b = 0;
        while (i > -1) {
            newString = String.valueOf(newString) + theString.substring(b, i);
            newString = String.valueOf(newString) + replaceBy;
            b = i + searchFor.length();
            i = theString.indexOf(searchFor, b);
        }
        if (b < theString.length()) {
            newString = String.valueOf(newString) + theString.substring(b);
        }
        return newString;
    }

    protected String createDecisionFunctionTemplate(Vector colNamesPredictingAttribs, Vector columnsToConvert) throws M4CompilerError {
        int dimension = colNamesPredictingAttribs.size();
        if (columnsToConvert.size() != colNamesPredictingAttribs.size() + 1 || columnsToConvert.size() != this.implementationalColumnTypes.size()) {
            throw new M4CompilerError("Error: could not create decision function in SQL: parameter mismatch.");
        }
        String theFunction = "CREATE OR REPLACE function " + this.getDecisionFunctionName() + "\n(\n";
        int i = 0;
        while (i < dimension) {
            theFunction = String.valueOf(theFunction) + "X_" + (String)colNamesPredictingAttribs.get(i) + " IN " + (String)this.implementationalColumnTypes.get(i);
            if (i < dimension - 1) {
                theFunction = String.valueOf(theFunction) + ",\n";
            }
            ++i;
        }
        theFunction = String.valueOf(theFunction) + "\n)\nRETURN " + ((String)this.implementationalColumnTypes.lastElement()).toUpperCase() + "\nAS\n";
        theFunction = String.valueOf(theFunction) + "BEGIN\n";
        theFunction = String.valueOf(theFunction) + "  DECLARE\n";
        theFunction = String.valueOf(theFunction) + "    retValue NUMBER;\n";
        i = 0;
        while (i < dimension) {
            if (!this.symbolsForBooleanValues[0][i].equals("-1")) {
                theFunction = String.valueOf(theFunction) + "    help" + i + " NUMBER;\n";
            }
            if (((String)this.implementationalColumnTypes.get(i)).equalsIgnoreCase("DATE")) {
                theFunction = String.valueOf(theFunction) + "    help" + i + i + " NUMBER;\n";
            }
            ++i;
        }
        theFunction = String.valueOf(theFunction) + "$DECLARATION\n";
        theFunction = String.valueOf(theFunction) + "  BEGIN\n";
        i = 0;
        while (i < dimension) {
            if (!this.symbolsForBooleanValues[0][i].equals("-1")) {
                theFunction = String.valueOf(theFunction) + "    IF X_" + (String)colNamesPredictingAttribs.get(i) + " = '" + this.symbolsForBooleanValues[0][i] + "'\n" + "      THEN help" + i + " := -1;\n";
                theFunction = String.valueOf(theFunction) + "    ELSIF X_" + (String)colNamesPredictingAttribs.get(i) + " = '" + this.symbolsForBooleanValues[1][i] + "'\n" + "      THEN help" + i + " := 1;\n    END IF;\n";
            }
            if (((String)this.implementationalColumnTypes.get(i)).equalsIgnoreCase("DATE")) {
                theFunction = String.valueOf(theFunction) + "    help" + i + i + " := to_number(to_char(X_" + (String)colNamesPredictingAttribs.get(i) + ", 'J'));\n";
            }
            ++i;
        }
        theFunction = String.valueOf(theFunction) + "\n$BODY\n";
        theFunction = this.forClassification ? String.valueOf(theFunction) + "    IF (retValue > 0)\n      THEN RETURN 1;\n    END IF;\n    RETURN -1;\n" : String.valueOf(theFunction) + "    RETURN retValue;\n";
        theFunction = String.valueOf(theFunction) + "  END;\n";
        theFunction = String.valueOf(theFunction) + "END;\n";
        return theFunction;
    }

    protected String checkDouble(String test) throws M4CompilerError {
        int a = test.indexOf(",");
        if (a > -1) {
            String pre = test.substring(0, a);
            String post = test.substring(a + 1);
            test = String.valueOf(pre) + "." + post;
        }
        if (test.startsWith(".")) {
            test = "0" + test;
        }
        try {
            Double.parseDouble(test);
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SVM wrapper: Error trying to convert '" + test + "' into double.");
        }
        return test;
    }

    protected void setPositiveTargetValue(String posValue) {
        this.targetPositive = posValue;
    }

    protected String getPositiveTargetValue() {
        return this.targetPositive;
    }

    protected abstract void checkKernel(String var1) throws M4CompilerError;

    protected abstract String getModelTablePlusCondition();

    protected abstract Vector getColNamesInput(Vector var1);

    protected abstract void checkColSetType(String var1) throws M4CompilerError;

    protected DB getDatabaseObj() {
        return this.databaseObj;
    }

    protected String getParTableName() {
        return String.valueOf(this.dbPrefix) + "_PAR";
    }

    protected String getLogTableName() {
        return String.valueOf(this.dbPrefix) + "_LOG";
    }

    protected String getOutputViewName() {
        return String.valueOf(this.dbPrefix) + "_OUT";
    }

    protected String getInputViewName() {
        return String.valueOf(this.dbPrefix) + "_IN";
    }

    protected String getModelTableName() {
        return String.valueOf(this.dbPrefix) + "_MOD";
    }

    public String getDecisionFunctionName() {
        return String.valueOf(this.dbPrefix) + "_F";
    }

    protected Print getPrint() {
        return this.pr;
    }

    protected Vector getKernelParams(String kern) {
        this.theKernelParams = new Vector();
        if (kern.toLowerCase().equals("dot")) {
            this.theKernelParams = null;
            return null;
        }
        if (kern.toLowerCase().equals("polynomial")) {
            this.theKernelParams.add("degree 2");
        }
        if (kern.toLowerCase().equals("neural")) {
            this.theKernelParams.add("a 0.5");
            this.theKernelParams.add("b 0.5");
        }
        if (kern.toLowerCase().equals("radial")) {
            this.theKernelParams.add("gamma 0.1");
        }
        if (kern.toLowerCase().equals("anova")) {
            this.theKernelParams.add("gamma 0.1");
            this.theKernelParams.add("degree 2");
        }
        this.theKernelParams.trimToSize();
        return this.theKernelParams;
    }

    protected String getArtificalColumnName(String otherColumns) {
        String artCol = "Z";
        while (otherColumns.indexOf(String.valueOf(artCol) + ",") > -1) {
            artCol = String.valueOf(artCol) + "1";
        }
        return artCol;
    }
}

