/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.RowSelection;
import miningmart.compiler.utils.DB;

public final class RowSelectionByRandomSampling
extends RowSelection {
    private String colNames;
    private String colNamesWithDefs;

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String artCol = this.getArtificalColumnName(selectPart);
        this.makeListsOfColumns();
        String viewDef = "(select " + this.colNames + " from " + "(select " + selectPart + ", " + this.generateRandomCall() + " " + artCol + " from " + this.getInputConcept().getCurrentColumnSet().getName() + ") where " + artCol + " = 1)";
        String sql_create = "CREATE TABLE " + this.getNewCSName() + " (" + this.colNamesWithDefs + ")";
        String sql_insert = "INSERT INTO " + this.getNewCSName() + " " + viewDef;
        try {
            this.getM4Db().dropBusinessTable(this.getNewCSName());
            this.getM4Db().executeBusinessSqlWrite(sql_create);
            this.getM4Db().executeBusinessSqlWrite(sql_insert);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("RowSelectionByRandomSampling: could not create sample table: " + sqle.getMessage());
        }
        this.getM4Db().addTableToTrash(this.getNewCSName(), this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("RowSelectionByRandomSampling: could not commit to M4: " + sqle.getMessage());
        }
        return this.getNewCSName();
    }

    public String generateConditionForOp() {
        return null;
    }

    private void makeListsOfColumns() throws M4CompilerError {
        Feature[] outF = this.getOutputConcept().getFeatures();
        this.colNames = "";
        this.colNamesWithDefs = "";
        this.colNames = "";
        this.colNamesWithDefs = "";
        int i = 0;
        while (i < outF.length) {
            Feature fIn;
            int iIn = 0;
            do {
                fIn = this.getInputConcept().getFeature(iIn);
            } while (++iIn < this.getInputConcept().getFeatures().length && !outF[i].correspondsTo(fIn));
            if (outF[i].correspondsTo(fIn) && !this.isDeselectedParameter(fIn)) {
                Column col;
                if (fIn instanceof BaseAttribute) {
                    col = ((BaseAttribute)fIn).getCurrentColumn();
                    this.colNames = String.valueOf(this.colNames) + col.getName() + ", ";
                    this.colNamesWithDefs = String.valueOf(this.colNamesWithDefs) + col.getName() + " " + this.determineDBTypeOfColumn(col) + ", ";
                } else {
                    if (!(fIn instanceof MultiColumnFeature)) {
                        throw new M4CompilerError("Unknown Feature type found in Concept with id: " + this.getInputConcept().getId() + "; Feature id: " + fIn.getId());
                    }
                    MultiColumnFeature mcf = (MultiColumnFeature)fIn;
                    BaseAttribute[] theBAs = mcf.getBaseAttributes();
                    if (theBAs != null) {
                        try {
                            int j = 0;
                            while (j < theBAs.length) {
                                col = theBAs[j].getCurrentColumn();
                                this.colNames = String.valueOf(this.colNames) + col.getName() + ", ";
                                this.colNamesWithDefs = String.valueOf(this.colNamesWithDefs) + col.getName() + " " + this.determineDBTypeOfColumn(col) + ", ";
                                ++j;
                            }
                        }
                        catch (NullPointerException nfe) {
                            throw new M4CompilerError("RowSelectionByRandomSampling: Mismatch between MultiColumnFeatures in in- and output concept!");
                        }
                        catch (ArrayIndexOutOfBoundsException aie) {
                            throw new M4CompilerError("RowSelectionByRandomSampling: Mismatch between MultiColumnFeatures in in- and output concept!");
                        }
                    }
                }
            }
            ++i;
        }
        this.colNames = this.colNames.substring(0, this.colNames.length() - 2);
        this.colNamesWithDefs = this.colNamesWithDefs.substring(0, this.colNamesWithDefs.length() - 2);
    }

    private String determineDBTypeOfColumn(Column col) throws M4CompilerError {
        if (col.getColumnDataType() == 12L) {
            return "NUMBER";
        }
        if (col.getColumnDataType() == 13L || col.getColumnDataType() == 15L) {
            return "VARCHAR2(500)";
        }
        if (col.getColumnDataType() == 14L) {
            return "DATE";
        }
        throw new M4CompilerError("RowSelectionByRandomSampling: found column with unknown datatype; column id: " + col.getId());
    }

    private String generateRandomCall() throws M4CompilerError {
        long size = this.getHowMany();
        Columnset cs = this.getInputConcept().getCurrentColumnSet();
        int count = cs.getStatisticsAll();
        if (count == 0) {
            count = Integer.parseInt(this.getM4Db().readOrComputeCount(cs));
        }
        if (count == 0) {
            throw new M4CompilerError("Operator RowSelectionByRandomSampling: No rows found in input concept!");
        }
        long randomFactor = size * 1000000L / (long)count;
        String sqlCondition = " m4randomselect(" + DB.getRandomSeedNr() + ", ROWNUM, " + randomFactor + ")";
        return sqlCondition;
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    public int getHowMany() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("HowMany");
        try {
            return Integer.parseInt(v.getValue());
        }
        catch (NumberFormatException e) {
            throw new M4CompilerError("Parameter 'HowMany' of Operator RowSelectionByRandomSampling does not contain an integer value: " + v.getValue());
        }
        catch (NullPointerException e) {
            throw new M4CompilerError("Parameter 'HowMany' of Operator RowSelectionByRandomSampling not found!");
        }
    }
}

