/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.M4Object;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.OpParam;
import miningmart.compiler.Parameter;
import miningmart.compiler.Relation;
import miningmart.compiler.Step;
import miningmart.compiler.Value;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.exception.ParameterDeselectedError;
import miningmart.compiler.exception.ParameterError;
import miningmart.compiler.exception.ParameterNotFoundException;

public abstract class Operator
extends M4Object {
    protected Step myStep;
    protected boolean loopable;
    protected boolean stepable;
    protected boolean manual;
    protected String realize;
    protected String[] generatedSQLDefinitions;
    private Vector myOpParams;
    private final ParamDict myParameters = new ParamDict();
    private int numberOfLoops = -1;
    private static final HashMap opParamsForOpIDs = new HashMap();

    public void load(Step st) throws M4CompilerError {
        try {
            this.myId = st.getOperatorId();
            this.myStep = st;
            this.setM4DB(st.getM4Db());
            this.getM4Db().readOperatorFromDB(this);
            this.autoLoad();
            this.removeDeselectedParameters();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator '" + this.myName + "': error when loading operator: " + sqle.getMessage());
        }
    }

    public Iterator getOpParamsIterator() throws M4CompilerError {
        if (this.myOpParams == null) {
            Long opId = new Long(this.getId());
            this.myOpParams = (Vector)opParamsForOpIDs.get(opId);
            if (this.myOpParams == null) {
                try {
                    this.myOpParams = this.getM4Db().readOpParamsForOp(this);
                }
                catch (SQLException sqle) {
                    throw new M4CompilerError("Operator '" + this.myName + "': error when loading from OP_PARAM_T for operator: " + sqle.getMessage());
                }
                opParamsForOpIDs.put(opId, this.myOpParams);
            }
        }
        return ((AbstractList)this.myOpParams).iterator();
    }

    /*
     * Unable to fully structure code
     */
    private void autoLoad() throws M4CompilerError {
        it = this.getOpParamsIterator();
        block4: while (it.hasNext()) {
            block9: {
                op = (OpParam)it.next();
                if (op.getMinArg() == 0) {
                    try {
                        withoutLoop = this.loadParam(op, 0);
                        if (withoutLoop.length > 0 || this.getHighestLoopNr() <= 0) {
                            this.myParameters.put(op.getParamName(), withoutLoop);
                            continue;
                        }
                        loops = this.getHighestLoopNr() + 1;
                        i = 1;
                        while (i < loops) {
                            obj = this.loadParam(op, i);
                            this.myParameters.put(op.getParamName(), i, obj);
                            ++i;
                        }
                        continue;
                    }
                    catch (ParameterNotFoundException e) {
                        throw new M4CompilerError("Internal compiler error.'ParameterNotFound' exception was thrown for an optional parameter:\n" + e.getMessage());
                    }
                }
                try {
                    this.myParameters.put(op.getParamName(), this.loadParam(op, 0));
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    if (this.getHighestLoopNr() <= 0) break block9;
                    loops = this.getHighestLoopNr() + 1;
                    i = 1;
                    ** while (i < loops)
                }
lbl-1000:
                // 1 sources

                {
                    obj = this.loadParam(op, i);
                    this.myParameters.put(op.getParamName(), i, obj);
                    ++i;
                    continue;
lbl32:
                    // 1 sources

                    continue block4;
                }
            }
            throw e;
        }
    }

    private Parameter[] loadParam(OpParam op, int loopNr) throws M4CompilerError {
        Parameter[] ret = null;
        try {
            if (op.getMaxArg() == 1) {
                Parameter obj = this.loadSingleParam(op, loopNr);
                ret = (Parameter[])Array.newInstance(obj.getClass(), 1);
                ret[0] = obj;
            } else {
                ret = this.loadParamArray(op, loopNr);
            }
        }
        catch (ParameterError obj) {
        }
        catch (SQLException e) {
            this.throwParameterLoadException(loopNr, String.valueOf(op.getParamName()) + " caused an SQL-Exception:\n" + e.getMessage());
        }
        if (ret == null) {
            if (op.getMinArg() > 0) {
                this.throwParameterLoadException(loopNr, String.valueOf(op.getParamName()) + " not found.");
            } else {
                ret = this.createEmptyM4ObjArrayFor(op);
            }
        } else {
            if (ret.length < op.getMinArg()) {
                this.throwParameterLoadException(loopNr, String.valueOf(op.getParamName()) + " should be an Array of at least " + op.getMinArg() + " entries, but has only " + ret.length + " elements!");
            }
            if (op.getMaxArg() >= 0 && ret.length > op.getMaxArg()) {
                this.throwParameterLoadException(loopNr, String.valueOf(op.getParamName()) + " should be an Array of at most " + op.getMinArg() + " entries, but has " + ret.length + " elements!");
            }
        }
        return ret;
    }

    private Parameter loadSingleParam(OpParam op, int loopNr) throws M4CompilerError, SQLException {
        Parameter ret = null;
        String parName = op.getParamName();
        switch (op.getType()) {
            case 1: {
                ret = Parameter.loadConcept(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 2: {
                ret = Parameter.loadRelation(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 3: {
                ret = Parameter.loadBaseAttribute(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 4: {
                ret = Parameter.loadMultiColumnFeature(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 5: {
                try {
                    ret = Parameter.loadMultiColumnFeature(this, parName, loopNr, this.getM4Db());
                }
                catch (M4CompilerError e) {
                    ret = Parameter.loadBaseAttribute(this, parName, loopNr, this.getM4Db());
                }
                break;
            }
            case 6: {
                ret = Parameter.loadValue(this, parName, loopNr, this.getM4Db());
                break;
            }
            default: {
                this.throwParameterLoadException(loopNr, String.valueOf(parName) + " of unsupported type!");
            }
        }
        return ret;
    }

    private Parameter[] loadParamArray(OpParam op, int loopNr) throws M4CompilerError, SQLException {
        Parameter[] ret = null;
        String parName = op.getParamName();
        switch (op.getType()) {
            case 1: {
                ret = Parameter.loadConceptArray(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 2: {
                ret = Parameter.loadRelationArray(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 3: {
                ret = Parameter.loadBaseAttributeArray(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 4: {
                ret = Parameter.loadMultiColumnFeatureArray(this, parName, loopNr, this.getM4Db());
                break;
            }
            case 5: {
                try {
                    ret = Parameter.loadMultiColumnFeatureArray(this, parName, loopNr, this.getM4Db());
                }
                catch (M4CompilerError e) {
                    ret = Parameter.loadBaseAttributeArray(this, parName, loopNr, this.getM4Db());
                }
                break;
            }
            case 6: {
                ret = Parameter.loadValueArray(this, parName, loopNr, this.getM4Db());
                break;
            }
            default: {
                this.throwParameterLoadException(loopNr, String.valueOf(parName) + " of unsupported type!");
            }
        }
        return ret;
    }

    private Parameter[] createEmptyM4ObjArrayFor(OpParam op) throws ParameterError {
        Parameter[] ret = null;
        switch (op.getType()) {
            case 1: {
                ret = new Concept[]{};
                break;
            }
            case 2: {
                ret = new Relation[]{};
                break;
            }
            case 3: {
                ret = new BaseAttribute[]{};
                break;
            }
            case 4: {
                ret = new MultiColumnFeature[]{};
                break;
            }
            case 5: {
                ret = new Feature[]{};
                break;
            }
            case 6: {
                ret = new Value[]{};
                break;
            }
            default: {
                this.throwParameterLoadException(0, String.valueOf(op.getParamName()) + " of unsupported type!");
            }
        }
        return ret;
    }

    private void removeDeselectedParameters() throws M4CompilerError {
        Iterator it = this.getOpParamsIterator();
        ParameterDeselectedError e = null;
        while (it.hasNext()) {
            OpParam op = (OpParam)it.next();
            if (!op.isInput()) continue;
            String paramName = op.getParamName();
            int highestLoop = this.myParameters.isLooped(paramName) ? this.getHighestLoopNr() : 1;
            int i = 0;
            while (i < highestLoop) {
                Parameter[] newParam;
                Parameter[] oldParam = this.getParameter(paramName, i);
                if (oldParam.length != (newParam = this.removeDeselectedParameters(oldParam)).length) {
                    e = this.replaceParameterInCache(op, i, newParam, e);
                }
                ++i;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    private ParameterDeselectedError replaceParameterInCache(OpParam op, int loop, Parameter[] par, ParameterDeselectedError e) throws M4CompilerError {
        int length;
        this.myParameters.replace(op.getParamName(), loop, par);
        int n = length = par == null ? 0 : par.length;
        if (length < op.getMinArg()) {
            if (e == null) {
                String msg = "Loading parameters for operator " + this.getName() + ", step id: " + this.getStep().getId() + "\n" + "Due to deselection of features by FeatureSelection the " + "following parameters violate operator constraints:\n" + op.getParamName();
                e = new ParameterDeselectedError(msg, op);
            } else {
                e = new ParameterDeselectedError(op.getParamName(), op, e);
            }
        }
        return e;
    }

    private Parameter[] removeDeselectedParameters(Parameter[] m4o) throws M4CompilerError {
        if (m4o == null || m4o.length == 0) {
            return m4o;
        }
        Vector<Parameter> v = new Vector<Parameter>();
        int i = 0;
        while (i < m4o.length) {
            if (!this.isDeselectedParameter(m4o[i])) {
                v.add(m4o[i]);
            }
            ++i;
        }
        if (v.size() != m4o.length) {
            Parameter[] ret = (Parameter[])Array.newInstance(m4o.getClass().getComponentType(), v.size());
            return v.toArray(ret);
        }
        return m4o;
    }

    protected final boolean isDeselectedParameter(M4Object m4o) throws M4CompilerError {
        if (m4o instanceof BaseAttribute) {
            return this.isDeselectedBA((BaseAttribute)m4o);
        }
        if (m4o instanceof MultiColumnFeature) {
            return this.isDeselectedMCF((MultiColumnFeature)m4o);
        }
        return false;
    }

    private boolean isDeselectedBA(BaseAttribute ba) throws M4CompilerError {
        return ba == null || ba.getCurrentColumn() == null;
    }

    private boolean isDeselectedMCF(MultiColumnFeature mcf) throws M4CompilerError {
        if (mcf == null) {
            return true;
        }
        BaseAttribute[] bas = mcf.getBaseAttributes();
        int i = 0;
        while (i < bas.length) {
            if (this.isDeselectedBA(bas[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Parameter[] getParameter(String name) {
        return this.getParameter(name, 0);
    }

    public final Parameter[] getParameter(String name, int loopNr) {
        return this.myParameters.get(name, loopNr);
    }

    public final M4Object getSingleParameter(String name) {
        return this.getSingleParameter(name, 0);
    }

    public final M4Object getSingleParameter(String name, int loopNr) {
        Parameter[] array = this.getParameter(name, loopNr);
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    public final void autoPrint() {
        try {
            Iterator it = this.getOpParamsIterator();
            while (it.hasNext()) {
                String name = ((OpParam)it.next()).getParamName();
                M4Object[] par = this.myParameters.get(name);
                this.doPrint(4, "Parameter '" + name + "' :");
                if (par != null) {
                    this.printM4Object(par);
                    continue;
                }
                int i = 0;
                while (i < this.getHighestLoopNr()) {
                    par = this.myParameters.get(name, i + 1);
                    this.doPrint(4, "  loopnr." + i + 1 + ":");
                    this.printM4Object(par);
                    ++i;
                }
            }
        }
        catch (M4CompilerError e) {
            this.doPrint(20, "autoPrint() for operator " + this.getName() + ", id: " + this.getId() + " failed!\n" + e.getMessage());
        }
    }

    private void printM4Object(M4Object[] obj) {
        if (obj != null) {
            int i = 0;
            while (i < obj.length) {
                obj[i].print();
                ++i;
            }
        }
    }

    private void throwParameterLoadException(int loopNr, String restOfMessage) throws ParameterNotFoundException {
        String message = "Could not autoLoad() parameters for operator " + this.getName() + " in step " + this.getStep().getId();
        if (loopNr > 0) {
            message = String.valueOf(message) + ", loop nr." + loopNr;
        }
        message = String.valueOf(message) + " !\nParameter " + restOfMessage;
        throw new ParameterNotFoundException(message);
    }

    public final M4Object load(long id) throws SQLException, M4CompilerError {
        return this;
    }

    public void execute(boolean lazy) throws SQLException, M4CompilerError {
        this.print();
        this.createStatement(lazy);
        this.showCreateStatement();
        this.compileStatement();
        this.writeResults();
    }

    public final void print() {
        this.autoPrint();
    }

    public abstract void createStatement(boolean var1) throws SQLException, M4CompilerError;

    public void showCreateStatement() throws SQLException, M4CompilerError {
        if (this.generatedSQLDefinitions != null) {
            int i = 0;
            while (i < this.generatedSQLDefinitions.length) {
                this.doPrint(12, String.valueOf(this.getName()) + " generated: " + this.generatedSQLDefinitions[i]);
                ++i;
            }
        }
    }

    public abstract void compileStatement() throws SQLException, M4CompilerError;

    public abstract void writeResults() throws SQLException, M4CompilerError;

    public void setRealize(String r) {
        this.realize = r;
    }

    public String getRealize() {
        return this.realize;
    }

    public void setStep(Step s) {
        this.myStep = s;
    }

    public Step getStep() {
        return this.myStep;
    }

    public void setLoopable(boolean l) {
        this.loopable = l;
    }

    public boolean isLoopable() {
        return this.loopable;
    }

    public void setManual(boolean m) {
        this.manual = m;
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setStepable(boolean s) {
        this.stepable = s;
    }

    public boolean isStepable() {
        return this.stepable;
    }

    protected final int getHighestLoopNr() {
        if (this.numberOfLoops == -1) {
            this.numberOfLoops = this.getStep().getLoopCount();
        }
        return this.numberOfLoops;
    }

    protected String getArtificalColumnName(String otherColumns) {
        String artCol = "Z";
        while (otherColumns.indexOf(String.valueOf(artCol) + ",") > -1) {
            artCol = String.valueOf(artCol) + "1";
        }
        return artCol;
    }

    private class ParamDict {
        private final HashMap entries = new HashMap();
        private static final String LOOPNR_DELIMITER = " #";

        ParamDict() {
        }

        public void put(String paramName, Parameter[] theParameter) throws M4CompilerError {
            this.put(paramName, 0, theParameter);
        }

        public void put(String paramName, int loopNr, Parameter[] theParameter) throws M4CompilerError {
            if (theParameter == null) {
                throw new M4CompilerError("Operator.autoLoad() mechanism, internal class ParamDict:\nError - Operator tried to insert null into parameter dictionary!");
            }
            if (this.containsKey(paramName, 0)) {
                throw new M4CompilerError("Could not store parameter in autoLoad() of class Operator: Already loaded!");
            }
            if (loopNr > 1 && !this.containsKey(paramName, 1)) {
                throw new M4CompilerError("Could not store parameter in autoLoad() of class Operator:\nCan't store loop nr." + loopNr + " before storing loop nr.1!");
            }
            this.store(paramName, loopNr, theParameter);
        }

        public void replace(String paramName, int loopNr, Parameter[] theParameter) throws M4CompilerError {
            if (loopNr > 0 || this.isLooped(paramName)) {
                ++loopNr;
            }
            if (!this.remove(paramName, loopNr)) {
                throw new M4CompilerError("Could not replace parameter " + paramName + ", loopNr: " + loopNr + " in autoLoad() of class Operator:\nOld parameter value not found!");
            }
            this.store(paramName, loopNr, theParameter);
        }

        public boolean containsKey(String paramName) {
            return this.containsKey(paramName, 0) || this.containsKey(paramName, 1);
        }

        public boolean containsKey(String paramName, int loopNr) {
            return this.entries.containsKey(String.valueOf(paramName) + LOOPNR_DELIMITER + loopNr);
        }

        public Parameter[] get(String paramName) throws M4CompilerError {
            return this.get(paramName, 0);
        }

        public Parameter[] get(String paramName, int loopNr) {
            if (loopNr > 0 || this.isLooped(paramName)) {
                ++loopNr;
            }
            String key = String.valueOf(paramName) + LOOPNR_DELIMITER + loopNr;
            return (Parameter[])this.entries.get(key);
        }

        public boolean isLooped(String paramName) {
            return this.containsKey(paramName, 1) && !this.containsKey(paramName, 0);
        }

        private void store(String paramName, int loopNr, Parameter[] theParameter) {
            String key = String.valueOf(paramName) + LOOPNR_DELIMITER + loopNr;
            if (key.equalsIgnoreCase("MapInput #6")) {
                // empty if block
            }
            if (!this.entries.containsKey("MapInput #6")) {
                // empty if block
            }
            this.entries.put(key, theParameter);
        }

        private boolean remove(String paramName, int loopNr) {
            String key = String.valueOf(paramName) + LOOPNR_DELIMITER + loopNr;
            return this.entries.remove(key) != null;
        }
    }
}

