/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.sql.SQLException;
import miningmart.compiler.Column;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.ManualDiscretization;

public class NumericalIntervalManualDiscretization
extends ManualDiscretization {
    private String tableName;

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        if (this.getIntervalStart().length != this.getIntervalEnd().length || this.getIntervalEnd().length != this.getMapTo().length || this.getMapTo().length != this.getStartIncExc().length || this.getStartIncExc().length != this.getEndIncExc().length) {
            throw new M4CompilerError("NumericalIntervalManualDiscretization: Parameters lists IntervalStart, IntervalEnd, MapTo, StartIncExc and EndIncExc sizes must be equal!");
        }
    }

    private void createTable(String schema) throws M4CompilerError {
        this.tableName = "M4_DT_" + this.getStep().getId() + "_" + this.getCurrentLoopNumber();
        try {
            this.getM4Db().executeBusinessSqlWrite("DROP TABLE " + this.tableName);
        }
        catch (SQLException e) {
            this.doPrint(20, "Discretization table for this step didn't exist. OK!");
        }
        String create_table = "CREATE TABLE " + this.tableName + " (int_start number, int_end number, value varchar2(100), left_b char(1), right_b char(1))";
        try {
            this.getM4Db().executeBusinessSqlWrite(create_table);
        }
        catch (SQLException e) {
            throw new M4CompilerError("Error trying to create the table " + this.tableName + ": " + e.getMessage());
        }
        String alter_table = "ALTER TABLE " + this.tableName + " ADD CONSTRAINT " + this.tableName + "_chk CHECK (left_b IN ('I','E') AND right_b IN ('I','E'))";
        try {
            this.getM4Db().executeBusinessSqlWrite(alter_table);
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException e) {
            throw new M4CompilerError("Error trying to alter the table " + this.tableName + ": " + e.getMessage());
        }
        this.getM4Db().addTableToTrash(this.tableName, schema, this.getStep().getId());
        String insert_query = null;
        int i = 0;
        while (i < this.getIntervalStart().length) {
            insert_query = "INSERT INTO " + schema + "." + this.tableName + " VALUES (" + this.getIntervalStart()[i].getValue() + "," + this.getIntervalEnd()[i].getValue() + ",'" + this.getMapTo()[i].getValue() + "','" + this.getStartIncExc()[i].getValue() + "','" + this.getEndIncExc()[i].getValue() + "')";
            this.doPrint(10, insert_query);
            try {
                this.getM4Db().executeBusinessSqlWrite(insert_query);
                this.getM4Db().commitBusinessTransactions();
            }
            catch (SQLException e) {
                throw new M4CompilerError("Error trying to fill the discretization table " + this.tableName + ": " + e.getMessage());
            }
            ++i;
        }
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        this.createTable(theTargetAttributeColumn.getColumnSet().getSchema());
        String return_query = null;
        return_query = "num_interv_to_cat(" + theTargetAttributeColumn.getSQLDefinition() + ",'" + theTargetAttributeColumn.getColumnSet().getSchema() + "." + this.tableName + "'," + "'" + this.getDefaultValue().getValue() + "')";
        this.doPrint(12, "generatedSQL: " + return_query);
        return return_query;
    }
}

