/*
 * Decompiled with CFR 0.152.
 */
package miningmart.compiler.operator;

import java.util.Arrays;
import java.util.Vector;
import miningmart.compiler.BaseAttribute;
import miningmart.compiler.Column;
import miningmart.compiler.Columnset;
import miningmart.compiler.Concept;
import miningmart.compiler.Feature;
import miningmart.compiler.MultiColumnFeature;
import miningmart.compiler.Relation;
import miningmart.compiler.Step;
import miningmart.compiler.exception.M4CompilerError;
import miningmart.compiler.operator.SingleCSOperator;

public class MultiRelationalFeatureConstruction
extends SingleCSOperator {
    private String condition;
    private String listOfColumnSets;

    protected Concept[] getMyChainConcepts() {
        return (Concept[])this.getParameter("TheConcepts");
    }

    protected Relation[] getMyRelations() {
        return (Relation[])this.getParameter("TheRelations");
    }

    protected Feature[] getSelectedFeatures() {
        return (Feature[])this.getParameter("TheChainedFeatures");
    }

    protected String getCondition() {
        return this.condition;
    }

    protected String getListOfColumnSets() {
        return this.listOfColumnSets;
    }

    protected void setCondition(String condition) {
        this.condition = condition;
    }

    protected void setListOfColumnSets(String listOfColumnSets) {
        this.listOfColumnSets = listOfColumnSets;
    }

    public void load(Step st) throws M4CompilerError {
        super.load(st);
        this.checkChainValidity();
    }

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return "(select " + selectPart + " from " + this.getListOfColumnSets() + " where " + this.getCondition() + ")";
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String listOfColumns = "";
        this.setCondition("");
        this.setListOfColumnSets("");
        int index = 0;
        Concept actualDomain = this.getInputConcept();
        listOfColumns = this.addToListsAndCreateMetadata(actualDomain, csForOutputConcept, listOfColumns);
        while (index < this.getMyRelations().length) {
            Columnset actualRangeCS;
            Columnset actualDomainCS;
            Column actualRangeKeyCol;
            Column actualDomainKeyCol;
            Column rangeKeyCol;
            Column domainKeyCol;
            Concept actualRange = this.getMyChainConcepts()[index];
            Columnset crossCS = this.getMyRelations()[index].getCrossLinkColumnSet();
            if (crossCS == null) {
                domainKeyCol = this.getMyRelations()[index].getFromKey().getForeignKeyColumn();
                rangeKeyCol = this.getMyRelations()[index].getFromKey().getPrimaryKeyColumn();
                actualDomainKeyCol = this.findColumnInConcept(domainKeyCol, actualDomain);
                actualRangeKeyCol = this.findColumnInConcept(rangeKeyCol, actualRange);
                actualDomainCS = actualDomain.getCurrentColumnSet();
                actualRangeCS = actualRange.getCurrentColumnSet();
                this.setCondition(String.valueOf(this.getCondition()) + actualDomainCS.getSchema() + "." + actualDomainCS.getName() + "." + actualDomainKeyCol.getSQLDefinition() + " = " + actualRangeCS.getSchema() + "." + actualRangeCS.getName() + "." + actualRangeKeyCol.getSQLDefinition() + " AND ");
            } else {
                if (this.getMyRelations()[index].getToKey() == null) {
                    throw new M4CompilerError("MRFC: Relation with Id " + this.getMyRelations()[index].getId() + " seems to be n:m, but the second key is missing!");
                }
                domainKeyCol = this.getMyRelations()[index].getFromKey().getPrimaryKeyColumn();
                Column crossKeyCol_1 = this.getMyRelations()[index].getFromKey().getForeignKeyColumn();
                Column crossKeyCol_2 = this.getMyRelations()[index].getToKey().getForeignKeyColumn();
                rangeKeyCol = this.getMyRelations()[index].getToKey().getPrimaryKeyColumn();
                actualDomainKeyCol = this.findColumnInConcept(domainKeyCol, actualDomain);
                actualRangeKeyCol = this.findColumnInConcept(rangeKeyCol, actualRange);
                actualDomainCS = actualDomain.getCurrentColumnSet();
                actualRangeCS = actualRange.getCurrentColumnSet();
                this.setCondition(String.valueOf(this.getCondition()) + actualDomainCS.getSchema() + "." + actualDomainCS.getName() + "." + actualDomainKeyCol.getSQLDefinition() + " = " + crossCS.getSchema() + "." + crossCS.getName() + "." + crossKeyCol_1.getSQLDefinition() + " AND " + actualRangeCS.getSchema() + "." + actualRangeCS.getName() + "." + actualRangeKeyCol.getSQLDefinition() + " = " + crossCS.getSchema() + "." + crossCS.getName() + "." + crossKeyCol_2.getSQLDefinition() + " AND ");
                this.setListOfColumnSets(String.valueOf(this.getListOfColumnSets()) + crossCS.getSchema() + "." + crossCS.getName() + ", ");
            }
            listOfColumns = this.addToListsAndCreateMetadata(actualRange, csForOutputConcept, listOfColumns);
            ++index;
            actualDomain = actualRange;
        }
        this.setCondition(this.getCondition().substring(0, this.getCondition().length() - 5));
        listOfColumns = listOfColumns.substring(0, listOfColumns.length() - 2);
        this.setListOfColumnSets(this.getListOfColumnSets().substring(0, this.getListOfColumnSets().length() - 2));
        return listOfColumns;
    }

    private String addToListsAndCreateMetadata(Concept currentConcept, Columnset csForOutputConcept, String listOfColumns) throws M4CompilerError {
        Vector<Feature> selectedFeaturesOfCurrentConcept = new Vector<Feature>();
        Feature[] concFeatures = currentConcept.getFeatures();
        int i = 0;
        while (i < concFeatures.length) {
            int j = 0;
            while (j < this.getSelectedFeatures().length) {
                if (concFeatures[i].getId() == this.getSelectedFeatures()[j].getId()) {
                    selectedFeaturesOfCurrentConcept.add(concFeatures[i]);
                }
                ++j;
            }
            ++i;
        }
        if (selectedFeaturesOfCurrentConcept.isEmpty()) {
            return listOfColumns;
        }
        this.setListOfColumnSets(String.valueOf(this.getListOfColumnSets()) + currentConcept.getCurrentColumnSet().getSchema() + "." + currentConcept.getCurrentColumnSet().getName() + ", ");
        int i2 = 0;
        while (i2 < selectedFeaturesOfCurrentConcept.size()) {
            Column copiedColumn;
            Column oldColumn;
            BaseAttribute oldBA;
            BaseAttribute newBA;
            Feature oldF = (Feature)selectedFeaturesOfCurrentConcept.get(i2);
            Feature newF = null;
            int k = 0;
            while (k < this.getOutputConcept().getFeatures().length && !(newF = this.getOutputConcept().getFeature(k)).correspondsTo(oldF)) {
                ++k;
            }
            if (k == this.getOutputConcept().getFeatures().length) {
                throw new M4CompilerError("MRFC: TheChainedFeature '" + oldF.getName() + "' not found in TheOutputConcept!");
            }
            if (this.isDeselectedParameter(oldF)) {
                this.doPrint(6, "MRFC: TheChainedFeature '" + oldF.getName() + "' is skipped " + "because it was deselected by a FeatureSelection operator.");
            } else if (oldF instanceof BaseAttribute) {
                newBA = (BaseAttribute)newF;
                oldBA = (BaseAttribute)oldF;
                oldColumn = oldBA.getCurrentColumn();
                copiedColumn = oldColumn.copyColTo(csForOutputConcept);
                copiedColumn.setBaseAttribute(newBA);
                newBA.addColumn(copiedColumn);
                copiedColumn.setSQLDefinition(oldColumn.getName());
                listOfColumns = oldColumn.getSQLDefinition().equalsIgnoreCase(oldColumn.getName()) ? String.valueOf(listOfColumns) + oldColumn.getColumnSet().getSchema() + "." + oldColumn.getColumnSet().getName() + "." + oldColumn.getSQLDefinition() + " " + copiedColumn.getSQLDefinition() + ", " : String.valueOf(listOfColumns) + oldColumn.getSQLDefinition() + " " + copiedColumn.getSQLDefinition() + ", ";
            } else {
                if (!(oldF instanceof MultiColumnFeature)) {
                    throw new M4CompilerError("Unknown Feature type found in Concept with id: " + currentConcept.getId() + "; Feature id: " + oldF.getId());
                }
                MultiColumnFeature newMCF = (MultiColumnFeature)newF;
                MultiColumnFeature oldMCF = (MultiColumnFeature)oldF;
                BaseAttribute[] theBAs = newMCF.getBaseAttributes();
                if (theBAs != null) {
                    try {
                        int j = 0;
                        while (j < theBAs.length) {
                            newBA = theBAs[j];
                            oldBA = oldMCF.getBaseAttributes()[j];
                            oldColumn = oldBA.getCurrentColumn();
                            copiedColumn = oldColumn.copyColTo(csForOutputConcept);
                            copiedColumn.setBaseAttribute(newBA);
                            newBA.addColumn(copiedColumn);
                            copiedColumn.setSQLDefinition(oldColumn.getName());
                            listOfColumns = oldColumn.getSQLDefinition().equalsIgnoreCase(oldColumn.getName()) ? String.valueOf(listOfColumns) + oldColumn.getColumnSet().getSchema() + "." + oldColumn.getColumnSet().getName() + "." + oldColumn.getSQLDefinition() + " " + copiedColumn.getSQLDefinition() + ", " : String.valueOf(listOfColumns) + oldColumn.getSQLDefinition() + " " + copiedColumn.getSQLDefinition() + ", ";
                            ++j;
                        }
                    }
                    catch (NullPointerException nfe) {
                        throw new M4CompilerError("MRFC: Mismatch between MultiColumnFeatures in in- and output concept!");
                    }
                    catch (ArrayIndexOutOfBoundsException aie) {
                        throw new M4CompilerError("MRFC: Mismatch between MultiColumnFeatures in in- and output concept!");
                    }
                }
            }
            ++i2;
        }
        return listOfColumns;
    }

    private Column findColumnInConcept(Column keyCol, Concept toSearch) throws M4CompilerError {
        Feature[] fs = toSearch.getFeatures();
        Feature foundFeature = null;
        int i = 0;
        while (i < fs.length) {
            if (fs[i].correspondsTo(keyCol.getBaseAttribute())) {
                foundFeature = fs[i];
            }
            ++i;
        }
        if (foundFeature == null) {
            throw new M4CompilerError("MRFC: Column '" + keyCol.getName() + "' (Id: " + keyCol.getId() + ") was found in one of the relation keys, " + "but could not be matched to the current Concept!");
        }
        BaseAttribute foundBA = (BaseAttribute)foundFeature;
        Column foundColumn = foundBA.getCurrentColumn();
        return foundColumn;
    }

    private void checkChainValidity() throws M4CompilerError {
        String info = "No valid chain of relations found among the input concepts! \nParameter 'TheInputConcept' must be the first element of the chain. \nThe following elements must be given as parameters 'TheConcepts' \nin the order of the chain. The relations between these concepts \nmust be given as parameters 'TheRelations' in the same order. \nThere must be as many relations as concepts, excluding 'TheInputConcept'.";
        if (this.getMyRelations().length != this.getMyChainConcepts().length) {
            throw new M4CompilerError(info);
        }
    }

    protected void setNewCSMultiStepBranch(Columnset newCS, int index) throws M4CompilerError {
        Concept[] theConcepts = this.getMyChainConcepts();
        Object[] msbArray = new String[theConcepts.length + 1];
        int i = 0;
        while (i < theConcepts.length) {
            String msb = theConcepts[i].getCurrentColumnSet().getMultiStepBranch();
            msbArray[i++] = MultiRelationalFeatureConstruction.nullToEmpty(msb);
        }
        msbArray[i] = MultiRelationalFeatureConstruction.nullToEmpty(this.getInputConcept().getCurrentColumnSet().getMultiStepBranch());
        Arrays.sort(msbArray);
        newCS.setMultiStepBranch("");
        i = 0;
        while (i < msbArray.length) {
            newCS.addMultiStepBranch((String)msbArray[i]);
            ++i;
        }
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }
}

